//    IPS Java Utils
//    (c) Copyright 2009-2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Utils
//
//
//    IPS Java Utils is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Utils is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Utils.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyledDocument.ParagraphElement;
import ipsk.swing.text.EditorKitMenu;
import ipsk.text.ParserException;


/**
 * 
 * Styled document editor.
 * Experimental source and WYSIWYG editor for HTML (and RTF docs).
 * @version alpha
 * @author klausj
 *
 */
public class JHTMLDocumentEditor extends JPanel {

	final private JTextPane editorPane;


	
	public JHTMLDocumentEditor() {
		super(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = 0;
		c.gridy = 0;
		c.weightx = 2.0;
		c.weighty = 2.0;
		c.fill = GridBagConstraints.BOTH;
		editorPane = new JTextPane();
		
		editorPane.setPreferredSize(new Dimension(300, 100));
		HTMLEditorKit htmleditorKit=new HTMLEditorKit();
		StyleSheet s=new StyleSheet();
		s.addRule("p {margin-bottom:3em;color:green}");
		s.addRule("body {color:red}");
		//s.addAttribute(new SimpleAttributeSet(),StyleConstants.SpaceBelow, 30.0f);
		htmleditorKit.setStyleSheet(s);
		
	
		//editorPane.setEditorKit(editorKit);
		editorPane.setContentType("text/html");
		 String htmlStr="<html><head><style>p {margin-bottom:10px;color:red}</style></head><body><p style=\"color:red;\">Para1-Line1<br/>Para1-line2</p><p>Para2-Line1<br/>Para2-Line2</p></body></html>";
		editorPane.setText(htmlStr);
		add(new JScrollPane(editorPane), c);
		Document doc=editorPane.getDocument();
		if(doc instanceof HTMLDocument) {
			HTMLDocument hdoc=(HTMLDocument)doc;
			hdoc.dump(System.out);
		}
		
	
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		
		Runnable guiRunnable=new Runnable() {
            
            @Override
            public void run() {
                JFrame f = new JFrame("Test");
                f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                JHTMLDocumentEditor e = new JHTMLDocumentEditor();
                f.add(e);
                f.pack();
                f.setVisible(true);
                
     
            
            }
        };
        
        SwingUtilities.invokeLater(guiRunnable);
	
	}

}
