package ipsk.apps.speechrecorder.script.ui.prompt.styled.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.text.Document;

import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyledDocument;

/**
 * An action to toggle use virtual scale box attribute.

 */
public class UseVirtualScaleBoxAction extends AbstractAction{

	public final static String ACTION_COMMAND = new String("toggle_use_virtual_scale_box_action");
    public final static String SHORT_DESCRIPTION_VAL=new String("Use virtual scale box");

    private PromptStyledDocument promptStyledDocument;
    
    public PromptStyledDocument getPromptStyledDocument() {
		return promptStyledDocument;
	}

	public void setPromptStyledDocument(PromptStyledDocument promptStyledDocument) {
		this.promptStyledDocument = promptStyledDocument;
	}

	public UseVirtualScaleBoxAction() {
        super(SHORT_DESCRIPTION_VAL);
    }

    /**
     * Toggles the use virtual scale box attribute.
     *
     * @param e the action event
     */
    public void actionPerformed(ActionEvent e) {
    	Object src=e.getSource();
    	
         if (promptStyledDocument!=null){
            	boolean uvsb=promptStyledDocument.getUseVirtualScaleBox();
            	promptStyledDocument.setUseVirtualScaleBox(!uvsb);
            
        }
    }
}