/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.RecObserver;
import ipsk.apps.speechrecorder.RecSubject;
import java.util.Enumeration;
import java.util.Vector;

public class RecStatus
implements RecSubject {
    public static final int INIT = 0;
    public static final int IDLE = 1;
    public static final int NON_RECORDING = 2;
    public static final int PLAY_PROMPT_PREVIEW = 3;
    public static final int PLAY_PROMPT = 4;
    public static final int PLAY_BEEP = 5;
    public static final int NON_RECORDING_WAIT = 6;
    public static final int PRERECWAITING = 7;
    public static final int RECORDING = 8;
    public static final int POSTRECWAITING = 9;
    public static final int RECORDED = 10;
    public static final int ANNOTATE = 11;
    public static final int NAVIGATE = 12;
    public static final int PLAY = 13;
    public static final int PLAYPAUSE = 14;
    public static final int STOPPING_PLAY = 15;
    public static final int PROCESSING = 16;
    public static final int TERMINATE = 17;
    public static final int CLOSE = 18;
    public static final int ERROR = -1;
    public static final int ITEM_ERROR = -2;
    public static final int MIN_STATUS_NUMBER = -2;
    private static final String[] STATUS_NAMES = new String[]{"ITEM_ERROR", "ERROR", "INIT", "IDLE", "NON RECORDING", "PLAY_PROMPT_PREVIEW", "PLAY_PROMPT", "PLAY_BEEP", "PRERECWAITING", "RECORDING", "POSTRECWAITING", "RECORDED", "ANNOTATE", "NAVIGATE", "PLAY", "PLAYPAUSE", "STOPPING_PLAY", "PROCESSING", "TERMINATE", "CLOSE"};
    private static RecStatus _instance = null;
    private int currentStatus = 18;
    private Vector<RecObserver> recObservers = new Vector();

    private RecStatus() {
    }

    public static RecStatus getInstance() {
        if (_instance == null) {
            _instance = new RecStatus();
        }
        return _instance;
    }

    public synchronized void setStatus(int status) {
        this.currentStatus = status;
        this.notifyStatusChange(status);
    }

    @Override
    public synchronized void notifyStatusChange(int status) {
        Enumeration<RecObserver> e = this.recObservers.elements();
        while (e.hasMoreElements()) {
            RecObserver ro = e.nextElement();
            if (ro == null) continue;
            ro.update(status);
        }
    }

    public static String getStatusName(int status) {
        return STATUS_NAMES[status - -2];
    }

    public int getStatus() {
        return this.currentStatus;
    }

    @Override
    public void attach(RecObserver ro) {
        this.recObservers.addElement(ro);
    }

    @Override
    public void detach(RecObserver ro) {
        this.recObservers.removeElement(ro);
    }
}

