/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.PluginLoadingException;
import ipsk.apps.speechrecorder.RecStatus;
import ipsk.apps.speechrecorder.RecTransporter;
import ipsk.apps.speechrecorder.monitor.RecMonitor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptViewer;
import ipsk.apps.speechrecorder.prompting.Prompter;
import ipsk.apps.speechrecorder.session.action.RecTransporterActions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class RecWindowPanel
extends JPanel {
    private static final long serialVersionUID = -7638145123216040482L;
    private boolean showTransporter;
    private RecMonitor recMonitor;
    private PromptViewer promptViewer;
    private RecTransporter recTransporter;
    private boolean activeState;

    public RecWindowPanel(RecTransporterActions recTransporterActions, List<PromptPresenterServiceDescriptor> promptPresenters, GraphicsConfiguration spkc, Prompter prompter) throws PluginLoadingException {
        this.setLayout(new BorderLayout());
        this.recMonitor = new RecMonitor();
        this.promptViewer = new PromptViewer(promptPresenters, prompter.getStartPromptPlaybackAction(), prompter.getStopPromptPlaybackAction());
        this.promptViewer.setShowComments(false);
        this.recTransporter = new RecTransporter(recTransporterActions, true);
        this.add((Component)this.recMonitor, "West");
        this.add((Component)this.promptViewer, "Center");
        this.add((Component)this.recTransporter, "South");
        this.showTransporter = true;
    }

    public void setSilent(boolean silence) {
        this.promptViewer.setSilent(silence);
    }

    public void setWindowActive(boolean wa) {
        this.activeState = wa;
        this.promptViewer.setSilent(!this.activeState);
        if (this.activeState) {
            Runnable doShow = new Runnable(){

                @Override
                public void run() {
                    RecWindowPanel.this.setVisible(true);
                }
            };
            if (EventQueue.isDispatchThread()) {
                doShow.run();
            } else {
                SwingUtilities.invokeLater(doShow);
            }
        } else {
            Runnable doHide = new Runnable(){

                @Override
                public void run() {
                    RecWindowPanel.this.setVisible(false);
                }
            };
            SwingUtilities.invokeLater(doHide);
        }
    }

    public boolean isWindowActive() {
        return this.activeState;
    }

    public void setTransporterShowing(boolean show) {
        if (show) {
            if (!this.isTransporterShowing() && !this.isAncestorOf(this.recTransporter)) {
                this.add((Component)this.recTransporter, "South");
            }
        } else {
            this.remove(this.recTransporter);
        }
        this.showTransporter = show;
    }

    public boolean isTransporterShowing() {
        return this.showTransporter;
    }

    public PromptViewer getPromptViewer() {
        return this.promptViewer;
    }

    public void setAutoRecording(boolean b) {
        this.recTransporter.setAutoRecording(b);
    }

    public RecTransporter getRecTransporter() {
        return this.recTransporter;
    }

    public boolean isInstructionNumbering() {
        return this.promptViewer.isInstructionNumbering();
    }

    public void setInstructionNumbering(boolean instructionNumbering) {
        this.promptViewer.setInstructionNumbering(instructionNumbering);
    }

    public RecMonitor getRecMonitor() {
        return this.recMonitor;
    }

    public void attachToRecStatus() {
        RecStatus rs = RecStatus.getInstance();
        rs.attach(this.recTransporter);
    }

    public void detachFromRecStatus() {
        RecStatus rs = RecStatus.getInstance();
        rs.detach(this.recTransporter);
    }
}

