/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ips.annot.BundleAnnotationPersistorServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotationServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.model.emu.EmuBundleAnnotationPersistor;
import ips.annot.textgrid.TextGridFilePersistor;
import ips.incubator.util.apps.consent.Consent;
import ipsk.apps.speechrecorder.PluginLoadingException;
import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.SpeechRecorderPluginException;
import ipsk.apps.speechrecorder.SpeechRecorderUI;
import ipsk.apps.speechrecorder.TimeLogFormatter;
import ipsk.apps.speechrecorder.UIResources;
import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationPluginManager;
import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationWorker;
import ipsk.apps.speechrecorder.annotation.auto.MAUSTemplateTextFilePersistor;
import ipsk.apps.speechrecorder.annotation.auto.TemplateTextFilePersistor;
import ipsk.apps.speechrecorder.annotation.auto.impl.PromptAutoAnnotatorServiceDescriptor;
import ipsk.apps.speechrecorder.annotation.auto.impl.TemplateAutoAnnotatorServiceDescriptor;
import ipsk.apps.speechrecorder.config.ConfigHelper;
import ipsk.apps.speechrecorder.config.Formatter;
import ipsk.apps.speechrecorder.config.Handler;
import ipsk.apps.speechrecorder.config.Logger;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.WorkspaceProject;
import ipsk.apps.speechrecorder.project.ActiveProjectManager;
import ipsk.apps.speechrecorder.project.ProjectManagerEvent;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.apps.speechrecorder.project.ProjectManagerListener;
import ipsk.apps.speechrecorder.project.ProjectManagerProjectClosedEvent;
import ipsk.apps.speechrecorder.project.ProjectManagerProjectOpenedEvent;
import ipsk.apps.speechrecorder.project.ProjectManagerProjectReadyForShutdownEvent;
import ipsk.apps.speechrecorder.prompting.FormattedPromptTextViewer;
import ipsk.apps.speechrecorder.prompting.PromptBufferedImageViewer;
import ipsk.apps.speechrecorder.prompting.PromptFormattedTextViewer;
import ipsk.apps.speechrecorder.prompting.PromptImageIconViewer;
import ipsk.apps.speechrecorder.prompting.PromptPlainTextViewer;
import ipsk.apps.speechrecorder.prompting.PromptPresenterPluginManager;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.ScrollableFormattedPromptTextViewer;
import ipsk.apps.speechrecorder.prompting.combined.FormattedTextAndAudioJavaSoundViewer;
import ipsk.apps.speechrecorder.prompting.combined.ImageAndAudioJavaSoundViewer;
import ipsk.apps.speechrecorder.prompting.combined.TextButtonAudioJavaSoundViewer;
import ipsk.apps.speechrecorder.prompting.sound.javasound.PromptAudioJavaSoundViewer;
import ipsk.apps.speechrecorder.script.RecscriptManagerException;
import ipsk.apps.speechrecorder.session.action.CloseSpeakerDisplayAction;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.apps.speechrecorder.workspace.WorkspaceException;
import ipsk.apps.speechrecorder.workspace.WorkspaceManager;
import ipsk.audio.AudioController4;
import ipsk.audio.AudioControllerException;
import ipsk.audio.mixer.MixerManager;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.net.SimplePasswordAuthentication;
import ipsk.net.URLContext;
import ipsk.net.cookie.SessionCookieHandler;
import ipsk.swing.JProgressDialogPanel;
import ipsk.text.ParserException;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;
import ipsk.util.SystemHelper;
import ipsk.util.apps.UpdateManager;
import ipsk.util.apps.UpdateManagerConfig;
import ipsk.util.apps.UpdateManagerEvent;
import ipsk.util.apps.UpdateManagerListener;
import ipsk.util.apps.descriptor.Change;
import ipsk.util.apps.event.UpdateAvailableEvent;
import ipsk.util.apps.ui.JUpdateManagerConfigDialog;
import ipsk.util.apps.ui.JUpdateManagerConsentDialog;
import ipsk.util.optionparser.Option;
import ipsk.util.optionparser.OptionParser;
import ipsk.util.optionparser.OptionParserException;
import ipsk.util.zip.UnzipWorker;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXB;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SpeechRecorder
implements ActionListener,
ProjectManagerListener,
UpdateManagerListener {
    public static final boolean DEBUG = false;
    public static final String VERSION = SpeechRecorder.class.getPackage().getImplementationVersion();
    public static final String FULL_QUALIFIED_APPLICATION_NAME = "de.uni-muenchen.phonetik.SpeechRecorder";
    public static final String APPLICATION_NAME = "SpeechRecorder";
    public static final String FREEDESKTOP_APPLICATION_ICON_NAME = "speechrecorder";
    public static final boolean IS_STABLE_RELEASE = true;
    private static final String NON_STABLE_VERSION_WARNING = "You are using a non stable development version.\nPlease use this version only for evaluation!\nProjects configured by this version might be incompatible to stable releases!";
    public static final String AUTHORS = " Chr. Draxler, K. J\u00e4nsch";
    public static final String COPYRIGHT = "Copyright \u00a9 2004-2021";
    public static final String CONTACT_URI = "mailto:speechrecorder@phonetik.uni-muenchen.de";
    private final String DEF_REL_WORKSPACE_DIR = "speechrecorder";
    private final String USER_CONFIG_DIR = ".speechrecorder";
    private final String USER_CONFIG_LEGAL_DIR = "legal";
    public final String APPLICATION_DESCRIPTOR_KEY = "ipsk.util.apps.descriptor.url";
    public final String PREFERRED_START_STOP_SIGNAL_PLUGIN = "ips.apps.speechrecorder.startstopsignal.Ampelmaennchen";
    public final boolean USE_MAX_REC_TIMER = true;
    public static final String PROJECT_FILE_EXTENSION = "_project.prj";
    private long SHUTDOWN_RETRY_DELAY = 2000L;
    public String LOG_HANDLER_NAME = "default";
    public String TIMELOG_HANDLER_NAME = "timelog";
    public static Handler[] DEF_LOG_HANDLERS = new Handler[0];
    protected static final Formatter TIME_LOG_FORMATTER_CFG = new Formatter(TimeLogFormatter.class.getName(), "Time logger");
    public static final Formatter[] LOG_FORMATTERS = new Formatter[]{new Formatter(null, "(Default)"), new Formatter("java.util.logging.SimpleFormatter", "Plain Text"), new Formatter("java.util.logging.XMLFormatter", "XML"), TIME_LOG_FORMATTER_CFG};
    public static Logger[] AVAIL_LOGGERS = new Logger[0];
    private java.util.logging.Logger logger;
    private java.util.logging.Logger timeLogger;
    private DOMCodec domCodec;
    private DOMConverter domConverter;
    private File defWorkspaceDir;
    private WorkspaceProject[] workspaceProjects;
    private GraphicsConfiguration speakerScreenConfig = null;
    private GraphicsConfiguration experimenterScreenConfig = null;
    private ActiveProjectManager projectManager;
    private AudioController4 audioController;
    private UIResources uiString;
    private SpeechRecorderUI speechRecorderUI;
    private CloseSpeakerDisplayAction closeSpeakerDisplayAction;
    private WorkspaceManager workspaceManager;
    private PromptPresenterPluginManager promptPresenterPluginManager;
    private AutoAnnotationPluginManager autoAnnotatorPluginManager;
    private AutoAnnotationWorker autoAnnotationWorker;
    private UpdateManager updateManager;
    private Consent appCheckUpdatesConsent = null;
    private UpdateManagerConfig updateManagerConfig;
    private List<BundleAnnotationPersistorServiceDescriptor> availableBundleAnnotationServiceDescriptors;
    private Path userConfigDir;
    private Path userDataDir;
    private Path userConfigUpdateManagerDir;
    private Path userDataUpdateManagerDir;
    private SystemHelper systemHelper = SystemHelper.getInstance();

    public AutoAnnotationPluginManager getAutoAnnotatorPluginManager() {
        return this.autoAnnotatorPluginManager;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public SpeechRecorder(String projectFileURL, String projectName, String user, String password) throws ClassNotFoundException, DOMCodecException, DOMConverterException, IOException, PluginLoadingException, AudioControllerException, ParserConfigurationException, SAXException, StorageManagerException, InstantiationException, IllegalAccessException, WorkspaceException, ProjectManagerException {
        String appDescrUrlParam;
        PromptPresenterServiceDescriptor piaajsvsd;
        PromptPresenterServiceDescriptor pftaajsvsd;
        PromptPresenterServiceDescriptor ptaajsvsd;
        PromptPresenterServiceDescriptor pajsvsd;
        PromptPresenterServiceDescriptor piivsd;
        PromptPresenterServiceDescriptor pbivsd;
        PromptPresenterServiceDescriptor pftvsd;
        PromptPresenterServiceDescriptor pptvsd;
        PromptPresenterServiceDescriptor scftpctvsd;
        GraphicsDevice gd;
        int i;
        Handler logHandler = new Handler(this.LOG_HANDLER_NAME);
        Handler timeLogHandler = new Handler(this.TIMELOG_HANDLER_NAME);
        timeLogHandler.setFormatter(TIME_LOG_FORMATTER_CFG);
        DEF_LOG_HANDLERS = new Handler[]{logHandler, timeLogHandler};
        Logger defLogger = new Logger();
        defLogger.setName("ipsk.apps.speechrecorder");
        defLogger.setHandlerName(logHandler.getName());
        Logger defTimeLogger = new Logger();
        defTimeLogger.setName("time");
        defTimeLogger.setHandlerName(timeLogHandler.getName());
        this.logger = java.util.logging.Logger.getLogger("ipsk.apps.speechrecorder");
        AVAIL_LOGGERS = new Logger[]{defLogger, defTimeLogger};
        this.timeLogger = java.util.logging.Logger.getLogger("time");
        this.uiString = UIResources.getInstance();
        String userHomePropStr = null;
        try {
            userHomePropStr = System.getProperty("user.home");
        }
        catch (SecurityException se) {
            JOptionPane.showMessageDialog(this.speechRecorderUI, "Could not get user home directory path: " + se.getLocalizedMessage(), "Fatal security excption", 64);
            this.shutdown();
        }
        File homeDir = new File(userHomePropStr);
        this.userConfigDir = this.systemHelper.applicationUserConfigFolder().resolve(FULL_QUALIFIED_APPLICATION_NAME);
        if (Files.exists(this.userConfigDir, new LinkOption[0])) {
            if (!Files.isDirectory(this.userConfigDir, new LinkOption[0])) {
                JOptionPane.showMessageDialog(this.speechRecorderUI, "Could not use \"" + this.userConfigDir + ". It is not a directory!", "Fatal I/O excption", 64);
                this.shutdown();
            }
        } else {
            try {
                Files.createDirectories(this.userConfigDir, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.speechRecorderUI, "Could not create user config directory: " + ioe.getLocalizedMessage(), "Fatal I/O excption", 64);
                this.shutdown();
            }
        }
        this.userDataDir = this.systemHelper.applicationUserDataFolder().resolve(FULL_QUALIFIED_APPLICATION_NAME);
        if (Files.exists(this.userDataDir, new LinkOption[0])) {
            if (!Files.isDirectory(this.userDataDir, new LinkOption[0])) {
                JOptionPane.showMessageDialog(this.speechRecorderUI, "Could not use \"" + this.userDataDir + ". It is not a directory!", "Fatal I/O excption", 64);
                this.shutdown();
            }
        } else {
            try {
                Files.createDirectories(this.userDataDir, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.speechRecorderUI, "Could not create user data directory: " + ioe.getLocalizedMessage(), "Fatal I/O excption", 64);
                this.shutdown();
            }
        }
        this.defWorkspaceDir = new File(homeDir, FREEDESKTOP_APPLICATION_ICON_NAME);
        this.workspaceManager = new WorkspaceManager(this.defWorkspaceDir, this);
        Package configBasePack = Class.forName("ipsk.apps.speechrecorder.config.ProjectConfiguration").getPackage();
        new MixerManager();
        this.domCodec = new DOMCodec(configBasePack);
        this.domConverter = new DOMConverter();
        if (user != null) {
            Authenticator.setDefault((Authenticator)new SimplePasswordAuthentication(user, password));
            this.logger.info("Set authenticator for user " + user);
        }
        URL projectURL = null;
        if (projectFileURL != null) {
            projectURL = new URL(projectFileURL);
            InputStream projectFileStream = projectURL.openStream();
            projectFileStream.close();
        }
        int experimenterScreenIdx = 0;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        GraphicsDevice defGd = ge.getDefaultScreenDevice();
        if (defGd == null && gds.length > 0) {
            defGd = gds[0];
        }
        if (gds == null || gds.length == 0) {
            this.logger.severe("No display connected!");
        }
        for (i = 0; i < gds.length; ++i) {
            gd = gds[i];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle gb = gc.getBounds();
            this.logger.info("Display " + i + ": " + gb.getWidth() + " x " + gb.getHeight());
        }
        if (defGd != null) {
            for (i = 0; i < gds.length; ++i) {
                gd = gds[i];
                if (!gd.equals(defGd)) continue;
                this.experimenterScreenConfig = defGd.getDefaultConfiguration();
                experimenterScreenIdx = i;
                this.logger.info("Selected default display " + i + " as experimenter screen");
            }
        }
        if (gds.length == 1) {
            this.speakerScreenConfig = this.experimenterScreenConfig;
            this.logger.info("Selected default display 0 as speaker screen");
        } else if (gds.length >= 2) {
            for (i = 0; i < gds.length; ++i) {
                gd = gds[i];
                if (this.speakerScreenConfig != null || gd.equals(defGd)) continue;
                this.speakerScreenConfig = gd.getDefaultConfiguration();
                this.logger.info("Selected display " + i + " as speaker screen");
            }
        }
        this.promptPresenterPluginManager = new PromptPresenterPluginManager();
        List<PromptPresenterServiceDescriptor> promptPresenterClassList = this.promptPresenterPluginManager.getPromptPresenterServiceDescriptors();
        PromptPresenterServiceDescriptor ftpctvsd = FormattedPromptTextViewer.DESCRIPTOR;
        if (!promptPresenterClassList.contains(ftpctvsd)) {
            promptPresenterClassList.add(ftpctvsd);
        }
        if (!promptPresenterClassList.contains(scftpctvsd = ScrollableFormattedPromptTextViewer.DESCRIPTOR)) {
            promptPresenterClassList.add(scftpctvsd);
        }
        if (!promptPresenterClassList.contains(pptvsd = PromptPlainTextViewer.DESCRIPTOR)) {
            promptPresenterClassList.add(pptvsd);
        }
        if (!promptPresenterClassList.contains(pftvsd = PromptFormattedTextViewer.DESCRIPTOR)) {
            promptPresenterClassList.add(pftvsd);
        }
        if (!promptPresenterClassList.contains(pbivsd = PromptBufferedImageViewer.DESCRIPTOR)) {
            promptPresenterClassList.add(pbivsd);
        }
        if (!promptPresenterClassList.contains(piivsd = PromptImageIconViewer.DESCRIPTOR)) {
            promptPresenterClassList.add(piivsd);
        }
        if (!promptPresenterClassList.contains(pajsvsd = PromptAudioJavaSoundViewer.DESCRIPTOR)) {
            promptPresenterClassList.add(pajsvsd);
        }
        if (!promptPresenterClassList.contains(ptaajsvsd = TextButtonAudioJavaSoundViewer.DESCRIPTOR)) {
            promptPresenterClassList.add(ptaajsvsd);
        }
        if (!promptPresenterClassList.contains(pftaajsvsd = FormattedTextAndAudioJavaSoundViewer.DESCRIPTOR)) {
            promptPresenterClassList.add(pftaajsvsd);
        }
        if (!promptPresenterClassList.contains(piaajsvsd = ImageAndAudioJavaSoundViewer.DESCRIPTOR)) {
            promptPresenterClassList.add(piaajsvsd);
        }
        this.availableBundleAnnotationServiceDescriptors = new ArrayList<BundleAnnotationPersistorServiceDescriptor>();
        this.availableBundleAnnotationServiceDescriptors.add((BundleAnnotationPersistorServiceDescriptor)new EmuBundleAnnotationPersistor());
        this.availableBundleAnnotationServiceDescriptors.add((BundleAnnotationPersistorServiceDescriptor)new TextGridFilePersistor());
        this.availableBundleAnnotationServiceDescriptors.add((BundleAnnotationPersistorServiceDescriptor)new TemplateTextFilePersistor());
        this.availableBundleAnnotationServiceDescriptors.add((BundleAnnotationPersistorServiceDescriptor)new MAUSTemplateTextFilePersistor());
        this.autoAnnotatorPluginManager = new AutoAnnotationPluginManager();
        List<AutoAnnotationServiceDescriptor> autoAnnotatorDescriptors = this.autoAnnotatorPluginManager.getAutoAnnotatorServiceDescriptors();
        autoAnnotatorDescriptors.add(0, new PromptAutoAnnotatorServiceDescriptor());
        autoAnnotatorDescriptors.add(1, new TemplateAutoAnnotatorServiceDescriptor());
        this.projectManager = new ActiveProjectManager(this.promptPresenterPluginManager, this.autoAnnotatorPluginManager, projectFileURL, user, password);
        this.projectManager.setWorkspaceDir(this.defWorkspaceDir);
        this.projectManager.setListener(this);
        if (this.speechRecorderUI != null) {
            this.speechRecorderUI.dispose();
        }
        if ((appDescrUrlParam = System.getProperty("ipsk.util.apps.descriptor.url")) != null) {
            Version currentVersion = null;
            if (VERSION == null) {
                currentVersion = new Version(new int[]{0, 0, 1});
            } else {
                try {
                    currentVersion = Version.parseString((String)VERSION);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
            this.updateManager = new UpdateManager(currentVersion);
            this.updateManager.addUpdateManagerListener((UpdateManagerListener)this);
        }
        this.speechRecorderUI = new SpeechRecorderUI(this, experimenterScreenIdx, this.experimenterScreenConfig, this.speakerScreenConfig);
        this.speechRecorderUI.setPromptPresenterServiceDescriptors(promptPresenterClassList);
        this.speechRecorderUI.createUI(this.projectManager);
        this.projectManager.setSpeechRecorderUI(this.speechRecorderUI);
        this.speechRecorderUI.pack();
        this.speechRecorderUI.setExtendedState(6);
        this.speechRecorderUI.setVisible(true);
        if (this.updateManager != null) {
            URL appDescrUrl = new URL(appDescrUrlParam);
            this.updateManager.setApplicationDescriptorURL(appDescrUrl);
            this.userConfigUpdateManagerDir = this.userConfigDir.resolve("update_manager");
            this.userDataUpdateManagerDir = this.userDataDir.resolve("update_manager");
            this.loadAppUpdatesConfig();
            if (this.updateManagerConfig == null) {
                boolean consent = this.checkAppUpdatesConsent(true);
                this.configureUpdateManager(consent);
            }
            if (this.updateManagerConfig != null && this.updateManagerConfig.isCheckOnStartup()) {
                this.checkAppUpdatesConsent(true);
                this.updateManager.startLoadApplicationDescriptor();
            }
        }
        this.speechRecorderUI.setWaiting(true);
        if (projectURL != null) {
            boolean canceled = false;
            try {
                canceled = this.configureProject(projectURL);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "ERROR", 0);
                System.exit(-1);
            }
            if (canceled) {
                return;
            }
            this.projectManager.start();
        } else {
            try {
                this.workspaceProjects = this.workspaceManager.scanWorkspace();
            }
            catch (WorkspaceException e) {
                e.printStackTrace();
            }
            this.speechRecorderUI.setWorkspaceProjects(this.workspaceProjects);
            this.speechRecorderUI.setEnableOpenOrNewProject(true);
        }
        this.speechRecorderUI.setWaiting(false);
        if (projectName != null) {
            try {
                this.openProject(projectName);
            }
            catch (SpeechRecorderException e) {
                this.speechRecorderUI.displayError("Open project error", e.getLocalizedMessage());
                System.err.println(e.getLocalizedMessage());
                e.printStackTrace();
                System.exit(-2);
            }
        }
    }

    public boolean checkAppUpdatesConsent(boolean forceUserInteractice) {
        if (this.updateManager != null) {
            Path userUpdateManagerLegalDir = this.userDataUpdateManagerDir.resolve("legal");
            Path userUpdateManagerLegalFile = userUpdateManagerLegalDir.resolve("consent_update_check.xml");
            if (Files.exists(userUpdateManagerLegalFile, new LinkOption[0])) {
                this.appCheckUpdatesConsent = (Consent)JAXB.unmarshal((File)userUpdateManagerLegalFile.toFile(), Consent.class);
            }
            if (this.appCheckUpdatesConsent == null || forceUserInteractice && !this.appCheckUpdatesConsent.isAccepted()) {
                String consentText = this.uiString.getString("updatemanager.consent");
                JUpdateManagerConsentDialog pcd = new JUpdateManagerConsentDialog(consentText);
                Object res = pcd.showDialog((JFrame)this.speechRecorderUI);
                try {
                    Files.createDirectories(userUpdateManagerLegalDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.appCheckUpdatesConsent = new Consent();
                this.appCheckUpdatesConsent.setAccepted(false);
                if (res.equals(0)) {
                    this.appCheckUpdatesConsent.setText(pcd.getText());
                    this.appCheckUpdatesConsent.setAccepted(true);
                }
                JAXB.marshal((Object)this.appCheckUpdatesConsent, (File)userUpdateManagerLegalFile.toFile());
            }
        }
        return this.appCheckUpdatesConsent != null && this.appCheckUpdatesConsent.isAccepted();
    }

    public void loadAppUpdatesConfig() {
        Path userUpdateManagerConfigDir = this.userConfigUpdateManagerDir.resolve("config");
        Path userUpdateManagerConfigFile = userUpdateManagerConfigDir.resolve("update_check_config.xml");
        if (Files.exists(userUpdateManagerConfigFile, new LinkOption[0])) {
            this.updateManagerConfig = (UpdateManagerConfig)JAXB.unmarshal((File)userUpdateManagerConfigFile.toFile(), UpdateManagerConfig.class);
        }
    }

    public void configureUpdateManager(boolean checkOnStartup) throws IOException {
        Path userUpdateManagerConfigDir = this.userConfigUpdateManagerDir.resolve("config");
        if (!Files.exists(userUpdateManagerConfigDir, new LinkOption[0])) {
            Files.createDirectories(userUpdateManagerConfigDir, new FileAttribute[0]);
        }
        Path userUpdateManagerConfigFile = userUpdateManagerConfigDir.resolve("update_check_config.xml");
        if (this.updateManagerConfig == null) {
            this.updateManagerConfig = new UpdateManagerConfig();
        }
        this.updateManagerConfig.setCheckOnStartup(checkOnStartup);
        JAXB.marshal((Object)this.updateManagerConfig, (File)userUpdateManagerConfigFile.toFile());
    }

    public void configureUpdateManagerInteractive() {
        Path userUpdateManagerConfigDir = this.userConfigUpdateManagerDir.resolve("config");
        Path userUpdateManagerConfigFile = userUpdateManagerConfigDir.resolve("update_check_config.xml");
        if (this.updateManagerConfig == null) {
            this.updateManagerConfig = new UpdateManagerConfig();
        }
        JUpdateManagerConfigDialog umcd = new JUpdateManagerConfigDialog(APPLICATION_NAME);
        umcd.setConfig(this.updateManagerConfig);
        Object res = umcd.showDialog((JFrame)this.speechRecorderUI);
        if (res.equals(0)) {
            umcd.apply();
            UpdateManagerConfig newCfg = umcd.getConfig();
            boolean reqCheckOnstartup = newCfg.isCheckOnStartup();
            if (reqCheckOnstartup) {
                boolean cons = this.checkAppUpdatesConsent(true);
                newCfg.setCheckOnStartup(cons && reqCheckOnstartup);
            }
            this.updateManagerConfig = newCfg;
            try {
                Files.createDirectories(userUpdateManagerConfigDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            JAXB.marshal((Object)this.updateManagerConfig, (File)userUpdateManagerConfigFile.toFile());
        }
    }

    public List<AutoAnnotator> getAutoAnnotators() {
        if (this.autoAnnotationWorker != null) {
            return this.autoAnnotationWorker.getAutoAnnotators();
        }
        return null;
    }

    public boolean configureProject(URL projectUrl) throws ClassNotFoundException, DOMCodecException, DOMConverterException, StorageManagerException, PluginLoadingException, AudioControllerException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, WorkspaceException, URISyntaxException, RecscriptManagerException, SpeechRecorderException, ProjectManagerException {
        URLConnection prUrlConn = projectUrl.openConnection();
        prUrlConn.setUseCaches(false);
        InputStream prInStream = prUrlConn.getInputStream();
        Document d = this.domConverter.readXML(prInStream);
        ProjectConfiguration p = (ProjectConfiguration)this.domCodec.readDocument(d);
        this.projectManager.setProjectURL(projectUrl);
        URL projectContext = URLContext.baseContextFromResourceURL((URL)projectUrl);
        this.projectManager.setProjectContext(projectContext);
        ConfigHelper.applyLegacyToStrictConversions(p);
        boolean canceled = this.projectManager.configure(p);
        this.projectManager.setProjectConfigurationSaved(true);
        return canceled;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
    }

    public void openProject(String projectName) throws SpeechRecorderException {
        boolean canceled;
        try {
            canceled = this.configureProject(projectName);
        }
        catch (ProjectManagerException | RecscriptManagerException | WorkspaceException | AudioControllerException e1) {
            throw new SpeechRecorderException(e1.getLocalizedMessage(), e1);
        }
        catch (PluginLoadingException e) {
            throw new SpeechRecorderPluginException(e.getLocalizedMessage(), e);
        }
        if (!canceled) {
            this.speechRecorderUI.closeWorkspaceDialog();
            this.speechRecorderUI.showSpeakerDatabase();
            try {
                this.projectManager.start();
            }
            catch (ProjectManagerException | AudioControllerException e) {
                throw new SpeechRecorderException(e);
            }
        }
    }

    public void setEditingEnabled(boolean b) {
        this.projectManager.setEditingEnabled(b);
        this.speechRecorderUI.setEditingEnabled(b);
    }

    public void shutdown() {
        this.projectManager.shutdown();
    }

    public SpeechRecorderUI getSpeechRecorderUI() {
        return this.speechRecorderUI;
    }

    public void stopPlayback() throws AudioControllerException {
        this.audioController.stopPlayback();
    }

    public void pausePlayback() throws AudioControllerException {
        this.audioController.pausePlayback();
    }

    public void continuePlayback() {
        try {
            this.audioController.startPlayback();
        }
        catch (AudioControllerException e) {
            this.speechRecorderUI.displayError("AudioController Error", e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public File getDefWorkspaceDir() {
        return this.defWorkspaceDir;
    }

    public boolean configureProject(String projectName) throws PluginLoadingException, AudioControllerException, WorkspaceException, RecscriptManagerException, SpeechRecorderException, ProjectManagerException {
        List<WorkspaceProject> workspaceProjects = this.workspaceManager.getWorkspaceProjects();
        boolean canceled = false;
        boolean found = false;
        for (WorkspaceProject wsp : workspaceProjects) {
            if (!wsp.getName().equals(projectName)) continue;
            found = true;
            ProjectConfiguration p = wsp.getConfiguration();
            File projFile = wsp.getProjectFile();
            if (p == null) {
                Document d = null;
                try {
                    d = this.domConverter.readXML((InputStream)new FileInputStream(projFile));
                    p = (ProjectConfiguration)this.domCodec.readDocument(d);
                }
                catch (Exception e) {
                    String attrProjVers;
                    Element projElem;
                    e.printStackTrace();
                    if (d != null && (projElem = d.getDocumentElement()) != null && projElem.getTagName().equals("ProjectConfiguration") && (attrProjVers = projElem.getAttribute("version")) != null) {
                        try {
                            Version projVers = Version.parseString((String)attrProjVers);
                            Version sprProjVers = Version.parseString((String)"4.0.0");
                            int versComp = sprProjVers.compareTo(projVers);
                            if (versComp < 0) {
                                throw new SpeechRecorderException("Project configuration of project \"" + projectName + "\" could not be loaded.\nIt was configured with a newer version of Speechrecorder.\n(Project configuration version " + projVers + ">" + sprProjVers + ")\nPlease update Speechrecorder to newest version. (Help->Check for updates)");
                            }
                        }
                        catch (ParserException e1) {
                            e.printStackTrace();
                        }
                    }
                    throw new SpeechRecorderException("Error loading project configuration from file " + projFile + ":\n" + e.getLocalizedMessage());
                }
            }
            try {
                this.projectManager.setProjectURL(projFile.toURI().toURL());
                File projectDir = new File(this.defWorkspaceDir, p.getName());
                URI projectURI = projectDir.toURI();
                String projURLStr = projectURI.toASCIIString();
                URL projectContext = new URL(projURLStr);
                ConfigHelper.applyLegacyToStrictConversions(p);
                this.projectManager.setProjectContext(projectContext);
                canceled = this.projectManager.configure(p);
                this.projectManager.setProjectConfigurationSaved(true);
                break;
            }
            catch (DOMConverterException | IOException e) {
                throw new SpeechRecorderException("Could not configure project: " + e.getMessage(), e);
            }
        }
        if (!found) {
            throw new WorkspaceException("Project " + projectName + " not found!");
        }
        return canceled;
    }

    private static void printUsageAndExit() {
        String usageStr = "Usage:\n\n\t{SPECHRECORDER_BIN}\n\n\t{SPECHRECORDER_BIN} [PROJECT_FILE_URL]\n\n\t{SPECHRECORDER_BIN} open project PROJECT_NAME\n\n{SPECHRECORDER_BIN}: the SpeechRecorder application executable";
        String osDepExpl = "";
        SystemHelper sh = SystemHelper.getInstance();
        if (sh.isMacOSX()) {
            osDepExpl = ",\n\"/Applications/SpeechRecorder.app/Contents/MacOS/JavaAppLauncher\" for default installations on macOS.";
        } else if (sh.isWindows()) {
            osDepExpl = ",\n\"C:\\Program Files\\BAS\\SpeechRecorder\\speechrecorder.exe\" for default installations on Windows.";
        } else if (sh.isLinux()) {
            osDepExpl = ",\n\"/usr/local/bin/speechrecorder\" on Linux";
        }
        usageStr = usageStr.concat(osDepExpl);
        System.out.println(usageStr);
        Console console = System.console();
        if (console == null) {
            JOptionPane.showMessageDialog(null, usageStr, "Usage", 0);
        }
        System.exit(-1);
    }

    public static void main(String[] args) {
        String projectName = null;
        String projectFileURL = null;
        String user = null;
        String password = "";
        OptionParser op = new OptionParser();
        op.addOption("h");
        op.addOption("u", "");
        op.addOption("p", "");
        op.addOption("s", "");
        try {
            op.parse(args);
        }
        catch (OptionParserException e) {
            System.err.println(e.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "ERROR", 0);
            System.exit(-1);
        }
        Option[] options = op.getOptions();
        for (int i = 0; i < options.length; ++i) {
            Option option = options[i];
            String optionName = option.getOptionName();
            if ("h".equals(optionName) && option.isSet()) {
                SpeechRecorder.printUsageAndExit();
                continue;
            }
            if ("u".equals(optionName)) {
                user = option.getParam();
                continue;
            }
            if ("p".equals(optionName)) {
                password = option.getParam();
                continue;
            }
            if (!"s".equals(optionName)) continue;
            String sessionCookie = option.getParam();
            CookieHandler.setDefault((CookieHandler)new SessionCookieHandler(sessionCookie));
        }
        String[] params = op.getParams();
        if (params.length > 3) {
            SpeechRecorder.printUsageAndExit();
        }
        if (params.length == 1) {
            projectFileURL = params[0];
        } else if (params.length == 2) {
            SpeechRecorder.printUsageAndExit();
        } else if (params.length == 3) {
            String cmd = params[0];
            String object = params[1];
            if ("open".equals(cmd)) {
                if ("project".equals(object)) {
                    projectName = params[2];
                } else {
                    SpeechRecorder.printUsageAndExit();
                }
            } else {
                SpeechRecorder.printUsageAndExit();
            }
        }
        final String fprojectName = projectName;
        final String fprojectFileURL = projectFileURL;
        final String fuser = user;
        final String fpassword = password;
        Runnable doStart = new Runnable(){

            @Override
            public void run() {
                try {
                    SystemHelper sh = SystemHelper.getInstance();
                    if (sh.isWindows()) {
                        try {
                            Class<?> dsSndMpCls = Class.forName("ips.audio.ds.DSMixerProvider");
                            if (dsSndMpCls != null) {
                                Constructor<?> dsSndMpCstr = dsSndMpCls.getConstructor(new Class[0]);
                                Object dsSndMpObj = dsSndMpCstr.newInstance(new Object[0]);
                                Method dsSndMpInit = dsSndMpCls.getMethod("init", new Class[0]);
                                dsSndMpInit.invoke(dsSndMpObj, new Object[0]);
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    new SpeechRecorder(fprojectFileURL, fprojectName, fuser, fpassword);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "ERROR", 0);
                    System.exit(-1);
                }
            }
        };
        SwingUtilities.invokeLater(doStart);
    }

    public void importProject(File file) throws PluginLoadingException, AudioControllerException, IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, DOMConverterException, WorkspaceException, DOMCodecException, URISyntaxException, RecscriptManagerException, StorageManagerException, SpeechRecorderException, ProjectManagerException {
        File firstFile;
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ZipEntry firstEntry = entries.nextElement();
        String firstFilename = firstEntry.getName();
        File parentFile = firstFile = new File(firstFilename);
        while (parentFile.getParentFile() != null) {
            parentFile = parentFile.getParentFile();
        }
        String projectDirName = parentFile.getName();
        File projectDirFile = new File(projectDirName);
        String projectName = projectDirFile.getName();
        File projectDir = new File(this.defWorkspaceDir, projectDirName);
        if (projectDir.exists()) {
            this.speechRecorderUI.displayError(this.uiString.getString("MenuItemImport"), "Project " + projectDirName + " already exists !");
            zipFile.close();
            return;
        }
        zipFile.close();
        zipFile = new ZipFile(file);
        File projectCfgPrototypeFile = new File(projectDirFile, projectName + PROJECT_FILE_EXTENSION);
        entries = zipFile.entries();
        ZipEntry entry = null;
        boolean hasProjectCfgFile = false;
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            String entryFn = entry.getName();
            File entryF = new File(entryFn);
            if (!projectCfgPrototypeFile.equals(entryF)) continue;
            hasProjectCfgFile = true;
            break;
        }
        zipFile.close();
        if (!hasProjectCfgFile) {
            throw new IOException("Speechrecorder project file not found in ZIP file.\nThis does not look like a Speechrecorder export.");
        }
        UnzipWorker unzipWorker = new UnzipWorker();
        unzipWorker.setSourceZipFile(file);
        unzipWorker.setTrgDir(this.defWorkspaceDir);
        JProgressDialogPanel progressDialog = new JProgressDialogPanel((Worker)unzipWorker, "Import project", "Importing...");
        try {
            unzipWorker.open();
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
        unzipWorker.start();
        Object val = progressDialog.showDialog((JFrame)this.speechRecorderUI);
        try {
            unzipWorker.close();
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
        Worker.State s = unzipWorker.getStatus();
        if (!Worker.State.DONE.equals((Object)s)) {
            if (Worker.State.CANCELLED.equals((Object)s) || val.equals(2)) {
                JOptionPane.showMessageDialog(this.speechRecorderUI, "Project import canceled.");
            } else {
                LocalizableMessage lm = unzipWorker.getProgressStatus().getMessage();
                JOptionPane.showMessageDialog(this.speechRecorderUI, lm.localize(), "Project import error.", 0);
            }
        } else {
            this.workspaceProjects = this.workspaceManager.scanWorkspace();
            this.speechRecorderUI.setWorkspaceProjects(this.workspaceProjects);
            this.openProject(projectName);
        }
    }

    public void update(UpdateManagerEvent event) {
        if (event instanceof UpdateAvailableEvent) {
            int cp;
            UpdateAvailableEvent uae = (UpdateAvailableEvent)event;
            Change.Priority priority = uae.getPriority();
            Change.Priority informPriority = null;
            if (this.updateManagerConfig != null) {
                informPriority = this.updateManagerConfig.getInformOnUpdatePriority();
            }
            if (informPriority == null) {
                informPriority = Change.Priority.STRONGLY_RECOMMENDED;
            }
            if ((cp = informPriority.compareTo((Enum)priority)) <= 0) {
                Runnable checkUpdatesRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SpeechRecorder.this.speechRecorderUI.doCheckUpdates();
                    }
                };
                SwingUtilities.invokeLater(checkUpdatesRunnable);
            }
        }
    }

    public List<AutoAnnotationServiceDescriptor> getAutoAnnotatorServiceDescriptors() throws IOException {
        return this.autoAnnotatorPluginManager.getAutoAnnotatorServiceDescriptors();
    }

    public WorkspaceManager getWorkspaceManager() {
        return this.workspaceManager;
    }

    public List<BundleAnnotationPersistorServiceDescriptor> getBundleAnnotationPersistorServiceDescriptors() {
        return this.availableBundleAnnotationServiceDescriptors;
    }

    @Override
    public void update(ProjectManagerEvent e) {
        if (e instanceof ProjectManagerProjectOpenedEvent) {
            this.workspaceManager.lock(e.getProjectName());
        } else if (e instanceof ProjectManagerProjectClosedEvent) {
            if (!this.projectManager.isUsingUploadCache()) {
                try {
                    this.workspaceProjects = this.workspaceManager.scanWorkspace();
                }
                catch (WorkspaceException e1) {
                    e1.printStackTrace();
                }
                this.speechRecorderUI.setWorkspaceProjects(this.workspaceProjects);
            }
            this.workspaceManager.unlock(e.getProjectName());
        } else if (e instanceof ProjectManagerProjectReadyForShutdownEvent) {
            System.exit(1);
        }
    }

    public void closeActiveProject() throws SpeechRecorderException {
        try {
            this.projectManager.close();
        }
        catch (SpeechRecorderException | StorageManagerException | WorkspaceException | AudioControllerException e) {
            throw new SpeechRecorderException(e);
        }
    }
}

