/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.SpeechRecorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SplashPanel
extends JPanel
implements DocumentListener {
    private static final long serialVersionUID = -664721791281526748L;
    private static final int NORMAL = 12;
    private static final int LARGE = 18;
    private static final int HUGE = 36;
    private static final int CREDITPANE_WIDTH = 600;
    private static final int CREDITPANE_HEIGHT = 350;
    private final JLabel splashTitle;
    private final JLabel splashVersion;
    private final JLabel splashAuthors;
    private final JLabel splashURL;
    private final JLabel splashCopyright;
    private final JLabel splashAddress;
    private final JLabel splashBatik;
    private final JLabel splashBatikURL;
    private JEditorPane splashCredits;
    private Logger logger;

    public SplashPanel() {
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.logger = Logger.getLogger("ipsk.apps.speechrecorder");
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        JPanel splashTextPane = new JPanel();
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        splashTextPane.setBorder(emptyBorder);
        splashTextPane.setLayout(new BoxLayout(splashTextPane, 1));
        splashTextPane.setAlignmentX(0.5f);
        this.splashTitle = new JLabel("SpeechRecorder", 0);
        this.splashTitle.setFont(new Font("Sans-serif", 1, 36));
        this.splashTitle.setAlignmentX(0.5f);
        this.splashVersion = new JLabel("Version " + SpeechRecorder.VERSION, 0);
        this.splashVersion.setFont(new Font("Sans-serif", 0, 12));
        this.splashVersion.setAlignmentX(0.5f);
        this.splashAuthors = new JLabel(" Chr. Draxler, K. J\u00e4nsch", 0);
        this.splashAuthors.setFont(new Font("Sans-serif", 0, 18));
        this.splashAuthors.setAlignmentX(0.5f);
        this.splashURL = new JLabel("http://www.bas.uni-muenchen.de/Bas/software/", 0);
        this.splashURL.setFont(new Font("sans-serif", 0, 12));
        this.splashURL.setAlignmentX(0.5f);
        this.splashCopyright = new JLabel("Copyright \u00a9 2004-2021", 0);
        this.splashCopyright.setFont(new Font("Sans-serif", 0, 12));
        this.splashCopyright.setAlignmentX(0.5f);
        this.splashAddress = new JLabel("Institut f\u00fcr Phonetik und Sprachverarbeitung, LMU M\u00fcnchen", 0);
        this.splashAddress.setFont(new Font("Sans-serif", 0, 12));
        this.splashAddress.setAlignmentX(0.5f);
        this.splashCredits = new JEditorPane();
        this.splashCredits.setEditable(false);
        this.splashCredits.setFont(new Font("Sans-serif", 0, 12));
        URL creditURL = this.getClass().getResource("text/credits.html");
        try {
            this.splashCredits.setPage(creditURL);
        }
        catch (IOException e) {
            this.logger.severe("IOException when loading splash screen credits: " + creditURL.toExternalForm());
        }
        this.splashCredits.getDocument().addDocumentListener(this);
        this.splashCredits.setPreferredSize(new Dimension(600, 350));
        this.splashBatik = new JLabel("Apache Batik SVG by \"The Apache Software Foundation\"");
        this.splashBatik.setFont(new Font("Sans-serif", 0, 12));
        this.splashBatik.setAlignmentX(0.5f);
        this.splashBatikURL = new JLabel("http://xmlgraphics.apache.org/batik/");
        this.splashBatikURL.setFont(new Font("Sans-serif", 0, 12));
        this.splashBatikURL.setAlignmentX(0.5f);
        splashTextPane.add(this.splashTitle);
        splashTextPane.add(Box.createRigidArea(new Dimension(0, 20)));
        splashTextPane.add(this.splashVersion);
        splashTextPane.add(Box.createRigidArea(new Dimension(0, 10)));
        splashTextPane.add(this.splashAuthors);
        splashTextPane.add(Box.createRigidArea(new Dimension(0, 10)));
        splashTextPane.add(this.splashCopyright);
        splashTextPane.add(Box.createRigidArea(new Dimension(0, 10)));
        splashTextPane.add(this.splashAddress);
        splashTextPane.add(Box.createRigidArea(new Dimension(0, 10)));
        splashTextPane.add(this.splashURL);
        splashTextPane.add(Box.createRigidArea(new Dimension(0, 20)));
        splashTextPane.add(this.splashBatik);
        splashTextPane.add(this.splashBatikURL);
        splashTextPane.add(Box.createRigidArea(new Dimension(0, 20)));
        splashTextPane.add(this.splashCredits);
        this.add((Component)splashTextPane, "Center");
    }

    private void updateSize() {
        this.revalidate();
        Container parent = this.getParent();
        if (parent != null && parent instanceof JComponent) {
            ((JComponent)parent).revalidate();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateSize();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateSize();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateSize();
    }
}

