/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.SplashPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JWindow;
import javax.swing.Timer;

public class SplashScreen
extends JWindow {
    private static final long serialVersionUID = 1L;
    private JButton closeButton;
    private SplashPanel splashPane;
    private GraphicsConfiguration splashScreenConfiguration;
    private int displayTime = 5000;
    private boolean closeable;
    private Timer timer;

    public SplashScreen(GraphicsConfiguration gc, boolean closeable) {
        this.setBackground(Color.WHITE);
        this.splashScreenConfiguration = gc;
        this.splashPane = new SplashPanel();
        this.closeButton = new JButton("OK");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplashScreen.this.disposeSplashScreen();
            }
        });
        this.setCloseable(closeable);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.splashPane, "Center");
        this.setCloseable(closeable);
        this.pack();
        int locX = (int)(((double)this.splashScreenConfiguration.getBounds().width - this.getSize().getWidth()) / 2.0);
        int locY = (int)(((double)this.splashScreenConfiguration.getBounds().height - this.getSize().getHeight()) / 2.0);
        this.setLocation(locX, locY);
        this.timer = new Timer(this.displayTime, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplashScreen.this.disposeSplashScreen();
            }
        });
    }

    private boolean isCloseable() {
        return this.closeable;
    }

    private void setCloseable(boolean b) {
        this.closeable = b;
        if (this.isCloseable()) {
            this.getContentPane().add((Component)this.closeButton, "South");
        } else {
            this.getContentPane().remove(this.closeButton);
        }
        this.repaint();
    }

    public void showScreen() {
        this.setVisible(true);
        this.toFront();
        this.timer.start();
    }

    public void disposeSplashScreen() {
        this.setVisible(false);
        this.dispose();
        this.timer.stop();
    }
}

