/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class TimeLogger {
    private Logger timeLogger;
    private String timeLoggerName;
    private Handler logFileHandler;

    public TimeLogger(String logName, Handler handler) {
        this.timeLoggerName = logName;
        this.logFileHandler = handler;
        this.timeLogger = Logger.getLogger(this.timeLoggerName);
        if (this.logFileHandler == null) {
            try {
                this.logFileHandler = new FileHandler(this.timeLoggerName);
                this.logFileHandler.setFormatter(new TimeLogFormatter());
                this.timeLogger.addHandler(this.logFileHandler);
            }
            catch (IOException e) {
                this.timeLogger.severe("Could not associate a file with the current logger: " + e);
            }
            catch (SecurityException e) {
                this.timeLogger.severe("Could not write to a log file: " + e);
            }
        }
    }

    public TimeLogger(String logName) {
        this(logName, null);
    }

    public void createLogEntry(String message) {
        this.timeLogger.info(message);
    }

    public void setLevel(Level timeLogLevel) {
        this.timeLogger.setLevel(timeLogLevel);
    }

    public Level getLevel() {
        return this.timeLogger.getLevel();
    }

    public synchronized void removeHandler(Handler handler) throws SecurityException {
        this.timeLogger.removeHandler(handler);
    }

    class TimeLogFormatter
    extends Formatter {
        TimeLogFormatter() {
        }

        @Override
        public String format(LogRecord lr) {
            return lr.getLevel() + "\t" + lr.getMessage() + "\t" + lr.getMillis() + "\n";
        }
    }
}

