/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.annotation.auto;

import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.annotation.auto.ProjectAutoAnnotator;
import ipsk.apps.speechrecorder.project.ActiveProjectManager;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.awt.ProgressWorker;
import ipsk.awt.WorkerException;
import ipsk.util.ProgressUpdate;
import java.io.IOException;
import java.net.URISyntaxException;

public class ProjectAutoAnnotatorWorker
extends ProgressWorker {
    private ProjectAutoAnnotator paa;
    private boolean overwriteAnnotationFiles = false;

    public boolean isOverwriteAnnotationFiles() {
        return this.overwriteAnnotationFiles;
    }

    public void setOverwriteAnnotationFiles(boolean overwriteAnnotationFiles) {
        this.overwriteAnnotationFiles = overwriteAnnotationFiles;
    }

    public ProjectAutoAnnotatorWorker(ActiveProjectManager projectManager) {
        this.paa = new ProjectAutoAnnotator(projectManager);
        this.setTask(this.paa);
    }

    protected void doWork() throws WorkerException {
        try {
            this.paa.autoAnnotateProject(this.overwriteAnnotationFiles, (ProgressUpdate)this);
        }
        catch (SpeechRecorderException | ProjectManagerException | IOException | URISyntaxException e) {
            e.printStackTrace();
            throw new WorkerException("Error auto annotating project: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

