/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.annotation.auto.impl;

import ips.annot.autoannotator.AutoAnnotation;
import ips.annot.autoannotator.AutoAnnotationServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.autoannotator.BundleAutoAnnotation;
import ips.annot.model.PredefinedLevelDefinition;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ipsk.apps.speechrecorder.annotation.auto.impl.TemplateAutoAnnotatorServiceDescriptor;
import java.io.IOException;
import java.util.List;

public class TemplateAutoAnnotator
implements AutoAnnotator {
    public static final PredefinedLevelDefinition PREDEFINED_LEVEL_DEFINITION = PredefinedLevelDefinition.TPL;
    private TemplateAutoAnnotatorServiceDescriptor sd = new TemplateAutoAnnotatorServiceDescriptor();
    private AutoAnnotator.AnnotationRequest annotationRequest;
    private String templateText;

    public String getTemplateText() {
        return this.templateText;
    }

    public void setTemplateText(String templateText) {
        this.templateText = templateText;
    }

    public AutoAnnotation call() throws Exception {
        if (this.templateText == null) {
            return null;
        }
        Bundle inputBundle = this.annotationRequest.getBundle();
        List lvls = inputBundle.getLevels();
        Level lvl = null;
        for (Level l : lvls) {
            if (!PREDEFINED_LEVEL_DEFINITION.getKeyName().equals(l.getName())) continue;
            lvl = l;
            break;
        }
        if (lvl == null) {
            lvl = new Level();
            lvl.setName(PREDEFINED_LEVEL_DEFINITION.getKeyName());
            lvl.setType(PREDEFINED_LEVEL_DEFINITION.getType());
            lvls.add(lvl);
        }
        Item it = new Item();
        it.setLevel(lvl);
        it.setLabel(PREDEFINED_LEVEL_DEFINITION.getKeyName(), (Object)this.templateText);
        lvl.getItems().add(it);
        return new BundleAutoAnnotation(inputBundle);
    }

    public AutoAnnotationServiceDescriptor getServiceDescriptor() {
        return this.sd;
    }

    public boolean isBundleSupported(Bundle bundle) throws IOException {
        return true;
    }

    public void open() {
    }

    public void setAnnotationRequest(AutoAnnotator.AnnotationRequest annotationRequest) {
        this.annotationRequest = annotationRequest;
    }

    public void close() {
    }

    public boolean needsWorker() {
        return false;
    }
}

