/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config;

import ipsk.beans.dom.DOMAttributes;
import ipsk.beans.dom.DOMTextNodePropertyName;
import ipsk.text.ParserException;

@DOMAttributes(value={"providerId", "interfaceName", "regex"})
@DOMTextNodePropertyName(value="name")
public class MixerName {
    private String name;
    private String interfaceName = null;
    private String providerId = null;
    private boolean regex = false;

    public MixerName() {
    }

    public MixerName(String name) {
        this(null, name);
    }

    public MixerName(String providerId, String name) {
        this(providerId, name, false);
    }

    public MixerName(String providerId, String name, boolean regex) {
        this(providerId, null, name, regex);
    }

    public MixerName(String providerId, String interfaceName, String name) {
        this(providerId, interfaceName, name, false);
    }

    public MixerName(String providerId, String interfaceName, String name, boolean regex) {
        this();
        this.providerId = providerId;
        this.interfaceName = interfaceName;
        this.name = name;
        this.regex = regex;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public ProviderId providerIdObj() throws ParserException {
        if (this.providerId == null) {
            if (this.interfaceName == null || "".equals(this.interfaceName)) {
                return new ProviderId(ProviderId.ProviderIdType.JAVA_SOUND);
            }
            return new ProviderId(ProviderId.ProviderIdType.SELECT_BY_NAME, this.interfaceName);
        }
        return ProviderId.parse(this.providerId);
    }

    public void setProviderId(String interfaceId) {
        this.providerId = interfaceId;
    }

    public boolean equals(Object o) {
        MixerName oRmn;
        if (o != null && o instanceof MixerName && (oRmn = (MixerName)o).isRegex() == this.isRegex()) {
            String oRmnName;
            String oProviderId = oRmn.getProviderId();
            if (oProviderId == null) {
                if (this.providerId != null) {
                    return false;
                }
                String oInterfaceName = oRmn.getInterfaceName();
                if (oInterfaceName == null ? this.interfaceName != null : !oInterfaceName.equals(this.interfaceName)) {
                    return false;
                }
            } else if (!oProviderId.equals(this.providerId)) {
                return false;
            }
            if ((oRmnName = oRmn.getName()) == null ? this.name == null : oRmnName.equals(this.name)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.providerId != null) {
            s.append(this.providerId);
            s.append(": ");
        }
        if (this.interfaceName != null) {
            s.append(this.interfaceName);
            s.append(": ");
        }
        if (this.name != null) {
            s.append(this.name);
        }
        if (this.regex) {
            s.append(" (regular expr)");
        }
        return s.toString();
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public static class ProviderId {
        private ProviderIdType idType;
        private String id;

        public ProviderIdType getIdType() {
            return this.idType;
        }

        public String getId() {
            return this.id;
        }

        public ProviderId(ProviderIdType idType) {
            this(idType, null);
        }

        public ProviderId(ProviderIdType idType, String id) {
            this.idType = idType;
            this.id = id;
        }

        public static ProviderId parse(String providerIdStr) throws ParserException {
            ProviderIdType idType = ProviderIdType.parse(providerIdStr);
            String id = null;
            if (idType.hasIdValue) {
                id = providerIdStr.substring(idType.prefix().length());
            } else if (idType.value().length() != providerIdStr.length()) {
                throw new ParserException("Audio interface ID type " + idType + " must not have an ID value");
            }
            return new ProviderId(idType, id);
        }

        public String toString() {
            return this.idType.prefix() + this.id;
        }

        public static enum ProviderIdType {
            JAVA_SOUND("java", "javasound", false),
            JAVA_CLASS("java", "class", true),
            SELECT_DEFAULT("select", "default", false),
            SELECT_BY_NAME("select", "name", true);

            private final String major;
            private final String minor;
            private final boolean hasIdValue;
            private final String value;

            public boolean isHasIdValue() {
                return this.hasIdValue;
            }

            private ProviderIdType(String major, String minor, boolean hasIdValue) {
                this.major = major;
                this.minor = minor;
                this.hasIdValue = hasIdValue;
                String val = major;
                if (minor != null) {
                    val = val.concat(":" + minor);
                }
                this.value = val;
            }

            public String value() {
                return this.value;
            }

            public String toString() {
                return this.value;
            }

            public static ProviderIdType getByValue(String value) {
                for (ProviderIdType pit : ProviderIdType.values()) {
                    if (!pit.value.equals(value)) continue;
                    return pit;
                }
                return null;
            }

            public static ProviderIdType parse(String providerIdStr) throws ParserException {
                for (ProviderIdType pit : ProviderIdType.values()) {
                    String major = pit.getMajor();
                    if (!providerIdStr.startsWith(major + ":")) continue;
                    String minor = pit.getMinor();
                    if (minor == null) {
                        return pit;
                    }
                    if (!(pit.isHasIdValue() ? providerIdStr.startsWith(pit.prefix()) : providerIdStr.equals(pit.value()))) continue;
                    return pit;
                }
                throw new ParserException("Not a valid audio interface provider ID type.");
            }

            public String prefix() {
                return this.value + ":";
            }

            public String getMajor() {
                return this.major;
            }

            public String getMinor() {
                return this.minor;
            }
        }
    }
}

