/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.config.MixerName;
import ipsk.swing.TitledPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MixerListChooser
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -389739661431600386L;
    private static final String PROTOTYPE_MIXERNAME = "Audio dummy prototype mixer name foo bla (dummy)";
    private JList list;
    private JButton addButt;
    private JButton removeButt;
    private JComboBox availBox;
    private JTextField vendorField;
    private JTextField versionField;
    private DefaultListModel listData = new DefaultListModel();
    private Vector<ActionListener> listeners;
    private JTextArea descrArea;
    private Mixer.Info[] availMixers;

    public MixerListChooser(Mixer.Info[] availMixers, MixerName[] selMixerNames) {
        this.availMixers = availMixers;
        this.listeners = new Vector();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 1;
        c.weightx = 2.0;
        JLabel listedMixersLabel = new JLabel("Listed mixers:");
        this.add((Component)listedMixersLabel, c);
        ++c.gridy;
        c.weighty = 2.0;
        this.list = new JList(this.listData);
        MixerName prototypeDummyMixerName = new MixerName(PROTOTYPE_MIXERNAME);
        this.list.setPrototypeCellValue(prototypeDummyMixerName);
        this.list.setVisibleRowCount(3);
        this.list.addListSelectionListener(this);
        JScrollPane listScrollPane = new JScrollPane(this.list);
        this.add((Component)listScrollPane, c);
        c.weighty = 0.0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 2.0;
        JPanel buttPanel = new JPanel(){
            private static final long serialVersionUID = 8969034884681272616L;

            @Override
            public void setEnabled(boolean enabled) {
                for (Component child : this.getComponents()) {
                    child.setEnabled(enabled);
                }
            }
        };
        this.addButt = new JButton("Add");
        this.addButt.addActionListener(this);
        buttPanel.add(this.addButt);
        this.removeButt = new JButton("Remove");
        this.removeButt.addActionListener(this);
        buttPanel.add(this.removeButt);
        this.add((Component)buttPanel, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Available mixers:"), c);
        ++c.gridy;
        c.gridwidth = 2;
        this.availBox = new JComboBox<Mixer.Info>(availMixers);
        this.availBox.addActionListener(this);
        this.add((Component)this.availBox, c);
        c.weightx = 2.0;
        c.fill = 2;
        ++c.gridy;
        this.add((Component)new JLabel("Vendor:"), c);
        ++c.gridy;
        this.vendorField = new JTextField();
        this.vendorField.setEditable(false);
        this.add((Component)this.vendorField, c);
        ++c.gridy;
        this.add((Component)new JLabel("Version:"), c);
        this.versionField = new JTextField();
        this.versionField.setEditable(false);
        ++c.gridy;
        this.add((Component)this.versionField, c);
        ++c.gridy;
        this.add((Component)new JLabel("Description:"), c);
        this.descrArea = new JTextArea();
        this.descrArea.setEditable(false);
        this.descrArea.setRows(2);
        ++c.gridy;
        this.add((Component)this.descrArea, c);
        this.setSelectedMixerNames(selMixerNames);
        this.updateInfoFields();
        this.updateEnabledActions();
    }

    public MixerListChooser(Mixer.Info[] availMixerInfos) {
        this(availMixerInfos, null);
    }

    public void setSelectedMixerNames(MixerName[] selectedMixerNames) {
        this.listData.clear();
        if (selectedMixerNames != null) {
            for (MixerName sm : selectedMixerNames) {
                this.listData.addElement(sm);
            }
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        MixerName rmn = new MixerName();
        rmn.setName("Haha");
        MixerListChooser mlch = new MixerListChooser(AudioSystem.getMixerInfo(), new MixerName[]{rmn});
        TitledPanel tPanel = new TitledPanel("Playback");
        tPanel.add((Component)mlch);
        f.getContentPane().add((Component)tPanel);
        f.pack();
        f.setVisible(true);
        mlch.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] children;
        super.setEnabled(enabled);
        for (Component ch : children = this.getComponents()) {
            ch.setEnabled(enabled);
        }
        this.list.setEnabled(enabled);
        if (enabled) {
            this.updateEnabledActions();
        }
    }

    private void updateEnabledActions() {
        if (this.isEnabled()) {
            if (this.availMixers == null || this.availMixers.length == 0) {
                this.list.setEnabled(false);
            }
            boolean addAble = false;
            Mixer.Info selInfo = (Mixer.Info)this.availBox.getSelectedItem();
            if (selInfo != null) {
                MixerName listSelMn = new MixerName(selInfo.getName());
                addAble = !this.listData.contains(listSelMn);
            }
            this.addButt.setEnabled(addAble);
            if (this.list.isSelectionEmpty()) {
                this.removeButt.setEnabled(false);
            } else {
                this.removeButt.setEnabled(true);
            }
        }
    }

    private void updateInfoFields() {
        Mixer.Info selInfo = (Mixer.Info)this.availBox.getSelectedItem();
        if (selInfo == null) {
            this.vendorField.setText("");
            this.versionField.setText("");
            this.descrArea.setText("");
        } else {
            this.vendorField.setText(selInfo.getVendor());
            this.versionField.setText(selInfo.getVersion());
            this.descrArea.setText(selInfo.getDescription());
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        if (src == this.addButt) {
            String selInfo = ((Mixer.Info)this.availBox.getSelectedItem()).getName();
            MixerName rmn = new MixerName(selInfo);
            if (!this.listData.contains(rmn)) {
                this.listData.addElement(rmn);
                this.fireAction();
            }
        } else if (src == this.removeButt) {
            Object[] selMixers;
            for (Object selMixer : selMixers = this.list.getSelectedValues()) {
                this.listData.removeElement(selMixer);
            }
            this.fireAction();
        } else if (src == this.availBox) {
            this.updateInfoFields();
        }
        this.updateEnabledActions();
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.updateEnabledActions();
    }

    protected synchronized void fireAction() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, 1001, "mixer_chooser_list_changed"));
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener != null && !this.listeners.contains(actionListener)) {
            this.listeners.addElement(actionListener);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.removeElement(actionListener);
        }
    }

    public MixerName[] getMixerList() {
        Object[] objData = this.listData.toArray();
        MixerName[] strData = new MixerName[objData.length];
        for (int i = 0; i < objData.length; ++i) {
            strData[i] = (MixerName)objData[i];
        }
        return strData;
    }
}

