/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui.prompt;

import ipsk.apps.speechrecorder.config.PromptConfiguration;
import ipsk.apps.speechrecorder.project.ActiveProjectManager;
import ipsk.swing.panel.JConfigPanel;
import ipsk.swing.text.EditorKitMenu;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class PromptCommonConfigurationView
extends JConfigPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private JCheckBox autoPromptPlayCheckBox;
    private JCheckBox recManualPlayCheckBox;
    private JCheckBox instructionNumberingCheckBox;
    private JCheckBox selectPromptFileCheckBox;
    private JButton promptsUrlBrowseButton;
    private JTextField urlField;
    private ActiveProjectManager activeProjectManager;
    private Document urlDoc;
    private PromptConfiguration initalPromptConfiguration = null;

    public PromptCommonConfigurationView(ActiveProjectManager activeProjectManager) {
        this.activeProjectManager = activeProjectManager;
        JPanel pp = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.gridx = 0;
        c.gridy = 0;
        pp.add((Component)new JLabel("Select recording script manually:"), c);
        this.selectPromptFileCheckBox = new JCheckBox();
        this.selectPromptFileCheckBox.addActionListener(this);
        ++c.gridx;
        pp.add((Component)this.selectPromptFileCheckBox, c);
        c.gridx = 0;
        ++c.gridy;
        pp.add((Component)new JLabel("Prompts URL:"), c);
        this.urlField = new JTextField();
        this.urlDoc = this.urlField.getDocument();
        this.urlDoc.addDocumentListener(this);
        EditorKitMenu urlFieldEkm = new EditorKitMenu((JTextComponent)this.urlField);
        urlFieldEkm.setPopupMenuActiv(true);
        ++c.gridx;
        c.weightx = 1.0;
        pp.add((Component)this.urlField, c);
        this.promptsUrlBrowseButton = new JButton("Browse...");
        this.promptsUrlBrowseButton.addActionListener(this);
        ++c.gridx;
        c.weightx = 0.0;
        pp.add((Component)this.promptsUrlBrowseButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        pp.add((Component)new JLabel("Automatic prompt play:"), c);
        this.autoPromptPlayCheckBox = new JCheckBox();
        this.autoPromptPlayCheckBox.addActionListener(this);
        ++c.gridx;
        pp.add((Component)this.autoPromptPlayCheckBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        pp.add((Component)new JLabel("Enable manual prompt start and stop while recording:"), c);
        this.recManualPlayCheckBox = new JCheckBox();
        this.recManualPlayCheckBox.addActionListener(this);
        ++c.gridx;
        pp.add((Component)this.recManualPlayCheckBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        pp.add((Component)new JLabel("Instruction numbering:"), c);
        this.instructionNumberingCheckBox = new JCheckBox();
        this.instructionNumberingCheckBox.addActionListener(this);
        ++c.gridx;
        pp.add((Component)this.instructionNumberingCheckBox, c);
        this.setDependencies();
        this.add(pp, "Center");
    }

    public void setPromptConfiguration(PromptConfiguration promptConfiguration) {
        this.initalPromptConfiguration = promptConfiguration;
        String cfgPromptsUrl = promptConfiguration.getPromptsUrl();
        boolean selectpromptsFileManually = cfgPromptsUrl == null;
        this.selectPromptFileCheckBox.setSelected(selectpromptsFileManually);
        String promptsUrl = this.activeProjectManager.defaultScriptUrlString();
        if (!selectpromptsFileManually) {
            promptsUrl = cfgPromptsUrl;
        }
        this.urlField.setText(promptsUrl);
        this.autoPromptPlayCheckBox.setSelected(promptConfiguration.getAutomaticPromptPlay());
        this.recManualPlayCheckBox.setSelected(promptConfiguration.getRecManualPlay());
        this.instructionNumberingCheckBox.setSelected(promptConfiguration.getInstructionNumbering());
        this.setDependencies();
    }

    public void applyValues(PromptConfiguration p) {
        p.setAutomaticPromptPlay(this.autoPromptPlayCheckBox.isSelected());
        p.setRecManualPlay(this.recManualPlayCheckBox.isSelected());
        p.setInstructionNumbering(this.instructionNumberingCheckBox.isSelected());
        String promptsUrl = null;
        boolean selectPromptsFile = this.selectPromptFileCheckBox.isSelected();
        if (!selectPromptsFile) {
            promptsUrl = this.urlField.getText();
        }
        p.setPromptsUrl(promptsUrl);
    }

    private void setDependencies() {
        boolean selectablePromptsUrl = !this.selectPromptFileCheckBox.isSelected();
        this.promptsUrlBrowseButton.setEnabled(selectablePromptsUrl);
        this.urlField.setEnabled(selectablePromptsUrl);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src != this.autoPromptPlayCheckBox && src != this.instructionNumberingCheckBox) {
            if (src == this.selectPromptFileCheckBox) {
                this.setDependencies();
            } else if (src == this.promptsUrlBrowseButton) {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Select prompt file");
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    File selFile = chooser.getSelectedFile();
                    URI selFileUri = selFile.toURI();
                    String selFileuriStr = selFileUri.toString();
                    this.urlField.setText(selFileuriStr);
                }
            }
        }
        super.actionPerformed(ae);
        this.setDependencies();
    }

    public void documentChanged(DocumentEvent de) {
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    public void resetToDefaults() {
        this.selectPromptFileCheckBox.setSelected(false);
        this.urlField.setText(this.activeProjectManager.defaultScriptUrlString());
        PromptConfiguration defPc = new PromptConfiguration();
        this.recManualPlayCheckBox.setSelected(defPc.getRecManualPlay());
        this.instructionNumberingCheckBox.setSelected(defPc.getInstructionNumbering());
        this.autoPromptPlayCheckBox.setSelected(false);
    }

    public void resetToInitial() {
        this.setPromptConfiguration(this.initalPromptConfiguration);
    }
}

