/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.monitor.plugins;

import ipsk.apps.speechrecorder.monitor.StartStopSignal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class SimpleTrafficLight
extends JComponent
implements StartStopSignal {
    private static final long serialVersionUID = 1L;
    private static final int LIGHT_WIDTH = 60;
    private static final int LIGHT_PADDING = 2;
    private static final int WIDTH = 64;
    private static final int HEIGHT = 192;
    private static final int BORDER_WIDTH = 2;
    private StartStopSignal.State status = StartStopSignal.State.OFF;
    private Dimension fixedSize = new Dimension(68, 196);

    public SimpleTrafficLight() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setStatus(StartStopSignal.State status) {
        this.status = status;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, 64, 192);
        int y = 0;
        if (this.status.equals((Object)StartStopSignal.State.IDLE) || this.status.equals((Object)StartStopSignal.State.PRERECORDING)) {
            g2.setColor(Color.RED);
        } else {
            g2.setColor(Color.GRAY);
        }
        g2.fillOval(2, y + 2, 60, 60);
        y += 64;
        if (this.status.equals((Object)StartStopSignal.State.POSTRECORDING) || this.status.equals((Object)StartStopSignal.State.PRERECORDING)) {
            g2.setColor(Color.YELLOW);
        } else {
            g2.setColor(Color.GRAY);
        }
        g2.fillOval(2, y + 2, 60, 60);
        y += 64;
        if (this.status.equals((Object)StartStopSignal.State.RECORDING)) {
            g2.setColor(Color.GREEN);
        } else {
            g2.setColor(Color.GRAY);
        }
        g2.fillOval(2, y + 2, 60, 60);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.fixedSize;
    }
}

