/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.MediaPromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterListener;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterClosedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterOpenedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterStartEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterStopEvent;
import java.util.Vector;

public abstract class BasicMediaPromptPresenter
extends BasicPromptPresenter
implements MediaPromptPresenter {
    private static final long serialVersionUID = 1L;
    protected Vector<PromptPresenterListener> listeners = new Vector();
    protected boolean open = false;
    protected boolean running = false;

    public void setContents(String string, String description, String type) {
    }

    @Override
    public void open() {
        if (!this.open) {
            this.open = true;
            this.updateListeners(new PromptPresenterOpenedEvent(this));
        }
    }

    @Override
    public void start() {
        if (!this.running) {
            this.running = true;
            this.updateListeners(new PromptPresenterStartEvent(this));
        }
    }

    @Override
    public void stop() {
        if (this.running) {
            this.running = false;
            this.updateListeners(new PromptPresenterStopEvent(this));
        }
    }

    @Override
    public void close() {
        this.stop();
        if (!this.open) {
            this.open = false;
            this.updateListeners(new PromptPresenterClosedEvent(this));
        }
    }

    @Override
    protected synchronized void updateListeners(PromptPresenterEvent event) {
        for (PromptPresenterListener ppl : this.listeners) {
            ppl.update(event);
        }
    }

    @Override
    public void addPromptPresenterListener(PromptPresenterListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    @Override
    public void removePromptPresenterListener(PromptPresenterListener listener) {
        if (listener != null) {
            this.listeners.removeElement(listener);
        }
    }
}

