/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterListener;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterClosedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterStopEvent;
import ipsk.audio.AudioController2;
import ipsk.audio.AudioControllerException;
import ipsk.audio.AudioSource;
import ipsk.audio.URLAudioSource;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;

@Title(value="Audio prompter")
@Description(value="Presents audio using speechrecorder audio controller interface")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=1)
public class PromptAudioControllerViewer
extends BasicPromptPresenter
implements PromptPresenter,
AudioController2.AudioController2Listener {
    private static final long serialVersionUID = -448684398142928391L;
    private static final PromptPresenterServiceDescriptor DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(PromptAudioControllerViewer.class.getName(), new LocalizableMessage("Audio prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(new int[]{1, 0, 0}), new LocalizableMessage("Presents audio using speechrecorder audio controller interface"), PromptAudioControllerViewer.getSupportedMIMETypes());
    private ImageIcon audioImage;
    private AudioController2 audioController;
    private Vector<PromptPresenterListener> listeners = new Vector();
    private JButton audioButton;
    private URL audioURL = null;

    PromptAudioControllerViewer(AudioController2 audioController) {
        this.audioController = audioController;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.audioImage = new ImageIcon(this.getClass().getResource("icons/playAudio.gif"));
        this.audioButton = new JButton(this.audioImage);
        this.audioButton.setVerticalTextPosition(3);
        this.audioButton.setHorizontalTextPosition(0);
        this.audioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PromptAudioControllerViewer.this.mediaPlay();
            }
        });
        this.add((Component)this.audioButton, "Center");
    }

    public void setContents(String string, String description, String type) {
    }

    public void mediaPlay() {
        if (this.audioURL != null) {
            try {
                this.audioController.addAudioController2Listener((AudioController2.AudioController2Listener)this);
                this.audioController.openPlayback();
                this.audioController.startPlayback();
            }
            catch (AudioControllerException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getSize());
    }

    public void showContents() {
    }

    public void hideContents() {
    }

    public void loadContents(URL url) {
    }

    public void setContents(String name) {
    }

    public void setContents(String name, String description) {
    }

    public void setContents(URL url) {
        this.audioURL = url;
        this.audioButton.setIcon(this.audioImage);
        try {
            this.audioController.setPlaybackAudioSource((AudioSource)new URLAudioSource(this.audioURL));
        }
        catch (AudioControllerException e) {
            e.printStackTrace();
        }
    }

    public void setContents(URL url, String description) {
        this.audioButton.setText(description);
        this.setContents(url);
    }

    public void setContents(URL url, String description, String type) {
        this.setContents(url, description);
    }

    public void setContents(URL url, String description, String t, String charset) {
        this.setContents(url, description, t);
    }

    public void mediaStop() {
        try {
            this.audioController.stopPlayback();
        }
        catch (AudioControllerException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.audioController.closePlayback();
        }
        catch (AudioControllerException e) {
            e.printStackTrace();
        }
    }

    public void update(AudioController2.AudioControllerEvent ace) {
        if (ace instanceof PlayerEvent) {
            if (ace instanceof PlayerStopEvent) {
                this.updateListeners(new PromptPresenterStopEvent(this));
            } else if (ace instanceof PlayerCloseEvent) {
                this.updateListeners(new PromptPresenterClosedEvent(this));
            }
        }
    }

    @Override
    protected synchronized void updateListeners(PromptPresenterEvent event) {
        for (PromptPresenterListener ppl : this.listeners) {
            ppl.update(event);
        }
    }

    @Override
    public void addPromptPresenterListener(PromptPresenterListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    @Override
    public void removePromptPresenterListener(PromptPresenterListener listener) {
        if (listener != null) {
            this.listeners.removeElement(listener);
        }
    }

    public static String[][] getSupportedMIMETypes() {
        String[][] mtypes = new String[MIMETypes.AUDIOMIMETYPES.length][1];
        for (int i = 0; i < MIMETypes.AUDIOMIMETYPES.length; ++i) {
            mtypes[i][0] = MIMETypes.AUDIOMIMETYPES[i];
        }
        return mtypes;
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        if (this.mediaitems.length > 1) {
            throw new UnsupportedContentException("Multiple media items not supported!");
        }
        Mediaitem mi = this.mediaitems[0];
        URL url = this.applyContextToMediaitemURL(mi);
        String description = mi.getDescription();
        if (description != null) {
            this.audioButton.setText(description);
        }
        this.audioURL = url;
        this.audioButton.setIcon(this.audioImage);
        try {
            this.audioController.setPlaybackAudioSource((AudioSource)new URLAudioSource(this.audioURL));
        }
        catch (AudioControllerException e) {
            throw new PromptPresenterException(e);
        }
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }
}

