/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import java.awt.Dimension;
import java.awt.Image;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

@Title(value="Image icon prompter")
@Description(value="Presents image icons (GIF files).")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=1)
public class PromptImageIconViewer
extends BasicPromptPresenter
implements PromptPresenter {
    private static final long serialVersionUID = 1L;
    public static final PromptPresenterServiceDescriptor DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(PromptImageIconViewer.class.getName(), new LocalizableMessage("Image prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(new int[]{1, 0, 0}), new LocalizableMessage("Presents image icons."), PromptImageIconViewer.getSupportedMIMETypes());
    private Image image;
    private ImageIcon imageIcon = new ImageIcon();
    private JLabel label = null;

    public PromptImageIconViewer() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.label = new JLabel(this.imageIcon);
        this.add(this.label);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getSize());
    }

    public void showContents() {
    }

    public void hideContents() {
    }

    public void loadContents(URL url) {
    }

    public void setContents(String imageName) {
    }

    public void setContents(String imageName, String description) {
    }

    public void setContents(String cts, String description, String type) {
    }

    public synchronized void setContents(URL imageIconURL) {
        this.loadImageIcon(imageIconURL);
    }

    public void setContents(URL imageURL, String d) {
        this.setContents(imageURL);
    }

    public void setContents(URL imageURL, String d, String t) {
        this.setContents(imageURL);
    }

    public void setContents(URL imageUrl, String description, String type, String charset) {
        this.setContents(imageUrl);
    }

    @Override
    public void doLayout() {
        if (this.image != null) {
            int h;
            int w;
            int ih;
            float hr;
            int cw = this.getSize().width;
            int ch = this.getSize().height;
            int iw = this.image.getWidth(this);
            float wr = (float)cw / (float)iw;
            if (wr < (hr = (float)ch / (float)(ih = this.image.getHeight(this)))) {
                w = (int)((float)iw * wr);
                h = (int)((float)ih * wr);
            } else {
                w = (int)((float)iw * hr);
                h = (int)((float)ih * hr);
            }
            int x = (cw - w) / 2;
            int y = (ch - h) / 2;
            Image scaledImage = this.image.getScaledInstance(w, h, 1);
            this.imageIcon.setImage(scaledImage);
            this.label.setBounds(x, y, w, h);
        }
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        if (this.mediaitems == null || this.mediaitems.length == 0) {
            throw new UnsupportedContentException("No media item to display!");
        }
        if (this.mediaitems.length > 1) {
            throw new UnsupportedContentException("Multiple media items not supported!");
        }
        Mediaitem mi = this.mediaitems[0];
        URL imageIconURL = this.applyContextToMediaitemURL(mi);
        this.loadImageIcon(imageIconURL);
    }

    private void loadImageIcon(URL imageIconURL) {
        if (this.image == null) {
            ImageIcon imgIcon = new ImageIcon(imageIconURL);
            this.image = imgIcon.getImage();
        }
    }

    public static String[][] getSupportedMIMETypes() {
        return PromptImageIconViewer.getSupportedMIMETypes(MIMETypes.IMAGEICONMIMETYPES);
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }
}

