/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.BorderFactory;

@Title(value="Image prompter")
@Description(value="Presents images.")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=1)
public class PromptImageViewer
extends BasicPromptPresenter
implements PromptPresenter {
    private static final long serialVersionUID = 1L;
    private static final PromptPresenterServiceDescriptor DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(PromptImageViewer.class.getName(), new LocalizableMessage("Image prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(new int[]{1, 0, 0}), new LocalizableMessage("Presents images."), PromptImageViewer.getSupportedMIMETypes());
    private Hashtable promptImages;
    private Image image;
    private Logger logger = Logger.getLogger("ipsk.apps.speechrecorder");
    MediaTracker tracker;

    PromptImageViewer() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.tracker = new MediaTracker(this);
    }

    public void setRecScriptResources(Hashtable ih) {
        this.promptImages = ih;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getSize());
    }

    public void showContents() {
    }

    public void hideContents() {
    }

    public void loadContents(URL url) {
    }

    public void setContents(String imageName) {
    }

    public void setContents(String imageName, String description) {
    }

    public void setContents(String cts, String description, String type) {
    }

    public synchronized void setContents(URL imageURL) {
        if (this.promptImages != null) {
            this.image = (Image)this.promptImages.get(imageURL);
        }
        if (this.image == null) {
            this.image = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
    }

    public void setContents(URL imageURL, String d) {
        this.setContents(imageURL);
    }

    public void setContents(URL imageURL, String d, String t) {
        this.setContents(imageURL);
    }

    public void setContents(URL imageUrl, String description, String type, String charset) {
        this.setContents(imageUrl);
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        if (this.mediaitems == null || this.mediaitems.length == 0) {
            throw new UnsupportedContentException("No media item to display!");
        }
        if (this.mediaitems.length > 1) {
            throw new UnsupportedContentException("Multiple media items not supported!");
        }
        Mediaitem mi = this.mediaitems[0];
        URL imageURL = this.applyContextToMediaitemURL(mi);
        if (this.promptImages != null) {
            this.image = (Image)this.promptImages.get(imageURL);
        }
        if (this.image == null) {
            this.image = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.image != null) {
            int h;
            int w;
            int ih;
            float hr;
            int cw = this.getSize().width;
            int ch = this.getSize().height;
            int iw = this.image.getWidth(this);
            float wr = (float)cw / (float)iw;
            if (wr < (hr = (float)ch / (float)(ih = this.image.getHeight(this)))) {
                w = (int)((float)iw * wr);
                h = (int)((float)ih * wr);
            } else {
                w = (int)((float)iw * hr);
                h = (int)((float)ih * hr);
            }
            int x = (cw - w) / 2;
            int y = (ch - h) / 2;
            g.drawImage(this.image, x, y, w, h, this);
        }
    }

    public static String[][] getSupportedMIMETypes() {
        return PromptImageViewer.getSupportedMIMETypes(MIMETypes.IMAGEMIMETYPES);
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }
}

