/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui;

import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.script.ui.BaseMediaitemUI;
import ipsk.apps.speechrecorder.script.ui.StringSel;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyledDocument;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.db.speech.script.prompt.doc.PromptDoc;
import ipsk.swing.JServiceSelector;
import ipsk.swing.TitledPanel;
import ipsk.swing.action.EditActionsListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;

public class MediaitemUI
extends BaseMediaitemUI
implements ActionListener,
EditActionsListener,
PropertyChangeListener,
DocumentListener {
    public MediaitemUI(URL projectContext, List<PromptPresenterServiceDescriptor> availablePromptPresenters) {
        this(projectContext, null, availablePromptPresenters);
    }

    public MediaitemUI(URL projectContext, Mediaitem mediaitem, List<PromptPresenterServiceDescriptor> availablePromptPresenters) {
        super(projectContext, availablePromptPresenters);
        this.createWidgets();
        JTabbedPane itemPanel = this.makeItemPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)itemPanel, "Center");
        this.setMediaitem(mediaitem);
    }

    private JTabbedPane makeItemPanel() {
        JTabbedPane itemPanel = new JTabbedPane();
        itemPanel.addTab("Prompt", this.makeMediaSourcePanel());
        itemPanel.addTab("Control", this.makeControlPanel());
        itemPanel.setSelectedIndex(0);
        return itemPanel;
    }

    private JPanel makeControlPanel() {
        JPanel controlPanel = new JPanel();
        GridBagLayout tpL = new GridBagLayout();
        controlPanel.setLayout(tpL);
        GridBagConstraints tpC = new GridBagConstraints();
        tpC.fill = 2;
        tpC.insets = new Insets(0, 5, 5, 5);
        tpC.gridx = 0;
        tpC.gridy = 0;
        ++tpC.gridy;
        tpC.anchor = 17;
        this.volumeLabel = new JLabel("Volume %", 4);
        tpC.gridx = 0;
        ++tpC.gridy;
        tpC.gridwidth = 1;
        tpL.setConstraints(this.volumeLabel, tpC);
        ++tpC.gridx;
        tpC.gridwidth = 3;
        tpC.anchor = 17;
        tpL.setConstraints(this.mediaVolumeWidget, tpC);
        tpC.gridx = 0;
        ++tpC.gridy;
        tpC.gridwidth = 1;
        tpC.anchor = 17;
        tpL.setConstraints(this.autoPlayNonDefaultWidget, tpC);
        ++tpC.gridx;
        tpC.gridwidth = 1;
        tpC.anchor = 17;
        tpL.setConstraints(this.autoPlayWidget, tpC);
        tpC.gridx = 0;
        ++tpC.gridy;
        tpC.gridwidth = 3;
        tpC.anchor = 17;
        tpL.setConstraints(this.modalPlayWidget, tpC);
        controlPanel.add(this.volumeLabel);
        controlPanel.add(this.mediaVolumeWidget);
        controlPanel.add(this.autoPlayNonDefaultWidget);
        controlPanel.add(this.autoPlayWidget);
        controlPanel.add(this.modalPlayWidget);
        return controlPanel;
    }

    private JPanel makeMediaSourcePanel() {
        JPanel mediaSourcePanel = new JPanel();
        GridBagLayout mspL = new GridBagLayout();
        GridBagConstraints mspC = new GridBagConstraints();
        mediaSourcePanel.setLayout(mspL);
        mspC.anchor = 17;
        this.srcTypeLabel = new JLabel("Location", 4);
        this.mimeTypeLabel = new JLabel("MIME-Type", 4);
        this.importButton.addActionListener(this);
        this.selectButton.addActionListener(this);
        mediaSourcePanel.add(this.srcTypeLabel);
        mediaSourcePanel.add(this.external);
        mediaSourcePanel.add(this.promptSourceWidget);
        mediaSourcePanel.add(this.importButton);
        mediaSourcePanel.add(this.selectButton);
        mspC.insets = new Insets(0, 5, 5, 5);
        mspC.gridx = 0;
        mspC.gridy = 0;
        mspC.anchor = 13;
        ++mspC.gridx;
        mspC.gridwidth = 3;
        mspC.anchor = 17;
        mspC.weightx = 2.0;
        mspC.fill = 2;
        mspC.gridx = 0;
        ++mspC.gridy;
        mspC.gridwidth = 1;
        mspC.weightx = 0.0;
        mspC.fill = 0;
        mspC.anchor = 13;
        mspL.setConstraints(this.mimeTypeLabel, mspC);
        ++mspC.gridx;
        mspC.gridwidth = 3;
        mspC.anchor = 17;
        mspL.setConstraints(this.mimeTypeWidget, mspC);
        mspC.gridx = 0;
        ++mspC.gridy;
        mspC.gridwidth = 1;
        mspC.anchor = 13;
        mspL.setConstraints(this.charsetLabel, mspC);
        ++mspC.gridx;
        mspC.anchor = 17;
        mspC.gridwidth = 3;
        mspL.setConstraints(this.charsetWidget, mspC);
        mspC.gridx = 0;
        ++mspC.gridy;
        mspC.gridwidth = 1;
        mspC.anchor = 13;
        mspL.setConstraints(this.srcTypeLabel, mspC);
        ++mspC.gridx;
        mspC.anchor = 17;
        mspC.gridwidth = 2;
        mspL.setConstraints(this.external, mspC);
        mspC.gridx = 0;
        ++mspC.gridy;
        mspC.gridwidth = 1;
        mspC.anchor = 13;
        mspL.setConstraints(this.sourceLabel, mspC);
        ++mspC.gridx;
        mspC.gridwidth = 1;
        mspC.weightx = 2.0;
        mspC.anchor = 17;
        mspC.fill = 2;
        mspL.setConstraints(this.promptSourceWidget, mspC);
        ++mspC.gridx;
        mspC.gridwidth = 1;
        mspC.weightx = 0.0;
        mspC.anchor = 17;
        mspC.fill = 0;
        mspL.setConstraints(this.importButton, mspC);
        ++mspC.gridx;
        mspC.gridwidth = 1;
        mspC.weightx = 0.0;
        mspC.anchor = 17;
        mspC.fill = 0;
        mspL.setConstraints(this.selectButton, mspC);
        mspC.gridx = 0;
        ++mspC.gridy;
        mspC.weightx = 0.0;
        mspC.anchor = 13;
        mspL.setConstraints(this.altTextLabel, mspC);
        ++mspC.gridx;
        mspC.gridwidth = 4;
        mspC.anchor = 17;
        mspC.weightx = 2.0;
        mspC.fill = 2;
        mspL.setConstraints(this.altTextWidget, mspC);
        mediaSourcePanel.add(this.mimeTypeLabel);
        mediaSourcePanel.add(this.mimeTypeWidget);
        mediaSourcePanel.add(this.charsetLabel);
        mediaSourcePanel.add(this.charsetWidget);
        mediaSourcePanel.add(this.sourceLabel);
        mediaSourcePanel.add(this.altTextLabel);
        mediaSourcePanel.add(this.altTextWidget);
        mspC.gridx = 0;
        this.promptTextContentsPanel = new TitledPanel(BorderFactory.createEtchedBorder(), "Prompt");
        this.promptTextContentsPanel.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints ptGbc = new GridBagConstraints();
        ptGbc.gridx = 0;
        ptGbc.gridy = 0;
        ptGbc.gridwidth = 2;
        ptGbc.fill = 1;
        ptGbc.weightx = 2.0;
        ptGbc.weighty = 2.0;
        JScrollPane scrollPane = new JScrollPane(this.promptTextWidget, 20, 31);
        this.promptTextContentsPanel.add((Component)scrollPane, (Object)ptGbc);
        ++ptGbc.gridy;
        ptGbc.fill = 0;
        ptGbc.anchor = 17;
        ptGbc.gridwidth = 2;
        ptGbc.weightx = 0.0;
        ptGbc.weighty = 0.0;
        this.promptTextContentsPanel.add((Component)this.promptAsAnnotationTemplateWidget, (Object)ptGbc);
        ++ptGbc.gridy;
        this.promptTextContentsPanel.add((Component)this.localeSelector, (Object)ptGbc);
        ++mspC.gridy;
        mspC.weighty = 2.0;
        mspC.fill = 1;
        mspL.setConstraints((Component)this.promptTextContentsPanel, mspC);
        mediaSourcePanel.add((Component)this.promptTextContentsPanel);
        return mediaSourcePanel;
    }

    private JPanel makePresentationPanel() {
        JPanel presentationPanel = new JPanel(new BorderLayout());
        this.promptPresenterSelector = new JServiceSelector();
        GridBagLayout mspL = new GridBagLayout();
        GridBagConstraints mspC = new GridBagConstraints();
        mspC.anchor = 17;
        mspC.insets = new Insets(5, 5, 5, 5);
        mspC.gridx = 0;
        mspC.gridy = 0;
        mspC.weightx = 2.0;
        mspC.weighty = 2.0;
        mspC.fill = 1;
        mspC.anchor = 13;
        presentationPanel.add((Component)this.promptPresenterSelector, "Center");
        return presentationPanel;
    }

    private void loadPromptContents() {
        URL url = null;
        try {
            url = new URL(this.promptSourceWidget.getText());
        }
        catch (MalformedURLException e) {
            JOptionPane errorMessage = new JOptionPane("Error loading from URL: " + e, 0);
            errorMessage.setVisible(true);
        }
    }

    @Override
    protected void applyValues() {
        if (this.mediaitem == null) {
            return;
        }
        String altText = this.altTextWidget.getText();
        if (altText.equals("")) {
            this.mediaitem.setAlt(null);
        } else {
            this.mediaitem.setAlt(altText);
        }
        if (this.autoPlayNonDefaultWidget.isSelected()) {
            this.mediaitem.setAutoplay(Boolean.valueOf(this.autoPlayWidget.isSelected()));
        } else {
            this.mediaitem.setAutoplay(null);
        }
        this.mediaitem.setNNModal(this.modalPlayWidget.isSelected());
        this.mediaitem.setNNHeight(Integer.parseInt(this.mediaHeightWidget.getText()));
        this.mediaitem.setNNWidth(Integer.parseInt(this.mediaWidthWidget.getText()));
        Integer vol = (Integer)this.mediaVolumeWidget.getValue();
        if (vol == 100) {
            this.mediaitem.setVolume(null);
        } else {
            this.mediaitem.setVolume(vol);
        }
        this.mediaitem.setNNMimetype((String)this.mimeTypeWidget.getSelectedItem());
        StringSel selCharSet = (StringSel)this.charsetWidget.getSelectedItem();
        String selCharSetStr = selCharSet.getString();
        this.mediaitem.setCharSet(selCharSetStr);
        Locale miLocale = this.localeSelector.getSelectedLocale();
        if (miLocale == null) {
            this.mediaitem.setLanguageISO639code(null);
            this.mediaitem.setCountryISO3166code(null);
        } else {
            this.mediaitem.setLanguageISO639code(miLocale.getLanguage());
            String miCountry = miLocale.getCountry();
            if (!"".equals(miCountry)) {
                this.mediaitem.setCountryISO3166code(miCountry);
            }
        }
        this.mediaitem.setAnnotationTemplate(this.promptAsAnnotationTemplateWidget.isSelected());
        if (this.external.getSelectedItem().equals("External")) {
            String promptSrcUrlStr = this.promptSourceWidget.getText();
            URI promptSrcUri = null;
            try {
                promptSrcUri = new URI(promptSrcUrlStr);
            }
            catch (URISyntaxException e) {
                try {
                    promptSrcUri = new URI(null, promptSrcUrlStr, null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            this.mediaitem.setSrc(promptSrcUri);
            this.mediaitem.setText(null);
            this.mediaitem.setPromptDoc(null);
        } else {
            this.mediaitem.setSrc(null);
            Document d = this.promptTextWidget.getDocument();
            PromptDoc prompt = this.mediaitem.getPromptDoc();
            if (this.formattedCheckbox.isSelected() && d instanceof PromptStyledDocument) {
                PromptStyledDocument psd = (PromptStyledDocument)d;
                PromptDoc pr = psd.toPromptFormat();
                this.mediaitem.setPromptDoc(pr);
                this.mediaitem.setText(null);
            } else {
                this.mediaitem.setPromptDoc(null);
                this.mediaitem.setText(this.promptTextWidget.getText());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    private void createTree() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Recording Script");
        this.createNodes(top);
        final JTree tree = new JTree(top);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setDragEnabled(true);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object nodeInfo = node.getUserObject();
            }
        });
        JScrollPane treeView = new JScrollPane(tree);
        JFrame frame = new JFrame("Recording script tree");
        frame.getContentPane().add(treeView);
        frame.pack();
        frame.setVisible(true);
    }

    private void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode section = null;
        DefaultMutableTreeNode item = null;
        section = new DefaultMutableTreeNode("Introduction");
        top.add(section);
        item = new DefaultMutableTreeNode("promptItem 1");
        section.add(item);
        section = new DefaultMutableTreeNode("Recording");
        top.add(section);
        item = new DefaultMutableTreeNode("IMAGE\ta small but quite nice photo\tx");
        section.add(item);
        item = new DefaultMutableTreeNode("TEXT\tW O L V E R H A M P T O N");
        section.add(item);
        item = new DefaultMutableTreeNode("TEXT\tBillericay");
        section.add(item);
        item = new DefaultMutableTreeNode("AUDIO\taudio file\t_");
        section.add(item);
    }

    public static void main(String[] args) {
        Mediaitem mi = new Mediaitem();
        mi.setAlt("Alternative");
        mi.setAutoplay(Boolean.valueOf(false));
        mi.setHeight(Integer.valueOf(100));
        mi.setWidth(Integer.valueOf(100));
        mi.setVolume(Integer.valueOf(50));
        mi.setMimetype("text/plain");
        mi.setModal(Boolean.valueOf(false));
        try {
            mi.setSrc(new URI("http://www.source.url/a_very_long_filename.html"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        mi.setText("Prompt text");
        MediaitemUI pie = new MediaitemUI(null, mi, null);
        pie.createTree();
    }
}

