/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.ui;

import ipsk.apps.speechrecorder.project.ActiveProjectManager;
import ipsk.util.LocalizableMessage;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class InfoViewer
extends JPanel
implements ActionListener {
    private static final int LEFT = 5;
    private static final int RIGHT = 5;
    private static final int TOP = 5;
    private static final int BOTTOM = 5;
    private ActiveProjectManager projectManager;
    private JLabel projectPathLabel;
    private JLabel projectPathValue;
    private JButton projectPathOpenButt;
    private JLabel recScriptLabel;
    private JLabel recDirLabel;
    private JLabel recScriptValue;
    private JLabel recDirValue;

    public InfoViewer(ActiveProjectManager sr) {
        this.projectManager = sr;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 19;
        this.projectPathLabel = new JLabel("Project directory: ");
        this.projectPathValue = new JLabel("");
        this.projectPathOpenButt = new JButton("Open in file manager");
        this.projectPathOpenButt.addActionListener(this);
        this.recScriptLabel = new JLabel("Script file: ");
        this.recDirLabel = new JLabel("Recording directory: ");
        this.recScriptValue = new JLabel("");
        this.recDirValue = new JLabel("");
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel("Java Runtime Environment: "), c);
        ++c.gridx;
        this.add((Component)new JLabel(System.getProperty("java.vendor") + " " + System.getProperty("java.version")), c);
        c.gridx = 0;
        ++c.gridy;
        try {
            Class.forName(LocalizableMessage.class.getName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Package javaUtilsPkg = Package.getPackage("ipsk.util");
        String utilLibVers = "n/a";
        if (javaUtilsPkg != null) {
            utilLibVers = javaUtilsPkg.getImplementationVersion();
        }
        this.add((Component)new JLabel("Utils library:"), c);
        ++c.gridx;
        this.add((Component)new JLabel(utilLibVers), c);
        c.gridx = 0;
        ++c.gridy;
        Package javaSpeechDbPkg = Package.getPackage("ipsk.db.speech");
        String speechDbLibVers = "n/a";
        if (javaSpeechDbPkg != null) {
            speechDbLibVers = javaSpeechDbPkg.getImplementationVersion();
        }
        this.add((Component)new JLabel("Speech DB library:"), c);
        ++c.gridx;
        this.add((Component)new JLabel(speechDbLibVers), c);
        c.gridx = 0;
        ++c.gridy;
        Package speechDbToolsPkg = Package.getPackage("ips.annot");
        String speechDbToolsLibVers = "n/a";
        if (speechDbToolsPkg != null) {
            speechDbToolsLibVers = speechDbToolsPkg.getImplementationVersion();
        }
        this.add((Component)new JLabel("Speech DB Tools library:"), c);
        ++c.gridx;
        this.add((Component)new JLabel(speechDbToolsLibVers), c);
        c.gridx = 0;
        ++c.gridy;
        Package javaAudioToolsPkg = Package.getPackage("ipsk.audio");
        String audioLibVers = "n/a";
        if (javaAudioToolsPkg != null) {
            audioLibVers = javaAudioToolsPkg.getImplementationVersion();
        }
        this.add((Component)new JLabel("Audio tool library:"), c);
        ++c.gridx;
        this.add((Component)new JLabel(audioLibVers), c);
        c.gridx = 0;
        ++c.gridy;
        Package speechRecorderPkg = Package.getPackage("ipsk.apps.speechrecorder");
        String speechrecLibVersion = "n/a";
        if (speechRecorderPkg != null) {
            speechrecLibVersion = speechRecorderPkg.getImplementationVersion();
        }
        this.add((Component)new JLabel("Speechrecorder library:"), c);
        ++c.gridx;
        this.add((Component)new JLabel(speechrecLibVersion), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)this.projectPathLabel, c);
        ++c.gridx;
        this.add((Component)this.projectPathValue, c);
        ++c.gridx;
        this.add((Component)this.projectPathOpenButt, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)this.recScriptLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.add((Component)this.recScriptValue, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)this.recDirLabel, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.add((Component)this.recDirValue, c);
        this.setData();
    }

    private boolean projectPathOpenable() {
        File projectPath = null;
        try {
            projectPath = this.projectManager.getProjectDir();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return Desktop.isDesktopSupported() && projectPath != null && projectPath.exists();
    }

    public void setData() {
        File projectPath = null;
        try {
            projectPath = this.projectManager.getProjectDir();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        String projectPathStr = "";
        if (projectPath != null) {
            projectPathStr = projectPath.toString();
        }
        boolean openable = this.projectPathOpenable();
        this.projectPathOpenButt.setEnabled(openable);
        this.projectPathValue.setText(projectPathStr);
        String recScriptName = this.projectManager.getRecScriptName();
        if (recScriptName == null) {
            recScriptName = new String("");
        }
        this.recScriptValue.setText(recScriptName);
        String recDirName = this.projectManager.getRecDirName();
        if (recDirName == null) {
            recDirName = new String("");
        }
        this.recDirValue.setText(recDirName);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            File projectDir = null;
            try {
                projectDir = this.projectManager.getProjectDir();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            if (projectDir != null) {
                try {
                    d.open(projectDir);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Could not open project directory:\n" + e.getLocalizedMessage(), "Project directory open error", 0);
                }
            }
        }
    }
}

