/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.workspace.ui;

import ipsk.apps.speechrecorder.workspace.WorkspaceManager;
import ipsk.apps.speechrecorder.workspace.ui.WorkspaceProjectsPanel;
import ipsk.swing.JDialogPanel;
import ipsk.swing.text.EditorKitMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class WorkspacePanel
extends JDialogPanel {
    private WorkspaceProjectsPanel projectsPanel;
    private JButton openButt;
    private Desktop desktop = null;
    private File workspaceDir;

    public WorkspacePanel(WorkspaceManager workspaceManager) {
        super(JDialogPanel.Options.CANCEL);
        this.cancelButton.setText("Close");
        this.setFrameTitle("Workspace");
        Container panel = this.getContentPane();
        panel.setLayout(new BorderLayout());
        TitledBorder infoBorder = BorderFactory.createTitledBorder("Info");
        JPanel infoPanel = new JPanel(new GridBagLayout());
        GridBagConstraints ic = new GridBagConstraints();
        ic.insets = new Insets(2, 2, 2, 2);
        ic.gridx = 0;
        ic.gridy = 0;
        ic.anchor = 13;
        infoPanel.setBorder(infoBorder);
        infoPanel.add((Component)new JLabel("Path:"), ic);
        JTextField pathField = new JTextField();
        pathField.setEditable(false);
        new EditorKitMenu((JTextComponent)pathField, false);
        this.workspaceDir = workspaceManager.getWorkspaceDir();
        pathField.setText(this.workspaceDir.getAbsolutePath());
        ++ic.gridx;
        ic.weightx = 2.0;
        ic.fill = 2;
        infoPanel.add((Component)pathField, ic);
        if (Desktop.isDesktopSupported()) {
            this.desktop = Desktop.getDesktop();
            this.openButt = new JButton("Open in file manager");
            this.openButt.addActionListener((ActionListener)((Object)this));
            ++ic.gridx;
            ic.weightx = 0.0;
            ic.fill = 0;
            infoPanel.add((Component)this.openButt, ic);
        }
        long freeSpace = this.workspaceDir.getFreeSpace();
        long freeSpaceGB = freeSpace / 1000000000L;
        ic.gridx = 0;
        ++ic.gridy;
        ic.anchor = 13;
        infoPanel.add((Component)new JLabel("Free space:"), ic);
        ++ic.gridx;
        ic.anchor = 17;
        infoPanel.add((Component)new JLabel(freeSpaceGB + " GB"), ic);
        panel.add((Component)infoPanel, "North");
        TitledBorder projsBorder = BorderFactory.createTitledBorder("Projects");
        this.projectsPanel = new WorkspaceProjectsPanel(workspaceManager);
        this.projectsPanel.setBorder(projsBorder);
        panel.add((Component)this.projectsPanel, "Center");
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.openButt && this.desktop != null) {
            try {
                this.desktop.open(this.workspaceDir);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Could not open directory: " + e.getLocalizedMessage(), "Desktop open directory error", 0);
            }
        }
        super.actionPerformed(ae);
    }

    public void close() {
        super.doCancel();
    }
}

