/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net.http;

import ipsk.net.http.PutServlet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ZipUploadServlet
extends PutServlet {
    private static final boolean DEBUG = true;

    @Override
    protected synchronized void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String relServletPath = req.getServletPath();
        ServletContext sc = this.getServletContext();
        this.log("ServletPath: " + relServletPath);
        this.log("Authentication: " + req.getAuthType());
        this.log("User: " + req.getRemoteUser());
        String recsDir = sc.getInitParameter("recsDir");
        this.log("recsDir: " + recsDir);
        Enumeration params = sc.getInitParameterNames();
        this.log("Params: " + params);
        this.is = req.getInputStream();
        ZipInputStream zipInputStream = new ZipInputStream(this.is);
        ZipEntry entry = null;
        while ((entry = zipInputStream.getNextEntry()) != null) {
            String entryName = entry.getName();
            this.log("Got new ZIP entry: " + entryName);
            StringTokenizer st = new StringTokenizer(entryName, " ");
            st.nextToken();
            String path = st.nextToken();
            String rPath = new String(String.valueOf(recsDir) + File.separator + path);
            File f = new File(rPath);
            File pd = f.getParentFile();
            this.log("Saving:" + rPath);
            try {
                this.log("Path:" + f.getCanonicalPath());
            }
            catch (IOException e) {
                this.log("Cannot get canonical path.", e);
                throw e;
            }
            boolean created = false;
            if (!pd.exists()) {
                this.log("Creating dir ...");
                created = pd.mkdirs();
            }
            if (created) {
                this.log("Directory " + pd.getName() + " created.");
            }
            this.fos = new FileOutputStream(f);
            int read = 0;
            try {
                do {
                    if ((read = zipInputStream.read(this.buf, 0, this.bufSize)) <= 0) continue;
                    this.fos.write(this.buf, 0, read);
                } while (read >= 0);
                this.log("File '" + f.getAbsolutePath() + "' written.");
            }
            finally {
                zipInputStream.closeEntry();
                this.log("Closed entry.");
                if (this.fos != null) {
                    this.fos.close();
                }
            }
        }
    }
}

