/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps;

import ipsk.beans.form.FormConfiguration;
import ipsk.jsp.Controller;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.SecurityManager;
import ipsk.webapps.ControllerException;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.ProcessResult;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BasicController<T>
implements Controller {
    public static final boolean USE_FULL_QUALIFIED_CLASSNAMES_IN_QUERY = false;
    public static final String KEY_CMD = "_cmd";
    public static final String KEY_ACTION = "_action";
    public static final String KEY_QUERY_NAME = "name";
    public static final String CMD_NAMED_QUERY = "named_query";
    public static final String CMD_NAMED_QUERY_SINGLE = "named_query_single";
    public static final String KEY_LOCALE = "_locale";
    private T item;
    private EntityManagerThreadLocal emtl;
    private ParameterizedQuery parameterizedQuery = null;
    protected SecurityManager securityManager = new SecurityManager();
    protected HttpServletRequest currentRequest;
    protected ProcessResult processResult;
    protected FormConfiguration formConfiguration;
    public static String RESOURCE_BUNDLE_NAME = "ipsk.jsp.Messages";

    public FormConfiguration getFormConfiguration() {
        return this.formConfiguration;
    }

    public void setFormConfiguration(FormConfiguration formConfiguration) {
        this.formConfiguration = formConfiguration;
    }

    public BasicController(String persistenceUnit) {
        this.emtl = new EntityManagerThreadLocal();
    }

    public String processCommand(HttpServletRequest request, String[] submitCommands) {
        String command = request.getParameter(KEY_CMD);
        String[] stringArray = submitCommands;
        int n = submitCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String possibleSubmitCmd = stringArray[n2];
            if (request.getParameter("_" + possibleSubmitCmd) != null) {
                command = possibleSubmitCmd;
                break;
            }
            ++n2;
        }
        return command;
    }

    @Override
    public void open() {
        EntityManager em = this.getThreadEntityManager();
        EntityTransaction tx = em.getTransaction();
        if (tx != null && !tx.isActive()) {
            tx.begin();
        }
    }

    @Override
    public ProcessResult process(HttpServletRequest request, HttpServletResponse response, Servlet servlet) throws ControllerException {
        this.processRequest(request);
        return this.getProcessResult();
    }

    @Override
    public ProcessResult process(HttpServletRequest request, HttpServletResponse response) throws ControllerException {
        this.processRequest(request);
        return this.getProcessResult();
    }

    public EntityManager getEntityManager() {
        return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
    }

    public EntityManager getThreadEntityManager() {
        if (this.emtl == null) {
            this.emtl = new EntityManagerThreadLocal();
        }
        return (EntityManager)this.emtl.get();
    }

    public T getItem() throws ControllerException {
        return this.item;
    }

    @Override
    public void rollback() {
        EntityManager em = this.getThreadEntityManager();
        if (em != null) {
            EntityTransaction tx = null;
            tx = em.getTransaction();
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    @Override
    public void commit() throws ControllerException {
        EntityManager em = this.getThreadEntityManager();
        if (em != null) {
            EntityTransaction tx = null;
            try {
                tx = em.getTransaction();
                if (tx != null && tx.isActive()) {
                    tx.commit();
                }
            }
            catch (PersistenceException e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new ControllerException(e);
            }
            catch (IllegalStateException ise) {
                ise.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new ControllerException(ise);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new ControllerException(e);
            }
        }
    }

    protected void clear() {
        this.processResult = null;
    }

    @Override
    public synchronized void close() {
        EntityManager em = this.getThreadEntityManager();
        try {
            this.commit();
        }
        catch (ControllerException e) {
            e.printStackTrace();
        }
        if (em != null) {
            em.close();
        }
        if (this.emtl != null) {
            this.emtl.remove();
        }
    }

    public String getKEY_ACTION() {
        return KEY_ACTION;
    }

    @Override
    public ProcessResult getProcessResult() {
        return this.processResult;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public class EntityManagerThreadLocal
    extends ThreadLocal<EntityManager> {
        @Override
        protected synchronized EntityManager initialValue() {
            return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
        }
    }
}

