/*
 * Decompiled with CFR 0.152.
 */
package ipsk.persistence;

import ipsk.math.bool.BoolExpr;
import ipsk.persistence.PersistenceBoolExpr;
import ipsk.persistence.PersistenceBoolExprConverter;
import ipsk.persistence.QueryParam;
import ipsk.sql.OrderBy;
import ipsk.sql.OrderByClause;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class ParameterizedQuery {
    public static final String JPQL_SELECT_EXPRESSION = "o";
    protected boolean selectDistinct = false;
    protected String whereClause;
    protected QueryParam[] queryParams;
    protected BoolExpr additionalCondition;
    protected OrderByClause orders;
    protected String qlQueryTypeName;
    protected FromDeclaration[] additionalFromDeclarations = null;

    public ParameterizedQuery(Class queryType) {
        String queryTypeName = queryType.getName();
        this.qlQueryTypeName = queryTypeName.substring(queryTypeName.lastIndexOf(".") + 1);
    }

    public Query createQuery(EntityManager em) {
        Object[] objectArray;
        StringBuffer queryStrBuf = new StringBuffer();
        queryStrBuf.append("SELECT ");
        if (this.selectDistinct) {
            queryStrBuf.append("DISTINCT ");
        }
        queryStrBuf.append(JPQL_SELECT_EXPRESSION);
        queryStrBuf.append(" FROM ");
        queryStrBuf.append(this.qlQueryTypeName);
        queryStrBuf.append(" ");
        queryStrBuf.append(JPQL_SELECT_EXPRESSION);
        if (this.additionalFromDeclarations != null) {
            for (FromDeclaration fromDeclaration : this.additionalFromDeclarations) {
                queryStrBuf.append(",");
                queryStrBuf.append(fromDeclaration);
            }
        }
        if (this.whereClause != null || this.additionalCondition != null) {
            queryStrBuf.append(" WHERE (");
        }
        if (this.whereClause != null) {
            queryStrBuf.append("(");
            queryStrBuf.append(this.whereClause);
            queryStrBuf.append(")");
        }
        if (this.whereClause != null && this.additionalCondition != null) {
            queryStrBuf.append(" AND ");
        }
        PersistenceBoolExpr persBoolExpr = null;
        if (this.additionalCondition != null) {
            PersistenceBoolExprConverter condConverter = new PersistenceBoolExprConverter(this.additionalCondition, JPQL_SELECT_EXPRESSION);
            persBoolExpr = condConverter.createQueryData(em);
            queryStrBuf.append("( ");
            queryStrBuf.append(persBoolExpr.getConditionalExpression());
            queryStrBuf.append(" )");
        }
        if (this.whereClause != null || this.additionalCondition != null) {
            queryStrBuf.append(")");
        }
        if (this.orders != null) {
            queryStrBuf.append(this.orders.toJPQLString(JPQL_SELECT_EXPRESSION));
        }
        String qStr = queryStrBuf.toString();
        Query q = em.createQuery(qStr);
        if (this.queryParams != null) {
            for (QueryParam qp : this.queryParams) {
                q.setParameter(qp.getName(), qp.getParam());
            }
        }
        if (persBoolExpr != null && (objectArray = persBoolExpr.getQueryVars()) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                q.setParameter("persistenceboolexprconverter_" + (i + 1), objectArray[i]);
            }
        }
        return q;
    }

    public OrderByClause getOrderByClause() {
        return this.orders;
    }

    public void setOrderByClause(OrderByClause orders) {
        this.orders = orders;
    }

    public BoolExpr getAdditionalCondition() {
        return this.additionalCondition;
    }

    public void setAdditionalCondition(BoolExpr additionalCondition) {
        this.additionalCondition = additionalCondition;
    }

    public QueryParam[] getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(QueryParam[] queryParams) {
        this.queryParams = queryParams;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public FromDeclaration[] getAdditionalFromDeclarations() {
        return this.additionalFromDeclarations;
    }

    public void setAdditionalFromDeclarations(FromDeclaration[] fromDeclarations) {
        this.additionalFromDeclarations = fromDeclarations;
    }

    public void appendOrderByClause(OrderByClause orderByClause) {
        if (this.orders != null && orderByClause != null) {
            OrderBy[] orderBys = this.orders.getOrder();
            OrderBy[] appOrderBys = orderByClause.getOrder();
            if (orderBys != null && appOrderBys != null) {
                int i;
                int newArrSize = orderBys.length + appOrderBys.length;
                OrderBy[] newArr = new OrderBy[newArrSize];
                for (i = 0; i < orderBys.length; ++i) {
                    newArr[i] = orderBys[i];
                }
                for (i = 0; i < appOrderBys.length; ++i) {
                    newArr[i + orderBys.length] = appOrderBys[i];
                }
                this.orders.setOrder(newArr);
            }
        } else {
            this.setOrderByClause(orderByClause);
        }
    }

    public boolean isSelectDistinct() {
        return this.selectDistinct;
    }

    public void setSelectDistinct(boolean selectDistinct) {
        this.selectDistinct = selectDistinct;
    }

    public static class FromDeclaration {
        private String type;
        private String identifier;

        public FromDeclaration(String type, String identifier) {
            this.type = type;
            this.identifier = identifier;
        }

        public String getType() {
            return this.type;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return new String(this.type + " " + this.identifier);
        }
    }
}

