/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.beans.edit;

import ipsk.jsp.taglib.beans.BeanPropertyIterator;
import ipsk.jsp.taglib.beans.BeanProviderTag;
import ipsk.jsp.taglib.beans.edit.BeanPropertyTag;
import ipsk.text.html.HTMLTextEncoder;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

public class BeanFormTag
extends BeanProviderTag {
    private String action;
    private String actionCommand;
    private String submitText;
    private String cancelText;
    private boolean showResetButton = true;
    private String tableClass;
    private String tableClassAttr = "";
    private boolean hasBody = false;
    private boolean tableEndPrinted = false;
    private Set<String> hiddenProperties = null;

    @Override
    public int doStartTag() throws JspException {
        String hrefAction;
        PropertyDescriptor idPd;
        super.doStartTag();
        if (this.displayedProps != null && (idPd = this.beanInfo.getIdPropertyDescriptor()) != null) {
            String idPdName = idPd.getName();
            if (this.actionCommand.equals("store") && !this.displayedProps.contains(idPdName)) {
                this.displayedProps.add(0, idPdName);
            }
            if (this.beanInfo.isIdGenerated() && this.actionCommand.equals("add")) {
                this.displayedProps.remove(idPdName);
            }
        }
        this.currentProperty = null;
        this.validationMessage = null;
        if (this.displayedProps.size() > 0) {
            this.propertyPosition = 0;
            this.currentProperty = (String)this.displayedProps.get(this.propertyPosition);
        }
        JspWriter w = this.pageContext.getOut();
        if (this.action != null) {
            hrefAction = this.action;
        } else {
            HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
            hrefAction = req.getRequestURL().toString();
        }
        this.tableEndPrinted = false;
        try {
            w.println("<form method=\"POST\" action=\"" + this.encodeURL(hrefAction) + "\" accept-charset=\"UTF-8\" enctype=\"application/x-www-form-urlencoded;charset=utf-8\">");
            w.println("<table" + this.tableClassAttr + ">");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        this.hiddenProperties = new HashSet<String>();
        this.hasBody = false;
        return 1;
    }

    @Override
    public int doAfterBody() throws JspException {
        this.hasBody = true;
        return this.printProperties();
    }

    public int printProperties() throws JspException {
        BeanPropertyIterator.Iteration it = this.getIteration();
        if (BeanPropertyIterator.Iteration.TABLE.equals((Object)it)) {
            if (this.currentProperty != null && !this.currentPropertyDone) {
                BeanPropertyTag bpt = new BeanPropertyTag();
                try {
                    bpt.setPageContext(this.pageContext);
                    bpt.setParent((Tag)this);
                    bpt.getBeanProperty().setContext(this);
                    bpt.printTag();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new JspException((Throwable)e);
                }
                this.setCurrentPropertyDone(true);
            }
        } else if (BeanPropertyIterator.Iteration.HIDDEN.equals((Object)it) && !this.tableEndPrinted) {
            JspWriter w = this.pageContext.getOut();
            try {
                w.println("</table>");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new JspException((Throwable)e);
            }
            this.tableEndPrinted = true;
        }
        return super.doAfterBody();
    }

    @Override
    public int doEndTag() throws JspException {
        JspWriter w = this.pageContext.getOut();
        try {
            if (!this.hasBody) {
                int res;
                while ((res = this.printProperties()) == 2) {
                }
            }
            if (!this.tableEndPrinted) {
                w.println("</table>");
            }
            String submitValue = this.submitText != null && !"".equals(this.submitText) ? HTMLTextEncoder.encode((String)this.submitText) : this.getLocalizedMessage("save");
            String cancelValue = this.cancelText != null && !"".equals(this.cancelText) ? HTMLTextEncoder.encode((String)this.cancelText) : this.getLocalizedMessage("cancel");
            w.print("<input type=\"submit\" name=\"_" + this.actionCommand + "\" value=\"" + submitValue + "\"/>");
            w.print("<input type=\"submit\" name=\"_cancel\" value=\"" + cancelValue + "\"/>");
            if (this.showResetButton) {
                w.println("<input type=\"reset\" name=\"_cancel\" value=\"" + this.getLocalizedMessage("reset") + "\"/>");
            }
            w.println("</form>");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public String getSubmitText() {
        return this.submitText;
    }

    public void setSubmitText(String submitText) {
        this.submitText = submitText;
    }

    public String getCancelText() {
        return this.cancelText;
    }

    public void setCancelText(String cancelText) {
        this.cancelText = cancelText;
    }

    public boolean isShowResetButton() {
        return this.showResetButton;
    }

    public void setShowResetButton(boolean showResetButton) {
        this.showResetButton = showResetButton;
    }

    @Override
    public String getBeanIdPropertyVar() {
        return this.beanIdPropertyVar;
    }

    @Override
    public void setBeanIdPropertyVar(String beanIdPropertyVar) {
        this.beanIdPropertyVar = beanIdPropertyVar;
    }

    public String getTableClass() {
        return this.tableClass;
    }

    public void setTableClass(String tableClass) {
        this.tableClass = tableClass;
        this.tableClassAttr = " class=\"" + tableClass + "\"";
    }
}

