/*
 * Decompiled with CFR 0.152.
 */
package ips.servlet.http;

import ipsk.io.EditInputStream;
import ipsk.text.StringTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileServer
extends HttpServlet {
    protected final boolean DEBUG = true;
    private static final int DEF_BUF_SIZE = 4096;
    private int bufSize = 4096;
    private static final Charset ASCII_CHARSET = Charset.forName("US-ASCII");

    public void init() throws ServletException {
        super.init();
    }

    private void sendStream(File file, OutputStream out, long start, long length) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        EditInputStream editInputStream = new EditInputStream((InputStream)fis, start, length);
        try {
            byte[] buf = new byte[this.bufSize];
            int read = 0;
            while ((read = editInputStream.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void serve(File file, String contentType, HttpServletRequest req, HttpServletResponse res) throws IOException {
        block21: {
            block23: {
                block22: {
                    if (!file.exists()) {
                        throw new FileNotFoundException(String.valueOf(file.getAbsolutePath()) + " not found");
                    }
                    contentLength = file.length();
                    if (contentType == null) {
                        servletContext = this.getServletContext();
                        contentType = servletContext.getMimeType(file.getAbsolutePath());
                    }
                    if (req == null) break block21;
                    rangeStr = req.getHeader("Range");
                    if (rangeStr == null) break block22;
                    byteRanges = new ArrayList<ByteRange>();
                    maxIdx = contentLength - 1L;
                    ies = (rangeStr = rangeStr.trim()).indexOf(61);
                    if (ies <= 0 || !"bytes".equals(unit = rangeStr.substring(0, ies))) break block21;
                    valueStr = rangeStr.substring(ies + 1);
                    brStrs = StringTokenizer.split((String)valueStr, (char)',', (boolean)true);
                    multiRangeContentLength = 0;
                    var19_19 = brStrs;
                    var18_21 = brStrs.length;
                    var17_23 = 0;
                    if (true) ** GOTO lbl39
                }
                res.setHeader("Accept-Ranges", "bytes");
                break block21;
                do {
                    if ((brD = (brStr = var19_19[var17_23]).indexOf(45)) >= 0) {
                        brStart = 0L;
                        brEnd = maxIdx;
                        brStartStr = brStr.substring(0, brD);
                        brEndStr = brStr.substring(brD + 1);
                        if (!"".equals(brStartStr) && (brStart = Long.parseLong(brStartStr)) < 0L) {
                            brStart = 0L;
                        }
                        if (!"".equals(brEndStr) && (brEnd = Long.parseLong(brEndStr)) > maxIdx) {
                            brEnd = maxIdx;
                        }
                        br = new ByteRange(brStart, brEnd);
                        byteRanges.add(br);
                        multiRangeContentLength = (int)((long)multiRangeContentLength + br.getLength());
                    }
                    ++var17_23;
lbl39:
                    // 2 sources

                } while (var17_23 < var18_21);
                if (byteRanges.size() <= 0) break block21;
                if (byteRanges.size() != 1) break block23;
                br = (ByteRange)byteRanges.get(0);
                brLength = br.getLength();
                brStart = br.getStart();
                brEnd = br.getEnd();
                if (brStart != 0L || brLength != contentLength) {
                    res.setContentType(contentType);
                    res.setContentLength((int)brLength);
                    rangeHeader = "bytes " + brStart + "-" + brEnd + "/" + contentLength;
                    res.setHeader("Content-range", rangeHeader);
                    res.setStatus(206);
                    out = res.getOutputStream();
                    this.sendStream(file, (OutputStream)out, brStart, brLength);
                    return;
                }
                break block21;
            }
            uuid = UUID.randomUUID();
            boundary = uuid.toString().replace('-', '_').substring(0, 22);
            multiRangeContentLength += (boundary.length() + 2) * byteRanges.size();
            multiRangeContentLength += boundary.length() + 2;
            res.setContentType("multipart/byteranges; boundary=" + boundary);
            out = res.getOutputStream();
            rangeContentHeader = "Content-Type: " + contentType;
            res.setStatus(206);
            var21_31 = byteRanges.iterator();
            if (true) ** GOTO lbl107
        }
        out = res.getOutputStream();
        res.setContentType(contentType);
        if (contentLength <= 0x7FFFFFFFL) {
            res.setContentLength((int)contentLength);
        }
        fis = new FileInputStream(file);
        try {
            buf = new byte[this.bufSize];
            read = 0;
            while (true) {
                if ((read = fis.read(buf)) == -1) {
                    return;
                }
                out.write(buf, 0, read);
                out.flush();
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException var12_16) {}
        }
        do {
            br = (ByteRange)var21_31.next();
            brStart = br.getStart();
            brLength = br.getLength();
            sb = new StringBuffer();
            sb.append("\n--" + boundary + "\n");
            sb.append(String.valueOf(rangeContentHeader) + "\n");
            rangeHeader = "bytes " + br.getStart() + "-" + br.getEnd() + "/" + contentLength;
            sb.append("Content-range: " + rangeHeader + "\n\n");
            bb = sb.toString().getBytes(FileServer.ASCII_CHARSET);
            out.write(bb);
            this.sendStream(file, (OutputStream)out, brStart, brLength);
lbl107:
            // 2 sources

        } while (var21_31.hasNext());
        fs = new String("\n--" + boundary + "--\n");
        out.write(fs.getBytes(FileServer.ASCII_CHARSET));
    }

    protected void serve(File file, String contentType, HttpServletResponse res) throws IOException {
        this.serve(file, contentType, null, res);
    }

    protected void serve(File file, HttpServletResponse res) throws IOException {
        this.serve(file, null, res);
    }

    public class ByteRange {
        private long start;
        private long end;

        public ByteRange(long brStart, long brEnd) {
            this.start = brStart;
            this.end = brEnd;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public long getLength() {
            return this.end - this.start + 1L;
        }
    }
}

