/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.beans.table;

import ips.beans.ExtBeanInfo;
import ipsk.beans.PropertyNameOrder;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.Controller;
import ipsk.jsp.taglib.ControllerProvider;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanPropertyValueText;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.net.BoolExprQueryParser;
import ipsk.text.html.HTMLTextEncoder;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.Tag;

public class DynamicBoolExprTag
extends ExtBodyTagSupport {
    private ArrayList<PropertyDescriptor> displayedProps;
    private String CSSclass = null;
    private BeanTableController controller;
    private ExtBeanInfo beanInfo;
    private int ci = 0;
    private int ei = 0;

    public void setParent(Tag parent) {
        if (parent instanceof ControllerProvider) {
            String[] orderedPropNames;
            Controller scontroller = ((ControllerProvider)parent).getController();
            if (scontroller instanceof BeanTableController) {
                this.controller = (BeanTableController)scontroller;
            }
            this.beanInfo = this.controller.getBeanInfo();
            PropertyDescriptor[] pds = this.beanInfo.getPersistencePropertyDescriptors();
            this.displayedProps = new ArrayList();
            ArrayList<String> displayablePropNames = new ArrayList<String>();
            PropertyDescriptor[] propertyDescriptorArray = pds;
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                Class<?> type = pd.getPropertyType();
                if (type.isPrimitive() || type.equals(Boolean.class) || type.isEnum() || Number.class.isAssignableFrom(type) || type.equals(String.class) || type.equals(Date.class)) {
                    displayablePropNames.add(pd.getName());
                }
                ++n2;
            }
            PropertyNameOrder pnOrder = new PropertyNameOrder(displayablePropNames.toArray(new String[0]));
            pnOrder.applyPreferredOrder(this.beanInfo.getPreferredDisplayOrder());
            String[] stringArray = orderedPropNames = pnOrder.getOrder();
            int n3 = orderedPropNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String pName = stringArray[n4];
                PropertyDescriptor[] propertyDescriptorArray2 = pds;
                int n5 = pds.length;
                int n6 = 0;
                while (n6 < n5) {
                    PropertyDescriptor pd = propertyDescriptorArray2[n6];
                    if (pName.equals(pd.getName())) {
                        this.displayedProps.add(pd);
                    }
                    ++n6;
                }
                ++n4;
            }
        }
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.controller.getNamedQuery() != null) {
            return 0;
        }
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        String servletPath = req.getServletPath();
        String encodedPath = this.encodeURL(servletPath);
        JspWriter ow = this.pageContext.getOut();
        try {
            ow.println("<form method=\"POST\" action=\"" + HTMLTextEncoder.encode((String)encodedPath) + "\" accept-charset=\"UTF-8\" enctype=\"application/x-www-form-urlencoded;charset=utf-8\">");
            ow.println("<fieldset>");
            ow.println("<legend>" + HTMLTextEncoder.encode((String)this.getLocalizedMessage("conditions")) + "</legend>");
        }
        catch (IOException ioe) {
            throw new JspException("Error: IOException while writing conditition query");
        }
        return 1;
    }

    private void printColumnSelectOption(JspWriter ow, PropertyDescriptor pd, boolean selected) throws IOException {
        String selectAttr = "";
        if (selected) {
            selectAttr = " selected ";
        }
        String pDescr = pd.getShortDescription();
        String resKey = (String)pd.getValue("ipsk.util.ResourceKey");
        if (resKey != null) {
            pDescr = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)resKey, (String)this.controller.getBeanInfo().getResourceBundleName());
        }
        ow.println("<option value=\"" + pd.getName() + "\"" + selectAttr + ">" + HTMLTextEncoder.encode((String)pDescr) + "</option>");
    }

    private void printOperatorSelectOption(JspWriter ow, Object exprOp, boolean selected) throws IOException {
        String selectAttr = "";
        if (selected) {
            selectAttr = " selected ";
        }
        String queryOp = BoolExprQueryParser.getQueryOperator(exprOp);
        String localizedExprOp = "";
        if (exprOp instanceof String) {
            localizedExprOp = (String)exprOp;
        }
        if (exprOp.equals("(starts with)")) {
            localizedExprOp = this.getLocalizedMessage("starts_with");
        } else if (exprOp.equals("(ends with)")) {
            localizedExprOp = this.getLocalizedMessage("ends_with");
        } else if (exprOp.equals(ExtBoolExpr.CONTAINS)) {
            localizedExprOp = this.getLocalizedMessage("contains");
        } else if (exprOp.equals(ExtBoolExpr.EQUALS)) {
            localizedExprOp = this.getLocalizedMessage("id.equals");
        } else if (exprOp.equals(ExtBoolExpr.BOUND)) {
            localizedExprOp = this.getLocalizedMessage("is.bound");
        } else if (exprOp.equals(ExtBoolExpr.MEMBER)) {
            localizedExprOp = this.getLocalizedMessage("id.has_member");
        } else if (exprOp.equals(ExtBoolExpr.EQUALS_NOT)) {
            localizedExprOp = this.getLocalizedMessage("id.equals_not");
        } else if (exprOp.equals(ExtBoolExpr.NOT_MEMBER)) {
            localizedExprOp = this.getLocalizedMessage("id.has_not_member");
        } else if (exprOp.equals(ExtBoolExpr.NOT_BOUND)) {
            localizedExprOp = this.getLocalizedMessage("is.not_bound");
        }
        ow.println("<option value=\"" + queryOp + "\"" + selectAttr + ">" + HTMLTextEncoder.encode((String)localizedExprOp) + "</option>");
    }

    public void printBoolExpression(ExtBoolExpr be, int ei, JspWriter ow) throws IOException {
        PropertyDescriptor[] ppds = this.beanInfo.getPersistencePropertyDescriptors();
        String op0 = (String)be.getOperand0();
        Object opStr = be.getOperator();
        ow.println("<fieldset>");
        ow.println("<legend>" + HTMLTextEncoder.encode((String)this.getLocalizedMessage("condition")) + "</legend>");
        ow.println("<select name=\"_ec" + ei + "\">");
        if (op0 == null) {
            ow.println("<option value=\"\" selected >-- " + HTMLTextEncoder.encode((String)this.getLocalizedMessage("field.select")) + " --</option>");
        } else {
            ow.println("<option value=\"\">" + HTMLTextEncoder.encode((String)("-- " + this.getLocalizedMessage("reset") + " --")) + "</option>");
        }
        if (be.isObjectRelationShip()) {
            PropertyDescriptor[] propertyDescriptorArray = ppds;
            int n = ppds.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (pd.getName().equals(op0)) {
                    this.printColumnSelectOption(ow, pd, true);
                }
                ++n2;
            }
        } else {
            for (PropertyDescriptor pd : this.displayedProps) {
                boolean selected = op0 != null && op0.equals(pd.getName());
                this.printColumnSelectOption(ow, pd, selected);
            }
        }
        ow.println("</select>");
        ow.println("<select name=\"_eo" + ei + "\">");
        String[] exprOps = ExtBoolExpr.getExprOperators();
        if (opStr == null) {
            ow.println("<option value=\"\" selected >" + HTMLTextEncoder.encode((String)("-- " + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"operator.select", (String)"ipsk.jsp.Messages") + " --")) + "</option>");
        } else {
            ow.println("<option value=\"\">" + HTMLTextEncoder.encode((String)("-- " + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"reset", (String)"ipsk.jsp.Messages") + " --")) + "</option>");
        }
        if (be.isObjectRelationShip()) {
            this.printOperatorSelectOption(ow, opStr, true);
        } else {
            String[] exprOpsNoRelationship;
            String[] stringArray = exprOpsNoRelationship = ExtBoolExpr.getExprOperatorsWithoutRelationshipOperators();
            int n = exprOpsNoRelationship.length;
            int n3 = 0;
            while (n3 < n) {
                String exprOp = stringArray[n3];
                boolean selected = opStr != null && opStr.equals(exprOp);
                this.printOperatorSelectOption(ow, exprOp, selected);
                ++n3;
            }
        }
        ow.println("</select>");
        String op1Str = "";
        if (!be.unaryOperator()) {
            Object op1 = be.getOperand1();
            BeanPropertyValueText bpvt = new BeanPropertyValueText(this.beanInfo, this.pageContext);
            PropertyDescriptor opPd = null;
            PropertyDescriptor[] propertyDescriptorArray = ppds;
            int n = ppds.length;
            int n4 = 0;
            while (n4 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n4];
                if (op0 != null && op0.equals(pd.getName())) {
                    opPd = pd;
                    break;
                }
                ++n4;
            }
            op1Str = bpvt.getValueTextRepresentation(opPd, op1);
        }
        String readOnlyStr = "";
        if (be.unaryOperator() || be.isObjectRelationShip()) {
            readOnlyStr = " readonly ";
        }
        ow.println("<input name=\"_ev" + ei + "\" type=\"text\" value=\"" + HTMLTextEncoder.encode((String)op1Str) + "\"" + readOnlyStr + " />");
        String caseInSensitiveSelStr = "";
        if (be.isCaseInSensitive()) {
            caseInSensitiveSelStr = " checked ";
        }
        ow.println("<span style=\"white-space: nowrap\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"case_insensitive", (String)"ipsk.jsp.Messages") + "</span><input type=\"checkbox\" name=\"_eci" + ei + "\" value=\"insensitive\"" + caseInSensitiveSelStr + ">");
        ow.println("</fieldset>");
    }

    public void resolveBoolExpr(ExtBoolExpr ebe, JspWriter out) throws IOException {
        if (ebe == null) {
            return;
        }
        if (ebe.getOperator() == null || ebe.isExpression()) {
            this.printBoolExpression(ebe, this.ei, out);
            ++this.ei;
        } else {
            String condstr = "<input type=\"hidden\" name=\"_c" + this.ci + "\" value=\"";
            ++this.ci;
            ExtBoolExpr op0 = (ExtBoolExpr)ebe.getOperand0();
            condstr = op0.getOperator() == null || op0.isExpression() ? condstr.concat("e" + this.ei) : condstr.concat("c" + this.ci);
            this.resolveBoolExpr(op0, out);
            String opr = (String)ebe.getOperator();
            condstr = condstr.concat("_" + opr + "_");
            ExtBoolExpr op1 = (ExtBoolExpr)ebe.getOperand1();
            condstr = op1.getOperator() == null || op1.isExpression() ? condstr.concat("e" + this.ei) : condstr.concat("c" + this.ci);
            this.resolveBoolExpr(op1, out);
            condstr = condstr.concat("\">");
            out.println(condstr);
        }
    }

    @Override
    public int doEndTag() throws JspException {
        if (this.controller.getNamedQuery() == null) {
            JspWriter ow = this.pageContext.getOut();
            ExtBoolExpr boolCondition = this.controller.getBoolCondition();
            try {
                ExtBoolExpr dispBe = null;
                dispBe = boolCondition == null ? new ExtBoolExpr() : boolCondition.addEmptyExpression();
                this.ci = 0;
                this.ei = 0;
                this.resolveBoolExpr(dispBe, ow);
                Locale locale = ipsk.jsp.fmt.LocaleSupport.getLocale(this.pageContext);
                ow.println("<input type=\"hidden\" name=\"_locale\" value=\"" + locale + "\" />");
                ow.println("<input type=\"hidden\" name=\"_cmd\" value=\"list_apply_cond\" />");
                ow.println("<input type=\"submit\" name=\"_submit\" value=\"" + this.getLocalizedMessage("condition.apply") + "\" />");
                ow.println("</fieldset>");
                ow.println("</form>");
            }
            catch (IOException ioe) {
                throw new JspException("Error: IOException while writing condition query end tag");
            }
            catch (CloneNotSupportedException e) {
                throw new JspException("Error: Could not clone boolean expression object.");
            }
        }
        return 6;
    }

    public String getCSSclass() {
        return this.CSSclass;
    }

    public void setCSSclass(String sclass) {
        this.CSSclass = sclass;
    }
}

