/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ips.beans.PersistenceMapConverter;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverter;
import ipsk.beans.MapConverterException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.form.FormConfiguration;
import ipsk.beans.form.PropertyConfiguration;
import ipsk.beans.validation.BeanValidator;
import ipsk.beans.validation.Input;
import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.BeanTableModel;
import ipsk.math.bool.BoolExpr;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.net.BoolExprQueryParser;
import ipsk.net.OrderByQueryParser;
import ipsk.persistence.Delegate;
import ipsk.persistence.ImmutibilityProvider;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.PersistenceBoolExpr;
import ipsk.persistence.PersistenceBoolExprConverter;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.persistence.SecurityManager;
import ipsk.sql.OrderByClause;
import ipsk.text.ParserException;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.ControllerException;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.NoSuchObjectException;
import ipsk.webapps.ObjectAlreadyExistsException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.SelectMode;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NoResultException;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BasicPersistenceBeanController<T>
implements BeanTableController,
BeanValidator {
    public static final int DEFAULT_BATCHSIZE = 20;
    public static final int MAX_BATCHSIZE = 1000;
    public static final boolean USE_FULL_QUALIFIED_CLASSNAMES_IN_QUERY = false;
    public static final String KEY_CMD = "_cmd";
    public static final String KEY_MODEL_REQUEST = "_model_req";
    public static final String KEY_ACTION = "_action";
    public static final String KEY_QUERY_NAME = "name";
    public static final String KEY_MAPPEDBY = "_related_mappedby";
    public static final String KEY_RELATED_PROPERTY = "_related_prop";
    public static final String KEY_SELECTED_PROPERTY = "_sel_prop";
    public static final String KEY_SELECTED_ID = "_sel_id";
    public static final String KEY_SELECT_TARGET_PROPERTY = "_sel_trg_prop";
    public static final String KEY_SELECT_TARGET_ID_PROPERTY = "_sel_trg_id_prop";
    public static final String KEY_SELECT_TARGET_ID = "_sel_trg_id";
    public static final String KEY_PREFIX_DELETE_RELATED = "_delete_rel";
    public static final String KEY_PREFIX_DEFAULT_DESELECT = "_default_deselect";
    public static final String CMD_LIST = "list";
    public static final String CMD_LIST_RELATED = "list_related";
    public static final String CMD_SELECT_TO_ADD = "select_to_add";
    public static final String CMD_SELECT_TO_REMOVE = "select_to_remove";
    public static final String CMD_SELECT_TO_SET = "select_to_set";
    public static final String CMD_SELECT_TO_RESET = "select_to_reset";
    public static final String CMD_LIST_ALL = "list_all";
    public static final String CMD_LIST_FIRST = "list_first";
    public static final String CMD_LIST_PREVIOUS = "list_previous";
    public static final String CMD_LIST_NEXT = "list_next";
    public static final String CMD_LIST_LAST = "list_last";
    public static final String CMD_LIST_NUM_ROWS_PAGE = "list_num_rows_page";
    public static final String CMD_LIST_ADD_COL = "list_add_col";
    public static final String CMD_LIST_REMOVE_COL = "list_remove_col";
    public static final String CMD_LIST_COLS_RESET = "list_cols_reset";
    public static final String CMD_LIST_APPLY_COND = "list_apply_cond";
    public static final String CMD_LIST_ORDER_BY = "list_order_by";
    public static final String CMD_LIST_CHANGE_SELECTION = "list_change_sel";
    public static final String CMD_CANCEL_LIST_CHANGE_SELECTION = "list_change_sel";
    public static final String CMD_NAMED_QUERY = "named_query";
    public static final String CMD_NAMED_QUERY_SINGLE = "named_query_single";
    public static final String CMD_NEW = "new";
    public static final String CMD_NEW_TO_ADD = "new_to_add";
    public static final String CMD_APPLY = "apply";
    public static final String CMD_MERGE = "merge";
    public static final String CMD_ADD = "add";
    public static final String CMD_ADD_ADD = "add_add";
    public static final String CMD_STORE = "store";
    public static final String CMD_STORE_ADD_RELATED = "store_add_related";
    public static final String CMD_STORE_REMOVE_RELATED = "store_remove_related";
    public static final String CMD_STORE_SET_RELATED = "store_set_related";
    public static final String CMD_STORE_RESET_RELATED = "store_reset_related";
    public static final String CMD_EXPORT = "export";
    public static final String CMD_REMOVE = "remove";
    public static final String CMD_DELETE = "delete";
    public static final String CMD_EDIT = "edit";
    public static final String CMD_CORRECT = "correct";
    public static final String CMD_LIST_SELECT_ITEM = "list_select_item";
    public static final String CMD_LIST_SELECT_MULTI = "list_select_multi";
    public static final String CMD_VIEW = "view";
    public static final String CMD_VIEW_TO_DELETE = "view_to_delete";
    public static final String CMD_CANCEL = "cancel";
    public static final String CMD_CANCEL_STORE_RELATED = "cancel_store_related";
    public static final String KEY_LOCALE = "_locale";
    public static final String KEY_ROWS = "rows";
    public static final String VAL_SELECT_ADD = "select_add";
    public static final String VAL_SELECT_REMOVE = "select_remove";
    public static final String JPQL_PARAM_NAME_PREFIX = "basiccontroller_where_param";
    public String[] SUBMIT_CMDS = new String[]{"cancel", "apply", "merge", "edit", "add", "store", "store_add_related", "store_remove_related", "store_set_related", "store_reset_related", "cancel_store_related", "export", "remove", "delete"};
    private EntityManagerThreadLocal emtl;
    protected Class<T> queryType;
    protected String queryTypeName;
    protected String jsfIdentifier;
    protected int batchSize = 20;
    protected int firstItem = 0;
    private String namedQuery = null;
    private Query query;
    private ParameterizedQuery parameterizedQuery = null;
    private ExtBoolExpr boolCondition;
    private OrderByClause orderByClause;
    private Object[] namedQueryParams = null;
    private PersistenceObjectIdentifier namedQueryParam;
    private String[] additionalColumns;
    private List<String> displayColumns;
    protected ExtBeanInfo beanInfo = null;
    protected Object id;
    private boolean idGenerated = false;
    protected BeanTableModel<T> beanTableModel;
    private PersistenceObjectIdentifier relatedObjectIdentifier;
    private PropertyDescriptor relatedPropertyDescriptor;
    private String qlQeryTypeName;
    private Mode mode = null;
    private boolean actionCanceled;
    private Object selectedItemId;
    private Set<Object> selectedItemIds;
    protected HttpServletRequest currentRequest;
    protected ServletContext servletContext;
    protected SecurityManager securityManager = new SecurityManager();
    protected boolean dropInSecureItems = false;
    protected BeanModel<T> beanModel = null;
    protected ProcessResult processResult;
    private boolean applyAllProperties = false;
    public static String RESOURCE_BUNDLE_NAME = "ipsk.jsp.Messages";
    private static LocalizableMessage VALIDATION_MSG_FIELD_REQUIRED = new LocalizableMessage(RESOURCE_BUNDLE_NAME, "validation.field.required");

    public String[] getAdditionalColumns() {
        return this.additionalColumns;
    }

    @Override
    public void setAdditionalColumns(String[] additionalColumns) {
        this.additionalColumns = additionalColumns;
    }

    public void setCurrentRequest(HttpServletRequest currentRequest) {
        this.currentRequest = currentRequest;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public FormConfiguration getFormConfiguration() {
        return null;
    }

    public BasicPersistenceBeanController(String persistenceUnit, Class<T> queryType) {
        this(persistenceUnit, queryType, queryType.getName());
    }

    public BasicPersistenceBeanController(String persistenceUnit, Class<T> queryType, String jsfIdentifier) {
        PropertyDescriptor[] pds;
        this.queryType = queryType;
        this.queryTypeName = queryType.getName();
        this.qlQeryTypeName = this.queryTypeName.substring(this.queryTypeName.lastIndexOf(".") + 1);
        try {
            this.beanInfo = PersistenceIntrospector.getExtendedBeanInfo(queryType, true, false);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        PropertyDescriptor[] propertyDescriptorArray = pds = this.beanInfo.getPropertyDescriptors();
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            Method rm = pd.getReadMethod();
            if (rm.getAnnotation(GeneratedValue.class) != null) {
                this.setIdGenerated(true);
            }
            ++n2;
        }
        this.jsfIdentifier = jsfIdentifier;
        this.emtl = new EntityManagerThreadLocal();
    }

    @Override
    public void open() {
        EntityManager em = this.getThreadEntityManager();
        EntityTransaction tx = em.getTransaction();
        if (tx != null && !tx.isActive()) {
            tx.begin();
        }
    }

    @Override
    public ExtBeanInfo getBeanInfo() {
        try {
            return PersistenceIntrospector.getPersistenceBeanInfo(this.queryType);
        }
        catch (IntrospectionException e1) {
            return null;
        }
    }

    public EntityManager getEntityManager() {
        return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
    }

    @Override
    public EntityManager getThreadEntityManager() {
        if (this.emtl == null) {
            this.emtl = new EntityManagerThreadLocal();
        }
        return (EntityManager)this.emtl.get();
    }

    public PropertyDescriptor[] getBeanProperties() {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(this.queryType);
        }
        catch (IntrospectionException e1) {
            return null;
        }
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        return pds;
    }

    public T getById(Object id) {
        EntityManager em = this.getThreadEntityManager();
        Object o = em.find(this.queryType, id);
        return (T)o;
    }

    public void deleteRelated(HttpServletRequest req, Object o) throws ControllerException {
        EntityManager em = this.getThreadEntityManager();
        Map queryMap = req.getParameterMap();
        Set paramKeys = queryMap.keySet();
        for (String key : paramKeys) {
            int dotIndex;
            String relPropStr;
            if (!key.startsWith(KEY_PREFIX_DELETE_RELATED) || !(relPropStr = key.substring(KEY_PREFIX_DELETE_RELATED.length())).startsWith(".") || (dotIndex = (relPropStr = relPropStr.substring(1)).indexOf(".")) <= 0) continue;
            String propertyName = relPropStr.substring(0, dotIndex);
            String propertyIdName = relPropStr.substring(dotIndex + 1);
            String[] relIdStrsToDelete = (String[])queryMap.get(key);
            PropertyDescriptor pd = this.beanInfo.getPersistencePropertyDescriptor(propertyName);
            if (pd == null) continue;
            Method readMethod = pd.getReadMethod();
            Class<?> getterType = readMethod.getReturnType();
            Class relatedType = null;
            if (Collection.class.isAssignableFrom(getterType)) {
                Type[] pts;
                Type rt = readMethod.getGenericReturnType();
                if (rt instanceof ParameterizedType) {
                    ParameterizedType prt = (ParameterizedType)rt;
                    pts = prt.getActualTypeArguments();
                    if (pts.length != 1) {
                        throw new ControllerException("Parameterized type has not exactly one type arguemnts\nCannot get bean info of property return type.");
                    }
                } else {
                    throw new ControllerException("Property is not prameterized.\nCannot create Id object for unknown type!");
                }
                relatedType = (Class)pts[0];
                try {
                    ExtBeanInfo relBeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(relatedType);
                    PropertyDescriptor relIdPd = relBeanInfo.getIdPropertyDescriptor();
                    if (!relIdPd.getName().equals(propertyIdName)) continue;
                    Collection coll = (Collection)readMethod.invoke(o, new Object[0]);
                    String[] stringArray = relIdStrsToDelete;
                    int n = relIdStrsToDelete.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String relIdStr = stringArray[n2];
                        Object relId = relBeanInfo.createIdValueByString(relIdStr);
                        Object relObjToDelete = em.find(relatedType, relId);
                        if (coll.contains(relObjToDelete)) {
                            this.securityManager.checkRemovePermission(req, relObjToDelete);
                            this.removeById(req, relBeanInfo, relId, true);
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                ExtBeanInfo relBeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(relatedType);
                PropertyDescriptor relIdPd = relBeanInfo.getIdPropertyDescriptor();
                if (!relIdPd.getName().equals(propertyIdName)) continue;
                Object relObj = readMethod.invoke(o, new Object[0]);
                if (relIdStrsToDelete.length != 1) continue;
                Object relId = relBeanInfo.createIdValueByString(relIdStrsToDelete[0]);
                Object relObjToDelete = em.find(relatedType, relId);
                if (relObj == null || !relObj.equals(relObjToDelete)) continue;
                this.securityManager.checkRemovePermission(req, relObjToDelete);
                this.removeById(req, relBeanInfo, relId, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean hasCascadeType(CascadeType[] cascadeTypes, CascadeType cascadeType) {
        if (cascadeTypes == null) {
            return false;
        }
        CascadeType[] cascadeTypeArray = cascadeTypes;
        int n = cascadeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            CascadeType ct = cascadeTypeArray[n2];
            if (CascadeType.ALL.equals((Object)ct) || cascadeType.equals((Object)ct)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean hasRelationShips(Object bean) throws ControllerException {
        return this.hasRelationShips(bean, (CascadeType)null);
    }

    @Override
    public boolean hasRelationShips(Object bean, PropertyDescriptor propertyDescriptor) throws ControllerException {
        OneToOne oneToOneAnno;
        Method rm;
        Object o;
        block10: {
            ManyToMany manyToManyAnno;
            block9: {
                o = bean;
                rm = propertyDescriptor.getReadMethod();
                OneToMany oneToManyAnno = rm.getAnnotation(OneToMany.class);
                manyToManyAnno = rm.getAnnotation(ManyToMany.class);
                oneToOneAnno = rm.getAnnotation(OneToOne.class);
                if (oneToManyAnno == null) break block9;
                Collection values = (Collection)rm.invoke(o, new Object[0]);
                if (values != null && values.size() > 0) {
                    return true;
                }
            }
            if (manyToManyAnno == null) break block10;
            Collection values = (Collection)rm.invoke(o, new Object[0]);
            if (values != null && values.size() > 0) {
                return true;
            }
        }
        try {
            Object relObj;
            if (oneToOneAnno != null && (relObj = rm.invoke(o, new Object[0])) != null) {
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            throw new ControllerException(e);
        }
        catch (IllegalAccessException e) {
            throw new ControllerException(e);
        }
        catch (InvocationTargetException e) {
            throw new ControllerException(e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasRelationShips(Object bean, CascadeType ignoreRemoveCascadedWith) throws ControllerException {
        try {
            PropertyDescriptor[] ppds;
            Object o = bean;
            PropertyDescriptor[] propertyDescriptorArray = ppds = this.beanInfo.getPersistencePropertyDescriptors();
            int n = ppds.length;
            int n2 = 0;
            while (true) {
                Object relObj;
                Collection values;
                CascadeType[] cascadeTypes;
                boolean hasCt;
                if (n2 >= n) {
                    return false;
                }
                PropertyDescriptor ppd = propertyDescriptorArray[n2];
                Method rm = ppd.getReadMethod();
                OneToMany oneToManyAnno = rm.getAnnotation(OneToMany.class);
                ManyToMany manyToManyAnno = rm.getAnnotation(ManyToMany.class);
                OneToOne oneToOneAnno = rm.getAnnotation(OneToOne.class);
                if (oneToManyAnno != null ? !(hasCt = this.hasCascadeType(cascadeTypes = oneToManyAnno.cascade(), ignoreRemoveCascadedWith)) && (values = (Collection)rm.invoke(o, new Object[0])) != null && values.size() > 0 : (manyToManyAnno != null ? !(hasCt = this.hasCascadeType(cascadeTypes = manyToManyAnno.cascade(), ignoreRemoveCascadedWith)) && (values = (Collection)rm.invoke(o, new Object[0])) != null && values.size() > 0 : oneToOneAnno != null && !(hasCt = this.hasCascadeType(cascadeTypes = oneToOneAnno.cascade(), ignoreRemoveCascadedWith)) && (relObj = rm.invoke(o, new Object[0])) != null)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
    }

    @Override
    public boolean isObjectImmutable(Object bean) throws ControllerException {
        ImmutibilityProvider ip;
        boolean beanImmut;
        if (bean instanceof ImmutibilityProvider && (beanImmut = (ip = (ImmutibilityProvider)bean).isImmutable())) {
            return true;
        }
        Set<PropertyDescriptor> oipds = this.beanInfo.getObjectImmutablePropertyDescriptors();
        for (PropertyDescriptor oipd : oipds) {
            boolean hasRefs = this.hasRelationShips(bean, oipd);
            if (!hasRefs) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isObjectRemovable(Object bean) throws ControllerException {
        if (bean instanceof ImmutibilityProvider) {
            ImmutibilityProvider ip = (ImmutibilityProvider)bean;
            boolean beanRemovable = ip.isRemovable();
            return beanRemovable;
        }
        Set<PropertyDescriptor> oipds = this.beanInfo.getObjectImmutablePropertyDescriptors();
        for (PropertyDescriptor oipd : oipds) {
            boolean hasRefs = this.hasRelationShips(bean, oipd);
            if (!hasRefs) continue;
            return false;
        }
        return true;
    }

    public Object removeById(HttpServletRequest req, Object id) throws ControllerException {
        return this.removeById(req, id, false);
    }

    public Object removeById(HttpServletRequest req, Object id, boolean removeRelationShips) throws ControllerException {
        return this.removeById(req, this.beanInfo, id, removeRelationShips);
    }

    public Object removeById(HttpServletRequest req, ExtBeanInfo typeInfo, Object id, boolean removeRelationShips) throws ControllerException {
        EntityManager em = this.getThreadEntityManager();
        try {
            Object o = em.find(typeInfo.getBeanDescriptor().getBeanClass(), id);
            if (o == null) {
                throw new NoSuchObjectException(id);
            }
            this.securityManager.checkRemovePermission(req, o);
            if (removeRelationShips) {
                PropertyDescriptor[] ppds;
                PropertyDescriptor[] propertyDescriptorArray = ppds = typeInfo.getPersistencePropertyDescriptors();
                int n = ppds.length;
                int n2 = 0;
                while (n2 < n) {
                    Object relObj;
                    Object values;
                    PropertyDescriptor relPpd;
                    PropertyDescriptor[] propertyDescriptorArray2;
                    Class relatedReturnType;
                    ParameterizedType prt;
                    Type[] pts;
                    PropertyDescriptor relatedPropertyDescriptor;
                    CascadeType ct;
                    CascadeType[] cascadeTypes;
                    PropertyDescriptor ppd = propertyDescriptorArray[n2];
                    Method rm = ppd.getReadMethod();
                    OneToMany oneToManyAnno = rm.getAnnotation(OneToMany.class);
                    ManyToMany manyToManyAnno = rm.getAnnotation(ManyToMany.class);
                    OneToOne oneToOneAnnotation = rm.getAnnotation(OneToOne.class);
                    boolean cascadeRemove = false;
                    if (oneToManyAnno != null) {
                        CascadeType[] cascadeTypeArray = cascadeTypes = oneToManyAnno.cascade();
                        int n3 = cascadeTypes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ct = cascadeTypeArray[n4];
                            if (ct.equals((Object)CascadeType.ALL) || ct.equals((Object)CascadeType.REMOVE)) {
                                cascadeRemove = true;
                                break;
                            }
                            ++n4;
                        }
                        if (!cascadeRemove) {
                            Type rt;
                            relatedPropertyDescriptor = null;
                            String mappedby = oneToManyAnno.mappedBy();
                            if (mappedby != null && !mappedby.equals("") && (rt = rm.getGenericReturnType()) instanceof ParameterizedType && (pts = (prt = (ParameterizedType)rt).getActualTypeArguments()).length == 1) {
                                PropertyDescriptor[] relPpds;
                                relatedReturnType = (Class)pts[0];
                                Object relatedbeanInfo = null;
                                relatedbeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(relatedReturnType);
                                propertyDescriptorArray2 = relPpds = relatedbeanInfo.getPersistencePropertyDescriptors();
                                int n5 = relPpds.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    relPpd = propertyDescriptorArray2[n6];
                                    if (relPpd.getName().equals(mappedby)) {
                                        relatedPropertyDescriptor = relPpd;
                                    }
                                    ++n6;
                                }
                                values = (Collection)rm.invoke(o, new Object[0]);
                                Method relWriteMethod = relatedPropertyDescriptor.getWriteMethod();
                                relatedbeanInfo = values.iterator();
                                while (relatedbeanInfo.hasNext()) {
                                    relObj = relatedbeanInfo.next();
                                    relWriteMethod.invoke(relObj, new Object[1]);
                                    this.securityManager.checkMergePermission(req, relObj);
                                    em.merge(relObj);
                                }
                                values.clear();
                            }
                        }
                    } else if (manyToManyAnno != null) {
                        cascadeTypes = manyToManyAnno.cascade();
                        values = cascadeTypes;
                        int rt = cascadeTypes.length;
                        int mappedby = 0;
                        while (mappedby < rt) {
                            ct = values[mappedby];
                            if (ct.equals((Object)CascadeType.ALL) || ct.equals((Object)CascadeType.REMOVE)) {
                                cascadeRemove = true;
                                break;
                            }
                            ++mappedby;
                        }
                        if (!cascadeRemove) {
                            relatedPropertyDescriptor = null;
                            String mappedby2 = manyToManyAnno.mappedBy();
                            if (mappedby2 != null && !mappedby2.equals("") && (rt = rm.getGenericReturnType()) instanceof ParameterizedType && (pts = (prt = (ParameterizedType)rt).getActualTypeArguments()).length == 1) {
                                PropertyDescriptor[] relPpds;
                                relatedReturnType = (Class)pts[0];
                                ExtBeanInfo relatedbeanInfo = null;
                                relatedbeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(relatedReturnType);
                                propertyDescriptorArray2 = relPpds = relatedbeanInfo.getPersistencePropertyDescriptors();
                                int n7 = relPpds.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    relPpd = propertyDescriptorArray2[n8];
                                    if (relPpd.getName().equals(mappedby2)) {
                                        relatedPropertyDescriptor = relPpd;
                                    }
                                    ++n8;
                                }
                                values = (Collection)rm.invoke(o, new Object[0]);
                                Method relReadMethod = relatedPropertyDescriptor.getReadMethod();
                                Iterator iterator = values.iterator();
                                while (iterator.hasNext()) {
                                    relObj = iterator.next();
                                    Collection relCollValues = (Collection)relReadMethod.invoke(relObj, new Object[0]);
                                    this.securityManager.checkMergePermission(req, relObj);
                                    relCollValues.remove(o);
                                    em.merge(relObj);
                                }
                                values.clear();
                            }
                        }
                    } else if (oneToOneAnnotation != null) {
                        cascadeTypes = oneToOneAnnotation.cascade();
                        values = cascadeTypes;
                        int rt = cascadeTypes.length;
                        int mappedby2 = 0;
                        while (mappedby2 < rt) {
                            ct = values[mappedby2];
                            if (ct.equals((Object)CascadeType.ALL) || ct.equals((Object)CascadeType.REMOVE)) {
                                cascadeRemove = true;
                                break;
                            }
                            ++mappedby2;
                        }
                        if (!cascadeRemove) {
                            Class<?> returnType = rm.getReturnType();
                            Object relObj2 = rm.invoke(o, new Object[0]);
                            if (relObj2 != null) {
                                PropertyDescriptor relPpd2;
                                PropertyDescriptor[] propertyDescriptorArray3;
                                ExtBeanInfo relBeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(returnType);
                                PropertyDescriptor[] relPPds = relBeanInfo.getPersistencePropertyDescriptors();
                                String mappedBy = oneToOneAnnotation.mappedBy();
                                if (mappedBy != null && !mappedBy.equals("")) {
                                    propertyDescriptorArray3 = relPPds;
                                    int n9 = relPPds.length;
                                    int n10 = 0;
                                    while (n10 < n9) {
                                        relPpd2 = propertyDescriptorArray3[n10];
                                        if (relPpd2.getName().equals(mappedBy)) {
                                            Method relWm = relPpd2.getWriteMethod();
                                            this.securityManager.checkMergePermission(req, relObj2);
                                            relWm.invoke(relObj2, new Object[1]);
                                            em.merge(relObj2);
                                            break;
                                        }
                                        ++n10;
                                    }
                                } else {
                                    propertyDescriptorArray3 = relPPds;
                                    int n11 = relPPds.length;
                                    int n12 = 0;
                                    while (n12 < n11) {
                                        String mappedby;
                                        relPpd2 = propertyDescriptorArray3[n12];
                                        Method relRm = relPpd2.getReadMethod();
                                        OneToOne relOneToOneAnno = relRm.getAnnotation(OneToOne.class);
                                        if (relOneToOneAnno != null && (mappedby = relOneToOneAnno.mappedBy()) != null && mappedby.equals(ppd.getName())) {
                                            Method relWm = relPpd2.getWriteMethod();
                                            this.securityManager.checkMergePermission(req, relObj2);
                                            relWm.invoke(relObj2, new Object[1]);
                                            break;
                                        }
                                        ++n12;
                                    }
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            em.remove(o);
            return o;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
    }

    @Override
    public BeanTableModel<?> getBeanTableModel(HttpServletRequest request) throws ControllerException {
        if (this.beanTableModel == null) {
            this.createBeanTableModel(request);
        }
        return this.beanTableModel;
    }

    public BeanTableModel<?> getBeanTableModel() {
        return this.beanTableModel;
    }

    @Override
    public int getFirstItem() {
        return this.firstItem;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void processNamedQuery(HttpServletRequest req, String namedQuery, Object[] params) throws ControllerException {
        this.currentRequest = req;
        this.clear();
        this.namedQueryParam = null;
        this.namedQueryParams = params;
        this.namedQuery = namedQuery;
        this.parameterizedQuery = null;
        this.processListRequest(req);
    }

    private List<PropertyDescriptor> getPropertyDescriptorByReturnType(PropertyDescriptor[] ppds, Class<?> returnType) {
        ArrayList<PropertyDescriptor> resList = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor[] propertyDescriptorArray = ppds;
        int n = ppds.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                Class relatedReturnType;
                PropertyDescriptor pd;
                block4: {
                    Type rt;
                    block2: {
                        Type pt;
                        pd = propertyDescriptorArray[n2];
                        Method rm = pd.getReadMethod();
                        relatedReturnType = null;
                        rt = rm.getGenericReturnType();
                        if (!(rt instanceof ParameterizedType)) break block2;
                        ParameterizedType prt = (ParameterizedType)rt;
                        Type[] pts = prt.getActualTypeArguments();
                        if (pts.length != 1 || !((pt = pts[0]) instanceof Class)) break block3;
                        relatedReturnType = (Class)pts[0];
                        break block4;
                    }
                    relatedReturnType = (Class)rt;
                }
                if (relatedReturnType != null && relatedReturnType.isAssignableFrom(returnType)) {
                    resList.add(pd);
                }
            }
            ++n2;
        }
        return resList;
    }

    @Deprecated
    private PropertyDescriptor getPropertyDescriptorByMappedBy(PropertyDescriptor[] ppds, Class<?> returnType, String relatedProp) {
        List<PropertyDescriptor> retTypeMatchPds = this.getPropertyDescriptorByReturnType(ppds, returnType);
        for (PropertyDescriptor pd : retTypeMatchPds) {
            Method rm = pd.getReadMethod();
            String mappedBy = null;
            ManyToMany mToMAnno = rm.getAnnotation(ManyToMany.class);
            OneToMany oToMAnno = rm.getAnnotation(OneToMany.class);
            OneToOne oToOAnno = rm.getAnnotation(OneToOne.class);
            if (mToMAnno != null) {
                mappedBy = mToMAnno.mappedBy();
            } else if (oToMAnno != null) {
                mappedBy = oToMAnno.mappedBy();
            } else if (oToOAnno != null) {
                mappedBy = oToOAnno.mappedBy();
            }
            if (mappedBy == null || !mappedBy.equals(relatedProp)) continue;
            return pd;
        }
        return null;
    }

    public void createBeanTableModel(HttpServletRequest request) throws ControllerException {
        this.createBeanTableModel(request.getParameter(KEY_CMD), request);
    }

    public void createBeanTableModel(String cmd, HttpServletRequest request) throws ControllerException {
        this.createBeanTableModel(cmd, new BeanTableModel(), request);
    }

    public void selectItem(HttpServletRequest request) throws ControllerException {
        HashMap pMap = (HashMap)request.getParameterMap();
        this.setSelectedItemId(request, this.createIdObject(pMap));
    }

    public void changeSelectedItemIds(HttpServletRequest request) throws ControllerException {
        Map pMap = request.getParameterMap();
        this.setSelectedItemId(request, this.createIdObject(pMap));
    }

    public void createEmptyBeanTableModel(HttpServletRequest request) {
        this.beanTableModel = new BeanTableModel();
        this.beanTableModel.setBatchSize(this.batchSize);
        this.beanTableModel.setExtBeanInfo(this.beanInfo);
        this.beanTableModel.setItems(new ArrayList());
        this.beanTableModel.setItemCount(0);
    }

    public void createBeanTableModel(String command, BeanTableModel<T> btm, HttpServletRequest request) throws ControllerException {
        ArrayList<String> newDisplayedProps;
        btm.setBatchSize(this.batchSize);
        btm.setExtBeanInfo(this.beanInfo);
        if (CMD_LIST_ALL.equals(command)) {
            this.setBoolCondition(null);
            this.mode = new ListMode();
        } else if (CMD_LIST_RELATED.equals(command)) {
            this.mode = new ListMode();
            this.processRelationShip(request.getParameterMap());
            command = CMD_LIST;
        } else if (CMD_SELECT_TO_RESET.equals(command)) {
            String selectTargetProperty = request.getParameter(KEY_RELATED_PROPERTY);
            ListMode lm = new ListMode();
            lm.setSelectMode(new SelectMode(SelectMode.ActionType.RESET, request.getParameter(KEY_ACTION), selectTargetProperty));
            this.mode = lm;
            this.processRelationShip(request.getParameterMap());
        } else if (CMD_LIST_APPLY_COND.equals(command)) {
            BoolExprQueryParser q = null;
            try {
                q = new BoolExprQueryParser((ServletRequest)request, this.queryType);
            }
            catch (ParserException e1) {
                e1.printStackTrace();
                this.setBoolCondition(null);
            }
            ExtBoolExpr be = null;
            try {
                be = q.parse();
                this.setBoolCondition(be);
            }
            catch (ParserException e) {
                this.setBoolCondition(null);
                e.printStackTrace();
            }
        } else if (CMD_LIST_ORDER_BY.equals(command)) {
            OrderByQueryParser obQueryParser = new OrderByQueryParser((ServletRequest)request);
            try {
                this.orderByClause = obQueryParser.parse();
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        if (this.mode != null && this.mode instanceof ListMode) {
            btm.setSelectMode(((ListMode)this.mode).getSelectMode());
        }
        EntityManager em = this.getThreadEntityManager();
        Query q = null;
        String jpqlSelectExpression = "o";
        int itemCount = 0;
        if (this.query != null) {
            q = this.query;
            itemCount = q.getResultList().size();
        } else if (this.namedQuery != null) {
            Query qc;
            Object idObj = null;
            if (this.namedQueryParam != null) {
                try {
                    idObj = em.find(this.namedQueryParam.getTargetClass(), this.namedQueryParam.getIdObject());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                qc = em.createNamedQuery(this.namedQuery);
                qc.setParameter(1, idObj);
                itemCount = qc.getResultList().size();
                q = em.createNamedQuery(this.namedQuery);
                q.setParameter(1, idObj);
            } else {
                int pi;
                qc = em.createNamedQuery(this.namedQuery);
                if (this.namedQueryParams != null) {
                    pi = 0;
                    while (pi < this.namedQueryParams.length) {
                        qc.setParameter(pi + 1, this.namedQueryParams[pi]);
                        ++pi;
                    }
                }
                itemCount = qc.getResultList().size();
                q = em.createNamedQuery(this.namedQuery);
                if (this.namedQueryParams != null) {
                    pi = 0;
                    while (pi < this.namedQueryParams.length) {
                        q.setParameter(pi + 1, this.namedQueryParams[pi]);
                        ++pi;
                    }
                }
            }
        } else if (this.parameterizedQuery != null) {
            this.parameterizedQuery.setAdditionalCondition((BoolExpr)this.boolCondition);
            this.parameterizedQuery.appendOrderByClause(this.orderByClause);
            q = this.parameterizedQuery.createQuery(em);
            itemCount = q.getResultList().size();
        } else {
            int i;
            Object[] vars;
            String baseQuery = "SELECT COUNT(" + jpqlSelectExpression + ") FROM " + this.qlQeryTypeName + " AS " + jpqlSelectExpression;
            String orderByClauseStr = "";
            String whereClauseStr = "";
            if (this.orderByClause != null) {
                orderByClauseStr = this.orderByClause.toJPQLString(jpqlSelectExpression);
            }
            PersistenceBoolExpr pqd = null;
            Query qc = null;
            if (this.boolCondition != null) {
                whereClauseStr = whereClauseStr.concat(" WHERE ");
            }
            if (this.boolCondition != null) {
                PersistenceBoolExprConverter pbec = new PersistenceBoolExprConverter((BoolExpr)this.boolCondition, jpqlSelectExpression);
                pqd = pbec.createQueryData(em);
                whereClauseStr = whereClauseStr.concat(" (" + pqd.getConditionalExpression() + " )");
            }
            qc = em.createQuery(String.valueOf(baseQuery) + whereClauseStr);
            if (this.boolCondition != null) {
                vars = pqd.getQueryVars();
                i = 0;
                while (i < vars.length) {
                    qc.setParameter("persistenceboolexprconverter_" + (i + 1), vars[i]);
                    ++i;
                }
            }
            itemCount = ((Long)qc.getSingleResult()).intValue();
            baseQuery = "SELECT " + jpqlSelectExpression + " FROM " + this.qlQeryTypeName + " " + jpqlSelectExpression;
            q = em.createQuery(String.valueOf(baseQuery) + whereClauseStr + " " + orderByClauseStr);
            if (this.boolCondition != null) {
                vars = pqd.getQueryVars();
                i = 0;
                while (i < vars.length) {
                    q.setParameter("persistenceboolexprconverter_" + (i + 1), vars[i]);
                    ++i;
                }
            }
        }
        PersistenceObjectIdentifier relatedPoi = this.getRelatedObjectIdentifier();
        SelectMode sm = btm.getSelectMode();
        if (relatedPoi != null && sm != null && (SelectMode.ActionType.SET.equals((Object)sm.getActionType()) || SelectMode.ActionType.RESET.equals((Object)sm.getActionType()))) {
            Object relatedObject = em.find(relatedPoi.getTargetClass(), relatedPoi.getIdObject());
            this.securityManager.checkReadPermission(request, relatedObject);
            PropertyDescriptor relPd = this.getRelatedPropertyDescriptor();
            Method rm = relPd.getReadMethod();
            ManyToMany mToMAnno = rm.getAnnotation(ManyToMany.class);
            OneToMany oToMAnno = rm.getAnnotation(OneToMany.class);
            String selQuery = null;
            selQuery = mToMAnno != null || oToMAnno != null ? "SELECT " + jpqlSelectExpression + " FROM " + this.qlQeryTypeName + " " + jpqlSelectExpression + " WHERE :" + JPQL_PARAM_NAME_PREFIX + " MEMBER OF " + jpqlSelectExpression + "." + relPd.getName() : "SELECT " + jpqlSelectExpression + " FROM " + this.qlQeryTypeName + " " + jpqlSelectExpression + " WHERE " + jpqlSelectExpression + "." + relPd.getName() + " = :" + JPQL_PARAM_NAME_PREFIX;
            Query selQ = em.createQuery(selQuery);
            selQ.setParameter(JPQL_PARAM_NAME_PREFIX, relatedObject);
            List resultList = selQ.getResultList();
            int selSize = resultList.size();
            if (selSize > 1) {
                throw new ControllerException("More than one result in many/one to one relationship !");
            }
            if (selSize == 1) {
                Object selObject = resultList.get(0);
                if (this.securityManager != null) {
                    this.securityManager.checkReadPermission(request, selObject);
                }
                try {
                    Object selId = this.beanInfo.getIdValue(selObject);
                    btm.setSelectedIds(new Object[]{selId});
                }
                catch (Exception e) {
                    throw new ControllerException(e);
                }
            }
        }
        if (CMD_LIST_ADD_COL.equals(command)) {
            String p = null;
            newDisplayedProps = new ArrayList<String>();
            ArrayList<String> dpdsList = new ArrayList<String>(this.displayColumns);
            newDisplayedProps.addAll(dpdsList);
            List<String> hiddenProps = this.beanInfo.getHiddenProperties();
            p = request.getParameter("_col");
            if (p != null) {
                if (hiddenProps.contains(p)) {
                    throw new ControllerException("Access to property denied!");
                }
                Object[] objectArray = this.beanInfo.getPersistencePropertyDescriptors();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor pd = objectArray[n2];
                    String pdName = pd.getName();
                    if (pdName.equals(p) && !dpdsList.contains(pdName)) {
                        newDisplayedProps.add(pdName);
                    }
                    ++n2;
                }
                if (this.additionalColumns != null) {
                    objectArray = this.additionalColumns;
                    n = this.additionalColumns.length;
                    n2 = 0;
                    while (n2 < n) {
                        Object additionalColName = objectArray[n2];
                        if (((String)additionalColName).equals(p) && !dpdsList.contains(additionalColName)) {
                            newDisplayedProps.add((String)additionalColName);
                        }
                        ++n2;
                    }
                }
            }
            newDisplayedProps.removeAll(hiddenProps);
            this.setDisplayColumns(newDisplayedProps);
        } else if (CMD_LIST_REMOVE_COL.equals(command)) {
            String p = null;
            newDisplayedProps = new ArrayList();
            p = request.getParameter("_col");
            if (p != null) {
                for (String colName : this.displayColumns) {
                    if (colName.equals(p)) continue;
                    newDisplayedProps.add(colName);
                }
            }
            this.setDisplayColumns(newDisplayedProps);
        } else if (CMD_LIST_COLS_RESET.equals(command)) {
            this.setDisplayColumns(null);
        } else if (CMD_LIST_SELECT_ITEM.equals(command) || CMD_LIST_SELECT_MULTI.equals(command)) {
            this.selectItem(request);
        } else if (CMD_LIST_FIRST.equals(command)) {
            this.firstItem = 0;
        } else if (CMD_LIST_NEXT.equals(command)) {
            if (this.firstItem + this.batchSize < itemCount) {
                this.firstItem += this.batchSize;
            }
        } else if (CMD_LIST_PREVIOUS.equals(command)) {
            this.firstItem -= this.batchSize;
            if (this.firstItem < 0) {
                this.firstItem = 0;
            }
        } else if (CMD_LIST_LAST.equals(command)) {
            int pages = itemCount / this.batchSize;
            if (itemCount % this.batchSize > 0) {
                ++pages;
            }
            this.firstItem = (pages - 1) * this.batchSize;
        } else if (CMD_LIST_ALL.equals(command)) {
            this.boolCondition = null;
        }
        if (this.firstItem > itemCount - 1) {
            this.firstItem = 0;
        }
        q.setMaxResults(this.batchSize);
        q.setFirstResult(this.firstItem);
        List resultList = q.getResultList();
        ArrayList<Object> safeItems = new ArrayList<Object>();
        for (Object o : resultList) {
            if (this.securityManager != null) {
                if (!this.dropInSecureItems) {
                    this.securityManager.checkReadPermission(request, o);
                } else if (this.securityManager.getReadPermission(request, o)) {
                    safeItems.add(o);
                }
            }
            this.setPropertiesAfterQuery(request, em, o);
        }
        if (this.dropInSecureItems) {
            itemCount = safeItems.size();
            btm.setItems(safeItems);
        } else {
            btm.setItems(resultList);
        }
        btm.setItemCount(itemCount);
        btm.setFirstItem(this.firstItem);
        btm.setLastItem(this.firstItem + this.batchSize >= itemCount ? itemCount - 1 : this.firstItem + this.batchSize - 1);
        if (this.selectedItemId != null) {
            btm.setSelectedRowsIds(new Object[]{this.selectedItemId});
        }
        btm.setExtBeanInfo(this.getBeanInfo());
        this.beanTableModel = btm;
    }

    protected void setPropertiesAfterSelect(HttpServletRequest request, Object selObject) {
    }

    protected void setPropertiesAfterSelect(HttpServletRequest request, Set<Object> selObjects) {
    }

    public void createBeanModel(HttpServletRequest request) throws ControllerException {
        Map map = request.getParameterMap();
        Object idObj = this.createIdObject(map);
        EntityManager em = this.getThreadEntityManager();
        try {
            Object editItem = em.find(this.queryType, idObj);
            if (editItem == null) {
                throw new NoSuchObjectException(idObj);
            }
            PersistenceMapConverter mapConverter = new PersistenceMapConverter();
            try {
                mapConverter.setBeanProperties(editItem, map, em, false, request, this.securityManager);
                this.securityManager.checkReadPermission(request, editItem);
                this.beanModel = new BeanModel(editItem);
            }
            catch (MapConverterException e) {
                e.printStackTrace();
                throw new ControllerException("Could not apply property values.", e);
            }
        }
        catch (PersistenceException e) {
            e.printStackTrace();
            this.close();
            throw e;
        }
    }

    private void createSingleItemModel(HttpServletRequest req) throws ControllerException {
        if (this.namedQuery == null && this.id == null) {
            throw new ControllerException("No named query or ID to load single object!");
        }
        Object singleItem = null;
        EntityManager em = this.getThreadEntityManager();
        if (this.namedQuery != null) {
            Query q = null;
            Object idObj = null;
            q = em.createNamedQuery(this.namedQuery);
            if (this.namedQueryParam != null) {
                try {
                    idObj = em.find(this.namedQueryParam.getTargetClass(), this.namedQueryParam.getIdObject());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ControllerException(e);
                }
                q.setParameter(1, idObj);
            } else if (this.namedQueryParams != null) {
                int pi = 0;
                while (pi < this.namedQueryParams.length) {
                    q.setParameter(pi + 1, this.namedQueryParams[pi]);
                    ++pi;
                }
            }
            try {
                singleItem = q.getSingleResult();
            }
            catch (NoResultException nre) {
                this.beanModel = null;
            }
        } else if (this.id != null) {
            singleItem = em.find(this.queryType, this.id);
        }
        if (singleItem != null) {
            this.securityManager.checkReadPermission(req, singleItem);
            em.refresh(singleItem);
            this.beanModel = new BeanModel(singleItem);
        }
    }

    public T getItem() throws ControllerException {
        if (this.beanModel == null) {
            this.createSingleItemModel(this.currentRequest);
        }
        if (this.beanModel != null) {
            return (T)this.beanModel.getBean();
        }
        return null;
    }

    @Override
    public List<String> getDisplayColumns() {
        return this.displayColumns;
    }

    protected void setPropertiesOnNew(Object bean) {
    }

    protected void setPropertiesOnCreate(HttpServletRequest request, EntityManager em, Object bean) {
    }

    protected void setPropertiesOnApply(HttpServletRequest request, EntityManager em, Object bean) {
    }

    protected void setPropertiesAfterQuery(HttpServletRequest request, EntityManager em, Object o) {
    }

    public ValidationResult validate(Object o, ValidationResult validationResult) throws ValidationException {
        FormConfiguration formConfiguration = this.getFormConfiguration();
        ValidationResult vr = validationResult;
        boolean defaultRequired = false;
        if (vr == null) {
            vr = new ValidationResult();
        }
        if (this.queryType.isAssignableFrom(o.getClass())) {
            PropertyDescriptor[] pPds;
            PropertyDescriptor[] propertyDescriptorArray = pPds = this.beanInfo.getPersistencePropertyDescriptors();
            int n = pPds.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                String pdName = pd.getName();
                PropertyValidationResult prVr = vr.getPropertyValidationResult(pdName);
                if (prVr == null || prVr.isValid()) {
                    Object val;
                    boolean required = defaultRequired;
                    if (formConfiguration != null) {
                        boolean requiredByFormConfig = false;
                        List propCfgs = formConfiguration.getPropertyConfigurations();
                        for (PropertyConfiguration pCfg : propCfgs) {
                            if (!pd.equals(pCfg.getPropertyDescriptor())) continue;
                            requiredByFormConfig = pCfg.isRequired() && pCfg.isShow();
                            break;
                        }
                        required = requiredByFormConfig;
                    }
                    Method rm = pd.getReadMethod();
                    try {
                        val = rm.invoke(o, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ValidationException((Throwable)e);
                    }
                    Input inputA = rm.getAnnotation(Input.class);
                    if (inputA != null) {
                        required = required || inputA.required();
                    }
                    Column colAnno = rm.getAnnotation(Column.class);
                    Delegate delegateAnno = rm.getAnnotation(Delegate.class);
                    if (colAnno != null || delegateAnno != null) {
                        LocalizableMessage msg;
                        if (colAnno != null && !colAnno.nullable() && val == null) {
                            vr.setType(ValidationResult.Type.ERRORS);
                            msg = new LocalizableMessage(this.beanInfo.getResourceBundleName(), "validation.field.must_be_set");
                            vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR, msg));
                        }
                        if (required && (val == null || pd.getPropertyType().equals(String.class) && "".equals(val))) {
                            vr.setType(ValidationResult.Type.ERRORS);
                            vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR, VALIDATION_MSG_FIELD_REQUIRED));
                        }
                        if (colAnno != null && pd.getPropertyType().equals(String.class) && val != null && ((String)val).length() > colAnno.length()) {
                            vr.setType(ValidationResult.Type.ERRORS);
                            msg = new LocalizableMessage(this.beanInfo.getResourceBundleName(), "validation.field.too_long");
                            vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR, msg));
                        }
                    }
                }
                ++n2;
            }
        } else {
            throw new ValidationException("Object has not type of controller !");
        }
        return vr;
    }

    protected void apply(HttpServletRequest request) throws ControllerException {
        T newItem = null;
        try {
            newItem = this.queryType.newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
            throw new ControllerException(e1);
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            throw new ControllerException(e1);
        }
        this._apply(request, newItem);
    }

    protected void merge(HttpServletRequest request) throws ControllerException {
        T item = this.getItem();
        if (item == null) {
            try {
                item = this.queryType.newInstance();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
                throw new ControllerException(e1);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
                throw new ControllerException(e1);
            }
        }
        MapConverter mc = new MapConverter();
        try {
            mc.validateAndSetBeanProperties(item, request.getParameterMap(), false);
            this.processResult = new ProcessResult(ProcessResult.Type.SUCCESS);
            this.beanModel = new BeanModel(item);
        }
        catch (MapConverterException e) {
            e.printStackTrace();
            this.processResult = new ProcessResult(ProcessResult.Type.ERROR);
            this.beanModel = null;
        }
    }

    protected void _apply(HttpServletRequest request, T item) throws ControllerException {
        Map map = request.getParameterMap();
        BeanModel<Object> newBeanModel = null;
        EntityManager em = this.getThreadEntityManager();
        this.setPropertiesOnCreate(request, em, item);
        PersistenceMapConverter mapConverter = new PersistenceMapConverter();
        try {
            newBeanModel = mapConverter.createBeanModel(item, map, em, false, request, this.securityManager);
        }
        catch (MapConverterException e) {
            e.printStackTrace();
            this.rollback();
            Throwable cause = e.getCause();
            if (cause instanceof ControllerException) {
                throw (ControllerException)cause;
            }
            throw new ControllerException("Could not apply properties.", e);
        }
        ExtBeanInfo bInfo = this.getBeanInfo();
        if (bInfo.getIdPropertyDescriptor() != null && !this.isIdGenerated()) {
            Object idO;
            try {
                idO = bInfo.getIdValue(item);
            }
            catch (Exception e) {
                e.printStackTrace();
                em.remove(item);
                throw new ControllerException(e);
            }
            Object exO = em.find(bInfo.getBeanDescriptor().getBeanClass(), idO);
            if (exO != null) {
                throw new ObjectAlreadyExistsException(idO);
            }
        }
        ValidationResult validationResult = null;
        try {
            validationResult = this.validate(newBeanModel.getBean(), newBeanModel.getValidationResult());
        }
        catch (ValidationException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        this.processResult = new ProcessResult(validationResult);
        this.beanModel = new BeanModel(item, validationResult);
    }

    private ValidationResult validateAlreadyExisting(EntityManager em, PropertyDescriptor idPd, T mergeItem) throws ControllerException {
        ValidationResult validationResult = null;
        if (idPd != null && !this.isIdGenerated()) {
            Object idO;
            try {
                idO = this.beanInfo.getIdValue(mergeItem);
            }
            catch (Exception e) {
                e.printStackTrace();
                em.remove(mergeItem);
                throw new ControllerException(e);
            }
            Object exO = em.find(this.beanInfo.getBeanDescriptor().getBeanClass(), idO);
            if (exO != null) {
                validationResult = new ValidationResult(ValidationResult.Type.ERRORS);
                String classDescr = null;
                String bRbNm = this.beanInfo.getResourceBundleName();
                String bClResKey = this.beanInfo.getClassResourceKey();
                if (bRbNm != null && bClResKey != null) {
                    LocalizableMessage objClassNm = new LocalizableMessage(bRbNm, bClResKey);
                    classDescr = objClassNm;
                } else {
                    classDescr = this.beanInfo.getBeanDescriptor().getBeanClass().getName();
                }
                PropertyValidationResult idPvr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR, new LocalizableMessage("ipsk.jsp.Messages", "object.already_exists", new Object[]{classDescr, idO}));
                validationResult.putPropertyValidationResult(idPd.getName(), idPvr);
            }
        }
        return validationResult;
    }

    protected void add(HttpServletRequest request, String command) throws ControllerException {
        Map map = request.getParameterMap();
        T newItem = null;
        try {
            newItem = this.queryType.newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
            throw new ControllerException(e1);
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            throw new ControllerException(e1);
        }
        EntityManager em = this.getThreadEntityManager();
        this.securityManager.checkPersistPermission(request, newItem);
        BeanModel newBeanModel = new BeanModel(newItem);
        boolean idGenerated = this.beanInfo.isIdGenerated();
        ValidationResult validationResult = null;
        ExtBeanInfo bInfo = this.getBeanInfo();
        PropertyDescriptor idPd = bInfo.getIdPropertyDescriptor();
        PersistenceMapConverter mapConverter = new PersistenceMapConverter();
        boolean prePersisted = false;
        try {
            boolean prePersistRequired = mapConverter.createPrepersistBeanModel(newItem, map, newBeanModel);
            if ((idGenerated || prePersistRequired) && (validationResult = this.validateAlreadyExisting(em, idPd, newItem)) == null) {
                em.persist(newItem);
                em.flush();
                prePersisted = true;
            }
        }
        catch (MapConverterException e) {
            throw new ControllerException(e);
        }
        BeanModel mergeModel = newBeanModel;
        this.setPropertiesOnCreate(request, em, newItem);
        Object mergeItem = mergeModel.getBean();
        if (validationResult == null || validationResult.isValid()) {
            try {
                mapConverter.applyToBeanModel(mergeModel, map, em, true, request, this.securityManager);
            }
            catch (MapConverterException e) {
                e.printStackTrace();
                this.rollback();
                Throwable cause = e.getCause();
                if (cause instanceof ControllerException) {
                    throw (ControllerException)cause;
                }
                throw new ControllerException("Could not apply properties.", e);
            }
            this.setPropertiesOnApply(request, em, mergeItem);
            if (!prePersisted) {
                validationResult = this.validateAlreadyExisting(em, idPd, newItem);
            }
            try {
                validationResult = this.validate(mergeModel.getBean(), mergeModel.getValidationResult());
            }
            catch (ValidationException e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
        }
        this.processResult = new ProcessResult(validationResult);
        if (validationResult.isValid()) {
            this.securityManager.checkMergePermission(request, mergeItem);
            if (idGenerated) {
                em.merge(mergeItem);
            } else {
                em.persist(mergeItem);
            }
            em.flush();
        } else {
            this.rollback();
        }
        this.beanModel = new BeanModel(mergeItem, validationResult);
    }

    public boolean isApplyAllProperties() {
        return this.applyAllProperties;
    }

    public void setApplyAllProperties(boolean applyAllProperties) {
        this.applyAllProperties = applyAllProperties;
    }

    private void processRelationShip(Map<String, String[]> queryMap) throws ControllerException {
        PersistenceObjectIdentifier poi;
        ExtBoolExpr relatedCondition = null;
        try {
            poi = PersistenceObjectIdentifier.parseQueryMap(queryMap);
        }
        catch (ParserException e1) {
            e1.printStackTrace();
            throw new ControllerException("Could not parse object identifier from query map.", e1);
        }
        catch (IntrospectionException e1) {
            e1.printStackTrace();
            throw new ControllerException("Could not introspect class.", e1);
        }
        PropertyDescriptor[] ppds = this.beanInfo.getPersistencePropertyDescriptors();
        String propertyName = null;
        String[] mappedByArr = queryMap.get(KEY_MAPPEDBY);
        boolean relIsToOne = false;
        if (mappedByArr != null) {
            propertyName = mappedByArr[0];
            PropertyDescriptor[] propertyDescriptorArray = ppds;
            int n = ppds.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (pd.getName().equals(propertyName)) {
                    this.relatedPropertyDescriptor = pd;
                    relIsToOne = true;
                    break;
                }
                ++n2;
            }
        } else {
            String[] relatedPropArr = queryMap.get(KEY_RELATED_PROPERTY);
            if (relatedPropArr == null || relatedPropArr.length != 1) {
                throw new ControllerException("Related property name missing in query (parameter '_related_prop'");
            }
            String relatedProp = relatedPropArr[0];
            List<PropertyDescriptor> retTypeMatchPds = this.getPropertyDescriptorByReturnType(ppds, poi.getTargetClass());
            this.relatedPropertyDescriptor = null;
            for (PropertyDescriptor pd : retTypeMatchPds) {
                Method rm = pd.getReadMethod();
                String mappedBy = null;
                ManyToMany mToMAnno = rm.getAnnotation(ManyToMany.class);
                OneToMany oToMAnno = rm.getAnnotation(OneToMany.class);
                OneToOne oToOAnno = rm.getAnnotation(OneToOne.class);
                if (mToMAnno != null) {
                    mappedBy = mToMAnno.mappedBy();
                } else if (oToMAnno != null) {
                    mappedBy = oToMAnno.mappedBy();
                } else if (oToOAnno != null) {
                    mappedBy = oToOAnno.mappedBy();
                    relIsToOne = true;
                }
                if (mappedBy != null && mappedBy.equals(relatedProp)) {
                    this.relatedPropertyDescriptor = pd;
                    break;
                }
                if (retTypeMatchPds.size() != 1) continue;
                this.relatedPropertyDescriptor = retTypeMatchPds.get(0);
                break;
            }
            if (this.relatedPropertyDescriptor == null) {
                throw new ControllerException("Could not find related property descriptor: '" + relatedProp + "'");
            }
            propertyName = this.relatedPropertyDescriptor.getName();
        }
        String relatedPropertyName = this.relatedPropertyDescriptor.getName();
        Class<?> relatedType = this.relatedPropertyDescriptor.getPropertyType();
        Method readMethod = this.relatedPropertyDescriptor.getReadMethod();
        if (this.mode != null && this.mode instanceof ListMode) {
            SelectMode selectMode = ((ListMode)this.mode).getSelectMode();
            SelectMode.ActionType actionType = null;
            if (selectMode != null) {
                actionType = selectMode.getActionType();
            }
            if (Collection.class.isAssignableFrom(relatedType)) {
                Type rt = readMethod.getGenericReturnType();
                if (rt instanceof ParameterizedType) {
                    ParameterizedType prt = (ParameterizedType)rt;
                    Type[] pts = prt.getActualTypeArguments();
                    if (pts.length != 1) {
                        throw new ControllerException("Parameterized type " + prt + " has not exactly one type argument\nCannot get bean info of property return type.");
                    }
                } else {
                    throw new ControllerException("Property " + relatedPropertyName + " is not prameterized.\nCannot create Id object for unknown type!");
                }
                if (actionType == null) {
                    relatedCondition = new ExtBoolExpr();
                    relatedCondition.setOperator((Object)ExtBoolExpr.MEMBER);
                } else if (actionType.equals((Object)SelectMode.ActionType.ADD)) {
                    relatedCondition = new ExtBoolExpr();
                    relatedCondition.setOperator((Object)ExtBoolExpr.NOT_MEMBER);
                } else if (actionType.equals((Object)SelectMode.ActionType.REMOVE)) {
                    relatedCondition = new ExtBoolExpr();
                    relatedCondition.setOperator((Object)ExtBoolExpr.MEMBER);
                } else if (!actionType.equals((Object)SelectMode.ActionType.SET) && actionType.equals((Object)SelectMode.ActionType.RESET)) {
                    relatedCondition = new ExtBoolExpr();
                    relatedCondition.setOperator((Object)ExtBoolExpr.MEMBER);
                }
            } else if (actionType == null || actionType.equals((Object)SelectMode.ActionType.REMOVE)) {
                relatedCondition = new ExtBoolExpr();
                relatedCondition.setOperator((Object)ExtBoolExpr.EQUALS);
            } else if (actionType.equals((Object)SelectMode.ActionType.ADD)) {
                relatedCondition = new ExtBoolExpr();
                relatedCondition.setOperator((Object)ExtBoolExpr.NOT_BOUND);
            }
            if (relatedCondition != null) {
                relatedCondition.setOperand0((Object)this.relatedPropertyDescriptor.getName());
                relatedCondition.setOperand1((Object)poi);
            }
            this.setBoolCondition(relatedCondition);
        }
        this.setRelatedObjectIdentifier(poi);
    }

    public void processListRequest(HttpServletRequest req) throws ControllerException {
        this.currentRequest = req;
        this.clear();
        if (!(this.mode instanceof ListMode)) {
            this.mode = new ListMode();
        }
        this.createBeanTableModel(req.getParameter(KEY_CMD), req);
    }

    public String processCommand(HttpServletRequest request, String[] possibleSubmitCommands) {
        String command = request.getParameter(KEY_CMD);
        String[] stringArray = possibleSubmitCommands;
        int n = possibleSubmitCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String possibleSubmitCmd = stringArray[n2];
            if (request.getParameter("_" + possibleSubmitCmd) != null) {
                command = possibleSubmitCmd;
                break;
            }
            ++n2;
        }
        return command;
    }

    public String processCommand(HttpServletRequest request) {
        return this.processCommand(request, this.SUBMIT_CMDS);
    }

    @Override
    public ProcessResult process(HttpServletRequest request, HttpServletResponse response, Servlet servlet) throws ControllerException {
        this.processRequest(request);
        return this.getProcessResult();
    }

    @Override
    public ProcessResult process(HttpServletRequest request, HttpServletResponse response) throws ControllerException {
        this.processRequest(request);
        return this.getProcessResult();
    }

    @Override
    public void processRequest(HttpServletRequest request) throws ControllerException {
        this.processRequest(request, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processRequest(HttpServletRequest request, ParameterizedQuery parameterizedQuery) throws ControllerException {
        this.currentRequest = request;
        this.parameterizedQuery = parameterizedQuery;
        this.namedQuery = null;
        this.processResult = null;
        this.actionCanceled = false;
        if (request.getCharacterEncoding() == null) {
            try {
                request.setCharacterEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ControllerException(e);
            }
        }
        Map queryMap = request.getParameterMap();
        String command = this.processCommand(request);
        if (command != null && command.equals(CMD_CANCEL)) {
            this.beanModel = new BeanModel(null, new ValidationResult(ValidationResult.Type.CANCELLED));
            this.processResult = new ProcessResult(ProcessResult.Type.CANCELLED);
            this.actionCanceled = true;
            return;
        }
        if (command != null && command.equals(CMD_CANCEL_STORE_RELATED)) {
            this.processResult = new ProcessResult(ProcessResult.Type.CANCELLED);
            this.actionCanceled = true;
            command = CMD_EDIT;
        }
        if (command == null || command.equals(CMD_CANCEL)) {
            command = CMD_LIST;
        }
        if (CMD_LIST_RELATED.equals(command)) {
            this.beanModel = null;
            this.beanTableModel = null;
            this.setNamedQuery(null, null);
            this.setBoolCondition(null);
            this.mode = new ListMode();
            this.processRelationShip(queryMap);
            this.createBeanTableModel(CMD_LIST, request);
            return;
        }
        if (command.equals(CMD_SELECT_TO_ADD)) {
            this.beanModel = null;
            this.beanTableModel = null;
            this.setNamedQuery(null, null);
            this.setBoolCondition(null);
            String selectTargetProperty = request.getParameter(KEY_RELATED_PROPERTY);
            ListMode lm = new ListMode();
            lm.setSelectMode(new SelectMode(SelectMode.ActionType.ADD, request.getParameter(KEY_ACTION), selectTargetProperty));
            this.mode = lm;
            BeanTableModel btm = new BeanTableModel();
            this.processRelationShip(queryMap);
            this.createBeanTableModel(command, btm, request);
            return;
        }
        if (command.equals(CMD_SELECT_TO_REMOVE)) {
            this.beanModel = null;
            this.beanTableModel = null;
            this.setNamedQuery(null, null);
            this.setBoolCondition(null);
            String selectTargetProperty = request.getParameter(KEY_RELATED_PROPERTY);
            ListMode lm = new ListMode();
            lm.setSelectMode(new SelectMode(SelectMode.ActionType.REMOVE, request.getParameter(KEY_ACTION), selectTargetProperty));
            this.mode = lm;
            BeanTableModel btm = new BeanTableModel();
            this.processRelationShip(queryMap);
            this.createBeanTableModel(command, btm, request);
            return;
        }
        if (command.equals(CMD_SELECT_TO_SET)) {
            this.beanModel = null;
            this.beanTableModel = null;
            this.setNamedQuery(null, null);
            this.setBoolCondition(null);
            String selectTargetProperty = request.getParameter(KEY_RELATED_PROPERTY);
            ListMode lm = new ListMode();
            lm.setSelectMode(new SelectMode(SelectMode.ActionType.SET, request.getParameter(KEY_ACTION), selectTargetProperty));
            this.mode = lm;
            BeanTableModel btm = new BeanTableModel();
            this.processRelationShip(queryMap);
            this.createBeanTableModel(command, btm, request);
            return;
        }
        if (command.equals(CMD_SELECT_TO_RESET)) {
            this.beanModel = null;
            this.beanTableModel = null;
            this.setNamedQuery(null, null);
            this.setBoolCondition(null);
            BeanTableModel btm = new BeanTableModel();
            this.createBeanTableModel(command, btm, request);
            return;
        }
        if (CMD_LIST_NUM_ROWS_PAGE.equals(command)) {
            int newRows;
            this.beanModel = null;
            this.beanTableModel = null;
            String rowsParm = request.getParameter(KEY_ROWS);
            if (rowsParm != null && (newRows = Integer.parseInt(rowsParm)) > 0) {
                if (newRows > 1000) {
                    newRows = 1000;
                }
                this.setBatchSize(newRows);
            }
            this.processListRequest(request);
            return;
        }
        if (command.equals(CMD_LIST) || command.equals(CMD_LIST_ALL)) {
            this.beanModel = null;
            this.beanTableModel = null;
            this.setBoolCondition(null);
            this.mode = new ListMode();
            this.processListRequest(request);
            return;
        }
        if (command.startsWith(CMD_LIST)) {
            this.beanModel = null;
            this.beanTableModel = null;
            this.processListRequest(request);
            return;
        }
        if (command.equals(CMD_NAMED_QUERY)) {
            PersistenceObjectIdentifier poi;
            this.beanModel = null;
            this.beanTableModel = null;
            this.mode = new ListMode();
            try {
                poi = PersistenceObjectIdentifier.parseQueryMap(queryMap);
            }
            catch (ParserException e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
            this.setNamedQuery(request.getParameter(KEY_QUERY_NAME), poi);
            this.createBeanTableModel(command, request);
            return;
        }
        if (command.equals(CMD_NAMED_QUERY_SINGLE)) {
            PersistenceObjectIdentifier poi;
            this.beanModel = null;
            this.beanTableModel = null;
            try {
                poi = PersistenceObjectIdentifier.parseQueryMap(queryMap);
            }
            catch (ParserException e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
            this.setNamedQuery(request.getParameter(KEY_QUERY_NAME), poi);
            this.createSingleItemModel(request);
            this.mode = new ViewMode();
            return;
        }
        if (command.equals(CMD_NEW)) {
            T newItem;
            this.beanModel = null;
            this.beanTableModel = null;
            this.setNamedQuery(null, null);
            this.setId(null);
            this.mode = new EditMode();
            try {
                newItem = this.queryType.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ControllerException("Could not instantiate new object.", e);
            }
            Map map = request.getParameterMap();
            EntityManager em = this.getThreadEntityManager();
            try {
                PersistenceMapConverter mapConverter = new PersistenceMapConverter();
                try {
                    mapConverter.setBeanProperties(newItem, map, em, false, request, this.securityManager);
                }
                catch (MapConverterException e) {
                    e.printStackTrace();
                    throw new ControllerException(e);
                }
                this.setPropertiesOnNew(newItem);
            }
            catch (PersistenceException e) {
                e.printStackTrace();
                this.close();
                throw e;
            }
            T newItemT = newItem;
            this.beanModel = new BeanModel(newItemT);
            return;
        }
        if (command.equals(CMD_NEW_TO_ADD)) {
            T newItem;
            this.beanModel = null;
            this.beanTableModel = null;
            this.setNamedQuery(null, null);
            this.setId(null);
            this.mode = new EditMode();
            try {
                newItem = this.queryType.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ControllerException("Could not instantiate new object.", e);
            }
            Map map = request.getParameterMap();
            EntityManager em = this.getThreadEntityManager();
            try {
                PersistenceMapConverter mapConverter = new PersistenceMapConverter();
                try {
                    mapConverter.setBeanProperties(newItem, map, em, false, request, this.securityManager);
                }
                catch (MapConverterException e) {
                    e.printStackTrace();
                    throw new ControllerException(e);
                }
                this.setPropertiesOnNew(newItem);
            }
            catch (PersistenceException e) {
                e.printStackTrace();
                this.close();
                throw e;
            }
            this.processRelationShip(queryMap);
            if (this.relatedPropertyDescriptor != null) {
                Method wm = this.relatedPropertyDescriptor.getWriteMethod();
                Method rm = this.relatedPropertyDescriptor.getReadMethod();
                PersistenceObjectIdentifier poi = this.getRelatedObjectIdentifier();
                Object poiIdObj = poi.getIdObject();
                Object relatedParentObj = em.find(poi.getTargetClass(), poiIdObj);
                ManyToMany mtom = rm.getAnnotation(ManyToMany.class);
                try {
                    if (mtom != null) {
                        Object collObj = rm.invoke(newItem, new Object[0]);
                        if (collObj instanceof Collection) {
                            Collection coll = (Collection)collObj;
                            coll.add(relatedParentObj);
                        }
                    } else {
                        wm.invoke(newItem, relatedParentObj);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ControllerException(e);
                }
            }
            T newItemT = newItem;
            this.beanModel = new BeanModel(newItemT);
            return;
        }
        if (command.equals(CMD_REMOVE)) {
            Object o;
            this.beanModel = null;
            this.beanTableModel = null;
            String idStr = request.getParameter(this.beanInfo.getIdPropertyDescriptor().getName());
            try {
                this.setId(this.beanInfo.createIdValueByString(idStr));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
            Object ot = o = this.removeById(request, this.id);
            this.beanModel = new BeanModel(ot);
            this.processResult = new ProcessResult(ProcessResult.Type.SUCCESS);
            return;
        }
        if (command.equals(CMD_DELETE)) {
            Object o;
            this.beanModel = null;
            this.beanTableModel = null;
            String idStr = request.getParameter(this.beanInfo.getIdPropertyDescriptor().getName());
            try {
                this.setId(this.beanInfo.createIdValueByString(idStr));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
            this.deleteRelated(request, this.id);
            Object ot = o = this.removeById(request, this.id, true);
            this.beanModel = new BeanModel(ot);
            this.processResult = new ProcessResult(ProcessResult.Type.SUCCESS);
            return;
        }
        if (command.equals(CMD_EDIT) || command.equals(CMD_CORRECT) || command.equals(CMD_VIEW) || command.equals(CMD_EXPORT)) {
            this.beanModel = null;
            this.beanTableModel = null;
            this.createBeanModel(request);
            this.mode = command.equals(CMD_EDIT) || command.equals(CMD_CORRECT) ? new EditMode() : new ViewMode();
            return;
        }
        if (command.equals(CMD_APPLY)) {
            this.beanModel = null;
            this.beanTableModel = null;
            this.apply(request);
            return;
        }
        if (command.equals(CMD_MERGE)) {
            this.merge(request);
            return;
        }
        if (command.equals(CMD_STORE)) {
            this.beanModel = null;
            this.beanTableModel = null;
            Map map = request.getParameterMap();
            Object idObj = this.createIdObject(map);
            EntityManager em = this.getThreadEntityManager();
            Object mergeItem = em.find(this.queryType, idObj);
            if (mergeItem == null) {
                throw new ControllerException("Item with ID '" + idObj + "' to update not found !");
            }
            this.beanModel = new BeanModel(mergeItem);
            PersistenceMapConverter mapConverter = new PersistenceMapConverter();
            try {
                mapConverter.applyToBeanModel(this.beanModel, map, em, false, request, this.securityManager);
            }
            catch (MapConverterException e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
            this.setPropertiesOnApply(request, em, mergeItem);
            ValidationResult validationResult = null;
            try {
                validationResult = this.validate(this.beanModel.getBean(), this.beanModel.getValidationResult());
                this.beanModel.setValidationResult(validationResult);
            }
            catch (ValidationException e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
            if (validationResult.isValid()) {
                this.securityManager.checkMergePermission(request, mergeItem);
                em.merge(mergeItem);
                em.flush();
            }
            this.processResult = new ProcessResult(validationResult);
            return;
        }
        if (command.equals(CMD_STORE_ADD_RELATED) || command.equals(CMD_STORE_REMOVE_RELATED) || command.equals(CMD_STORE_SET_RELATED) || command.equals(CMD_STORE_RESET_RELATED)) {
            this.beanModel = null;
            this.beanTableModel = null;
            Map map = request.getParameterMap();
            Object idObj = this.createIdObject(map);
            EntityManager em = this.getThreadEntityManager();
            try {
                Object o = em.find(this.queryType, idObj);
                if (o == null) {
                    throw new ControllerException("Could not find entity for class " + this.queryType + " with ID: " + idObj);
                }
                this.securityManager.checkMergePermission(request, o);
                this.beanModel = new BeanModel(o);
                PropertyDescriptor[] ppds = this.beanInfo.getPersistencePropertyDescriptors();
                PropertyDescriptor propertyDescriptor = null;
                Object enumValue = null;
                String[] relatedIdValues = null;
                Set queryKeySet = queryMap.keySet();
                for (String key : queryKeySet) {
                    int dotPosition = key.indexOf(".");
                    if (dotPosition == -1) continue;
                    String pName = key.substring(0, dotPosition);
                    PropertyDescriptor[] propertyDescriptorArray = ppds;
                    int n = ppds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PropertyDescriptor pd = propertyDescriptorArray[n2];
                        if (pd.getName().equals(pName)) {
                            propertyDescriptor = pd;
                            relatedIdValues = (String[])queryMap.get(key);
                            break;
                        }
                        ++n2;
                    }
                    if (propertyDescriptor == null) continue;
                }
                if (propertyDescriptor != null) {
                    EnumType enumtype;
                    Method readMethod = propertyDescriptor.getReadMethod();
                    Method writeMethod = propertyDescriptor.getWriteMethod();
                    Class collType = null;
                    OneToMany oneToManyAnno = readMethod.getAnnotation(OneToMany.class);
                    ManyToMany manyToManyAnno = readMethod.getAnnotation(ManyToMany.class);
                    ManyToOne manyToOneAnno = readMethod.getAnnotation(ManyToOne.class);
                    OneToOne oneToOneAnno = readMethod.getAnnotation(OneToOne.class);
                    Enumerated enumerated = readMethod.getAnnotation(Enumerated.class);
                    ElementCollection elementCollection = readMethod.getAnnotation(ElementCollection.class);
                    if (oneToManyAnno != null) {
                        String mappedByPropertyName = oneToManyAnno.mappedBy();
                        Type rt = readMethod.getGenericReturnType();
                        if (!(rt instanceof ParameterizedType)) throw new ControllerException("Collection return type of property is not parametrized.\nCannot get bean info of property return type.");
                        ParameterizedType prt = (ParameterizedType)rt;
                        Type[] pts = prt.getActualTypeArguments();
                        if (pts.length != 1) {
                            throw new ControllerException("Parameterized type " + prt + " has more than one type arguemnts\nCannot get bean info of property return type.");
                        }
                        collType = (Class)pts[0];
                        ExtBeanInfo retTypeInfo = null;
                        retTypeInfo = PersistenceIntrospector.getPersistenceBeanInfo(collType);
                        Collection collVal = (Collection)readMethod.invoke(o, new Object[0]);
                        String[] stringArray = relatedIdValues;
                        int n = relatedIdValues.length;
                        int n3 = 0;
                        while (n3 < n) {
                            PropertyDescriptor[] relPpds;
                            String idStr = stringArray[n3];
                            Object relIdObj = retTypeInfo.createIdValueByString(idStr);
                            Object relObj = em.find(collType, relIdObj);
                            PropertyDescriptor relPd = null;
                            PropertyDescriptor[] propertyDescriptorArray = relPpds = retTypeInfo.getPersistencePropertyDescriptors();
                            int n4 = relPpds.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                PropertyDescriptor rPd = propertyDescriptorArray[n5];
                                if (rPd.getName().equals(mappedByPropertyName)) {
                                    relPd = rPd;
                                    break;
                                }
                                ++n5;
                            }
                            this.securityManager.checkMergePermission(request, relObj, relPd);
                            Method relWriteMethod = relPd.getWriteMethod();
                            if (command.equals(CMD_STORE_ADD_RELATED)) {
                                relWriteMethod.invoke(relObj, o);
                                collVal.add(relObj);
                            } else if (command.equals(CMD_STORE_REMOVE_RELATED)) {
                                relWriteMethod.invoke(relObj, new Object[1]);
                                collVal.remove(relObj);
                            }
                            ++n3;
                        }
                    } else if (manyToManyAnno != null) {
                        List<PropertyDescriptor> retTypeMatchPds;
                        Type rt = readMethod.getGenericReturnType();
                        if (!(rt instanceof ParameterizedType)) throw new ControllerException("Collection return type of property is not parametrized.\nCannot get bean info of property return type.");
                        ParameterizedType prt = (ParameterizedType)rt;
                        Type[] pts = prt.getActualTypeArguments();
                        if (pts.length != 1) {
                            throw new ControllerException("Parameterized type " + prt + " has more than one type arguemnts\nCannot get bean info of property return type.");
                        }
                        collType = (Class)pts[0];
                        ExtBeanInfo retTypeInfo = null;
                        retTypeInfo = PersistenceIntrospector.getPersistenceBeanInfo(collType);
                        String relatedPropertyName = manyToManyAnno.mappedBy();
                        if ((relatedPropertyName == null || "".equals(relatedPropertyName)) && (retTypeMatchPds = this.getPropertyDescriptorByReturnType(retTypeInfo.getPropertyDescriptors(), this.queryType)) != null && retTypeMatchPds.size() == 1) {
                            PropertyDescriptor retTypeMatchPd = retTypeMatchPds.get(0);
                            relatedPropertyName = retTypeMatchPd.getName();
                        }
                        if (relatedPropertyName != null && !relatedPropertyName.equals("")) {
                            String[] stringArray = relatedIdValues;
                            int n = relatedIdValues.length;
                            int retTypeMatchPd = 0;
                            while (retTypeMatchPd < n) {
                                PropertyDescriptor[] relPpds2;
                                String idStr = stringArray[retTypeMatchPd];
                                Object relIdObj = retTypeInfo.createIdValueByString(idStr);
                                Object relObj = em.find(collType, relIdObj);
                                this.securityManager.checkMergePermission(request, relObj);
                                PropertyDescriptor relPd = null;
                                PropertyDescriptor[] propertyDescriptorArray = relPpds2 = retTypeInfo.getPersistencePropertyDescriptors();
                                int n6 = relPpds2.length;
                                int relWriteMethod = 0;
                                while (relWriteMethod < n6) {
                                    PropertyDescriptor rPd = propertyDescriptorArray[relWriteMethod];
                                    if (rPd.getName().equals(relatedPropertyName)) {
                                        relPd = rPd;
                                        break;
                                    }
                                    ++relWriteMethod;
                                }
                                Method relReadMethod2 = relPd.getReadMethod();
                                Collection coll = (Collection)readMethod.invoke(o, new Object[0]);
                                Collection relColl = (Collection)relReadMethod2.invoke(relObj, new Object[0]);
                                this.securityManager.checkMergePermission(request, relObj, this.relatedPropertyDescriptor);
                                if (command.equals(CMD_STORE_ADD_RELATED)) {
                                    relColl.add(o);
                                    coll.add(relObj);
                                } else if (command.equals(CMD_STORE_REMOVE_RELATED)) {
                                    relColl.remove(o);
                                    coll.remove(relObj);
                                }
                                ++retTypeMatchPd;
                            }
                        } else {
                            PropertyDescriptor[] relPpds;
                            PropertyDescriptor relPd = null;
                            PropertyDescriptor[] relObj = relPpds = retTypeInfo.getPersistencePropertyDescriptors();
                            int relIdObj = relPpds.length;
                            int n = 0;
                            while (n < relIdObj) {
                                PropertyDescriptor rPd = relObj[n];
                                ManyToMany relMtoMAnno = rPd.getReadMethod().getAnnotation(ManyToMany.class);
                                if (relMtoMAnno != null && relMtoMAnno.mappedBy().equals(propertyDescriptor.getName())) {
                                    relPd = rPd;
                                    break;
                                }
                                ++n;
                            }
                            Method relReadMethod = relPd.getReadMethod();
                            Collection coll = (Collection)readMethod.invoke(o, new Object[0]);
                            Object[] relatedObjects = new Object[relatedIdValues.length];
                            int i = 0;
                            while (i < relatedIdValues.length) {
                                Object relIdObj2 = retTypeInfo.createIdValueByString(relatedIdValues[i]);
                                relatedObjects[i] = em.find(collType, relIdObj2);
                                ++i;
                            }
                            Object[] relReadMethod2 = relatedObjects;
                            int relPpds2 = relatedObjects.length;
                            int relIdObj2 = 0;
                            while (relIdObj2 < relPpds2) {
                                Object relObj2 = relReadMethod2[relIdObj2];
                                this.securityManager.checkMergePermission(request, relObj2, relPd);
                                Collection relColl = (Collection)relReadMethod.invoke(relObj2, new Object[0]);
                                if (command.equals(CMD_STORE_ADD_RELATED)) {
                                    coll.add(relObj2);
                                    relColl.add(o);
                                } else if (command.equals(CMD_STORE_REMOVE_RELATED)) {
                                    coll.remove(relObj2);
                                    relColl.remove(o);
                                }
                                ++relIdObj2;
                            }
                        }
                    } else if (manyToOneAnno != null) {
                        if (relatedIdValues.length > 1) {
                            throw new ControllerException("More than one value for a many to one relationship.");
                        }
                        if (relatedIdValues.length == 1) {
                            PropertyDescriptor[] relPpds;
                            String idStr = relatedIdValues[0];
                            Class<?> relatedType = readMethod.getReturnType();
                            ExtBeanInfo relatedTypeInfo = PersistenceIntrospector.getPersistenceBeanInfo(relatedType);
                            PropertyDescriptor relPd = null;
                            PropertyDescriptor[] relObj2 = relPpds = relatedTypeInfo.getPersistencePropertyDescriptors();
                            int relatedObjects = relPpds.length;
                            int coll = 0;
                            while (coll < relatedObjects) {
                                PropertyDescriptor rPd = relObj2[coll];
                                OneToMany relOtoMAnno = rPd.getReadMethod().getAnnotation(OneToMany.class);
                                if (relOtoMAnno != null && relOtoMAnno.mappedBy().equals(propertyDescriptor.getName())) {
                                    relPd = rPd;
                                    break;
                                }
                                ++coll;
                            }
                            Method relReadMethod = relPd.getReadMethod();
                            Object relObj = null;
                            if (command.equals(CMD_STORE_SET_RELATED)) {
                                Object relIdObj = relatedTypeInfo.createIdValueByString(idStr);
                                relObj = em.find(relatedType, relIdObj);
                                this.securityManager.checkMergePermission(request, relObj, relPd);
                                writeMethod.invoke(o, relObj);
                                Collection relColl = (Collection)relReadMethod.invoke(relObj, new Object[0]);
                                relColl.add(o);
                            } else if (command.equals(CMD_STORE_RESET_RELATED)) {
                                relObj = readMethod.invoke(o, new Object[0]);
                                this.securityManager.checkMergePermission(request, relObj, relPd);
                                writeMethod.invoke(o, new Object[1]);
                                Collection relColl = (Collection)relReadMethod.invoke(relObj, new Object[0]);
                                relColl.remove(o);
                            }
                        }
                    } else if (oneToOneAnno != null) {
                        if (relatedIdValues.length > 1) {
                            throw new ControllerException("More than one value for a one to one relationship.");
                        }
                        if (relatedIdValues.length == 1) {
                            PropertyDescriptor[] relPpds;
                            String idStr = relatedIdValues[0];
                            Class<?> relatedType = readMethod.getReturnType();
                            String propertyName = propertyDescriptor.getName();
                            PropertyDescriptor relPd = null;
                            ExtBeanInfo relatedTypeInfo = PersistenceIntrospector.getPersistenceBeanInfo(relatedType);
                            Object relObj = null;
                            String mappedByAnno = oneToOneAnno.mappedBy();
                            String mappedBy = null;
                            if (mappedByAnno != null && !mappedByAnno.equals("")) {
                                mappedBy = mappedByAnno;
                            }
                            PropertyDescriptor[] propertyDescriptorArray = relPpds = relatedTypeInfo.getPersistencePropertyDescriptors();
                            int relReadMethod2 = relPpds.length;
                            int relPpds2 = 0;
                            while (relPpds2 < relReadMethod2) {
                                PropertyDescriptor relPpd = propertyDescriptorArray[relPpds2];
                                if (mappedBy != null) {
                                    if (mappedBy.equals(relPpd.getName())) {
                                        relPd = relPpd;
                                        break;
                                    }
                                } else {
                                    String relMappedby;
                                    OneToOne relOnetToOneAnno = relPpd.getReadMethod().getAnnotation(OneToOne.class);
                                    if (relOnetToOneAnno != null && (relMappedby = relOnetToOneAnno.mappedBy()) != null && relMappedby.equals(propertyName)) {
                                        relPd = relPpd;
                                        break;
                                    }
                                }
                                ++relPpds2;
                            }
                            Method relWriteMethod = relPd.getWriteMethod();
                            if (command.equals(CMD_STORE_SET_RELATED)) {
                                Object relIdObj = relatedTypeInfo.createIdValueByString(idStr);
                                relObj = em.find(relatedType, relIdObj);
                                this.securityManager.checkMergePermission(request, relObj);
                                Object oldRelObject = readMethod.invoke(o, new Object[0]);
                                if (oldRelObject != null) {
                                    relWriteMethod.invoke(oldRelObject, new Object[1]);
                                }
                                relWriteMethod.invoke(relObj, o);
                                writeMethod.invoke(o, relObj);
                            } else if (command.equals(CMD_STORE_RESET_RELATED)) {
                                relObj = readMethod.invoke(o, new Object[0]);
                                this.securityManager.checkMergePermission(request, relObj);
                                relWriteMethod.invoke(relObj, new Object[1]);
                                writeMethod.invoke(o, new Object[1]);
                            }
                        }
                    } else if (enumerated != null && EnumType.STRING.equals((Object)(enumtype = enumerated.value())) && elementCollection != null) {
                        Class enumClass = elementCollection.targetClass();
                        Type rt = readMethod.getGenericReturnType();
                        if (!(rt instanceof ParameterizedType)) throw new ControllerException("Collection return type of property is not parameterized.\nCannot get bean info of property return type.");
                        ParameterizedType prt = (ParameterizedType)rt;
                        Type[] pts = prt.getActualTypeArguments();
                        if (pts.length != 1) throw new ControllerException("Parameterized type " + prt + " has more than one type arguemnts\nCannot get bean info of property return type.");
                        collType = (Class)pts[0];
                        if (!enumClass.equals(collType)) {
                            throw new ControllerException("Parameterized type " + prt + " does not match type of annotated enumeration collection type " + enumClass.getName() + ".");
                        }
                        Collection collVal = (Collection)readMethod.invoke(o, new Object[0]);
                        String[] stringArray = relatedIdValues;
                        int n = relatedIdValues.length;
                        int n7 = 0;
                        while (n7 < n) {
                            String idStr = stringArray[n7];
                            Method valueOfM = enumClass.getDeclaredMethod("valueOf", String.class);
                            Object enumObj = valueOfM.invoke(null, idStr);
                            this.securityManager.checkMergePermission(request, enumObj);
                            if (command.equals(CMD_STORE_ADD_RELATED)) {
                                collVal.add(enumObj);
                            } else if (command.equals(CMD_STORE_REMOVE_RELATED)) {
                                collVal.remove(enumObj);
                            }
                            ++n7;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ControllerException ce = e instanceof ControllerException ? (ControllerException)e : new ControllerException(e);
                throw ce;
            }
            this.mode = new EditMode();
            return;
        }
        if (!command.equals(CMD_ADD)) return;
        this.beanModel = null;
        this.beanTableModel = null;
        this.add(request, command);
    }

    protected Object createIdObject(Map<String, String[]> map) throws ControllerException {
        String[] idStrs;
        Object idObj = null;
        if (this.beanInfo.isIdEmbedded()) {
            PropertyDescriptor idPd = this.beanInfo.getIdPropertyDescriptor();
            try {
                idObj = idPd.getPropertyType().newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
            HashMap<String, String[]> embProps = new HashMap<String, String[]>();
            Set<Map.Entry<String, String[]>> entries2 = map.entrySet();
            for (Map.Entry<String, String[]> entry2 : entries2) {
                String key2 = entry2.getKey();
                int dotIndex2 = key2.indexOf(46);
                String keyName2 = null;
                String deepProperty2 = null;
                if (dotIndex2 <= 0) continue;
                keyName2 = key2.substring(0, dotIndex2);
                deepProperty2 = key2.substring(dotIndex2 + 1);
                if (!keyName2.equals(idPd.getName())) continue;
                embProps.put(deepProperty2, entry2.getValue());
            }
            if (embProps.size() > 0) {
                MapConverter embMc = new MapConverter();
                try {
                    embMc.setBeanProperties(idObj, embProps);
                    return idObj;
                }
                catch (MapConverterException e) {
                    e.printStackTrace();
                    throw new ControllerException(e);
                }
            }
        }
        if ((idStrs = map.get(this.beanInfo.getIdPropertyDescriptor().getName())) != null && idStrs.length == 1 && idStrs[0] != null) {
            String idStr = idStrs[0];
            try {
                idObj = this.beanInfo.createIdValueByString(idStr);
                if (idObj == null) {
                    throw new ControllerException("Could not get item with id=" + idStr);
                }
                this.setId(idObj);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
        }
        try {
            PersistenceObjectIdentifier poi = PersistenceObjectIdentifier.parseQueryMap(map);
            if (poi != null) {
                idObj = poi.getIdObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        return idObj;
    }

    @Override
    public void rollback() {
        EntityManager em = this.getThreadEntityManager();
        if (em != null) {
            EntityTransaction tx = null;
            tx = em.getTransaction();
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    @Override
    public void commit() throws ControllerException {
        EntityManager em = this.getThreadEntityManager();
        if (em != null) {
            EntityTransaction tx = null;
            try {
                tx = em.getTransaction();
                if (tx != null && tx.isActive()) {
                    tx.commit();
                }
            }
            catch (PersistenceException e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                this.setBoolCondition(null);
                throw new ControllerException(e);
            }
            catch (IllegalStateException ise) {
                ise.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                this.setBoolCondition(null);
                throw new ControllerException(ise);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new ControllerException(e);
            }
        }
    }

    protected void clear() {
        this.processResult = null;
        this.beanModel = null;
        this.beanTableModel = null;
        this.actionCanceled = false;
    }

    @Override
    public synchronized void close() {
        EntityManager em = this.getThreadEntityManager();
        try {
            this.commit();
        }
        catch (ControllerException e) {
            e.printStackTrace();
        }
        if (em != null) {
            em.close();
        }
        if (this.emtl != null) {
            this.emtl.remove();
        }
    }

    @Override
    public ExtBoolExpr getBoolCondition() {
        return this.boolCondition;
    }

    public void setBoolCondition(ExtBoolExpr boolCondition) {
        ExtBoolExpr oldCondition = this.boolCondition;
        this.boolCondition = boolCondition;
        if (this.boolCondition == null) {
            if (oldCondition != null) {
                this.firstItem = 0;
            }
        } else if (!this.boolCondition.equals((Object)oldCondition)) {
            this.firstItem = 0;
        }
    }

    @Override
    public OrderByClause getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(OrderByClause orderByClause) {
        this.orderByClause = orderByClause;
    }

    @Override
    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery, PersistenceObjectIdentifier namedQueryParam) {
        this.namedQuery = namedQuery;
        this.namedQueryParam = namedQueryParam;
        this.namedQueryParams = null;
        if (namedQuery != null) {
            this.parameterizedQuery = null;
            this.query = null;
            this.boolCondition = null;
            this.orderByClause = null;
        }
        this.firstItem = 0;
    }

    @Override
    public void setDisplayColumns(List<String> displayColumns) {
        this.displayColumns = displayColumns;
    }

    @Override
    public boolean isIdGenerated() {
        return this.idGenerated;
    }

    public void setIdGenerated(boolean idGenerated) {
        this.idGenerated = idGenerated;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public String getKEY_SELECT_TARGET_PROPERTY() {
        return KEY_SELECT_TARGET_PROPERTY;
    }

    public String getKEY_SELECT_TARGET_ID() {
        return KEY_SELECT_TARGET_ID;
    }

    public String getKEY_SELECT_TARGET_ID_PROPERTY() {
        return KEY_SELECT_TARGET_ID_PROPERTY;
    }

    public String getKEY_SELECTED_ID() {
        return KEY_SELECTED_ID;
    }

    public String getKEY_ACTION() {
        return KEY_ACTION;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public PersistenceObjectIdentifier getRelatedObjectIdentifier() {
        return this.relatedObjectIdentifier;
    }

    public void setRelatedObjectIdentifier(PersistenceObjectIdentifier relatedObjectIdentifier) {
        this.relatedObjectIdentifier = relatedObjectIdentifier;
    }

    public PropertyDescriptor getRelatedPropertyDescriptor() {
        return this.relatedPropertyDescriptor;
    }

    public void setRelatedPropertyDescriptor(PropertyDescriptor relatedPropertyDescriptor) {
        this.relatedPropertyDescriptor = relatedPropertyDescriptor;
    }

    public Object getSelectedItemId() {
        return this.selectedItemId;
    }

    public Object getSelectedItem() {
        if (this.selectedItemId == null) {
            return null;
        }
        EntityManager em = this.getThreadEntityManager();
        Object ret = em.find(this.queryType, this.selectedItemId);
        return ret;
    }

    public void setSelectedItemId(HttpServletRequest request, Object selectedItemId) {
        this.selectedItemId = selectedItemId;
        this.setPropertiesAfterSelect(request, selectedItemId);
    }

    public void setSelectedItemIds(HttpServletRequest request, Set<Object> selectedItemIds) {
        this.selectedItemIds = selectedItemIds;
        this.setPropertiesAfterSelect(request, selectedItemIds);
    }

    public Set<Object> getSelectedItemIds() {
        return this.selectedItemIds;
    }

    public boolean isActionCanceled() {
        return this.actionCanceled;
    }

    public ParameterizedQuery getParameterizedQuery() {
        return this.parameterizedQuery;
    }

    public void setParameterizedQuery(ParameterizedQuery parameterizedQuery) {
        this.parameterizedQuery = parameterizedQuery;
        this.namedQuery = null;
        this.query = null;
    }

    public void setQuery(Query query) {
        this.query = query;
        this.namedQuery = null;
        this.parameterizedQuery = null;
    }

    public BeanModel<T> getBeanModel() {
        return this.beanModel;
    }

    @Override
    public ProcessResult getProcessResult() {
        return this.processResult;
    }

    public static String getKEY_PREFIX_DELETE_RELATED() {
        return KEY_PREFIX_DELETE_RELATED;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public boolean isDropInSecureItems() {
        return this.dropInSecureItems;
    }

    public void setDropInSecureItems(boolean dropInSecureItems) {
        this.dropInSecureItems = dropInSecureItems;
    }

    public static class EditMode
    extends SingleMode {
    }

    public class EntityManagerThreadLocal
    extends ThreadLocal<EntityManager> {
        @Override
        protected synchronized EntityManager initialValue() {
            return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
        }
    }

    public static class ListMode
    extends Mode {
        private SelectMode selectMode = null;

        public SelectMode getSelectMode() {
            return this.selectMode;
        }

        public void setSelectMode(SelectMode selectMode) {
            this.selectMode = selectMode;
        }
    }

    public static class Mode {
    }

    public static class SingleMode
    extends Mode {
    }

    public static class ViewMode
    extends SingleMode {
    }
}

