/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.jsp.fmt.LocaleSupport;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.persistence.text.StringObjectConverter;
import ipsk.text.ParserException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class BoolExprQueryParser {
    protected Hashtable<String, String> ht = null;
    protected ServletRequest req = null;
    protected Class<?> beanClass = null;
    protected PropertyDescriptor[] beanProperties = null;
    private Locale locale = null;

    public BoolExprQueryParser(ServletRequest req) {
        this.req = req;
    }

    public BoolExprQueryParser(ServletRequest req, Class beanClass) throws ParserException {
        this(req, beanClass, null);
        String localeStr = req.getParameter("_locale");
        if (localeStr != null) {
            this.locale = LocaleSupport.parse(localeStr);
        }
        if (this.locale == null) {
            this.locale = LocaleSupport.getLocale(req);
        }
        if (this.locale == null && req instanceof HttpServletRequest) {
            this.locale = ((HttpServletRequest)req).getLocale();
        }
    }

    public BoolExprQueryParser(ServletRequest req, Class beanClass, Locale locale) throws ParserException {
        BeanInfo beanInfo;
        this.req = req;
        this.beanClass = beanClass;
        this.locale = locale;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e1) {
            throw new ParserException((Throwable)e1);
        }
        this.beanProperties = beanInfo.getPropertyDescriptors();
    }

    public BoolExprQueryParser(Hashtable<String, String> ht) {
        this.ht = ht;
    }

    public ExtBoolExpr parse() throws ParserException {
        ExtBoolExpr retVal = null;
        retVal = this.parseCondition(0);
        if (retVal == null) {
            String op0 = this.getParameter("_ec0");
            if (op0 == null || op0.equals("")) {
                return null;
            }
            String o0 = this.getParameter("_eo0");
            if (o0 == null || o0.equals("")) {
                return null;
            }
            retVal = this.parseExpression(0);
        }
        return retVal;
    }

    private String getParameter(String paramName) {
        if (this.req != null) {
            return this.req.getParameter(paramName);
        }
        if (this.ht != null) {
            String o = this.ht.get(paramName);
            if (o == null) {
                return null;
            }
            return ((String[])o)[0];
        }
        return null;
    }

    private ExtBoolExpr parseCondition(int index) throws ParserException {
        String c = this.getParameter("_c" + index);
        if (c == null) {
            return null;
        }
        ExtBoolExpr retVal = new ExtBoolExpr();
        StringTokenizer st = new StringTokenizer(c, "_");
        String co1 = st.nextToken();
        int ind = Integer.parseInt(co1.substring(1));
        if (co1.startsWith("e")) {
            retVal.setOperand0((Object)this.parseExpression(ind));
        } else if (co1.startsWith("c")) {
            retVal.setOperand0((Object)this.parseCondition(ind));
        } else {
            throw new ParserException();
        }
        if (!st.hasMoreTokens()) {
            return retVal;
        }
        String coo = st.nextToken();
        String co2 = st.nextToken();
        int ind2 = Integer.parseInt(co2.substring(1));
        if (co2.startsWith("e")) {
            retVal.setOperand1((Object)this.parseExpression(ind2));
        } else if (co2.startsWith("c")) {
            retVal.setOperand1((Object)this.parseCondition(ind2));
        } else {
            throw new ParserException();
        }
        if (retVal != null) {
            retVal.setOperator((Object)coo);
            if (retVal.getOperand0() == null) {
                retVal = (ExtBoolExpr)retVal.getOperand1();
            } else if (retVal.getOperand1() == null) {
                retVal = (ExtBoolExpr)retVal.getOperand0();
            }
        }
        return retVal;
    }

    private ExtBoolExpr parseExpression(int ind) throws ParserException {
        String op0 = this.getParameter("_ec" + ind);
        String opr = this.getParameter("_eo" + ind);
        if (op0 == null || opr == null || op0.equals("") || opr.equals("")) {
            return null;
        }
        ExtBoolExpr retVal = new ExtBoolExpr();
        String op1 = this.getParameter("_ev" + ind);
        if (op0 == null || opr == null || op1 == null) {
            throw new ParserException();
        }
        String boolOp = BoolExprQueryParser.getBoolExprOperator(opr);
        Class<?> propertyType = null;
        Object op1Val = op1;
        if (this.beanClass != null && this.beanProperties != null) {
            PropertyDescriptor[] propertyDescriptorArray = this.beanProperties;
            int n = this.beanProperties.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (pd.getName().equals(op0)) {
                    propertyType = pd.getPropertyType();
                    if (!ExtBoolExpr.isOperatorSupportingType((Object)boolOp, propertyType)) {
                        throw new ParserException("Operator does not support " + propertyType.getName());
                    }
                    try {
                        op1Val = StringObjectConverter.stringToObject(op1, pd, this.locale);
                    }
                    catch (ParserException e) {
                        throw new ParserException((Throwable)e);
                    }
                }
                ++n2;
            }
        }
        if (propertyType != null && propertyType.equals(String.class)) {
            String caseInsensitiveParam = this.getParameter("_eci" + ind);
            retVal.setCaseInSensitive(caseInsensitiveParam != null && caseInsensitiveParam.equals("insensitive"));
        }
        retVal.setOperand0((Object)op0);
        retVal.setOperator((Object)boolOp);
        retVal.setOperand1(op1Val);
        return retVal;
    }

    public static String getQueryOperator(Object extBoolOperator) {
        if (extBoolOperator == null) {
            return "";
        }
        if (extBoolOperator.equals(ExtBoolExpr.EQUAL)) {
            return "is";
        }
        if (extBoolOperator.equals(ExtBoolExpr.NOT_EQUAL)) {
            return "ne";
        }
        if (extBoolOperator.equals(ExtBoolExpr.CONTAINS)) {
            return "contains";
        }
        if (extBoolOperator.equals("(starts with)")) {
            return "starts";
        }
        if (extBoolOperator.equals("(ends with)")) {
            return "ends";
        }
        if (extBoolOperator.equals(">")) {
            return "gt";
        }
        if (extBoolOperator.equals("<")) {
            return "lt";
        }
        if (extBoolOperator.equals(">=")) {
            return "ge";
        }
        if (extBoolOperator.equals("<=")) {
            return "le";
        }
        if (extBoolOperator.equals(ExtBoolExpr.EQUALS)) {
            return "equals";
        }
        if (extBoolOperator.equals(ExtBoolExpr.MEMBER)) {
            return "member";
        }
        if (extBoolOperator.equals(ExtBoolExpr.EQUALS_NOT)) {
            return "equals_not";
        }
        if (extBoolOperator.equals(ExtBoolExpr.NOT_MEMBER)) {
            return "not_member";
        }
        if (extBoolOperator.equals(ExtBoolExpr.BOUND)) {
            return "bound";
        }
        if (extBoolOperator.equals(ExtBoolExpr.NOT_BOUND)) {
            return "not_bound";
        }
        return null;
    }

    public static String getBoolExprOperator(String queryOperator) {
        if (queryOperator == null) {
            return ExtBoolExpr.EQUAL;
        }
        if (queryOperator.equals("is")) {
            return ExtBoolExpr.EQUAL;
        }
        if (queryOperator.equals("ne")) {
            return ExtBoolExpr.NOT_EQUAL;
        }
        if (queryOperator.equals("contains")) {
            return ExtBoolExpr.CONTAINS;
        }
        if (queryOperator.equals("starts")) {
            return "(starts with)";
        }
        if (queryOperator.equals("ends")) {
            return "(ends with)";
        }
        if (queryOperator.equals("gt")) {
            return ">";
        }
        if (queryOperator.equals("lt")) {
            return "<";
        }
        if (queryOperator.equals("ge")) {
            return ">=";
        }
        if (queryOperator.equals("le")) {
            return "<=";
        }
        if (queryOperator.equals("equals")) {
            return ExtBoolExpr.EQUALS;
        }
        if (queryOperator.equals("member")) {
            return ExtBoolExpr.MEMBER;
        }
        if (queryOperator.equals("equals_not")) {
            return ExtBoolExpr.EQUALS_NOT;
        }
        if (queryOperator.equals("not_member")) {
            return ExtBoolExpr.NOT_MEMBER;
        }
        if (queryOperator.equals("bound")) {
            return ExtBoolExpr.BOUND;
        }
        if (queryOperator.equals("not_bound")) {
            return ExtBoolExpr.NOT_BOUND;
        }
        return null;
    }
}

