/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ips.beans.PersistenceMapConverter;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverter;
import ipsk.beans.MapConverterException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.form.FormConfiguration;
import ipsk.beans.form.PropertyConfiguration;
import ipsk.beans.validation.BeanValidator;
import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.jsp.BeanTableModel;
import ipsk.jsp.Controller;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.persistence.SecurityManager;
import ipsk.sql.OrderByClause;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.ControllerException;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.NoSuchObjectException;
import ipsk.webapps.ObjectAlreadyExistsException;
import ipsk.webapps.ProcessResult;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.GeneratedValue;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BasicBeanController<T>
implements BeanValidator,
Controller {
    public static final String KEY_CMD = "_cmd";
    private EntityManagerThreadLocal emtl;
    protected Class<T> queryType;
    protected String queryTypeName;
    protected String jsfIdentifier;
    protected int firstItem = 0;
    private String namedQuery = null;
    private ParameterizedQuery parameterizedQuery = null;
    private ExtBoolExpr boolCondition;
    private OrderByClause orderByClause;
    private Object[] namedQueryParams = null;
    private PersistenceObjectIdentifier namedQueryParam;
    private String[] additionalColumns;
    private String[] displayColumns;
    private ExtBeanInfo beanInfo = null;
    private Object id;
    private boolean idGenerated = false;
    protected BeanTableModel<T> beanTableModel;
    private boolean actionCanceled;
    private Object selectedItemId;
    private Set<Object> selectedItemIds;
    protected HttpServletRequest currentRequest;
    protected SecurityManager securityManager = new SecurityManager();
    protected ServletContext servletContext;
    protected BeanModel<T> beanModel = null;
    protected ProcessResult processResult;
    public static String RESOURCE_BUNDLE_NAME = "ipsk.jsp.Messages";
    private static LocalizableMessage VALIDATION_MSG_FIELD_REQUIRED = new LocalizableMessage(RESOURCE_BUNDLE_NAME, "validation.field.required");

    public String[] getAdditionalColumns() {
        return this.additionalColumns;
    }

    public void setAdditionalColumns(String[] additionalColumns) {
        this.additionalColumns = additionalColumns;
    }

    public void setCurrentRequest(HttpServletRequest currentRequest) {
        this.currentRequest = currentRequest;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public FormConfiguration getFormConfiguration() {
        return null;
    }

    public BasicBeanController(String persistenceUnit, Class<T> queryType) {
        this(persistenceUnit, queryType, queryType.getName());
    }

    public BasicBeanController(String persistenceUnit, Class<T> queryType, String jsfIdentifier) {
        PropertyDescriptor[] pds;
        this.queryType = queryType;
        this.queryTypeName = queryType.getName();
        try {
            this.beanInfo = PersistenceIntrospector.getExtendedBeanInfo(queryType, true, false);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        PropertyDescriptor[] propertyDescriptorArray = pds = this.beanInfo.getPropertyDescriptors();
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            Method rm = pd.getReadMethod();
            if (rm.getAnnotation(GeneratedValue.class) != null) {
                this.setIdGenerated(true);
            }
            ++n2;
        }
        this.jsfIdentifier = jsfIdentifier;
        this.emtl = new EntityManagerThreadLocal();
    }

    @Override
    public void open() {
        EntityManager em = this.getThreadEntityManager();
        EntityTransaction tx = em.getTransaction();
        if (tx != null && !tx.isActive()) {
            tx.begin();
        }
    }

    public ExtBeanInfo getBeanInfo() {
        try {
            return PersistenceIntrospector.getPersistenceBeanInfo(this.queryType);
        }
        catch (IntrospectionException e1) {
            return null;
        }
    }

    public EntityManager getEntityManager() {
        return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
    }

    public EntityManager getThreadEntityManager() {
        if (this.emtl == null) {
            this.emtl = new EntityManagerThreadLocal();
        }
        return (EntityManager)this.emtl.get();
    }

    public PropertyDescriptor[] getBeanProperties() {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(this.queryType);
        }
        catch (IntrospectionException e1) {
            return null;
        }
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        return pds;
    }

    public T getById(Object id) {
        EntityManager em = this.getThreadEntityManager();
        Object o = em.find(this.queryType, id);
        return (T)o;
    }

    public void selectItem(HttpServletRequest request) throws ControllerException {
        Map pMap = request.getParameterMap();
        this.setSelectedItemId(request, this.createIdObject(pMap));
    }

    protected void setPropertiesAfterSelect(HttpServletRequest request, Object selObject) {
    }

    protected void setPropertiesAfterSelect(HttpServletRequest request, Set<Object> selObjects) {
    }

    public void createBeanModel(HttpServletRequest request) throws ControllerException {
        Map map = request.getParameterMap();
        Object idObj = this.createIdObject(map);
        EntityManager em = this.getThreadEntityManager();
        try {
            Object editItem = em.find(this.queryType, idObj);
            if (editItem == null) {
                throw new NoSuchObjectException(idObj);
            }
            PersistenceMapConverter mapConverter = new PersistenceMapConverter();
            try {
                mapConverter.setBeanProperties(editItem, map, em, false, request, this.securityManager);
                this.securityManager.checkReadPermission(request, editItem);
                this.beanModel = new BeanModel(editItem);
            }
            catch (MapConverterException e) {
                e.printStackTrace();
                throw new ControllerException("Could not apply property values.", e);
            }
        }
        catch (PersistenceException e) {
            e.printStackTrace();
            this.close();
            throw e;
        }
    }

    private void createSingleItemModel(HttpServletRequest req) throws ControllerException {
        if (this.namedQuery == null && this.id == null) {
            throw new ControllerException("No named query or ID to load single object!");
        }
        Object singleItem = null;
        EntityManager em = this.getThreadEntityManager();
        if (this.namedQuery != null) {
            Query q = null;
            Object idObj = null;
            q = em.createNamedQuery(this.namedQuery);
            if (this.namedQueryParam != null) {
                try {
                    idObj = em.find(this.namedQueryParam.getTargetClass(), this.namedQueryParam.getIdObject());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ControllerException(e);
                }
                q.setParameter(1, idObj);
            } else if (this.namedQueryParams != null) {
                int pi = 0;
                while (pi < this.namedQueryParams.length) {
                    q.setParameter(pi + 1, this.namedQueryParams[pi]);
                    ++pi;
                }
            }
            try {
                singleItem = q.getSingleResult();
            }
            catch (NoResultException nre) {
                this.beanModel = null;
            }
        } else if (this.id != null) {
            singleItem = em.find(this.queryType, this.id);
        }
        if (singleItem != null) {
            this.securityManager.checkReadPermission(req, singleItem);
            em.refresh(singleItem);
            this.beanModel = new BeanModel(singleItem);
        }
    }

    public T getItem() throws ControllerException {
        if (this.beanModel == null) {
            this.createSingleItemModel(this.currentRequest);
        }
        if (this.beanModel != null) {
            return (T)this.beanModel.getBean();
        }
        return null;
    }

    public String[] getDisplayColumns() {
        return this.displayColumns;
    }

    protected void setPropertiesOnNew(Object bean) {
    }

    protected void setPropertiesOnCreate(HttpServletRequest request, EntityManager em, Object bean) {
    }

    protected void setPropertiesAfterQuery(HttpServletRequest request, EntityManager em, Object o) {
    }

    public ValidationResult validate(Object o, ValidationResult validationResult) throws ValidationException {
        FormConfiguration formConfiguration = this.getFormConfiguration();
        ValidationResult vr = validationResult;
        boolean defaultRequired = false;
        if (vr == null) {
            vr = new ValidationResult();
        }
        if (this.queryType.isAssignableFrom(o.getClass())) {
            PropertyDescriptor[] pPds;
            PropertyDescriptor[] propertyDescriptorArray = pPds = this.beanInfo.getPersistencePropertyDescriptors();
            int n = pPds.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                String pdName = pd.getName();
                PropertyValidationResult prVr = vr.getPropertyValidationResult(pdName);
                if (prVr == null || prVr.isValid()) {
                    Object val;
                    boolean required = defaultRequired;
                    if (formConfiguration != null) {
                        List propCfgs = formConfiguration.getPropertyConfigurations();
                        for (PropertyConfiguration pCfg : propCfgs) {
                            if (!pd.equals(pCfg.getPropertyDescriptor())) continue;
                            required = pCfg.isRequired() && pCfg.isShow();
                            break;
                        }
                    }
                    Method rm = pd.getReadMethod();
                    try {
                        val = rm.invoke(o, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ValidationException((Throwable)e);
                    }
                    Column colAnno = pd.getReadMethod().getAnnotation(Column.class);
                    if (colAnno != null) {
                        LocalizableMessage msg;
                        if (!colAnno.nullable() && val == null) {
                            vr.setType(ValidationResult.Type.ERRORS);
                            msg = new LocalizableMessage(this.beanInfo.getResourceBundleName(), "validation.field.must_be_set");
                            vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR, msg));
                        }
                        if (required && (val == null || pd.getPropertyType().equals(String.class) && "".equals(val))) {
                            vr.setType(ValidationResult.Type.ERRORS);
                            vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR, VALIDATION_MSG_FIELD_REQUIRED));
                        }
                        if (pd.getPropertyType().equals(String.class) && val != null && ((String)val).length() > colAnno.length()) {
                            vr.setType(ValidationResult.Type.ERRORS);
                            msg = new LocalizableMessage(this.beanInfo.getResourceBundleName(), "validation.field.too_long");
                            vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR, msg));
                        }
                    }
                }
                ++n2;
            }
        } else {
            throw new ValidationException("Object has not type of controller !");
        }
        return vr;
    }

    protected void apply(HttpServletRequest request, String command) throws ControllerException {
        Map map = request.getParameterMap();
        BeanModel<Object> newBeanModel = null;
        Object newItem = null;
        try {
            newItem = this.queryType.newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
            throw new ControllerException(e1);
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            throw new ControllerException(e1);
        }
        EntityManager em = this.getThreadEntityManager();
        this.setPropertiesOnCreate(request, em, newItem);
        PersistenceMapConverter mapConverter = new PersistenceMapConverter();
        try {
            newBeanModel = mapConverter.createBeanModel(newItem, map, em, false, request, this.securityManager);
        }
        catch (MapConverterException e) {
            e.printStackTrace();
            this.rollback();
            Throwable cause = e.getCause();
            if (cause instanceof ControllerException) {
                throw (ControllerException)cause;
            }
            throw new ControllerException("Could not apply properties.", e);
        }
        ExtBeanInfo bInfo = this.getBeanInfo();
        if (bInfo.getIdPropertyDescriptor() != null && !this.isIdGenerated()) {
            Object idO;
            try {
                idO = bInfo.getIdValue(newItem);
            }
            catch (Exception e) {
                e.printStackTrace();
                em.remove(newItem);
                throw new ControllerException(e);
            }
            Object exO = em.find(bInfo.getBeanDescriptor().getBeanClass(), idO);
            if (exO != null) {
                throw new ObjectAlreadyExistsException(idO);
            }
        }
        ValidationResult validationResult = null;
        try {
            validationResult = this.validate(newBeanModel.getBean(), newBeanModel.getValidationResult());
        }
        catch (ValidationException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        this.processResult = new ProcessResult(validationResult);
        this.beanModel = new BeanModel(newItem, validationResult);
    }

    public String processCommand(HttpServletRequest request, String[] possibleSubmitCommands) {
        String command = request.getParameter(KEY_CMD);
        String[] stringArray = possibleSubmitCommands;
        int n = possibleSubmitCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String possibleSubmitCmd = stringArray[n2];
            if (request.getParameter("_" + possibleSubmitCmd) != null) {
                command = possibleSubmitCmd;
                break;
            }
            ++n2;
        }
        return command;
    }

    @Override
    public ProcessResult process(HttpServletRequest request, HttpServletResponse response, Servlet servlet) throws ControllerException {
        this.processRequest(request);
        return this.getProcessResult();
    }

    @Override
    public abstract void processRequest(HttpServletRequest var1);

    @Override
    public ProcessResult process(HttpServletRequest request, HttpServletResponse response) throws ControllerException {
        this.processRequest(request);
        return this.getProcessResult();
    }

    protected Object createIdObject(Map<String, String[]> map) throws ControllerException {
        Object idObj = null;
        if (this.beanInfo.isIdEmbedded()) {
            PropertyDescriptor idPd = this.beanInfo.getIdPropertyDescriptor();
            try {
                idObj = idPd.getPropertyType().newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
            HashMap<String, String[]> embProps = new HashMap<String, String[]>();
            Set<Map.Entry<String, String[]>> entries2 = map.entrySet();
            for (Map.Entry<String, String[]> entry2 : entries2) {
                String key2 = entry2.getKey();
                int dotIndex2 = key2.indexOf(46);
                String keyName2 = null;
                String deepProperty2 = null;
                if (dotIndex2 <= 0) continue;
                keyName2 = key2.substring(0, dotIndex2);
                deepProperty2 = key2.substring(dotIndex2 + 1);
                if (!keyName2.equals(idPd.getName())) continue;
                embProps.put(deepProperty2, entry2.getValue());
            }
            MapConverter embMc = new MapConverter();
            try {
                embMc.setBeanProperties(idObj, embProps);
            }
            catch (MapConverterException e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
        }
        String[] idStrs = map.get(this.beanInfo.getIdPropertyDescriptor().getName());
        if (idStrs != null && idStrs.length == 1 && idStrs[0] != null) {
            String idStr = idStrs[0];
            try {
                idObj = this.beanInfo.createIdValueByString(idStr);
                if (idObj == null) {
                    throw new ControllerException("Could not get item with id=" + idStr);
                }
                this.setId(idObj);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
        }
        try {
            PersistenceObjectIdentifier poi = PersistenceObjectIdentifier.parseQueryMap(map);
            if (poi != null) {
                idObj = poi.getIdObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        return idObj;
    }

    @Override
    public void rollback() {
        EntityManager em = this.getThreadEntityManager();
        if (em != null) {
            EntityTransaction tx = null;
            tx = em.getTransaction();
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    @Override
    public void commit() throws ControllerException {
        EntityManager em = this.getThreadEntityManager();
        if (em != null) {
            EntityTransaction tx = null;
            try {
                tx = em.getTransaction();
                if (tx != null && tx.isActive()) {
                    tx.commit();
                }
            }
            catch (PersistenceException e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                this.setBoolCondition(null);
                throw new ControllerException(e);
            }
            catch (IllegalStateException ise) {
                ise.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                this.setBoolCondition(null);
                throw new ControllerException(ise);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new ControllerException(e);
            }
        }
    }

    protected void clear() {
        this.processResult = null;
        this.beanModel = null;
        this.beanTableModel = null;
        this.actionCanceled = false;
    }

    @Override
    public synchronized void close() {
        EntityManager em = this.getThreadEntityManager();
        try {
            this.commit();
        }
        catch (ControllerException e) {
            e.printStackTrace();
        }
        if (em != null) {
            em.close();
        }
        if (this.emtl != null) {
            this.emtl.remove();
        }
    }

    public ExtBoolExpr getBoolCondition() {
        return this.boolCondition;
    }

    public void setBoolCondition(ExtBoolExpr boolCondition) {
        ExtBoolExpr oldCondition = this.boolCondition;
        this.boolCondition = boolCondition;
        if (this.boolCondition == null) {
            if (oldCondition != null) {
                this.firstItem = 0;
            }
        } else if (!this.boolCondition.equals((Object)oldCondition)) {
            this.firstItem = 0;
        }
    }

    public OrderByClause getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(OrderByClause orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery, PersistenceObjectIdentifier namedQueryParam) {
        this.namedQuery = namedQuery;
        this.namedQueryParam = namedQueryParam;
        this.namedQueryParams = null;
        if (namedQuery != null) {
            this.parameterizedQuery = null;
            this.boolCondition = null;
            this.orderByClause = null;
        }
        this.firstItem = 0;
    }

    public void setDisplayColumns(String[] displayColumns) {
        this.displayColumns = displayColumns;
    }

    public boolean isIdGenerated() {
        return this.idGenerated;
    }

    public void setIdGenerated(boolean idGenerated) {
        this.idGenerated = idGenerated;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public Object getSelectedItemId() {
        return this.selectedItemId;
    }

    public Object getSelectedItem() {
        if (this.selectedItemId == null) {
            return null;
        }
        EntityManager em = this.getThreadEntityManager();
        Object ret = em.find(this.queryType, this.selectedItemId);
        return ret;
    }

    public void setSelectedItemId(HttpServletRequest request, Object selectedItemId) {
        this.selectedItemId = selectedItemId;
        this.setPropertiesAfterSelect(request, selectedItemId);
    }

    public void setSelectedItemIds(HttpServletRequest request, Set<Object> selectedItemIds) {
        this.selectedItemIds = selectedItemIds;
        this.setPropertiesAfterSelect(request, selectedItemIds);
    }

    public Set<Object> getSelectedItemIds() {
        return this.selectedItemIds;
    }

    public boolean isActionCanceled() {
        return this.actionCanceled;
    }

    public ParameterizedQuery getParameterizedQuery() {
        return this.parameterizedQuery;
    }

    public void setParameterizedQuery(ParameterizedQuery parameterizedQuery) {
        this.parameterizedQuery = parameterizedQuery;
        this.namedQuery = null;
    }

    public BeanModel getBeanModel() {
        return this.beanModel;
    }

    @Override
    public ProcessResult getProcessResult() {
        return this.processResult;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public class EntityManagerThreadLocal
    extends ThreadLocal<EntityManager> {
        @Override
        protected synchronized EntityManager initialValue() {
            return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
        }
    }
}

