/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.beans;

import ipsk.beans.PropertyValidationResult;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanProperty;
import ipsk.jsp.taglib.beans.BeanPropertyProvider;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.util.LocalizableMessage;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

public class BeanPropertyValidationResultTag
extends ExtBodyTagSupport {
    private static final long serialVersionUID = 1L;
    protected BeanProperty beanProperty = null;

    public void setParent(Tag parent) {
        Tag bpParent = parent;
        while (bpParent != null && !(bpParent instanceof BeanPropertyProvider)) {
            bpParent = bpParent.getParent();
        }
        if (bpParent != null && bpParent instanceof BeanPropertyProvider) {
            this.beanProperty = ((BeanPropertyProvider)bpParent).getBeanProperty();
        }
    }

    @Override
    public int doStartTag() throws JspException {
        PropertyValidationResult pvr = this.beanProperty.getValidationResult();
        try {
            JspWriter ow = this.pageContext.getOut();
            if (pvr != null) {
                LocalizableMessage msg = pvr.getValidationMessage();
                if (msg != null) {
                    ow.print("<td class=\"error\">" + HTMLTextEncoder.encode((String)this.getLocalizedMessage(msg)) + "</td>");
                } else {
                    ow.print("<td class=\"error\">" + HTMLTextEncoder.encode((String)this.getLocalizedMessage("validation.field.invalid")) + "</td>");
                }
            }
        }
        catch (Exception e) {
            throw new JspException("Could not print bean property validation result!", (Throwable)e);
        }
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        return 6;
    }
}

