/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.beans.edit;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.jsp.taglib.beans.BeanPropertyTag;
import ipsk.jsp.taglib.beans.BeanProvider;
import ipsk.net.EditableURI;
import ipsk.persistence.PersistenceObjectIdentifier;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

public abstract class BeanRelatedTag
extends BeanPropertyTag {
    protected String href;
    protected boolean readonly = false;
    protected boolean hasBody = false;
    protected String command = null;
    protected String anchorResourceKey;
    protected Integer elementCount = null;

    @Override
    public void setParent(Tag parent) {
        super.setParent(parent);
        Tag bpParent = parent;
        while (bpParent != null && !(bpParent instanceof BeanPropertyTag)) {
            bpParent = bpParent.getParent();
        }
        if (bpParent != null && bpParent instanceof BeanPropertyTag) {
            this.beanProperty = ((BeanPropertyTag)bpParent).getBeanProperty();
        }
    }

    public void printTag() throws JspException {
        this.printTag(this.beanProvider);
    }

    public void printTag(BeanProvider beanProvider) throws JspException {
        JspWriter ow = this.pageContext.getOut();
        try {
            EditableURI relatedUri = new EditableURI(this.href);
            String p = this.beanProperty.getName();
            ExtBeanInfo beanInfo = beanProvider.getBeanInfo();
            PropertyDescriptor pd = this.beanProperty.getPropertyDescriptor();
            Method rm = pd.getReadMethod();
            Object value = this.beanProperty.getValue();
            PropertyDescriptor idPd = beanInfo.getIdPropertyDescriptor();
            boolean isId = pd != null && pd.equals(idPd);
            boolean bl = this.readonly = this.beanProperty.isReadOnly() || isId;
            if (!this.readonly) {
                ServletRequest sr = this.pageContext.getRequest();
                if (sr instanceof HttpServletRequest) {
                    HttpServletRequest httpSr = (HttpServletRequest)sr;
                    String backURI = httpSr.getServletPath();
                    relatedUri.appendQuery("_action", (Object)backURI);
                }
                String mappedBy = null;
                ManyToMany manyToManyAnno = rm.getAnnotation(ManyToMany.class);
                if (manyToManyAnno != null) {
                    mappedBy = manyToManyAnno.mappedBy();
                } else {
                    OneToMany oneToManyAnno = rm.getAnnotation(OneToMany.class);
                    if (oneToManyAnno != null) {
                        mappedBy = oneToManyAnno.mappedBy();
                    }
                }
                if (mappedBy != null && !mappedBy.equals("")) {
                    relatedUri.appendQuery("_related_mappedby", (Object)mappedBy);
                }
                relatedUri.appendQuery("_related_prop", (Object)p);
                Class<?> persClass = beanProvider.getBeanInfo().getBeanDescriptor().getBeanClass();
                Object idObject = beanProvider.getBeanInfo().getIdValue(beanProvider.getBeanModel().getBean());
                PersistenceObjectIdentifier poi = new PersistenceObjectIdentifier(persClass, idObject);
                relatedUri.appendQueryMap(poi.toQueryMap());
                Class<?> propType = pd.getPropertyType();
                if (Collection.class.isAssignableFrom(propType)) {
                    relatedUri.appendQuery("_cmd", (Object)this.command);
                    int elementCount = 0;
                    if (value != null) {
                        Class collClass;
                        ExtBeanInfo pbi;
                        PropertyDescriptor idDescr;
                        ParameterizedType prt;
                        Type[] pts;
                        elementCount = ((Collection)value).size();
                        this.elementCount = elementCount;
                        Type rt = rm.getGenericReturnType();
                        boolean paramterized = rt instanceof ParameterizedType;
                        if (elementCount > 0 && paramterized && (pts = (prt = (ParameterizedType)rt).getActualTypeArguments()).length == 1 && (idDescr = (pbi = PersistenceIntrospector.getPersistenceBeanInfo(collClass = (Class)pts[0], true)).getIdPropertyDescriptor()) != null) {
                            String idPropName = idDescr.getName();
                            Collection valueAsColl = (Collection)value;
                            Method deepIdReadMethod = idDescr.getReadMethod();
                            for (Object so : valueAsColl) {
                                Object object = deepIdReadMethod.invoke(so, new Object[0]);
                            }
                        }
                    }
                } else {
                    ExtBeanInfo relatedBi;
                    PropertyDescriptor relatedIdPd;
                    relatedUri.appendQuery("_cmd", (Object)this.command);
                    if (value != null && (relatedIdPd = (relatedBi = PersistenceIntrospector.getPersistenceBeanInfo(propType, true)).getIdPropertyDescriptor()) != null) {
                        String relatedIdPropName = relatedIdPd.getName();
                        Method relatedIdReadMethod = relatedIdPd.getReadMethod();
                        Object relatedIdvalue = relatedIdReadMethod.invoke(value, new Object[0]);
                        relatedUri.appendQuery("_sel_id", relatedIdvalue);
                    }
                }
                ow.print("<a href=\"" + this.encodeURL(relatedUri.getUri()) + "\">");
            }
        }
        catch (Exception e) {
            throw new JspException("Could not print bean property !", (Throwable)e);
        }
    }

    @Override
    public int doStartTag() throws JspException {
        Tag p = this.getParent();
        this.elementCount = null;
        ExtBeanInfo beanInfo = this.beanProvider.getBeanInfo();
        String currProp = this.beanProvider.getCurrentProperty();
        if (currProp != null && !currProp.equals(this.beanProperty.getName())) {
            return 0;
        }
        try {
            this.beanProperty.setContext(this.beanProvider);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JspException("Error setting bean context !", (Throwable)e);
        }
        if (beanInfo.getIdPropertyDescriptor().getName().equals(currProp)) {
            this.beanProperty.setReadOnly(true);
        }
        if (!this.beanProperty.isReadOnly()) {
            this.printTag();
        }
        this.hasBody = false;
        return 1;
    }

    public int doAfterBody() {
        this.hasBody = true;
        return 6;
    }

    @Override
    public int doEndTag() throws JspException {
        JspWriter ow = this.pageContext.getOut();
        try {
            if (!this.hasBody) {
                if (this.anchorResourceKey == null) {
                    ow.print("#");
                    if (this.elementCount != null) {
                        ow.print((Object)this.elementCount);
                    }
                } else {
                    ow.print("[" + this.getLocalizedMessage(this.anchorResourceKey) + "]");
                }
            }
            if (!this.readonly) {
                ow.println("</a>");
            }
        }
        catch (Exception e) {
            throw new JspException("Could not print bean property !", (Throwable)e);
        }
        return 6;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }
}

