/*
 * Decompiled with CFR 0.152.
 */
package ipsk.persistence;

import ipsk.awt.ProgressWorker;
import ipsk.awt.WorkerException;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;

public abstract class EntityManagerWorker
extends ProgressWorker {
    private EntityManagerFactory entityManagerFactory;
    protected volatile EntityManager entityManager;

    public EntityManagerWorker(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManagerWorker(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block38: {
            EntityTransaction tx;
            this.progressStatus.running();
            if (this.entityManagerFactory != null) {
                this.entityManager = this.entityManagerFactory.createEntityManager();
            }
            if ((tx = this.entityManager.getTransaction()) != null && !tx.isActive()) {
                tx.begin();
            }
            try {
                try {
                    this.doWork();
                    ProgressStatus progressStatus = this.progressStatus;
                    synchronized (progressStatus) {
                        if (this.progressStatus.hasCancelRequest()) {
                            this.rollback(this.entityManager);
                        } else {
                            try {
                                this.commit(this.entityManager);
                            }
                            catch (WorkerException e) {
                                this.rollback(this.entityManager);
                                this.progressStatus.error(new LocalizableMessage(e.getMessage()));
                            }
                        }
                    }
                }
                catch (WorkerException e) {
                    this.rollback(this.entityManager);
                    this.progressStatus.error(new LocalizableMessage(e.getMessage()));
                    try {
                        this.closeEntityManager(this.entityManager);
                    }
                    catch (WorkerException e2) {
                        e2.printStackTrace();
                        this.progressStatus.error(new LocalizableMessage(e2.getMessage()));
                    }
                    ProgressStatus e2 = this.progressStatus;
                    synchronized (e2) {
                        if (this.progressStatus.hasCancelRequest()) {
                            this.progressStatus.canceled();
                        } else if (!this.progressStatus.isError()) {
                            this.progressStatus.done();
                        }
                    }
                    this.fireProgressEvent();
                    break block38;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.closeEntityManager(this.entityManager);
                }
                catch (WorkerException e) {
                    e.printStackTrace();
                    this.progressStatus.error(new LocalizableMessage(e.getMessage()));
                }
                ProgressStatus e = this.progressStatus;
                synchronized (e) {
                    if (this.progressStatus.hasCancelRequest()) {
                        this.progressStatus.canceled();
                    } else if (!this.progressStatus.isError()) {
                        this.progressStatus.done();
                    }
                }
                this.fireProgressEvent();
                throw throwable;
            }
            try {
                this.closeEntityManager(this.entityManager);
            }
            catch (WorkerException e) {
                e.printStackTrace();
                this.progressStatus.error(new LocalizableMessage(e.getMessage()));
            }
            ProgressStatus progressStatus = this.progressStatus;
            synchronized (progressStatus) {
                if (this.progressStatus.hasCancelRequest()) {
                    this.progressStatus.canceled();
                } else if (!this.progressStatus.isError()) {
                    this.progressStatus.done();
                }
            }
            this.fireProgressEvent();
        }
    }

    private void commit(EntityManager em) throws WorkerException {
        if (em != null && em.isOpen()) {
            EntityTransaction tx = null;
            try {
                tx = em.getTransaction();
                if (tx != null && tx.isActive()) {
                    tx.commit();
                }
            }
            catch (PersistenceException e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new WorkerException((Throwable)e);
            }
            catch (IllegalStateException ise) {
                ise.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new WorkerException((Throwable)ise);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new WorkerException((Throwable)e);
            }
        }
    }

    private void closeEntityManager(EntityManager em) throws WorkerException {
        try {
            this.commit(em);
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
        if (em != null && em.isOpen()) {
            em.close();
        }
    }

    private void rollback(EntityManager em) {
        if (em != null) {
            EntityTransaction tx = null;
            tx = em.getTransaction();
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

