/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps.filter;

import ipsk.text.StringTokenizer;
import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MaintenanceSwitch
implements Filter {
    public static String MAINTENANCE_WELCOME_FILE_PARAM_NAME = "maintenanceWelcomeFile";
    public static String WELCOME_FILES_PARAM_NAME = "regularWelcomeFiles";
    public static String MAINTENANCE_CONTENT_FILES_PARAM_NAME = "maintenanceContentFiles";
    public static String MAINTENANCE_ATTR_KEY = MaintenanceSwitch.class.getName();
    private FilterConfig filterConfig;
    private Date maintenanceEnd;
    String maintenanceIndexFile;
    private String[] welcomeFiles;
    private String[] maintenanceContentFileLists;
    private String maintenanceWelcomeFile;

    private void sendServiceUnavailable(HttpServletResponse httpRes) throws IOException {
        if (this.maintenanceEnd != null) {
            long maintenanceTime = this.maintenanceEnd.getTime();
            httpRes.addDateHeader("Retry-After", maintenanceTime += 600000L);
        }
        httpRes.sendError(503, "Sorry we are in maintenance mode");
    }

    private void sendMaintenaceRedirect(HttpServletRequest httpReq, HttpServletResponse httpRes) throws IOException, ServletException {
        String contextpath = httpReq.getContextPath();
        RequestDispatcher rDis = httpReq.getRequestDispatcher(this.maintenanceWelcomeFile);
        rDis.forward((ServletRequest)httpReq, (ServletResponse)httpRes);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Object maintAttr = this.filterConfig.getServletContext().getAttribute(MAINTENANCE_ATTR_KEY);
        if (maintAttr != null) {
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                int n;
                int n2;
                String[] stringArray;
                HttpServletRequest httpReq = (HttpServletRequest)request;
                HttpServletResponse httpRes = (HttpServletResponse)response;
                String servletPath = httpReq.getServletPath();
                if (this.maintenanceContentFileLists != null) {
                    stringArray = this.maintenanceContentFileLists;
                    n2 = this.maintenanceContentFileLists.length;
                    n = 0;
                    while (n < n2) {
                        String contentFile = stringArray[n];
                        if (servletPath.equals(contentFile)) {
                            filterChain.doFilter(request, response);
                            return;
                        }
                        ++n;
                    }
                }
                if (this.maintenanceWelcomeFile != null && this.maintenanceWelcomeFile.equals(servletPath)) {
                    filterChain.doFilter(request, response);
                    return;
                }
                if (this.welcomeFiles != null) {
                    stringArray = this.welcomeFiles;
                    n2 = this.welcomeFiles.length;
                    n = 0;
                    while (n < n2) {
                        String welcomeFile = stringArray[n];
                        if (welcomeFile.equals(servletPath) && this.maintenanceWelcomeFile != null) {
                            this.sendMaintenaceRedirect(httpReq, httpRes);
                            return;
                        }
                        ++n;
                    }
                }
                if (servletPath.equals("/") || servletPath.equals("")) {
                    this.sendMaintenaceRedirect(httpReq, httpRes);
                    return;
                }
                this.sendServiceUnavailable(httpRes);
                return;
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String welcomeFilesParam = filterConfig.getInitParameter(WELCOME_FILES_PARAM_NAME);
        this.welcomeFiles = StringTokenizer.split((String)welcomeFilesParam, (char)',', (boolean)true);
        String maintenanceContentFilesParam = filterConfig.getInitParameter(MAINTENANCE_CONTENT_FILES_PARAM_NAME);
        this.maintenanceContentFileLists = StringTokenizer.split((String)maintenanceContentFilesParam, (char)',', (boolean)true);
        String maintenaceWelcomeFileParam = filterConfig.getInitParameter(MAINTENANCE_WELCOME_FILE_PARAM_NAME);
        if (maintenaceWelcomeFileParam != null) {
            this.maintenanceWelcomeFile = maintenaceWelcomeFileParam.trim();
        }
    }

    public void destroy() {
    }
}

