/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.beans;

import ips.beans.ExtBeanInfo;
import ipsk.beans.BeanModel;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.form.FormConfiguration;
import ipsk.beans.form.PropertyConfiguration;
import ipsk.beans.validation.Input;
import ipsk.beans.validation.ValidationResult;
import ipsk.jsp.taglib.beans.BeanPropertyIterator;
import ipsk.jsp.taglib.beans.BeanProvider;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;

public class BeanProperty {
    protected BeanModel<?> beanModel = null;
    protected Object value = null;
    protected String var = null;
    protected String name;
    protected String bundle;
    protected String key;
    private Method readmethod;
    private ResourceKey resourceKey;
    private String resourceBundleName;
    protected PropertyDescriptor propertyDescriptor;
    protected BeanProvider beanProvider;
    protected boolean readOnly = false;
    protected boolean required = false;
    protected String action = null;
    protected boolean valid = true;
    private PropertyConfiguration configuration;

    public boolean isRequired() {
        return this.required;
    }

    public PropertyConfiguration getConfiguration() {
        return this.configuration;
    }

    public BeanProperty() {
        this(null, null, null);
    }

    public BeanProperty(String name) {
        this(name, null, null);
    }

    public BeanProperty(String name, String bundle, String key) {
        this.name = name;
        this.bundle = bundle;
        this.key = key;
    }

    public BeanProperty(PropertyDescriptor pd) {
        this.propertyDescriptor = pd;
        this.name = this.propertyDescriptor.getName();
        this.bundle = null;
        this.key = null;
    }

    public void setContext(BeanPropertyIterator beanProvider) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String[] addProps;
        this.beanProvider = beanProvider;
        ExtBeanInfo beanInfo = beanProvider.getBeanInfo();
        if (this.name == null) {
            this.name = beanProvider.getCurrentProperty();
        }
        this.beanModel = beanProvider.getBeanModel();
        this.configuration = null;
        FormConfiguration formConfiguration = beanProvider.getFormConfiguration();
        if (formConfiguration != null) {
            this.required = false;
            List propCfgs = formConfiguration.getPropertyConfigurations();
            for (PropertyConfiguration pCfg : propCfgs) {
                if (!this.name.equals(pCfg.getPropertyDescriptor().getName())) continue;
                this.required = pCfg.isRequired();
                this.configuration = pCfg;
                break;
            }
        }
        boolean match = false;
        PropertyDescriptor pd = null;
        String propertyName = this.name;
        int sepIndex = this.name.indexOf(".");
        if (sepIndex != -1) {
            propertyName = this.name.substring(sepIndex + 1);
        }
        if ((addProps = beanProvider.getAdditionalPropertyNames()) != null) {
            for (String addProp : addProps) {
                if (!propertyName.equals(addProp)) continue;
                match = true;
                this.setPropertyDescriptor(null);
            }
        }
        if (!match && (pd = beanInfo.getPersistencePropertyDescriptor(propertyName)) != null) {
            this.setPropertyDescriptor(pd);
            if (beanInfo.isIdGenerated() && beanInfo.getIdPropertyDescriptor().equals(pd)) {
                this.setReadOnly(true);
            }
            match = true;
            this.readmethod = pd.getReadMethod();
            this.resourceKey = this.readmethod.getAnnotation(ResourceKey.class);
        }
        if (!match) {
            PropertyDescriptor[] pojoPds;
            for (PropertyDescriptor pojoPd : pojoPds = beanInfo.getPropertyDescriptors()) {
                String pojoPdNm = pojoPd.getName();
                if (!propertyName.equals(pojoPdNm)) continue;
                pd = pojoPd;
                this.setPropertyDescriptor(pd);
                match = true;
                this.readmethod = pd.getReadMethod();
                this.resourceKey = this.readmethod.getAnnotation(ResourceKey.class);
                break;
            }
        }
        if (!match) {
            throw new IllegalArgumentException("Unknown bean property: " + propertyName);
        }
        this.resourceBundleName = beanInfo.getResourceBundleName();
        if (this.readmethod != null) {
            Input inputA;
            ResourceBundleName resBundleAnno = this.readmethod.getAnnotation(ResourceBundleName.class);
            if (resBundleAnno != null) {
                this.resourceBundleName = resBundleAnno.value();
            }
            if ((inputA = this.readmethod.getAnnotation(Input.class)) != null) {
                this.required = this.required || inputA.required();
            }
        }
        Object bean = null;
        if (this.beanModel != null) {
            bean = this.beanModel.getBean();
        }
        if (bean == null) {
            this.setValue(null);
        } else if (this.readmethod != null) {
            Object value = this.readmethod.invoke(bean, new Object[0]);
            this.setValue(value);
        }
        if (this.var != null) {
            beanProvider.getPageContext().setAttribute(this.var, this.value, 2);
        }
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getName() {
        return this.name;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getDescriptor() {
        String descr = null;
        descr = this.resourceBundleName != null && this.resourceKey != null && this.beanProvider != null ? LocaleSupport.getLocalizedMessage((PageContext)this.beanProvider.getPageContext(), (String)this.resourceKey.value(), (String)this.resourceBundleName) : this.propertyDescriptor.getShortDescription();
        return descr;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public BeanModel getBeanModel() {
        return this.beanModel;
    }

    public void setBeanModel(BeanModel beanModel) {
        this.beanModel = beanModel;
    }

    public PropertyValidationResult getValidationResult() {
        ValidationResult vr;
        if (this.beanModel != null && (vr = this.beanModel.getValidationResult()) != null) {
            return vr.getPropertyValidationResult(this.name);
        }
        return null;
    }

    public BeanProvider getBeanProvider() {
        return this.beanProvider;
    }
}

