/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps;

import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.webapps.ControllerException;
import ipsk.webapps.actionmap.ActionLink;
import ipsk.webapps.actionmap.ActionMap;
import ipsk.webapps.actionmap.Controller;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;

public class ControllerMapper
implements Filter {
    public static final String DEFAULT_MAP_NAME = "ips_webutils_action_map.xml";
    private ActionMap actionMap;
    private HashMap<String, Controller> map = new HashMap();
    private FilterConfig filterConfig = null;

    public void destroy() {
    }

    public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain arg2) throws IOException, ServletException {
        if (arg0 instanceof HttpServletRequest) {
            String servletPath;
            HttpServletRequest httpReq = (HttpServletRequest)arg0;
            String pathInfo = httpReq.getPathInfo();
            if (pathInfo != null) {
                System.out.println("Path info " + pathInfo);
            }
            if ((servletPath = httpReq.getServletPath()) != null) {
                String ctrlClassName;
                System.out.println(servletPath);
                Controller ct = this.map.get(servletPath);
                if (ct != null && (ctrlClassName = ct.getClassname()) != null) {
                    Controller.Scope ctScope;
                    Object ctrlO = null;
                    HttpSession httpSession = null;
                    String ctVar = ct.getVar();
                    if (ctVar != null) {
                        ctScope = ct.getScope();
                        if (ctScope.equals((Object)Controller.Scope.SESSION)) {
                            httpSession = httpReq.getSession(true);
                            if (httpSession != null) {
                                ctrlO = httpSession.getAttribute(ctVar);
                            }
                        } else if (ctScope.equals((Object)Controller.Scope.REQUEST)) {
                            ctrlO = arg0.getAttribute(ctVar);
                        } else if (ctScope.equals((Object)Controller.Scope.APPLICATION)) {
                            ctrlO = this.filterConfig.getServletContext().getAttribute(ctVar);
                        }
                    }
                    if (ctrlO == null) {
                        try {
                            ctrlO = Beans.instantiate(this.getClass().getClassLoader(), ctrlClassName);
                        }
                        catch (ClassNotFoundException e) {
                            throw new ServletException((Throwable)e);
                        }
                        if (ctVar != null) {
                            ctScope = ct.getScope();
                            if (ctScope.equals((Object)Controller.Scope.SESSION)) {
                                if (httpSession != null) {
                                    httpSession.setAttribute(ctVar, ctrlO);
                                }
                            } else if (ctScope.equals((Object)Controller.Scope.REQUEST)) {
                                arg0.setAttribute(ctVar, ctrlO);
                            } else if (ctScope.equals((Object)Controller.Scope.APPLICATION)) {
                                this.filterConfig.getServletContext().setAttribute(ctVar, ctrlO);
                            }
                        }
                    }
                    if (ctrlO instanceof ipsk.jsp.Controller) {
                        ipsk.jsp.Controller ctrl = (ipsk.jsp.Controller)ctrlO;
                        ctrl.open();
                        try {
                            ctrl.processRequest(httpReq);
                        }
                        catch (ControllerException e) {
                            ctrl.rollback();
                            e.printStackTrace();
                            throw new ServletException((Throwable)e);
                        }
                        RequestDispatcher rd = httpReq.getRequestDispatcher(servletPath);
                        try {
                            rd.forward(arg0, arg1);
                        }
                        catch (ServletException se) {
                            throw se;
                        }
                        catch (IOException ioe) {
                            throw ioe;
                        }
                        finally {
                            ctrl.close();
                        }
                    }
                }
            }
        }
        if (arg2 != null) {
            arg2.doFilter(arg0, arg1);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
        this.filterConfig = arg0;
        InputStream is = arg0.getServletContext().getResourceAsStream(DEFAULT_MAP_NAME);
        InputStreamReader mr = new InputStreamReader(is);
        try {
            DOMConverter dc = new DOMConverter();
            Document md = dc.readXML((Reader)mr);
            DOMCodec cod = new DOMCodec(ActionLink.class.getPackage());
            this.actionMap = (ActionMap)cod.readDocument(md);
        }
        catch (DOMConverterException e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        catch (DOMCodecException e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        ActionLink[] als = this.actionMap.getActionLink();
        if (als != null) {
            for (ActionLink al : als) {
                this.map.put(al.getUrl(), al.getController());
            }
        }
    }
}

