/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps;

import ipsk.persistence.Controller;
import ipsk.persistence.SecurityManager;
import ipsk.webapps.ControllerException;
import ipsk.webapps.EntityManagerFactoryInitializer;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;

public class BasicPersistenceController
implements Controller {
    public static final boolean USE_FULL_QUALIFIED_CLASSNAMES_IN_QUERY = false;
    private EntityManagerThreadLocal emtl;
    protected SecurityManager securityManager = new SecurityManager();

    public BasicPersistenceController(String persistenceUnit) {
        this.emtl = new EntityManagerThreadLocal();
    }

    @Override
    public void open() {
        EntityManager em = this.getThreadEntityManager();
        EntityTransaction tx = em.getTransaction();
        if (tx != null && !tx.isActive()) {
            tx.begin();
        }
    }

    public EntityManager getEntityManager() {
        return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
    }

    public EntityManager getThreadEntityManager() {
        if (this.emtl == null) {
            this.emtl = new EntityManagerThreadLocal();
        }
        return (EntityManager)this.emtl.get();
    }

    @Override
    public void rollback() {
        EntityManager em = this.getThreadEntityManager();
        if (em != null) {
            EntityTransaction tx = null;
            tx = em.getTransaction();
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    @Override
    public void commit() throws ControllerException {
        EntityManager em = this.getThreadEntityManager();
        if (em != null) {
            EntityTransaction tx = null;
            try {
                tx = em.getTransaction();
                if (tx != null && tx.isActive()) {
                    tx.commit();
                }
            }
            catch (PersistenceException e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new ControllerException(e);
            }
            catch (IllegalStateException ise) {
                ise.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new ControllerException(ise);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new ControllerException(e);
            }
        }
    }

    @Override
    public synchronized void close() {
        EntityManager em = this.getThreadEntityManager();
        try {
            this.commit();
        }
        catch (ControllerException e) {
            e.printStackTrace();
        }
        if (em != null) {
            em.close();
        }
        if (this.emtl != null) {
            this.emtl.remove();
        }
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public class EntityManagerThreadLocal
    extends ThreadLocal<EntityManager> {
        @Override
        protected synchronized EntityManager initialValue() {
            return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
        }
    }
}

