/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.beans.table;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.beans.PropertyNameOrder;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.BeanTableModel;
import ipsk.jsp.Controller;
import ipsk.jsp.taglib.ControllerProvider;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanControllerProvider;
import ipsk.jsp.taglib.beans.BeanProperty;
import ipsk.jsp.taglib.beans.table.BeanPropertyTableCol;
import ipsk.jsp.taglib.beans.table.BeanTableCol;
import ipsk.jsp.taglib.beans.table.BeanTableRowAction;
import ipsk.net.EditableURI;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.util.ResourceKey;
import ipsk.webapps.ControllerException;
import ipsk.webapps.SelectMode;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.Tag;

public class BeanTableTag
extends ExtBodyTagSupport
implements BeanControllerProvider {
    public static final String KEY_ENUM_VALUE = "_enum_value";
    private String additionalCols = null;
    private String defColOrder = null;
    private String[] defOrder = null;
    private String beanVar;
    private ArrayList<BeanTableRowAction> rowActions = new ArrayList();
    private Hashtable<String, BeanTableCol> colTags = new Hashtable();
    protected PropertyDescriptor idPropertyDescriptor = null;
    protected boolean isEnum = false;
    private String tableClass = null;
    private BeanTableController controller;
    private BeanTableModel beanTableModel;
    private List<String> displayColumnNames;
    private int currentRow = -1;
    private int currentColPropertyIndex = -1;
    protected String currentProperty = null;
    protected boolean currentPropertyDone = false;
    private String resourceBundleName = null;
    private boolean selectionColumnDone = false;
    private List items = null;
    private Object item = null;
    private Object idVal = null;
    private RowStatus rowStatus;
    private ColStatus colStatus = ColStatus.SELECT;
    private boolean bodyProcessed = false;
    private Vector<Object> selectedIdsToDisplay = null;
    private boolean rowSelected = false;
    private String tdEmphasizeBegin = "";
    private String tdEmphasizeEnd = "";
    private String trEmphasizeClass = null;
    private String trEmphasizeClassAttribute = "";
    private String[] additionalColsArr = null;
    private ExtBeanInfo beanInfo;

    public String[] getAdditionalColsArr() {
        return this.additionalColsArr;
    }

    public String getColHeader(String colName) {
        BeanPropertyTableCol bptc;
        BeanProperty bp;
        PropertyDescriptor pd;
        ExtBeanInfo beanInfo = this.beanTableModel.getExtBeanInfo();
        String resBundleName = beanInfo.getResourceBundleName();
        BeanTableCol btc = this.colTags.get(colName);
        String header = btc.getName();
        String bundle = btc.getBundle();
        String headerKey = btc.getKey();
        if (bundle != null && headerKey != null) {
            header = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)headerKey, (String)bundle);
        } else if (headerKey != null) {
            header = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)headerKey);
        } else if (btc instanceof BeanPropertyTableCol && (pd = (bp = (bptc = (BeanPropertyTableCol)btc).getBeanProperty()).getPropertyDescriptor()) != null) {
            String rk = (String)pd.getValue(ResourceKey.class.getName());
            header = resBundleName != null && rk != null ? LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)rk, (String)resBundleName) : pd.getShortDescription();
        }
        return header;
    }

    private void printHeader(JspWriter ow) throws IOException {
        SelectMode selectMode = this.beanTableModel.getSelectMode();
        ow.print("<tr>");
        if (selectMode != null) {
            ow.print("<th>" + this.getLocalizedMessage("select") + "</th>");
        }
        for (String p : this.displayColumnNames) {
            String header = this.getColHeader(p);
            ow.print("<th>" + HTMLTextEncoder.encode((String)header) + "</th>");
        }
        if (selectMode == null && this.rowActions.size() > 0) {
            ow.print("<th>" + this.getLocalizedMessage("action") + "</th>");
        }
        ow.println("</tr>");
    }

    public void setParent(Tag parent) {
        PropertyDescriptor[] pds;
        this.colTags.clear();
        super.setParent(parent);
        if (parent instanceof ControllerProvider) {
            Controller scontroller = ((ControllerProvider)parent).getController();
            if (scontroller instanceof BeanTableController) {
                this.controller = (BeanTableController)scontroller;
            }
            try {
                this.beanTableModel = this.controller.getBeanTableModel((HttpServletRequest)this.pageContext.getRequest());
            }
            catch (ControllerException e) {
                e.printStackTrace();
            }
        }
        this.beanInfo = this.beanTableModel.getExtBeanInfo();
        for (PropertyDescriptor pd : pds = this.beanInfo.getPersistencePropertyDescriptors()) {
            String pName;
            Method rm = pd.getReadMethod();
            if (rm.getAnnotation(Id.class) != null || rm.getAnnotation(EmbeddedId.class) != null) {
                this.idPropertyDescriptor = pd;
            }
            if (this.colTags.containsKey(pName = pd.getName())) continue;
            BeanPropertyTableCol btct = new BeanPropertyTableCol(pd, this.beanInfo);
            this.colTags.put(pName, btct);
        }
        if (this.idPropertyDescriptor == null && this.beanInfo.getBeanDescriptor().getBeanClass().isEnum()) {
            this.isEnum = true;
        }
    }

    @Override
    public int doStartTag() throws JspException {
        this.bodyProcessed = false;
        this.items = null;
        this.rowActions.clear();
        PropertyDescriptor[] pds = this.beanInfo.getPersistencePropertyDescriptors();
        if (this.additionalColsArr != null) {
            this.controller.setAdditionalColumns(this.additionalColsArr);
        }
        this.displayColumnNames = this.controller.getDisplayColumns();
        if (this.displayColumnNames == null) {
            PropertyNameOrder propertyOrder = new PropertyNameOrder(this.colTags.keySet());
            propertyOrder.applyPreferredOrder(this.beanInfo.getPreferredDisplayOrder());
            propertyOrder.applyPreferredOrder(this.defOrder);
            String[] displayedPropertiesStr = propertyOrder.getOrder();
            this.displayColumnNames = new ArrayList<String>();
            block0: for (String s : displayedPropertiesStr) {
                boolean added = false;
                if (this.additionalColsArr != null) {
                    for (String addCol : this.additionalColsArr) {
                        if (!s.equals(addCol)) continue;
                        this.displayColumnNames.add(s);
                        added = true;
                        break;
                    }
                }
                if (added) continue;
                for (PropertyDescriptor pd : pds) {
                    if (!s.equals(pd.getName())) continue;
                    this.displayColumnNames.add(s);
                    continue block0;
                }
            }
            this.displayColumnNames.removeAll(this.beanInfo.getHiddenProperties());
            this.controller.setDisplayColumns(this.displayColumnNames);
        }
        this.rowStatus = RowStatus.TAGS;
        if (this.beanTableModel.getSelectMode() != null) {
            Object[] allSelIds = this.beanTableModel.getSelectedIds();
            if (allSelIds != null) {
                this.selectedIdsToDisplay = new Vector();
                this.selectedIdsToDisplay.addAll(Arrays.asList(allSelIds));
            } else {
                this.selectedIdsToDisplay = null;
            }
        }
        return 1;
    }

    private void printTableStartTags() throws IOException {
        SelectMode selectMode;
        JspWriter ow = this.pageContext.getOut();
        Object cssClassAttr = "";
        if (this.tableClass != null) {
            cssClassAttr = " class=\"" + this.tableClass + "\"";
        }
        if ((selectMode = this.beanTableModel.getSelectMode()) != null) {
            if (selectMode.isMultiSelection()) {
                String saopStr = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"select.all.on_page", (String)"ipsk.jsp.Messages");
                ow.println("<form><input type=\"checkbox\" name=\"_select_all\" value=\"select-all\" onchange=\"ips_selectAllToggle(this,'beanTableForm');\">" + saopStr + "</input></form>");
            }
            ow.println("<form id= \"beanTableForm\" method=\"post\" action=\"" + this.encodeURL(selectMode.getAction()) + "\" accept-charset=\"UTF-8\" enctype=\"application/x-www-form-urlencoded;charset=utf-8\">");
        }
        ow.println("<table" + (String)cssClassAttr + ">");
    }

    public int doAfterBody() throws JspException {
        JspWriter ow = this.pageContext.getOut();
        SelectMode selectMode = this.beanTableModel.getSelectMode();
        if (this.rowStatus == RowStatus.TAGS) {
            this.rowStatus = RowStatus.CUSTOMIZER;
            this.idVal = null;
        } else if (this.rowStatus == RowStatus.CUSTOMIZER) {
            try {
                this.printTableStartTags();
            }
            catch (IOException e) {
                throw new JspException("Error: IOException while writing table customizers");
            }
            this.rowStatus = RowStatus.HEADER;
        } else {
            if (this.rowStatus == RowStatus.HEADER) {
                try {
                    this.printHeader(ow);
                }
                catch (IOException e) {
                    throw new JspException();
                }
                finally {
                    this.rowStatus = RowStatus.DATA;
                    this.colStatus = ColStatus.SELECT;
                }
            }
            if (this.rowStatus == RowStatus.DATA) {
                if (this.colStatus == ColStatus.SELECT) {
                    if (this.items == null) {
                        this.items = this.beanTableModel.getItems();
                        this.currentRow = -1;
                    }
                    ++this.currentRow;
                    if (this.currentRow >= this.items.size()) {
                        this.bodyProcessed = true;
                        return 0;
                    }
                    if (this.currentRow < this.items.size()) {
                        this.item = this.items.get(this.currentRow);
                        if (this.beanVar != null) {
                            this.pageContext.setAttribute(this.beanVar, this.item, 2);
                        }
                        if (this.idPropertyDescriptor != null) {
                            Method idRm = this.idPropertyDescriptor.getReadMethod();
                            try {
                                this.idVal = idRm.invoke(this.item, new Object[0]);
                            }
                            catch (Exception e) {
                                throw new JspException("Could not read id (primary key): ", (Throwable)e);
                            }
                            Object[] selRowsIds = this.beanTableModel.getSelectedRowsIds();
                            this.rowSelected = false;
                            this.tdEmphasizeBegin = "";
                            this.tdEmphasizeEnd = "";
                            this.trEmphasizeClassAttribute = "";
                            if (selRowsIds != null) {
                                for (Object selRowsId : selRowsIds) {
                                    if (!selRowsId.equals(this.idVal)) continue;
                                    this.rowSelected = true;
                                    if (this.trEmphasizeClass != null) {
                                        this.trEmphasizeClassAttribute = " class=\"" + this.trEmphasizeClass + "\" ";
                                        continue;
                                    }
                                    this.tdEmphasizeBegin = "<em>";
                                    this.tdEmphasizeEnd = "</em>";
                                }
                            }
                        } else if (this.isEnum) {
                            this.idVal = this.item;
                        }
                    }
                    try {
                        ow.print("<tr" + this.trEmphasizeClassAttribute + ">");
                        if (selectMode != null) {
                            String selStr = "";
                            if (this.selectedIdsToDisplay != null) {
                                for (Object sId : this.selectedIdsToDisplay) {
                                    if (!sId.equals(this.idVal)) continue;
                                    selStr = " checked";
                                    this.selectedIdsToDisplay.remove(sId);
                                    break;
                                }
                            }
                            String type = "radio";
                            ow.print("<td>");
                            String selectName = null;
                            String selectValue = null;
                            if (this.idPropertyDescriptor != null) {
                                selectName = this.idPropertyDescriptor.getName();
                                selectValue = this.idVal.toString();
                            } else if (this.beanInfo.getBeanDescriptor().getBeanClass().isEnum()) {
                                selectName = KEY_ENUM_VALUE;
                                selectValue = ((Enum)this.idVal).name();
                            }
                            if (selectMode.isMultiSelection()) {
                                type = "checkbox";
                            }
                            ow.print("<input type=\"" + type + "\" name=\"" + selectMode.getTargetProperty() + "." + selectName + "\" value=\"" + HTMLTextEncoder.encode((String)selectValue) + "\"" + selStr + "></td>");
                        }
                    }
                    catch (IOException ioe) {
                        throw new JspException("Error: IOException while writing row data ");
                    }
                    this.colStatus = ColStatus.DATA;
                    this.currentProperty = null;
                    this.currentColPropertyIndex = -1;
                } else if (this.colStatus == ColStatus.DATA) {
                    ++this.currentColPropertyIndex;
                    if (this.currentColPropertyIndex < this.displayColumnNames.size()) {
                        BeanPropertyTableCol bptc;
                        this.currentProperty = this.displayColumnNames.get(this.currentColPropertyIndex);
                        BeanTableCol btc = this.colTags.get(this.currentProperty);
                        if (btc instanceof BeanPropertyTableCol && (bptc = (BeanPropertyTableCol)btc).getVar() == null) {
                            bptc.printTag(this.pageContext, this.item);
                        }
                    } else {
                        this.currentProperty = null;
                        this.colStatus = ColStatus.ACTION;
                    }
                } else if (this.colStatus == ColStatus.ACTION) {
                    try {
                        if (selectMode == null) {
                            boolean modifyable = true;
                            boolean removable = true;
                            try {
                                modifyable = this.controller.modifyable(this.item);
                                removable = this.controller.removable(this.item);
                            }
                            catch (ControllerException e1) {
                                throw new JspException((Throwable)e1);
                            }
                            String actionsStr = "";
                            for (BeanTableRowAction action : this.rowActions) {
                                String actionBodyStr;
                                boolean actionEnabled = true;
                                if (action.isRemoving()) {
                                    actionEnabled = removable;
                                } else if (action.isModifying()) {
                                    actionEnabled = modifyable;
                                }
                                String href = null;
                                if (actionEnabled) {
                                    String hrefUrl = action.getHrefURL();
                                    String baseHref = action.getHref();
                                    if (hrefUrl != null) {
                                        href = hrefUrl;
                                    } else if (baseHref != null) {
                                        EditableURI eUri = new EditableURI(this.encodeURL(baseHref));
                                        if (this.idVal != null && this.idPropertyDescriptor != null) {
                                            if (this.beanInfo.isIdEmbedded()) {
                                                PropertyDescriptor[] embPds;
                                                for (PropertyDescriptor embPd : embPds = this.beanInfo.getEmbeddedIdBeanInfo().getPropertyDescriptors()) {
                                                    Object embVal;
                                                    if (embPd.getName().equals("class")) continue;
                                                    Method rm = embPd.getReadMethod();
                                                    try {
                                                        embVal = rm.invoke(this.idVal, new Object[0]);
                                                    }
                                                    catch (Exception e) {
                                                        e.printStackTrace();
                                                        throw new JspException("Reflection error");
                                                    }
                                                    eUri.appendQuery(this.idPropertyDescriptor.getName() + "." + embPd.getName(), embVal);
                                                }
                                            } else {
                                                eUri.appendQuery(this.idPropertyDescriptor.getName(), this.idVal);
                                            }
                                        }
                                        String cmd = action.getControllerCommand();
                                        eUri.appendQuery("_cmd", (Object)cmd);
                                        href = eUri.getHTMLEncodedUri();
                                    }
                                }
                                String actionStr = "";
                                if (actionEnabled && href != null) {
                                    actionStr = actionStr.concat("<a href=\"" + href + "\">");
                                }
                                if ((actionBodyStr = action.getBodyContentStr()) != null) {
                                    actionStr = actionStr.concat(actionBodyStr);
                                } else {
                                    String actionResourceBundle = action.getResourceBundle();
                                    String actionResourceKey = action.getResourceKey();
                                    if (actionResourceBundle != null && actionResourceKey != null) {
                                        actionStr = actionStr.concat(HTMLTextEncoder.encode((String)("[" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)actionResourceKey, (String)actionResourceBundle) + "]")));
                                    }
                                }
                                if (actionEnabled && href != null) {
                                    actionStr = actionStr.concat("</a>");
                                }
                                actionsStr = actionsStr.concat(actionStr);
                            }
                            if (!actionsStr.equals("")) {
                                ow.print("<td>" + actionsStr + "</td>");
                            }
                        }
                        ow.println("</tr>");
                    }
                    catch (IOException ioe) {
                        throw new JspException("Error: IOException while writing actions");
                    }
                    finally {
                        this.currentProperty = null;
                        this.colStatus = ColStatus.SELECT;
                    }
                }
            }
        }
        return 2;
    }

    @Override
    public int doEndTag() throws JspException {
        if (!this.bodyProcessed) {
            while (this.doAfterBody() == 2) {
            }
            this.bodyProcessed = true;
        }
        SelectMode selectMode = this.beanTableModel.getSelectMode();
        JspWriter ow = this.pageContext.getOut();
        try {
            ow.println("</table>");
            if (selectMode != null) {
                SelectMode.ActionType selActionType = null;
                selActionType = selectMode.getActionType();
                if (selActionType == SelectMode.ActionType.ADD || selActionType == SelectMode.ActionType.REMOVE || selActionType == SelectMode.ActionType.DELETE || selActionType == SelectMode.ActionType.SET || selActionType == SelectMode.ActionType.RESET) {
                    PersistenceObjectIdentifier poi = this.controller.getRelatedObjectIdentifier();
                    ExtBeanInfo beanInfo = PersistenceIntrospector.getPersistenceBeanInfo(poi.getTargetClass(), true);
                    ow.print("<input type=\"hidden\" name=\"" + beanInfo.getIdPropertyDescriptor().getName() + "\" value=\"" + HTMLTextEncoder.encode((String)poi.getIdObject().toString()) + "\">");
                }
                if (selActionType == SelectMode.ActionType.SET) {
                    ow.print("<input type=\"submit\" name=\"_store_set_related\" value=\"" + this.getLocalizedMessage("select") + "\"/>");
                    ow.print("<input type=\"submit\" name=\"_cancel_store_related\" value=\"" + this.getLocalizedMessage("cancel") + "\"/>");
                } else if (selActionType == SelectMode.ActionType.RESET) {
                    ow.print("<input type=\"submit\" name=\"_store_reset_related\" value=\"" + this.getLocalizedMessage("remove") + "\"/>");
                    ow.print("<input type=\"submit\" name=\"_cancel_store_related\" value=\"" + this.getLocalizedMessage("cancel") + "\"/>");
                } else if (selActionType == SelectMode.ActionType.ADD) {
                    ow.print("<input type=\"submit\" name=\"_store_add_related\" value=\"" + this.getLocalizedMessage("add") + "\"/>");
                    ow.print("<input type=\"submit\" name=\"_cancel_store_related\" value=\"" + this.getLocalizedMessage("cancel") + "\"/>");
                } else if (selActionType == SelectMode.ActionType.REMOVE) {
                    ow.print("<input type=\"submit\" name=\"_store_remove_related\" value=\"" + this.getLocalizedMessage("remove") + "\"/>");
                    ow.print("<input type=\"submit\" name=\"_cancel_store_related\" value=\"" + this.getLocalizedMessage("cancel") + "\"/>");
                } else if (selActionType == SelectMode.ActionType.DELETE) {
                    ow.print("<input type=\"submit\" name=\"_store_delete_related\" value=\"" + this.getLocalizedMessage("delete") + "\"/>");
                    ow.print("<input type=\"submit\" name=\"_cancel_store_related\" value=\"" + this.getLocalizedMessage("cancel") + "\"/>");
                } else if (selActionType == SelectMode.ActionType.CHANGE_SELECTION) {
                    ow.print("<input type=\"submit\" name=\"_list_change_sel\" value=\"" + this.getLocalizedMessage("selection.change") + "\"/>");
                    ow.print("<input type=\"submit\" name=\"_cancel\" value=\"" + this.getLocalizedMessage("cancel") + "\"/>");
                }
                ow.println("<input type=\"reset\" name=\"_cancel\" value=\"" + this.getLocalizedMessage("reset") + "\"/>");
                ow.println("</form>");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new JspException(e.getMessage());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new JspException(e.getMessage());
        }
        return 6;
    }

    public String getTableClass() {
        return this.tableClass;
    }

    public void setTableClass(String sclass) {
        this.tableClass = sclass;
    }

    public String getDefColOrder() {
        return this.defColOrder;
    }

    public void setDefColOrder(String colOrder) {
        this.defColOrder = colOrder;
        StringTokenizer colOrderTokenizer = new StringTokenizer(this.defColOrder, ",");
        int dispPropsCount = colOrderTokenizer.countTokens();
        this.defOrder = new String[dispPropsCount];
        for (int i = 0; i < dispPropsCount; ++i) {
            this.defOrder[i] = colOrderTokenizer.nextToken().trim();
        }
    }

    public void addRowAction(BeanTableRowAction action) {
        this.rowActions.add(action);
    }

    public List<String> getDisplayColumns() {
        return this.displayColumnNames;
    }

    @Override
    public BeanTableController getController() {
        return this.controller;
    }

    @Override
    public ExtBeanInfo getBeanInfo() {
        return this.beanTableModel.getExtBeanInfo();
    }

    public String getCurrentProperty() {
        return this.currentProperty;
    }

    public void setCurrentProperty(String currentProperty) {
        this.currentProperty = currentProperty;
    }

    public RowStatus getRowStatus() {
        return this.rowStatus;
    }

    public void setRowStatus(RowStatus rowStatus) {
        this.rowStatus = rowStatus;
    }

    public Object getItem() {
        return this.item;
    }

    public BeanTableModel getBeanTableModel() {
        return this.beanTableModel;
    }

    public String getTrEmphasizeClass() {
        return this.trEmphasizeClass;
    }

    public void setTrEmphasizeClass(String tdEmphasizeClass) {
        this.trEmphasizeClass = tdEmphasizeClass;
    }

    public BeanTableCol getColumn(String name) {
        return this.colTags.get(name);
    }

    public BeanProperty getBeanProperty(String name) {
        BeanTableCol btc = this.colTags.get(name);
        if (btc instanceof BeanPropertyTableCol) {
            return ((BeanPropertyTableCol)btc).getBeanProperty();
        }
        return null;
    }

    public String getAdditionalCols() {
        return this.additionalCols;
    }

    public void setAdditionalCols(String additionalCols) {
        this.additionalCols = additionalCols;
        StringTokenizer addColsTokenizer = new StringTokenizer(additionalCols, ",");
        int c = addColsTokenizer.countTokens();
        this.additionalColsArr = new String[c];
        for (int i = 0; i < c; ++i) {
            this.additionalColsArr[i] = addColsTokenizer.nextToken().trim();
        }
        if (this.additionalColsArr != null) {
            for (String addColName : this.additionalColsArr) {
                BeanTableCol btct = new BeanTableCol(addColName);
                this.colTags.put(addColName, btct);
            }
        }
    }

    public String getBeanVar() {
        return this.beanVar;
    }

    public void setBeanVar(String beanVar) {
        this.beanVar = beanVar;
    }

    public static enum ColStatus {
        SELECT,
        DATA,
        ACTION;

    }

    public static enum RowStatus {
        TAGS,
        CUSTOMIZER,
        HEADER,
        DATA;

    }
}

