/*
 * Decompiled with CFR 0.152.
 */
package ips.beans;

import ips.beans.ExtBeanInfo;
import ips.beans.ExtBeanInfoImpl;
import ipsk.beans.HiddenProperties;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.Unit;
import ipsk.persistence.Delegate;
import ipsk.persistence.ObjectImmutableIfReferenced;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;

public class PersistenceIntrospector {
    private static Hashtable<Class, ExtBeanInfo> cache = new Hashtable();

    public static ExtBeanInfo getExtendedBeanInfo(Class<?> entityClass) throws IntrospectionException {
        return PersistenceIntrospector.getExtendedBeanInfo(entityClass, true, false);
    }

    public static ExtBeanInfo getPersistenceBeanInfo(Class<?> entityClass) throws IntrospectionException {
        return PersistenceIntrospector.getPersistenceBeanInfo(entityClass, true);
    }

    public static ExtBeanInfo getPersistenceBeanInfo(Class<?> entityClass, boolean searchEntitySuperClass) throws IntrospectionException {
        return PersistenceIntrospector.getExtendedBeanInfo(entityClass, searchEntitySuperClass, true);
    }

    public static ExtBeanInfo getExtendedBeanInfo(Class<?> beanClass, boolean searchEntitySuperClass, boolean acceptPersistenceClassesOnly) throws IntrospectionException {
        PluralResourceKey pluralResKeyClassAnno;
        ResourceKey resKeyClassAnno;
        ExtBeanInfo cachedBi = cache.get(beanClass);
        if (cachedBi != null) {
            return cachedBi;
        }
        Class<?> entityClass = beanClass;
        boolean searchHierarchy = false;
        if (searchEntitySuperClass) {
            Entity entityAnno = entityClass.getAnnotation(Entity.class);
            Embeddable embeddableAnno = entityClass.getAnnotation(Embeddable.class);
            Class<?> eClass = entityClass;
            while (entityAnno == null && embeddableAnno == null) {
                if ((eClass = eClass.getSuperclass()) == null) {
                    if (!acceptPersistenceClassesOnly) break;
                    throw new IntrospectionException("No superclass with Entity annotation found!");
                }
                entityAnno = eClass.getAnnotation(Entity.class);
                embeddableAnno = eClass.getAnnotation(Embeddable.class);
            }
            if (eClass != null) {
                entityClass = eClass;
            }
        }
        BeanInfo bi = null;
        bi = Introspector.getBeanInfo(entityClass);
        ExtBeanInfoImpl impl = new ExtBeanInfoImpl(bi);
        ResourceBundleName resBundleAnno = PersistenceIntrospector.getAnnotationInHierarchy(entityClass, ResourceBundleName.class, searchHierarchy);
        if (resBundleAnno != null) {
            impl.setResourceBundleName(resBundleAnno.value());
        }
        if ((resKeyClassAnno = PersistenceIntrospector.getAnnotationInHierarchy(entityClass, ResourceKey.class, searchHierarchy)) != null) {
            impl.setClassResourceKey(resKeyClassAnno.value());
        }
        if ((pluralResKeyClassAnno = PersistenceIntrospector.getAnnotationInHierarchy(entityClass, PluralResourceKey.class, searchHierarchy)) != null) {
            impl.setClassPluralResourceKey(pluralResKeyClassAnno.value());
        }
        HiddenProperties hiddenPropsAnno = null;
        Class<?> sClass = entityClass;
        do {
            hiddenPropsAnno = sClass.getAnnotation(HiddenProperties.class);
            sClass = sClass.getSuperclass();
        } while (hiddenPropsAnno == null && sClass != null);
        if (hiddenPropsAnno != null) {
            List<String> hiddenProps = Arrays.asList(hiddenPropsAnno.value());
            impl.setHiddenProperties(hiddenProps);
        }
        PreferredDisplayOrder prefDisplayOrderAnno = null;
        sClass = entityClass;
        do {
            prefDisplayOrderAnno = sClass.getAnnotation(PreferredDisplayOrder.class);
            sClass = sClass.getSuperclass();
        } while (prefDisplayOrderAnno == null && sClass != null);
        if (prefDisplayOrderAnno != null) {
            StringTokenizer st = new StringTokenizer(prefDisplayOrderAnno.value(), ",");
            ArrayList tmpList = new ArrayList();
            while (st.hasMoreTokens()) {
                tmpList.add(st.nextToken().trim());
            }
            impl.setPreferredDisplayOrder(tmpList.toArray(new String[0]));
        }
        ArrayList<PropertyDescriptor> persistencePds = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
            Unit unitAnno;
            ResourceKey resKeyAnno;
            Method rm = pd.getReadMethod();
            Delegate delegateAnnot = rm.getAnnotation(Delegate.class);
            if (rm == null || pd.getName().equals("class") || delegateAnnot == null && PersistenceIntrospector.getAnnotationInHierarchy(rm, Transient.class, searchHierarchy) != null) continue;
            persistencePds.add(pd);
            if (PersistenceIntrospector.getAnnotationInHierarchy(rm, Id.class, searchHierarchy) != null || PersistenceIntrospector.getAnnotationInHierarchy(rm, EmbeddedId.class, searchHierarchy) != null) {
                impl.setIdPropertyDescriptor(pd);
                if (PersistenceIntrospector.getAnnotationInHierarchy(rm, EmbeddedId.class, searchHierarchy) != null) {
                    impl.setIdEmbedded(true);
                    ExtBeanInfo embIdbi = PersistenceIntrospector.getPersistenceBeanInfo(pd.getPropertyType());
                    impl.setEmbeddedIdBeanInfo(embIdbi);
                }
                if (PersistenceIntrospector.getAnnotationInHierarchy(rm, GeneratedValue.class, searchHierarchy) != null) {
                    impl.setIdGenerated(true);
                }
            }
            if ((resKeyAnno = PersistenceIntrospector.getAnnotationInHierarchy(rm, ResourceKey.class, searchHierarchy)) != null) {
                pd.setValue(ResourceKey.class.getName(), resKeyAnno.value());
            }
            if ((unitAnno = PersistenceIntrospector.getAnnotationInHierarchy(rm, Unit.class, searchHierarchy)) == null) continue;
            pd.setValue(Unit.class.getName(), unitAnno.value());
        }
        impl.setPersistencePropertyDescriptors(persistencePds.toArray(new PropertyDescriptor[0]));
        HashSet<PropertyDescriptor> referenceProperties = new HashSet<PropertyDescriptor>();
        sClass = entityClass;
        for (PropertyDescriptor pPd : persistencePds) {
            Method rm = pPd.getReadMethod();
            ObjectImmutableIfReferenced oiirAnno = rm.getAnnotation(ObjectImmutableIfReferenced.class);
            if (oiirAnno == null) continue;
            referenceProperties.add(pPd);
        }
        impl.setObjectImmutablePropertyDescriptors(referenceProperties);
        cache.put(beanClass, impl);
        return impl;
    }

    private static <T extends Annotation> T getAnnotationInHierarchy(Method method, Class<T> annotationClass, boolean searchHierarchy) {
        T anno = method.getAnnotation(annotationClass);
        if (anno != null || !searchHierarchy) {
            return anno;
        }
        Class methodClass = method.getDeclaringClass();
        Type sType = null;
        while ((sType = methodClass.getGenericSuperclass()) != null) {
            if (!(sType instanceof Class)) continue;
            Class sClass = (Class)sType;
            try {
                Method sMethod = sClass.getMethod(method.getName(), method.getParameterTypes());
                anno = sMethod.getAnnotation(annotationClass);
                if (anno != null) {
                    return anno;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            methodClass = sClass;
        }
        return null;
    }

    private static <A extends Annotation> A getAnnotationInHierarchy(Class<?> aClass, Class<A> annotationClass, boolean searchHierarchy) {
        do {
            A anno;
            if ((anno = aClass.getAnnotation(annotationClass)) == null && searchHierarchy) continue;
            return anno;
        } while ((aClass = aClass.getSuperclass()) != null);
        return null;
    }
}

