/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.beans.table;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ips.servlet.http.URLEncoder;
import ipsk.jsp.taglib.beans.BeanProperty;
import ipsk.jsp.taglib.beans.BeanPropertyValueText;
import ipsk.jsp.taglib.beans.table.BeanTableCol;
import ipsk.net.EditableURI;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.text.html.HTMLTextEncoder;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class BeanPropertyTableCol
extends BeanTableCol {
    protected String var;
    protected String href;
    protected String queryName;
    protected int maxListLength = 0;
    protected BeanProperty beanProperty;
    protected ExtBeanInfo beanInfo;
    private PropertyDescriptor pd;
    private Class propType;

    public BeanPropertyTableCol(String name, String bundle, String key, String href, int maxListLength, String queryName, String var) {
        super(name, bundle, key);
        this.beanProperty = new BeanProperty(name, bundle, key);
        this.pd = this.beanProperty.getPropertyDescriptor();
        this.propType = this.pd.getPropertyType();
        this.href = href;
        this.maxListLength = maxListLength;
        this.queryName = queryName;
        this.var = var;
    }

    public BeanPropertyTableCol(PropertyDescriptor pd, ExtBeanInfo beanInfo) {
        super(pd.getName());
        this.beanProperty = new BeanProperty(pd);
        this.beanInfo = beanInfo;
        this.pd = this.beanProperty.getPropertyDescriptor();
        this.propType = pd.getPropertyType();
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String namedQuery) {
        this.queryName = namedQuery;
    }

    @Override
    public String getBundle() {
        if (this.bundle != null) {
            return this.bundle;
        }
        return this.beanProperty.getBundle();
    }

    @Override
    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        return this.beanProperty.getKey();
    }

    public String getEncodedHrefUri(Object item) throws JspException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object idVal = null;
        PropertyDescriptor pd = this.beanProperty.getPropertyDescriptor();
        try {
            boolean linkPossible = false;
            boolean toOneRelationShip = false;
            PersistenceObjectIdentifier relPoi = null;
            if (this.href != null) {
                EditableURI uri = new EditableURI(this.href);
                PersistenceObjectIdentifier poi = null;
                poi = this.beanInfo.getPersistenceObjectIdentifier(item);
                idVal = poi.getIdObject();
                PropertyDescriptor idPropertyDescriptor = this.beanInfo.getIdPropertyDescriptor();
                if (this.queryName != null) {
                    uri.appendQuery("_cmd", (Object)"named_query");
                    uri.appendQuery("name", (Object)this.queryName);
                    uri.appendQueryMap(poi.toQueryMap());
                } else if (pd.equals(idPropertyDescriptor)) {
                    uri.appendQuery("_cmd", (Object)"view");
                    uri.appendQuery(idPropertyDescriptor.getName(), idVal);
                    linkPossible = true;
                } else {
                    String mappedBy = null;
                    if (Collection.class.isAssignableFrom(this.propType)) {
                        uri.appendQuery("_cmd", (Object)"list_related");
                        Method rm = pd.getReadMethod();
                        ManyToMany manyToManyAnno = rm.getAnnotation(ManyToMany.class);
                        if (manyToManyAnno != null) {
                            mappedBy = manyToManyAnno.mappedBy();
                        } else {
                            OneToMany oneToManyAnno = rm.getAnnotation(OneToMany.class);
                            if (oneToManyAnno != null) {
                                mappedBy = oneToManyAnno.mappedBy();
                            }
                        }
                        uri.appendQueryMap(poi.toQueryMap());
                        if (mappedBy != null && !mappedBy.equals("")) {
                            uri.appendQuery("_related_mappedby", (Object)mappedBy);
                        } else {
                            uri.appendQuery("_related_prop", (Object)pd.getName());
                        }
                        linkPossible = true;
                    } else {
                        toOneRelationShip = true;
                        Method rm = pd.getReadMethod();
                        Object relObject = null;
                        relObject = rm.invoke(item, new Object[0]);
                        if (relObject != null) {
                            ExtBeanInfo relBeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(relObject.getClass(), true);
                            relPoi = relBeanInfo.getPersistenceObjectIdentifier(relObject);
                            uri.appendQuery("_cmd", (Object)"view");
                            uri.appendQueryMap(relPoi.toQueryMap());
                            linkPossible = true;
                        }
                    }
                }
                if (linkPossible) {
                    return uri.getUri();
                }
            }
        }
        catch (IOException ioe) {
            throw new JspException("Error: IOException while creating relationship URI");
        }
        catch (IntrospectionException e) {
            throw new JspException("Error: Bean Introspection error.");
        }
        return null;
    }

    public void printTag(PageContext pageContext, Object item) throws JspException {
        this.printTag(pageContext, this.beanInfo, item);
    }

    public void printTag(PageContext pageContext, ExtBeanInfo beanInfo, Object item) throws JspException {
        if (this.var == null) {
            JspWriter ow = pageContext.getOut();
            Object idVal = null;
            try {
                ow.print("<td>");
                String uriStr = this.getEncodedHrefUri(item);
                if (uriStr != null) {
                    String encodedUrl = URLEncoder.encodeURL(pageContext, uriStr);
                    String htmlEncodedUrl = HTMLTextEncoder.encode((String)encodedUrl);
                    ow.println("<a href=\"" + htmlEncodedUrl + "\">");
                }
                String valStr = null;
                BeanPropertyValueText bpvt = new BeanPropertyValueText(beanInfo, pageContext, this.maxListLength);
                try {
                    valStr = bpvt.getValueTextRepresentation(item, this.pd);
                }
                catch (Exception e) {
                    throw new JspException("Could not create bean value string representation: " + e);
                }
                ow.print(HTMLTextEncoder.encode((String)valStr));
                if (this.href != null && uriStr != null) {
                    if (valStr == null || "".equals(valStr)) {
                        ow.print("_");
                    }
                    ow.print("</a>");
                }
                ow.print("</td>");
            }
            catch (Exception ioe) {
                throw new JspException("Error: IOException while writing cell property");
            }
        }
    }

    public BeanProperty getBeanProperty() {
        return this.beanProperty;
    }

    public int getMaxListLength() {
        return this.maxListLength;
    }

    public void setMaxListLength(int maxListLength) {
        this.maxListLength = maxListLength;
    }
}

