/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.utils;

import ipsk.jsp.fmt.LocaleSupport;
import ipsk.text.StringTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class LanguageChooserTag
extends BodyTagSupport {
    private String languages;
    private String excludeLanguages;
    private String disabledLanguages;
    private String name;
    private String value = null;
    private boolean localize = true;
    private boolean nullable = false;
    private String standard;
    private List<Locale> localeList = null;
    private Set<String> disabledLanguageCodes = new HashSet<String>();

    public LanguageChooserTag() {
        Locale[] localeArray = Locale.getAvailableLocales();
        this.localeList = Arrays.asList(localeArray);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String getStandard() {
        return this.standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public boolean isLocalize() {
        return this.localize;
    }

    public void setLocalize(boolean localize) {
        this.localize = localize;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getLanguages() {
        return this.languages;
    }

    public void setLanguages(String locales) {
        this.languages = locales;
        if (locales != null) {
            String[] localesStrArr;
            this.localeList = new ArrayList<Locale>();
            for (String locStr : localesStrArr = StringTokenizer.split((String)locales, (char)',', (boolean)true)) {
                Locale l = LocaleSupport.parse(locStr.trim());
                this.localeList.add(l);
            }
        }
    }

    public String getExcludeLanguages() {
        return this.excludeLanguages;
    }

    public void setExcludeLanguages(String excludeLanguages) {
        this.excludeLanguages = excludeLanguages;
        if (this.excludeLanguages != null) {
            Locale[] localeArray;
            this.localeList = new ArrayList<Locale>();
            String[] excludeStrArr = StringTokenizer.split((String)this.excludeLanguages, (char)',', (boolean)true);
            for (Locale al : localeArray = Locale.getAvailableLocales()) {
                boolean include = true;
                for (String exclStr : excludeStrArr) {
                    String l3 = exclStr.trim();
                    String al3 = al.getISO3Language();
                    if (!al3.equals(l3)) continue;
                    include = false;
                }
                if (!include) continue;
                this.localeList.add(al);
            }
        }
    }

    public String getDisabledLanguages() {
        return this.disabledLanguages;
    }

    public void setDisabledLanguages(String disabledLanguages) {
        this.disabledLanguages = disabledLanguages;
        this.disabledLanguageCodes.clear();
        if (this.disabledLanguages != null) {
            String[] disabledStrArr;
            for (String disabledStr : disabledStrArr = StringTokenizer.split((String)this.disabledLanguages, (char)',', (boolean)true)) {
                this.disabledLanguageCodes.add(disabledStr);
            }
        }
    }

    public int doStartTag() throws JspException {
        String currLocaleLanCode;
        List<Locale> locList = this.localeList;
        if (locList == null) {
            locList = Arrays.asList(Locale.getAvailableLocales());
        }
        JspWriter ow = this.pageContext.getOut();
        Locale currLocale = LocaleSupport.getLocale(this.pageContext);
        if (this.standard == null || "ISO-639-1".equalsIgnoreCase(this.standard.trim())) {
            currLocaleLanCode = currLocale.getLanguage();
        } else if ("ISO-639-3".equalsIgnoreCase(this.standard.trim())) {
            currLocaleLanCode = currLocale.getISO3Language();
        } else {
            throw new JspException("Unknown language standard \"" + this.standard + "\". Possible values are ISO-639-1 and ISO-639-3 (default)");
        }
        try {
            ow.println("<select name=\"" + this.name + "\">");
            TreeSet<LanguageOption> langValueSet = new TreeSet<LanguageOption>();
            boolean languageSelected = false;
            for (Locale l : locList) {
                boolean disabled;
                LanguageOption lOpt;
                String optionLangValue;
                if (this.standard == null || "ISO-639-1".equalsIgnoreCase(this.standard.trim())) {
                    optionLangValue = l.getLanguage();
                } else if ("ISO-639-3".equalsIgnoreCase(this.standard.trim())) {
                    optionLangValue = l.getISO3Language();
                } else {
                    throw new JspException("Unknown language standard \"" + this.standard + "\". Possible values are ISO-639-1 and ISO-639-3 (default)");
                }
                Locale displayLocale = this.localize ? currLocale : l;
                String displaystring = l.getDisplayLanguage(displayLocale);
                if (optionLangValue == null || "".equals(optionLangValue) || langValueSet.contains(lOpt = new LanguageOption(optionLangValue, displaystring, disabled = this.disabledLanguageCodes.contains(optionLangValue)))) continue;
                langValueSet.add(lOpt);
            }
            if (this.nullable) {
                String selectedAttrStr = "";
                if (this.value == null || "".equals(this.value)) {
                    selectedAttrStr = " selected=\"selected\"";
                }
                String selLngStr = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"language.select", (String)"ipsk.jsp.Messages");
                ow.print("<option" + selectedAttrStr + " value=\"\">-- " + selLngStr + " --</option>");
            }
            for (LanguageOption lo : langValueSet) {
                boolean selected = false;
                if (this.value != null && !this.value.equals("")) {
                    if (this.value.equalsIgnoreCase(lo.value)) {
                        selected = true;
                    }
                } else if (!this.nullable && currLocaleLanCode.equals(lo.value)) {
                    selected = true;
                }
                String selectedAttrStr = "";
                String disabledStr = "";
                if (!lo.disabled && selected) {
                    languageSelected = true;
                    selectedAttrStr = " selected=\"selected\"";
                }
                if (lo.disabled) {
                    disabledStr = " disabled=\"true\"";
                }
                ow.print("<option" + selectedAttrStr + disabledStr + " value=\"" + lo.value + "\">");
                ow.print(lo.displayName);
                ow.println("</option>");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        JspWriter ow = this.pageContext.getOut();
        try {
            ow.println("</select>");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public class LanguageOption
    implements Comparable<LanguageOption> {
        private String value;
        private String displayName;
        private boolean disabled;

        public LanguageOption(String value, String displayName, boolean disabled) {
            this.value = value;
            this.displayName = displayName;
            this.disabled = disabled;
        }

        @Override
        public int compareTo(LanguageOption o) {
            return this.displayName.compareTo(o.displayName);
        }

        public boolean equals(Object o) {
            if (o instanceof LanguageOption) {
                LanguageOption other = (LanguageOption)o;
                return other.value.equals(this.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

