/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps;

import ipsk.webapps.ControllerException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SecureRequestTokenProvider {
    public static final int SECURE_REQUEST_TOKEN_BYTE_LEN = 64;
    public static final String SECURE_REQUEST_TOKEN_NAME = "_secureRequestToken";
    public static final String SECURE_REQUEST_TOKEN_ATTR_KEY = SecureRequestTokenProvider.class.getName() + "._secureRequestToken";
    private boolean consumeSecureRequestToken = true;

    public void setConsumeSecureRequestToken(boolean consumeSecureRequestToken) {
        this.consumeSecureRequestToken = consumeSecureRequestToken;
    }

    private static Set<String> sessionSecureRequestTokens(HttpServletRequest req) {
        Set secureTokensSet = null;
        HttpSession sess = req.getSession();
        if (sess != null) {
            Object secToksSetObj = sess.getAttribute(SECURE_REQUEST_TOKEN_ATTR_KEY);
            if (secToksSetObj == null) {
                secureTokensSet = new HashSet();
                sess.setAttribute(SECURE_REQUEST_TOKEN_ATTR_KEY, secureTokensSet);
            } else if (secToksSetObj instanceof Set) {
                secureTokensSet = (Set)secToksSetObj;
            }
        }
        return secureTokensSet;
    }

    public static String generateSecureRequestToken(HttpServletRequest req) {
        SecureRandom sr = new SecureRandom();
        byte[] bytes = new byte[64];
        sr.nextBytes(bytes);
        Base64.Encoder b64Enc = Base64.getUrlEncoder().withoutPadding();
        String secTok = b64Enc.encodeToString(bytes);
        Set<String> secureTokensSet = SecureRequestTokenProvider.sessionSecureRequestTokens(req);
        secureTokensSet.add(secTok);
        return secTok;
    }

    private boolean _checkSecureRequestToken(HttpServletRequest req) {
        Set<String> secureTokensSet;
        String secReqTokSent = req.getParameter(SECURE_REQUEST_TOKEN_NAME);
        if (secReqTokSent != null && (secureTokensSet = SecureRequestTokenProvider.sessionSecureRequestTokens(req)) != null) {
            if (this.consumeSecureRequestToken) {
                return secureTokensSet.remove(secReqTokSent);
            }
            return secureTokensSet.contains(secReqTokSent);
        }
        return false;
    }

    public void checkSecureRequestToken(HttpServletRequest req) throws ControllerException {
        boolean res = this._checkSecureRequestToken(req);
        if (!res) {
            throw new ControllerException("Invalid request!");
        }
    }
}

