/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ips.beans.PersistenceMapConverter;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverter;
import ipsk.beans.MapConverterException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.form.FormConfiguration;
import ipsk.beans.form.PropertyConfiguration;
import ipsk.beans.validation.BeanValidator;
import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.jsp.BeanTableController;
import ipsk.jsp.BeanTableModel;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.persistence.SecurityManager;
import ipsk.sql.OrderByClause;
import ipsk.text.ParserException;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.ControllerException;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.NoSuchObjectException;
import ipsk.webapps.ObjectAlreadyExistsException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.SelectMode;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.GeneratedValue;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceException;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BasicEnumBeanController<T extends Enum<T>>
implements BeanTableController,
BeanValidator {
    public static final int DEFAULT_BATCHSIZE = 20;
    public static final int MAX_BATCHSIZE = 1000;
    public static final boolean USE_FULL_QUALIFIED_CLASSNAMES_IN_QUERY = false;
    public static final String KEY_CMD = "_cmd";
    public static final String KEY_MODEL_REQUEST = "_model_req";
    public static final String KEY_ACTION = "_action";
    public static final String KEY_QUERY_NAME = "name";
    public static final String KEY_MAPPEDBY = "_related_mappedby";
    public static final String KEY_RELATED_PROPERTY = "_related_prop";
    public static final String KEY_SELECTED_PROPERTY = "_sel_prop";
    public static final String KEY_SELECTED_ID = "_sel_id";
    public static final String KEY_SELECT_TARGET_PROPERTY = "_sel_trg_prop";
    public static final String KEY_SELECT_TARGET_ID_PROPERTY = "_sel_trg_id_prop";
    public static final String KEY_SELECT_TARGET_ID = "_sel_trg_id";
    public static final String KEY_PREFIX_DELETE_RELATED = "_delete_rel";
    public static final String KEY_PREFIX_DEFAULT_DESELECT = "_default_deselect";
    public static final String CMD_LIST = "list";
    public static final String CMD_LIST_RELATED = "list_related";
    public static final String CMD_SELECT_TO_ADD = "select_to_add";
    public static final String CMD_SELECT_TO_REMOVE = "select_to_remove";
    public static final String CMD_SELECT_TO_SET = "select_to_set";
    public static final String CMD_SELECT_TO_RESET = "select_to_reset";
    public static final String CMD_LIST_CHANGE_SELECTION = "list_change_sel";
    public static final String CMD_CANCEL_LIST_CHANGE_SELECTION = "list_change_sel";
    public static final String CMD_CORRECT = "correct";
    public static final String CMD_LIST_SELECT_ITEM = "list_select_item";
    public static final String CMD_LIST_SELECT_MULTI = "list_select_multi";
    public static final String CMD_VIEW = "view";
    public static final String CMD_VIEW_TO_DELETE = "view_to_delete";
    public static final String CMD_CANCEL = "cancel";
    public static final String KEY_LOCALE = "_locale";
    public static final String KEY_ROWS = "rows";
    public static final String VAL_SELECT_ADD = "select_add";
    public static final String VAL_SELECT_REMOVE = "select_remove";
    public static final String JPQL_PARAM_NAME_PREFIX = "basiccontroller_where_param";
    public String[] SUBMIT_CMDS = new String[]{"cancel"};
    private EntityManagerThreadLocal emtl;
    protected Class<T> queryType;
    protected String queryTypeName;
    protected String jsfIdentifier;
    protected int batchSize = 20;
    protected int firstItem = 0;
    private boolean queryMembers = false;
    private String[] additionalColumns;
    private List<String> displayColumns;
    private ExtBeanInfo beanInfo = null;
    private Object id;
    private boolean idGenerated = false;
    protected BeanTableModel<T> beanTableModel;
    private PersistenceObjectIdentifier relatedObjectIdentifier;
    private Mode mode = null;
    private boolean actionCanceled;
    private Object selectedItemId;
    private Set<Object> selectedItemIds;
    protected HttpServletRequest currentRequest;
    protected ServletContext servletContext;
    protected SecurityManager securityManager = new SecurityManager();
    protected boolean dropInSecureItems = false;
    protected BeanModel<T> beanModel = null;
    protected ProcessResult processResult;
    protected T[] enumValues;
    protected String relatedPropertyName;
    protected boolean checkSecureRequestToken = false;
    public static String RESOURCE_BUNDLE_NAME = "ipsk.jsp.Messages";
    private static LocalizableMessage VALIDATION_MSG_FIELD_REQUIRED = new LocalizableMessage(RESOURCE_BUNDLE_NAME, "validation.field.required");

    public String[] getAdditionalColumns() {
        return this.additionalColumns;
    }

    @Override
    public void setAdditionalColumns(String[] additionalColumns) {
        this.additionalColumns = additionalColumns;
    }

    public void setCurrentRequest(HttpServletRequest currentRequest) {
        this.currentRequest = currentRequest;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void setCheckSecureRequestToken(boolean checkSecureRequestToken) {
        this.checkSecureRequestToken = checkSecureRequestToken;
    }

    @Override
    public FormConfiguration getFormConfiguration() {
        return null;
    }

    public BasicEnumBeanController(Class<T> queryType) {
        this(queryType, queryType.getName());
    }

    public BasicEnumBeanController(Class<T> queryType, String jsfIdentifier) {
        PropertyDescriptor[] pds;
        this.queryType = queryType;
        this.queryTypeName = queryType.getName();
        try {
            this.beanInfo = PersistenceIntrospector.getExtendedBeanInfo(queryType, true, false);
            Method vm = queryType.getMethod("values", new Class[0]);
            Object valArrObj = vm.invoke(null, new Object[0]);
            if (valArrObj instanceof Object[]) {
                this.enumValues = (Enum[])valArrObj;
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        for (PropertyDescriptor pd : pds = this.beanInfo.getPropertyDescriptors()) {
            Method rm = pd.getReadMethod();
            if (rm.getAnnotation(GeneratedValue.class) == null) continue;
            this.setIdGenerated(true);
        }
        this.jsfIdentifier = jsfIdentifier;
        this.emtl = new EntityManagerThreadLocal();
    }

    @Override
    public void open() {
        EntityManager em = this.getThreadEntityManager();
        EntityTransaction tx = em.getTransaction();
        if (tx != null && !tx.isActive()) {
            tx.begin();
        }
    }

    @Override
    public ExtBeanInfo getBeanInfo() {
        try {
            return PersistenceIntrospector.getPersistenceBeanInfo(this.queryType);
        }
        catch (IntrospectionException e1) {
            return null;
        }
    }

    public EntityManager getEntityManager() {
        return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
    }

    @Override
    public EntityManager getThreadEntityManager() {
        if (this.emtl == null) {
            this.emtl = new EntityManagerThreadLocal();
        }
        return (EntityManager)this.emtl.get();
    }

    public PropertyDescriptor[] getBeanProperties() {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(this.queryType);
        }
        catch (IntrospectionException e1) {
            return null;
        }
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        return pds;
    }

    public T getById(Object id) {
        EntityManager em = this.getThreadEntityManager();
        Enum o = (Enum)em.find(this.queryType, id);
        return (T)o;
    }

    @Override
    public boolean hasRelationShips(Object bean) throws ControllerException {
        return false;
    }

    @Override
    public boolean hasRelationShips(Object bean, PropertyDescriptor propertyDescriptor) throws ControllerException {
        return false;
    }

    @Override
    public boolean hasRelationShips(Object bean, CascadeType ignoreRemoveCascadedWith) throws ControllerException {
        return false;
    }

    public boolean isObjectImmutable(Object bean) throws ControllerException {
        return true;
    }

    public boolean isObjectRemovable(Object bean) throws ControllerException {
        return false;
    }

    @Override
    public boolean modifyable(Object bean) {
        return false;
    }

    @Override
    public boolean removable(Object bean) {
        return false;
    }

    public Object removeById(HttpServletRequest req, Object id) throws ControllerException {
        return this.removeById(req, id, false);
    }

    public Object removeById(HttpServletRequest req, Object id, boolean removeRelationShips) throws ControllerException {
        return this.removeById(req, this.beanInfo, id, removeRelationShips);
    }

    /*
     * WARNING - void declaration
     */
    public Object removeById(HttpServletRequest req, ExtBeanInfo typeInfo, Object id, boolean removeRelationShips) throws ControllerException {
        EntityManager em = this.getThreadEntityManager();
        try {
            Object o = em.find(typeInfo.getBeanDescriptor().getBeanClass(), id);
            if (o == null) {
                throw new NoSuchObjectException(id);
            }
            this.securityManager.checkRemovePermission(req, o);
            if (removeRelationShips) {
                PropertyDescriptor[] ppds;
                block5: for (PropertyDescriptor ppd : ppds = typeInfo.getPersistencePropertyDescriptors()) {
                    Collection values;
                    Object relatedReturnType;
                    ParameterizedType prt;
                    Type[] pts;
                    CascadeType[] cascadeTypes;
                    Method rm = ppd.getReadMethod();
                    OneToMany oneToManyAnno = rm.getAnnotation(OneToMany.class);
                    ManyToMany manyToManyAnno = rm.getAnnotation(ManyToMany.class);
                    OneToOne oneToOneAnnotation = rm.getAnnotation(OneToOne.class);
                    boolean cascadeRemove = false;
                    if (oneToManyAnno != null) {
                        void var18_25;
                        PropertyDescriptor[] relPpds;
                        Type rt;
                        for (CascadeType ct : cascadeTypes = oneToManyAnno.cascade()) {
                            if (!ct.equals((Object)CascadeType.ALL) && !ct.equals((Object)CascadeType.REMOVE)) continue;
                            cascadeRemove = true;
                            break;
                        }
                        if (cascadeRemove) continue;
                        Object var18_24 = null;
                        String mappedby = oneToManyAnno.mappedBy();
                        if (mappedby == null || mappedby.equals("") || !((rt = rm.getGenericReturnType()) instanceof ParameterizedType) || (pts = (prt = (ParameterizedType)rt).getActualTypeArguments()).length != 1) continue;
                        relatedReturnType = (Class)pts[0];
                        ExtBeanInfo relatedbeanInfo = null;
                        relatedbeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(relatedReturnType);
                        for (PropertyDescriptor relPpd : relPpds = relatedbeanInfo.getPersistencePropertyDescriptors()) {
                            if (!relPpd.getName().equals(mappedby)) continue;
                            PropertyDescriptor propertyDescriptor = relPpd;
                        }
                        values = (Collection)rm.invoke(o, new Object[0]);
                        Method relWriteMethod = var18_25.getWriteMethod();
                        for (Object relObj : values) {
                            relWriteMethod.invoke(relObj, new Object[]{null});
                            this.securityManager.checkMergePermission(req, relObj);
                            em.merge(relObj);
                        }
                        values.clear();
                        continue;
                    }
                    if (manyToManyAnno != null) {
                        void var18_29;
                        PropertyDescriptor[] relPpds;
                        Type rt;
                        for (CascadeType ct : cascadeTypes = manyToManyAnno.cascade()) {
                            if (!ct.equals((Object)CascadeType.ALL) && !ct.equals((Object)CascadeType.REMOVE)) continue;
                            cascadeRemove = true;
                            break;
                        }
                        if (cascadeRemove) continue;
                        Object var18_28 = null;
                        String mappedby = manyToManyAnno.mappedBy();
                        if (mappedby == null || mappedby.equals("") || !((rt = rm.getGenericReturnType()) instanceof ParameterizedType) || (pts = (prt = (ParameterizedType)rt).getActualTypeArguments()).length != 1) continue;
                        relatedReturnType = (Class)pts[0];
                        ExtBeanInfo relatedbeanInfo = null;
                        relatedbeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(relatedReturnType);
                        for (PropertyDescriptor relPpd : relPpds = relatedbeanInfo.getPersistencePropertyDescriptors()) {
                            if (!relPpd.getName().equals(mappedby)) continue;
                            PropertyDescriptor propertyDescriptor = relPpd;
                        }
                        values = (Collection)rm.invoke(o, new Object[0]);
                        Method relReadMethod = var18_29.getReadMethod();
                        for (Object relObj : values) {
                            Collection relCollValues = (Collection)relReadMethod.invoke(relObj, new Object[0]);
                            this.securityManager.checkMergePermission(req, relObj);
                            relCollValues.remove(o);
                            em.merge(relObj);
                        }
                        values.clear();
                        continue;
                    }
                    if (oneToOneAnnotation == null) continue;
                    for (CascadeType ct : cascadeTypes = oneToOneAnnotation.cascade()) {
                        if (!ct.equals((Object)CascadeType.ALL) && !ct.equals((Object)CascadeType.REMOVE)) continue;
                        cascadeRemove = true;
                        break;
                    }
                    if (cascadeRemove) continue;
                    Class<?> clazz = rm.getReturnType();
                    Object relObj = rm.invoke(o, new Object[0]);
                    if (relObj == null) continue;
                    ExtBeanInfo relBeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(clazz);
                    PropertyDescriptor[] relPPds = relBeanInfo.getPersistencePropertyDescriptors();
                    String mappedBy = oneToOneAnnotation.mappedBy();
                    if (mappedBy != null && !mappedBy.equals("")) {
                        for (PropertyDescriptor relPpd : relPPds) {
                            if (!relPpd.getName().equals(mappedBy)) continue;
                            Method relWm = relPpd.getWriteMethod();
                            this.securityManager.checkMergePermission(req, relObj);
                            relWm.invoke(relObj, new Object[]{null});
                            em.merge(relObj);
                            continue block5;
                        }
                        continue;
                    }
                    for (PropertyDescriptor relPpd : relPPds) {
                        String mappedby;
                        Method relRm = relPpd.getReadMethod();
                        OneToOne relOneToOneAnno = relRm.getAnnotation(OneToOne.class);
                        if (relOneToOneAnno == null || (mappedby = relOneToOneAnno.mappedBy()) == null || !mappedby.equals(ppd.getName())) continue;
                        Method relWm = relPpd.getWriteMethod();
                        this.securityManager.checkMergePermission(req, relObj);
                        relWm.invoke(relObj, new Object[]{null});
                        continue block5;
                    }
                }
            }
            em.remove(o);
            return o;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
    }

    @Override
    public BeanTableModel<?> getBeanTableModel(HttpServletRequest request) throws ControllerException {
        if (this.beanTableModel == null) {
            this.createBeanTableModel(request);
        }
        return this.beanTableModel;
    }

    public BeanTableModel<?> getBeanTableModel() {
        return this.beanTableModel;
    }

    @Override
    public int getFirstItem() {
        return this.firstItem;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void processNamedQuery(HttpServletRequest req, String namedQuery, Object[] params) throws ControllerException {
        this.currentRequest = req;
        this.clear();
        this.processListRequest(req);
    }

    public void createBeanTableModel(HttpServletRequest request) throws ControllerException {
        this.createBeanTableModel(request.getParameter(KEY_CMD), request);
    }

    public void createBeanTableModel(String cmd, HttpServletRequest request) throws ControllerException {
        this.createBeanTableModel(cmd, new BeanTableModel(), request);
    }

    public void selectItem(HttpServletRequest request) throws ControllerException {
        HashMap pMap = (HashMap)request.getParameterMap();
        this.setSelectedItemId(request, this.createIdObject(pMap));
    }

    public void changeSelectedItemIds(HttpServletRequest request) throws ControllerException {
        Map pMap = request.getParameterMap();
        this.setSelectedItemId(request, this.createIdObject(pMap));
    }

    public void createEmptyBeanTableModel(HttpServletRequest request) {
        this.beanTableModel = new BeanTableModel();
        this.beanTableModel.setBatchSize(this.batchSize);
        this.beanTableModel.setExtBeanInfo(this.beanInfo);
        this.beanTableModel.setItems(new ArrayList());
        this.beanTableModel.setItemCount(0);
    }

    public void createBeanTableModel(String command, BeanTableModel<T> btm, HttpServletRequest request) throws ControllerException {
        btm.setBatchSize(this.batchSize);
        btm.setExtBeanInfo(this.beanInfo);
        if (CMD_LIST_RELATED.equals(command)) {
            this.mode = new ListMode();
            this.processRelationShip(request.getParameterMap());
            command = CMD_LIST;
        } else if (CMD_SELECT_TO_RESET.equals(command)) {
            String selectTargetProperty = request.getParameter(KEY_RELATED_PROPERTY);
            ListMode lm = new ListMode();
            lm.setSelectMode(new SelectMode(SelectMode.ActionType.RESET, request.getParameter(KEY_ACTION), selectTargetProperty));
            this.mode = lm;
            this.processRelationShip(request.getParameterMap());
        }
        if (this.mode != null && this.mode instanceof ListMode) {
            btm.setSelectMode(((ListMode)this.mode).getSelectMode());
        }
        EntityManager em = this.getThreadEntityManager();
        PersistenceObjectIdentifier poi = this.getRelatedObjectIdentifier();
        Class<?> targetClass = poi.getTargetClass();
        ArrayList<T> resultList = new ArrayList<T>();
        int itemCount = resultList.size();
        try {
            ExtBeanInfo targetBi = PersistenceIntrospector.getExtendedBeanInfo(targetClass);
            PropertyDescriptor relPd = targetBi.getPersistencePropertyDescriptor(this.relatedPropertyName);
            Object targetObj = em.find(targetClass, poi.getIdObject());
            Method rm = relPd.getReadMethod();
            Object resObj = rm.invoke(targetObj, new Object[0]);
            if (!this.queryMembers) {
                resultList.addAll(Arrays.asList(this.enumValues));
            }
            if (resObj instanceof Collection) {
                Collection resCol = (Collection)resObj;
                for (T enumVal : this.enumValues) {
                    if (resCol.contains(enumVal)) continue;
                    if (this.queryMembers) {
                        resultList.add(enumVal);
                        continue;
                    }
                    resultList.remove(enumVal);
                }
            }
            itemCount = resultList.size();
        }
        catch (IntrospectionException e1) {
            e1.printStackTrace();
            throw new ControllerException(e1);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (CMD_LIST_SELECT_ITEM.equals(command) || CMD_LIST_SELECT_MULTI.equals(command)) {
            this.selectItem(request);
        }
        if (this.firstItem > itemCount - 1) {
            this.firstItem = 0;
        }
        ArrayList<Enum> safeItems = new ArrayList<Enum>();
        for (Enum o : resultList) {
            if (this.securityManager != null) {
                if (!this.dropInSecureItems) {
                    this.securityManager.checkReadPermission(request, o);
                } else if (this.securityManager.getReadPermission(request, o)) {
                    safeItems.add(o);
                }
            }
            this.setPropertiesAfterQuery(request, em, o);
        }
        if (this.dropInSecureItems) {
            itemCount = safeItems.size();
            btm.setItems(safeItems);
        } else {
            btm.setItems(resultList);
        }
        btm.setItemCount(itemCount);
        btm.setFirstItem(this.firstItem);
        btm.setLastItem(this.firstItem + this.batchSize >= itemCount ? itemCount - 1 : this.firstItem + this.batchSize - 1);
        if (this.selectedItemId != null) {
            btm.setSelectedRowsIds(new Object[]{this.selectedItemId});
        }
        btm.setExtBeanInfo(this.getBeanInfo());
        this.beanTableModel = btm;
    }

    protected void setPropertiesAfterSelect(HttpServletRequest request, Object selObject) {
    }

    protected void setPropertiesAfterSelect(HttpServletRequest request, Set<Object> selObjects) {
    }

    public void createBeanModel(HttpServletRequest request) throws ControllerException {
        Map map = request.getParameterMap();
        Object idObj = this.createIdObject(map);
        EntityManager em = this.getThreadEntityManager();
        try {
            Enum editItem = (Enum)em.find(this.queryType, idObj);
            if (editItem == null) {
                throw new NoSuchObjectException(idObj);
            }
            PersistenceMapConverter mapConverter = new PersistenceMapConverter();
            try {
                mapConverter.setBeanProperties(editItem, map, em, false, request, this.securityManager);
                this.securityManager.checkReadPermission(request, editItem);
                this.beanModel = new BeanModel((Object)editItem);
            }
            catch (MapConverterException e) {
                e.printStackTrace();
                throw new ControllerException("Could not apply property values.", e);
            }
        }
        catch (PersistenceException e) {
            e.printStackTrace();
            this.close();
            throw e;
        }
    }

    public T getItem() throws ControllerException {
        if (this.beanModel != null) {
            return (T)((Enum)this.beanModel.getBean());
        }
        return null;
    }

    @Override
    public List<String> getDisplayColumns() {
        return this.displayColumns;
    }

    protected void setPropertiesOnNew(Object bean) {
    }

    protected void setPropertiesOnCreate(HttpServletRequest request, EntityManager em, Object bean) {
    }

    protected void setPropertiesAfterQuery(HttpServletRequest request, EntityManager em, Object o) {
    }

    public ValidationResult validate(Object o, ValidationResult validationResult) throws ValidationException {
        FormConfiguration formConfiguration = this.getFormConfiguration();
        ValidationResult vr = validationResult;
        boolean defaultRequired = false;
        if (vr == null) {
            vr = new ValidationResult();
        }
        if (this.queryType.isAssignableFrom(o.getClass())) {
            PropertyDescriptor[] pPds;
            for (PropertyDescriptor pd : pPds = this.beanInfo.getPersistencePropertyDescriptors()) {
                LocalizableMessage msg;
                Object val;
                String pdName = pd.getName();
                PropertyValidationResult prVr = vr.getPropertyValidationResult(pdName);
                if (prVr != null && !prVr.isValid()) continue;
                boolean required = defaultRequired;
                if (formConfiguration != null) {
                    List propCfgs = formConfiguration.getPropertyConfigurations();
                    for (PropertyConfiguration pCfg : propCfgs) {
                        if (!pd.equals(pCfg.getPropertyDescriptor())) continue;
                        required = pCfg.isRequired() && pCfg.isShow();
                        break;
                    }
                }
                Method rm = pd.getReadMethod();
                try {
                    val = rm.invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ValidationException((Throwable)e);
                }
                Column colAnno = pd.getReadMethod().getAnnotation(Column.class);
                if (colAnno == null) continue;
                if (!colAnno.nullable() && val == null) {
                    vr.setType(ValidationResult.Type.ERRORS);
                    msg = new LocalizableMessage(this.beanInfo.getResourceBundleName(), "validation.field.must_be_set");
                    vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR, msg));
                }
                if (required && (val == null || pd.getPropertyType().equals(String.class) && "".equals(val))) {
                    vr.setType(ValidationResult.Type.ERRORS);
                    vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR, VALIDATION_MSG_FIELD_REQUIRED));
                }
                if (!pd.getPropertyType().equals(String.class) || val == null || ((String)val).length() <= colAnno.length()) continue;
                vr.setType(ValidationResult.Type.ERRORS);
                msg = new LocalizableMessage(this.beanInfo.getResourceBundleName(), "validation.field.too_long");
                vr.putPropertyValidationResult(pd.getName(), new PropertyValidationResult(PropertyValidationResult.Type.ERROR, msg));
            }
        } else {
            throw new ValidationException("Object has not type of controller !");
        }
        return vr;
    }

    protected void apply(HttpServletRequest request, String command) throws ControllerException {
        Map map = request.getParameterMap();
        BeanModel<Object> newBeanModel = null;
        Enum newItem = null;
        try {
            newItem = (Enum)this.queryType.newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
            throw new ControllerException(e1);
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            throw new ControllerException(e1);
        }
        EntityManager em = this.getThreadEntityManager();
        this.setPropertiesOnCreate(request, em, newItem);
        PersistenceMapConverter mapConverter = new PersistenceMapConverter();
        try {
            newBeanModel = mapConverter.createBeanModel(newItem, map, em, false, request, this.securityManager);
        }
        catch (MapConverterException e) {
            e.printStackTrace();
            this.rollback();
            Throwable cause = e.getCause();
            if (cause instanceof ControllerException) {
                throw (ControllerException)cause;
            }
            throw new ControllerException("Could not apply properties.", e);
        }
        ExtBeanInfo bInfo = this.getBeanInfo();
        if (bInfo.getIdPropertyDescriptor() != null && !this.isIdGenerated()) {
            Object idO;
            try {
                idO = bInfo.getIdValue(newItem);
            }
            catch (Exception e) {
                e.printStackTrace();
                em.remove((Object)newItem);
                throw new ControllerException(e);
            }
            Object exO = em.find(bInfo.getBeanDescriptor().getBeanClass(), idO);
            if (exO != null) {
                throw new ObjectAlreadyExistsException(idO);
            }
        }
        ValidationResult validationResult = null;
        try {
            validationResult = this.validate(newBeanModel.getBean(), newBeanModel.getValidationResult());
        }
        catch (ValidationException e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        this.processResult = new ProcessResult(validationResult);
        this.beanModel = new BeanModel((Object)newItem, validationResult);
    }

    private void processRelationShip(Map<String, String[]> queryMap) throws ControllerException {
        PersistenceObjectIdentifier poi;
        try {
            poi = PersistenceObjectIdentifier.parseQueryMap(queryMap);
        }
        catch (ParserException e1) {
            e1.printStackTrace();
            throw new ControllerException("Could not parse object identifier from query map.", e1);
        }
        catch (IntrospectionException e1) {
            e1.printStackTrace();
            throw new ControllerException("Could not introspect class.", e1);
        }
        PropertyDescriptor[] ppds = this.beanInfo.getPersistencePropertyDescriptors();
        String propertyName = null;
        this.relatedPropertyName = null;
        String[] mappedByArr = queryMap.get(KEY_MAPPEDBY);
        if (mappedByArr != null) {
            propertyName = mappedByArr[0];
            for (PropertyDescriptor pd : ppds) {
                if (pd.getName().equals(propertyName)) break;
            }
        } else {
            String[] relatedPropArr = queryMap.get(KEY_RELATED_PROPERTY);
            if (relatedPropArr == null || relatedPropArr.length != 1) {
                throw new ControllerException("Related property name missing in query (parameter '_related_prop'");
            }
            this.relatedPropertyName = relatedPropArr[0];
        }
        if (this.mode != null && this.mode instanceof ListMode) {
            SelectMode selectMode = ((ListMode)this.mode).getSelectMode();
            SelectMode.ActionType actionType = null;
            if (selectMode != null) {
                actionType = selectMode.getActionType();
            }
            if (actionType == null) {
                this.queryMembers = false;
            } else if (actionType.equals((Object)SelectMode.ActionType.ADD)) {
                this.queryMembers = true;
            } else if (actionType.equals((Object)SelectMode.ActionType.REMOVE)) {
                this.queryMembers = false;
            } else if (!actionType.equals((Object)SelectMode.ActionType.SET) && actionType.equals((Object)SelectMode.ActionType.RESET)) {
                this.queryMembers = false;
            }
        }
        this.setRelatedObjectIdentifier(poi);
    }

    public void processListRequest(HttpServletRequest req) throws ControllerException {
        this.currentRequest = req;
        this.clear();
        if (!(this.mode instanceof ListMode)) {
            this.mode = new ListMode();
        }
        this.createBeanTableModel(req.getParameter(KEY_CMD), req);
    }

    public String processCommand(HttpServletRequest request, String[] possibleSubmitCommands) {
        String command = request.getParameter(KEY_CMD);
        for (String possibleSubmitCmd : possibleSubmitCommands) {
            if (request.getParameter("_" + possibleSubmitCmd) == null) continue;
            command = possibleSubmitCmd;
            break;
        }
        return command;
    }

    public String processCommand(HttpServletRequest request) {
        return this.processCommand(request, this.SUBMIT_CMDS);
    }

    @Override
    public ProcessResult process(HttpServletRequest request, HttpServletResponse response, Servlet servlet) throws ControllerException {
        this.processRequest(request);
        return this.getProcessResult();
    }

    @Override
    public ProcessResult process(HttpServletRequest request, HttpServletResponse response) throws ControllerException {
        this.processRequest(request);
        return this.getProcessResult();
    }

    @Override
    public void processRequest(HttpServletRequest request) throws ControllerException {
        this.currentRequest = request;
        this.clear();
        if (request.getCharacterEncoding() == null) {
            try {
                request.setCharacterEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ControllerException(e);
            }
        }
        Map queryMap = request.getParameterMap();
        String command = this.processCommand(request);
        if (command != null && command.equals(CMD_CANCEL)) {
            this.beanModel = new BeanModel((Object)null, new ValidationResult(ValidationResult.Type.CANCELLED));
            this.processResult = new ProcessResult(ProcessResult.Type.CANCELLED);
            this.actionCanceled = true;
            return;
        }
        if (command == null || command.equals(CMD_CANCEL)) {
            command = CMD_LIST;
        }
        if (CMD_LIST_RELATED.equals(command)) {
            this.mode = new ListMode();
            this.processRelationShip(queryMap);
            this.createBeanTableModel(CMD_LIST, request);
        } else if (command.equals(CMD_SELECT_TO_ADD)) {
            String selectTargetProperty = request.getParameter(KEY_RELATED_PROPERTY);
            ListMode lm = new ListMode();
            lm.setSelectMode(new SelectMode(SelectMode.ActionType.ADD, request.getParameter(KEY_ACTION), selectTargetProperty));
            this.mode = lm;
            BeanTableModel btm = new BeanTableModel();
            this.processRelationShip(queryMap);
            this.createBeanTableModel(command, btm, request);
        } else if (command.equals(CMD_SELECT_TO_REMOVE)) {
            String selectTargetProperty = request.getParameter(KEY_RELATED_PROPERTY);
            ListMode lm = new ListMode();
            lm.setSelectMode(new SelectMode(SelectMode.ActionType.REMOVE, request.getParameter(KEY_ACTION), selectTargetProperty));
            this.mode = lm;
            BeanTableModel btm = new BeanTableModel();
            this.processRelationShip(queryMap);
            this.createBeanTableModel(command, btm, request);
        } else if (command.equals(CMD_SELECT_TO_SET)) {
            String selectTargetProperty = request.getParameter(KEY_RELATED_PROPERTY);
            ListMode lm = new ListMode();
            lm.setSelectMode(new SelectMode(SelectMode.ActionType.SET, request.getParameter(KEY_ACTION), selectTargetProperty));
            this.mode = lm;
            BeanTableModel btm = new BeanTableModel();
            this.processRelationShip(queryMap);
            this.createBeanTableModel(command, btm, request);
        } else if (command.equals(CMD_SELECT_TO_RESET)) {
            BeanTableModel btm = new BeanTableModel();
            this.createBeanTableModel(command, btm, request);
        } else if (command.equals(CMD_LIST)) {
            this.mode = new ListMode();
            this.processListRequest(request);
        } else if (command.startsWith(CMD_LIST)) {
            this.processListRequest(request);
        } else if (command.equals(CMD_CORRECT) || command.equals(CMD_VIEW)) {
            this.createBeanModel(request);
            this.mode = command.equals(command.equals(CMD_CORRECT)) ? new EditMode() : new ViewMode();
        }
    }

    protected Object createIdObject(Map<String, String[]> map) throws ControllerException {
        String[] idStrs;
        Object idObj = null;
        if (this.beanInfo.isIdEmbedded()) {
            PropertyDescriptor idPd = this.beanInfo.getIdPropertyDescriptor();
            try {
                idObj = idPd.getPropertyType().newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
            HashMap<String, String[]> embProps = new HashMap<String, String[]>();
            Set<Map.Entry<String, String[]>> entries2 = map.entrySet();
            for (Map.Entry<String, String[]> entry2 : entries2) {
                String key2 = entry2.getKey();
                int dotIndex2 = key2.indexOf(46);
                String keyName2 = null;
                String deepProperty2 = null;
                if (dotIndex2 <= 0) continue;
                keyName2 = key2.substring(0, dotIndex2);
                deepProperty2 = key2.substring(dotIndex2 + 1);
                if (!keyName2.equals(idPd.getName())) continue;
                embProps.put(deepProperty2, entry2.getValue());
            }
            if (embProps.size() > 0) {
                MapConverter embMc = new MapConverter();
                try {
                    embMc.setBeanProperties(idObj, embProps);
                    return idObj;
                }
                catch (MapConverterException e) {
                    e.printStackTrace();
                    throw new ControllerException(e);
                }
            }
        }
        if ((idStrs = map.get(this.beanInfo.getIdPropertyDescriptor().getName())) != null && idStrs.length == 1 && idStrs[0] != null) {
            String idStr = idStrs[0];
            try {
                idObj = this.beanInfo.createIdValueByString(idStr);
                if (idObj == null) {
                    throw new ControllerException("Could not get item with id=" + idStr);
                }
                this.setId(idObj);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ControllerException(e);
            }
        }
        try {
            PersistenceObjectIdentifier poi = PersistenceObjectIdentifier.parseQueryMap(map);
            if (poi != null) {
                idObj = poi.getIdObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ControllerException(e);
        }
        return idObj;
    }

    @Override
    public void rollback() {
        EntityManager em = this.getThreadEntityManager();
        if (em != null) {
            EntityTransaction tx = null;
            tx = em.getTransaction();
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
    }

    @Override
    public void commit() throws ControllerException {
        EntityManager em = this.getThreadEntityManager();
        if (em != null) {
            EntityTransaction tx = null;
            try {
                tx = em.getTransaction();
                if (tx != null && tx.isActive()) {
                    tx.commit();
                }
            }
            catch (PersistenceException e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new ControllerException(e);
            }
            catch (IllegalStateException ise) {
                ise.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new ControllerException(ise);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new ControllerException(e);
            }
        }
    }

    protected void clear() {
        this.processResult = null;
        this.beanModel = null;
        this.beanTableModel = null;
        this.actionCanceled = false;
    }

    @Override
    public synchronized void close() {
        EntityManager em = this.getThreadEntityManager();
        try {
            this.commit();
        }
        catch (ControllerException e) {
            e.printStackTrace();
        }
        if (em != null) {
            em.close();
        }
        if (this.emtl != null) {
            this.emtl.remove();
        }
    }

    @Override
    public ExtBoolExpr getBoolCondition() {
        return null;
    }

    @Override
    public OrderByClause getOrderByClause() {
        return null;
    }

    @Override
    public String getNamedQuery() {
        return null;
    }

    @Override
    public void setDisplayColumns(List<String> displayColumns) {
        this.displayColumns = displayColumns;
    }

    @Override
    public boolean isIdGenerated() {
        return this.idGenerated;
    }

    public void setIdGenerated(boolean idGenerated) {
        this.idGenerated = idGenerated;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public String getKEY_SELECT_TARGET_PROPERTY() {
        return KEY_SELECT_TARGET_PROPERTY;
    }

    public String getKEY_SELECT_TARGET_ID() {
        return KEY_SELECT_TARGET_ID;
    }

    public String getKEY_SELECT_TARGET_ID_PROPERTY() {
        return KEY_SELECT_TARGET_ID_PROPERTY;
    }

    public String getKEY_SELECTED_ID() {
        return KEY_SELECTED_ID;
    }

    public String getKEY_ACTION() {
        return KEY_ACTION;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public PersistenceObjectIdentifier getRelatedObjectIdentifier() {
        return this.relatedObjectIdentifier;
    }

    public void setRelatedObjectIdentifier(PersistenceObjectIdentifier relatedObjectIdentifier) {
        this.relatedObjectIdentifier = relatedObjectIdentifier;
    }

    public Object getSelectedItemId() {
        return this.selectedItemId;
    }

    public Object getSelectedItem() {
        if (this.selectedItemId == null) {
            return null;
        }
        EntityManager em = this.getThreadEntityManager();
        Object ret = em.find(this.queryType, this.selectedItemId);
        return ret;
    }

    public void setSelectedItemId(HttpServletRequest request, Object selectedItemId) {
        this.selectedItemId = selectedItemId;
        this.setPropertiesAfterSelect(request, selectedItemId);
    }

    public void setSelectedItemIds(HttpServletRequest request, Set<Object> selectedItemIds) {
        this.selectedItemIds = selectedItemIds;
        this.setPropertiesAfterSelect(request, selectedItemIds);
    }

    public Set<Object> getSelectedItemIds() {
        return this.selectedItemIds;
    }

    public boolean isActionCanceled() {
        return this.actionCanceled;
    }

    public BeanModel<T> getBeanModel() {
        return this.beanModel;
    }

    @Override
    public ProcessResult getProcessResult() {
        return this.processResult;
    }

    public static String getKEY_PREFIX_DELETE_RELATED() {
        return KEY_PREFIX_DELETE_RELATED;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public boolean isDropInSecureItems() {
        return this.dropInSecureItems;
    }

    public void setDropInSecureItems(boolean dropInSecureItems) {
        this.dropInSecureItems = dropInSecureItems;
    }

    public class EntityManagerThreadLocal
    extends ThreadLocal<EntityManager> {
        @Override
        protected synchronized EntityManager initialValue() {
            return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
        }
    }

    public static class ViewMode
    extends SingleMode {
    }

    public static class EditMode
    extends SingleMode {
    }

    public static class SingleMode
    extends Mode {
    }

    public static class ListMode
    extends Mode {
        private SelectMode selectMode = null;

        public SelectMode getSelectMode() {
            return this.selectMode;
        }

        public void setSelectMode(SelectMode selectMode) {
            this.selectMode = selectMode;
        }
    }

    public static class Mode {
    }
}

