/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps.session;

import java.util.Comparator;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionObserver
implements HttpSessionListener {
    private static SessionObserver instance = null;
    private Vector<HttpSession> boundedSessions;

    public SessionObserver() {
        instance = this;
        this.boundedSessions = new Vector();
    }

    public static synchronized SessionObserver getSessionObserver() {
        if (instance == null) {
            new SessionObserver();
        }
        return instance;
    }

    public HttpSession[] getBoundedSessions() {
        return SessionObserver.getSessionObserver().boundedSessions.toArray(new HttpSession[this.boundedSessions.size()]);
    }

    public HttpSession[] getBoundedSessionsOrderedByLastAccessed() {
        Vector bSesssClone = (Vector)SessionObserver.getSessionObserver().boundedSessions.clone();
        bSesssClone.sort(new Comparator<HttpSession>(){

            @Override
            public int compare(HttpSession o1, HttpSession o2) {
                long at1 = o1.getLastAccessedTime();
                long at2 = o2.getLastAccessedTime();
                return (int)(at2 - at1);
            }
        });
        return bSesssClone.toArray(new HttpSession[bSesssClone.size()]);
    }

    public void sessionCreated(HttpSessionEvent arg0) {
        SessionObserver.getSessionObserver();
        HttpSession session = arg0.getSession();
        Locale locale = null;
        if (session.getAttribute("locale") == null) {
            String localeStr = session.getServletContext().getInitParameter("locale");
            locale = localeStr == null ? Locale.getDefault() : new Locale(localeStr);
            session.setAttribute("locale", (Object)locale);
        }
        if (!this.boundedSessions.contains(session)) {
            this.boundedSessions.add(session);
        }
    }

    public void sessionDestroyed(HttpSessionEvent arg0) {
        SessionObserver.getSessionObserver();
        HttpSession session = arg0.getSession();
        this.boundedSessions.remove(session);
        try {
            session.setAttribute("locale", null);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

