/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.net.SendMailException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SendMail {
    private Properties props = new Properties();

    public SendMail() {
        this.props.put("mail.smtp.host", "localhost");
        System.setProperty("mail.mime.charset", "UTF-8");
    }

    public boolean isAddressValid(String address) {
        try {
            InternetAddress ia = new InternetAddress(address);
            ia.validate();
        }
        catch (AddressException e) {
            return false;
        }
        return true;
    }

    public void send(InternetAddress from, String to, String subject, String content) throws SendMailException {
        if (to == null) {
            throw new SendMailException("No recipient specified.");
        }
        String[] recipients = new String[]{to};
        this.send(from, recipients, subject, content);
    }

    public void send(InternetAddress from, String[] recipients, String subject, String content) throws SendMailException {
        if (recipients == null || recipients.length == 0) {
            throw new SendMailException("No recipient(s) specified.");
        }
        try {
            InternetAddress[] dests = new InternetAddress[recipients.length];
            for (int ri = 0; ri < recipients.length; ++ri) {
                dests[ri] = new InternetAddress(recipients[ri]);
            }
            this.send(from, dests, subject, content);
        }
        catch (AddressException e) {
            throw new SendMailException(e);
        }
    }

    public void send(InternetAddress from, InternetAddress[] dests, String subject, String content) throws SendMailException {
        if (dests == null) {
            throw new SendMailException("No recipient specified.");
        }
        if (from == null) {
            throw new SendMailException("No sender specified.");
        }
        if (subject == null) {
            subject = "";
        }
        if (content == null) {
            content = "";
        }
        try {
            Session session = Session.getDefaultInstance((Properties)this.props);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)from);
            message.setRecipients(Message.RecipientType.TO, (Address[])dests);
            message.setSubject(subject);
            message.setContent((Object)content, "text/plain; charset=UTF-8");
            Transport.send((Message)message);
        }
        catch (Throwable t) {
            throw new SendMailException(t);
        }
    }

    public void send(String fromStr, String to, String subject, String content) throws SendMailException {
        InternetAddress from = null;
        try {
            from = new InternetAddress(fromStr);
        }
        catch (Exception e) {
            throw new SendMailException("Sender address invalid.");
        }
        this.send(from, to, subject, content);
    }

    public static void main(String[] args) {
        String adr1 = "bla_fasel_falsch";
        String adr2 = "korrekt@bla.de";
        InternetAddress ia1 = null;
        try {
            ia1 = new InternetAddress(adr1);
        }
        catch (AddressException e) {
            System.out.println(adr1 + " failed");
            e.printStackTrace();
        }
        if (ia1 != null) {
            try {
                ia1.validate();
            }
            catch (AddressException e) {
                System.out.println(adr1 + " validate failed");
                e.printStackTrace();
            }
        }
        InternetAddress ia2 = null;
        try {
            ia2 = new InternetAddress(adr2);
        }
        catch (AddressException e) {
            e.printStackTrace();
        }
        if (ia2 != null) {
            try {
                ia2.validate();
            }
            catch (AddressException e) {
                e.printStackTrace();
            }
        }
    }
}

