/*
 * Decompiled with CFR 0.152.
 */
package ips.servlet.http;

import ipsk.io.EditInputStream;
import ipsk.text.StringTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileServer
extends HttpServlet {
    protected final boolean DEBUG = false;
    private static final int DEF_BUF_SIZE = 4096;
    private int bufSize = 4096;
    private static final Charset ASCII_CHARSET = Charset.forName("US-ASCII");

    public void init() throws ServletException {
        super.init();
    }

    private void sendStream(File file, OutputStream out, long start, long length) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        EditInputStream editInputStream = new EditInputStream((InputStream)fis, start, length);
        try {
            byte[] buf = new byte[this.bufSize];
            int read = 0;
            while ((read = editInputStream.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (editInputStream != null) {
                    editInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void serve(File file, String contentType, HttpServletRequest req, HttpServletResponse res) throws IOException {
        long contentLength;
        block26: {
            block27: {
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath() + " not found");
                }
                contentLength = file.length();
                if (contentType == null) {
                    ServletContext servletContext = this.getServletContext();
                    contentType = servletContext.getMimeType(file.getAbsolutePath());
                }
                if (req == null) break block26;
                String rangeStr = req.getHeader("Range");
                if (rangeStr == null) break block27;
                ArrayList<ByteRange> byteRanges = new ArrayList<ByteRange>();
                long maxIdx = contentLength - 1L;
                int ies = (rangeStr = rangeStr.trim()).indexOf(61);
                if (ies > 0) {
                    String unit = rangeStr.substring(0, ies);
                    if ("bytes".equals(unit)) {
                        String valueStr = rangeStr.substring(ies + 1);
                        String[] brStrs = StringTokenizer.split((String)valueStr, (char)',', (boolean)true);
                        int multiRangeContentLength = 0;
                        for (String brStr : brStrs) {
                            int brD = brStr.indexOf(45);
                            if (brD < 0) continue;
                            long brStart = 0L;
                            long brEnd = maxIdx;
                            String brStartStr = brStr.substring(0, brD);
                            String brEndStr = brStr.substring(brD + 1);
                            if (!"".equals(brStartStr) && (brStart = Long.parseLong(brStartStr)) < 0L) {
                                brStart = 0L;
                            }
                            if (!"".equals(brEndStr) && (brEnd = Long.parseLong(brEndStr)) > maxIdx) {
                                brEnd = maxIdx;
                            }
                            ByteRange br = new ByteRange(brStart, brEnd);
                            byteRanges.add(br);
                            multiRangeContentLength = (int)((long)multiRangeContentLength + br.getLength());
                        }
                        if (byteRanges.size() > 0) {
                            if (byteRanges.size() == 1) {
                                ByteRange br = (ByteRange)byteRanges.get(0);
                                long brLength = br.getLength();
                                long brStart = br.getStart();
                                long brEnd = br.getEnd();
                                if (brStart != 0L || brLength != contentLength) {
                                    res.setContentType(contentType);
                                    res.setContentLength((int)brLength);
                                    String rangeHeader = "bytes " + brStart + "-" + brEnd + "/" + contentLength;
                                    res.setHeader("Content-range", rangeHeader);
                                    res.setStatus(206);
                                    ServletOutputStream out = res.getOutputStream();
                                    this.sendStream(file, (OutputStream)out, brStart, brLength);
                                    return;
                                }
                                break block26;
                            } else {
                                UUID uuid = UUID.randomUUID();
                                String boundary = uuid.toString().replace('-', '_').substring(0, 22);
                                multiRangeContentLength += (boundary.length() + 2) * byteRanges.size();
                                multiRangeContentLength += boundary.length() + 2;
                                res.setContentType("multipart/byteranges; boundary=" + boundary);
                                ServletOutputStream out = res.getOutputStream();
                                String rangeContentHeader = "Content-Type: " + contentType;
                                res.setStatus(206);
                                Iterator brD = byteRanges.iterator();
                                while (true) {
                                    if (!brD.hasNext()) {
                                        String fs = new String("\n--" + boundary + "--\n");
                                        out.write(fs.getBytes(ASCII_CHARSET));
                                        return;
                                    }
                                    ByteRange br = (ByteRange)brD.next();
                                    long brStart = br.getStart();
                                    long brLength = br.getLength();
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("\n--" + boundary + "\n");
                                    sb.append(rangeContentHeader + "\n");
                                    String rangeHeader = "bytes " + br.getStart() + "-" + br.getEnd() + "/" + contentLength;
                                    sb.append("Content-range: " + rangeHeader + "\n\n");
                                    byte[] bb = sb.toString().getBytes(ASCII_CHARSET);
                                    out.write(bb);
                                    this.sendStream(file, (OutputStream)out, brStart, brLength);
                                }
                            }
                        }
                        break block26;
                    } else {
                        res.setStatus(400);
                    }
                }
                break block26;
            }
            res.setHeader("Accept-Ranges", "bytes");
        }
        ServletOutputStream out = res.getOutputStream();
        res.setContentType(contentType);
        if (contentLength <= Integer.MAX_VALUE) {
            res.setContentLength((int)contentLength);
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] buf = new byte[this.bufSize];
            int read = 0;
            while ((read = fis.read(buf)) != -1) {
                out.write(buf, 0, read);
                out.flush();
            }
            return;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void serve(File file, String contentType, HttpServletResponse res) throws IOException {
        this.serve(file, contentType, null, res);
    }

    protected void serve(File file, HttpServletResponse res) throws IOException {
        this.serve(file, null, res);
    }

    public class ByteRange {
        private long start;
        private long end;

        public ByteRange(long brStart, long brEnd) {
            this.start = brStart;
            this.end = brEnd;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public long getLength() {
            return this.end - this.start + 1L;
        }
    }
}

