/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class EntityManagerFactoryInitializer
implements ServletContextListener {
    private static boolean DEBUG = true;
    private static EntityManagerFactory entityManagerFactory;

    public static void closeEntityManagerFactory(ServletContext context) {
        if (DEBUG) {
            System.out.println("Entity manager factory listener: Context destroyed. (" + entityManagerFactory + ").");
        }
        if (entityManagerFactory != null) {
            entityManagerFactory.close();
            context.log("Closed entity manager factory.(" + entityManagerFactory + ").");
            context.removeAttribute("entityManagerFactory");
            entityManagerFactory = null;
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        EntityManagerFactoryInitializer.closeEntityManagerFactory(context);
    }

    public static synchronized void createEntitymanagerFactory(ServletContext context) {
        try {
            String persistenceUnitName = context.getInitParameter("persistenceUnitName");
            if (entityManagerFactory != null) {
                context.log("Entity manager already exists on initialize !");
                System.err.println("Entity manager factory already exists ! (" + entityManagerFactory + ").");
            } else {
                entityManagerFactory = Persistence.createEntityManagerFactory((String)persistenceUnitName);
                context.setAttribute("entityManagerFactory", (Object)entityManagerFactory);
                context.log("Created entity manager factory \"" + persistenceUnitName + "\" (" + entityManagerFactory + ").");
            }
        }
        catch (Exception ex) {
            context.log("Couldn't create entity manager factory !", (Throwable)ex);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        EntityManagerFactoryInitializer.createEntitymanagerFactory(context);
    }

    public static EntityManagerFactory getEntityManagerFactory() {
        return entityManagerFactory;
    }

    public static synchronized void reloadEntityManagerFactory(ServletContext context) {
        EntityManagerFactoryInitializer.closeEntityManagerFactory(context);
        EntityManagerFactoryInitializer.createEntitymanagerFactory(context);
    }
}

