/*
 * Decompiled with CFR 0.152.
 */
package ipsk.persistence.text;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.lang.reflect.NativeTypeWrapper;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.text.ParserException;
import ipsk.util.EnumResourceKeys;
import ipsk.util.MemberResourceKey;
import ipsk.util.ResourceBundleName;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

public class StringObjectConverter
extends ipsk.text.StringObjectConverter {
    public static Object stringToObject(String strValue, PropertyDescriptor pd, Locale locale) throws ParserException {
        return StringObjectConverter.stringToObject(strValue, pd, locale, false, false);
    }

    public static Object stringToObject(String strValue, PropertyDescriptor pd, Locale locale, boolean enumKey, boolean caseInsensitive) throws ParserException {
        Class<?> propertyType = pd.getPropertyType();
        ResourceBundle rb = ResourceBundle.getBundle("ipsk.jsp.Messages", locale);
        Method readMethod = pd.getReadMethod();
        if (Collection.class.isAssignableFrom(propertyType)) {
            Type rt = readMethod.getGenericReturnType();
            if (rt instanceof ParameterizedType) {
                ParameterizedType prt = (ParameterizedType)rt;
                Type[] pts = prt.getActualTypeArguments();
                if (pts.length == 1) {
                    Class relatedReturnType = (Class)pts[0];
                    Object idObj = null;
                    ExtBeanInfo relatedBeanInfo = null;
                    try {
                        relatedBeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(relatedReturnType, true);
                        idObj = relatedBeanInfo.createIdValueByString(strValue);
                    }
                    catch (Exception e) {
                        throw new ParserException((Throwable)e);
                    }
                    return new PersistenceObjectIdentifier(relatedReturnType, idObj);
                }
                throw new ParserException("Parameterized type " + prt + " has more than one type arguemnts\nCannot get bean info of property return type.");
            }
            throw new ParserException("Property " + pd.getName() + " is not prameterized.\nCannot create Id object for unknown type!");
        }
        if (NativeTypeWrapper.isPrimitiveNumber(propertyType) || Number.class.isAssignableFrom(propertyType)) {
            Number n;
            NumberFormat nf = NumberFormat.getNumberInstance(locale);
            try {
                n = nf.parse(strValue);
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new ParserException((Throwable)e);
            }
            if (propertyType.equals(Byte.TYPE) || propertyType.equals(Byte.class)) {
                return new Byte(n.byteValue());
            }
            if (propertyType.equals(Short.TYPE) || propertyType.equals(Short.class)) {
                return new Short(n.shortValue());
            }
            if (propertyType.equals(Integer.TYPE) || propertyType.equals(Integer.class)) {
                return new Integer(n.intValue());
            }
            if (propertyType.equals(Long.TYPE) || propertyType.equals(Long.class)) {
                return new Long(n.longValue());
            }
            if (propertyType.equals(Float.TYPE) || propertyType.equals(Float.class)) {
                return new Float(n.floatValue());
            }
            if (propertyType.equals(Double.TYPE) || propertyType.equals(Double.class)) {
                return new Double(n.doubleValue());
            }
            return null;
        }
        if (Date.class.isAssignableFrom(propertyType)) {
            try {
                Method rm = pd.getReadMethod();
                Temporal dateType = rm.getAnnotation(Temporal.class);
                if (dateType != null && dateType.value().equals((Object)TemporalType.DATE)) {
                    return DateFormat.getDateInstance(2, locale).parse(strValue);
                }
                if (dateType != null && dateType.value().equals((Object)TemporalType.TIME)) {
                    try {
                        long timeMillis = Long.parseLong(strValue);
                        Date dt = new Date(timeMillis);
                        return dt;
                    }
                    catch (NumberFormatException nfe) {
                        return DateFormat.getTimeInstance(2, locale).parse(strValue);
                    }
                }
                try {
                    long timeMillis = Long.parseLong(strValue);
                    Date dt = new Date(timeMillis);
                    return dt;
                }
                catch (NumberFormatException nfe) {
                    return DateFormat.getDateTimeInstance(2, 2, locale).parse(strValue);
                }
            }
            catch (ParseException e) {
                throw new ParserException((Throwable)e);
            }
        }
        if (propertyType.equals(Boolean.TYPE) || propertyType.equals(Boolean.class)) {
            if (strValue.equals(rb.getString("yes"))) {
                return new Boolean(true);
            }
            if (strValue.equals(rb.getString("yes"))) {
                return new Boolean(false);
            }
            return new Boolean(strValue);
        }
        if (propertyType.isEnum()) {
            if (enumKey) {
                Object enumType = Enum.valueOf(propertyType, strValue);
                return enumType;
            }
            EnumResourceKeys enumresKeysAnno = propertyType.getAnnotation(EnumResourceKeys.class);
            if (enumresKeysAnno != null) {
                MemberResourceKey[] memberResKeyAnnos;
                Class<?> beanClass = readMethod.getDeclaringClass();
                ResourceBundleName resBundleAnno = beanClass.getAnnotation(ResourceBundleName.class);
                ResourceBundle beanRb = null;
                if (resBundleAnno != null) {
                    String resBundleName = resBundleAnno.value();
                    beanRb = ResourceBundle.getBundle(resBundleName, locale);
                } else {
                    beanRb = rb;
                }
                for (MemberResourceKey mrkAnno : memberResKeyAnnos = enumresKeysAnno.memberResourceKeys()) {
                    String enumMemberResKey = mrkAnno.key();
                    String localizedEnumMemberPresentation = beanRb.getString(enumMemberResKey);
                    if (localizedEnumMemberPresentation == null || (!caseInsensitive || !localizedEnumMemberPresentation.equalsIgnoreCase(strValue)) && (caseInsensitive || !localizedEnumMemberPresentation.equals(strValue))) continue;
                    String enumName = mrkAnno.name();
                    Object enumType = Enum.valueOf(propertyType, enumName);
                    return enumType;
                }
                return null;
            }
            Object enumType = Enum.valueOf(propertyType, strValue);
            return enumType;
        }
        if (propertyType.isPrimitive() || propertyType.equals(String.class) || propertyType.equals(Character.class)) {
            return StringObjectConverter.stringToObject((String)strValue, propertyType);
        }
        Object idObj = null;
        ExtBeanInfo relatedBeanInfo = null;
        try {
            relatedBeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(propertyType, true);
            idObj = relatedBeanInfo.createIdValueByString(strValue);
        }
        catch (Exception e) {
            throw new ParserException((Throwable)e);
        }
        return new PersistenceObjectIdentifier(propertyType, idObj);
    }
}

