/*
 * Decompiled with CFR 0.152.
 */
package ips.servlet.http;

import ipsk.text.StringSequenceBuilder;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

public class URLEncoder {
    public static String encodeURL(ServletRequest servletRequest, ServletResponse servletResponse, String url) {
        Object contextUrl = null;
        contextUrl = url.startsWith("/") && servletRequest != null && servletRequest instanceof HttpServletRequest ? ((HttpServletRequest)servletRequest).getContextPath() + url : url;
        if (servletResponse != null && servletResponse instanceof HttpServletResponse) {
            contextUrl = ((HttpServletResponse)servletResponse).encodeURL((String)contextUrl);
        }
        return contextUrl;
    }

    public static String encodeURL(PageContext pageContext, String url) {
        if (pageContext != null) {
            return URLEncoder.encodeURL(pageContext.getRequest(), pageContext.getResponse(), url);
        }
        return URLEncoder.encodeURL(null, null, url);
    }

    public static String parameterMapToQueryString(Map<String, String[]> parameterMap) {
        ArrayList<CallSite> qStrs = new ArrayList<CallSite>();
        Set<String> paramKeys = parameterMap.keySet();
        for (String pKey : paramKeys) {
            try {
                String[] vals;
                String encKey = java.net.URLEncoder.encode(pKey, "UTF-8");
                for (String val : vals = parameterMap.get(pKey)) {
                    String encVal = java.net.URLEncoder.encode(val, "UTF-8");
                    qStrs.add((CallSite)((Object)(encKey + "=" + encVal)));
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
        return StringSequenceBuilder.buildString(qStrs, (char)'&');
    }
}

