/*
 * Decompiled with CFR 0.152.
 */
package ips.beans;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.beans.BeanModel;
import ipsk.beans.DateConversionException;
import ipsk.beans.MapConverter;
import ipsk.beans.MapConverterException;
import ipsk.beans.NumberConversionException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.TimeConversionException;
import ipsk.beans.validation.EMail;
import ipsk.beans.validation.ValidationResult;
import ipsk.lang.reflect.NativeTypeWrapper;
import ipsk.persistence.SecurityManager;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.PermissionDeniedException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.servlet.http.HttpServletRequest;

public class PersistenceMapConverter<T>
extends MapConverter {
    private boolean DEBUG = false;

    protected PropertyApplyResult applyProperty(PropertyDescriptor pd, Map<String, String[]> properties, Object bean) throws MapConverterException {
        PropertyValidationResult pvr = null;
        Object o = null;
        String propertyName = pd.getName();
        String[] propertyParams = null;
        if (properties.containsKey(propertyName)) {
            propertyParams = properties.get(propertyName);
        }
        try {
            o = super.getValue(pd, properties);
            Method readMethod = pd.getReadMethod();
            EMail emailAnno = readMethod.getAnnotation(EMail.class);
            if (emailAnno != null && o instanceof String) {
                InternetAddress[] testIas;
                String emailAddressList = (String)o;
                for (InternetAddress testIa : testIas = InternetAddress.parse((String)emailAddressList)) {
                    testIa.validate();
                }
            }
        }
        catch (DateConversionException e) {
            pvr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
            pvr.setValidationException((Exception)((Object)e));
            pvr.setFailedProperties(e.getFailedProperties());
            pvr.setValidationMessage(new LocalizableMessage("ipsk.jsp.Messages", "validation.field.wrong_date_format"));
        }
        catch (TimeConversionException e) {
            pvr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
            pvr.setValidationException((Exception)((Object)e));
            pvr.setFailedProperties(e.getFailedProperties());
            pvr.setValidationMessage(new LocalizableMessage("ipsk.jsp.Messages", "validation.field.wrong_time_format"));
        }
        catch (NumberConversionException e) {
            pvr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
            pvr.setValidationException((Exception)((Object)e));
            pvr.setFailedProperties(e.getFailedProperties());
            pvr.setValidationMessage(new LocalizableMessage("ipsk.jsp.Messages", "validation.field.wrong_number_format"));
        }
        catch (AddressException e) {
            pvr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
            pvr.setValidationException((Exception)((Object)e));
            HashMap<String, String[]> failedPrMap = new HashMap<String, String[]>();
            failedPrMap.put(propertyName, propertyParams);
            pvr.setFailedProperties(failedPrMap);
            pvr.setValidationMessage(new LocalizableMessage("ipsk.jsp.Messages", "validation.field.wrong_email_format"));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new MapConverterException((Throwable)e);
        }
        return new PropertyApplyResult(o, pvr);
    }

    protected PropertyApplyResult applyProperty(PropertyDescriptor pd, Map<String, String[]> properties, Object bean, EntityManager em, boolean persist, HttpServletRequest req, SecurityManager securityManager) throws MapConverterException, PermissionDeniedException {
        PropertyValidationResult pvr = null;
        Object o = null;
        try {
            o = super.getValue(pd, properties);
            if (o == null || o.equals(NULL_VALUE_AS_DEF)) {
                o = this.applyRelationshipProperty(pd, properties, bean, em, persist, req, securityManager);
            }
        }
        catch (DateConversionException e) {
            pvr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
            pvr.setValidationException((Exception)((Object)e));
            pvr.setFailedProperties(e.getFailedProperties());
            pvr.setValidationMessage(new LocalizableMessage("ipsk.jsp.Messages", "validation.field.wrong_date_format"));
        }
        catch (TimeConversionException e) {
            pvr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
            pvr.setValidationException((Exception)((Object)e));
            pvr.setFailedProperties(e.getFailedProperties());
            pvr.setValidationMessage(new LocalizableMessage("ipsk.jsp.Messages", "validation.field.wrong_time_format"));
        }
        catch (NumberConversionException e) {
            pvr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR);
            pvr.setValidationException((Exception)((Object)e));
            pvr.setFailedProperties(e.getFailedProperties());
            pvr.setValidationMessage(new LocalizableMessage("ipsk.jsp.Messages", "validation.field.wrong_number_format"));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new MapConverterException((Throwable)e);
        }
        return new PropertyApplyResult(o, pvr);
    }

    protected Object getValue(PropertyDescriptor pd, Map<String, String[]> properties, Object bean, EntityManager em, boolean persist, HttpServletRequest req, SecurityManager securityManager) throws MapConverterException, PermissionDeniedException {
        Object o = super.getValue(pd, properties);
        if (o != null && !o.equals(NULL_VALUE_AS_DEF)) {
            return o;
        }
        return this.applyRelationshipProperty(pd, properties, bean, em, persist, req, securityManager);
    }

    protected Object applyRelationshipProperty(PropertyDescriptor pd, Map<String, String[]> properties, Object bean, EntityManager em, boolean persist, HttpServletRequest req, SecurityManager securityManager) throws MapConverterException, PermissionDeniedException {
        Object o = null;
        Class<?> beanClass = bean.getClass();
        try {
            ExtBeanInfo extBeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(beanClass, true);
            String propertyName = pd.getName();
            Set<Map.Entry<String, String[]>> entries = properties.entrySet();
            for (Map.Entry<String, String[]> entry : entries) {
                String key = entry.getKey();
                String[] value = entry.getValue();
                int dotIndex = key.indexOf(46);
                String keyName = null;
                String deepProperty = null;
                if (dotIndex <= 0) continue;
                keyName = key.substring(0, dotIndex);
                deepProperty = key.substring(dotIndex + 1);
                if (!keyName.equals(propertyName)) continue;
                Class<?> propertyType = pd.getPropertyType();
                Method readMethod = pd.getReadMethod();
                boolean embeddedid = extBeanInfo.isIdEmbedded() && pd.equals(extBeanInfo.getIdPropertyDescriptor());
                Type rt = readMethod.getGenericReturnType();
                boolean isCollection = Collection.class.isAssignableFrom(propertyType);
                boolean paramterized = rt instanceof ParameterizedType;
                if (embeddedid) {
                    Object embIdObj = readMethod.invoke(bean, new Object[0]);
                    if (embIdObj == null) {
                        embIdObj = propertyType.newInstance();
                    }
                    HashMap<String, String[]> embProps = new HashMap<String, String[]>();
                    Set<Map.Entry<String, String[]>> entries2 = properties.entrySet();
                    for (Map.Entry<String, String[]> entry2 : entries2) {
                        String key2 = entry2.getKey();
                        int dotIndex2 = key2.indexOf(46);
                        String keyName2 = null;
                        String deepProperty2 = null;
                        if (dotIndex2 <= 0) continue;
                        keyName2 = key2.substring(0, dotIndex2);
                        deepProperty2 = key2.substring(dotIndex2 + 1);
                        if (!keyName2.equals(propertyName)) continue;
                        embProps.put(deepProperty2, entry2.getValue());
                    }
                    MapConverter embMc = new MapConverter();
                    embMc.setBeanProperties(embIdObj, embProps);
                    return embIdObj;
                }
                if (isCollection && paramterized) {
                    PropertyDescriptor deepPd;
                    int n;
                    Collection coll;
                    ParameterizedType prt = (ParameterizedType)rt;
                    ExtBeanInfo deepClassInfo = null;
                    Class collClass = null;
                    PropertyDescriptor[] deepPds = null;
                    PropertyDescriptor relatedIdPd = null;
                    Object[] relatedIdObjects = null;
                    Object[] relatedObjects = null;
                    Type[] pts = prt.getActualTypeArguments();
                    if (pts.length == 1) {
                        collClass = (Class)pts[0];
                        deepClassInfo = PersistenceIntrospector.getPersistenceBeanInfo(collClass, true);
                        deepPds = deepClassInfo.getPersistencePropertyDescriptors();
                        relatedIdPd = deepClassInfo.getIdPropertyDescriptor();
                        if (!relatedIdPd.getName().equals(deepProperty)) {
                            throw new MapConverterException("Property " + deepProperty + " of related type does not match " + relatedIdPd.getName());
                        }
                        Class<?> idClass = relatedIdPd.getPropertyType();
                        Class idwClass = NativeTypeWrapper.getWrapperClass(idClass);
                        Constructor idCstr = idwClass.getConstructor(String.class);
                        String[] idStrVals = value;
                        relatedIdObjects = new Object[idStrVals.length];
                        relatedObjects = new Object[idStrVals.length];
                        for (int i = 0; i < idStrVals.length; ++i) {
                            relatedIdObjects[i] = idCstr.newInstance(idStrVals[i]);
                            relatedObjects[i] = em.find(collClass, relatedIdObjects[i]);
                            securityManager.checkReadPermission(req, relatedObjects[i]);
                        }
                    } else {
                        throw new MapConverterException("Property " + pd.getName() + " has ambigious (more than one) type arguments.");
                    }
                    String mappedBy = null;
                    ManyToMany mmA = readMethod.getAnnotation(ManyToMany.class);
                    OneToMany omA = readMethod.getAnnotation(OneToMany.class);
                    if (mmA != null) {
                        mappedBy = mmA.mappedBy();
                        if (mappedBy == null || mappedBy.equals("")) {
                            PropertyDescriptor relatedPropertyPd = null;
                            for (PropertyDescriptor relPd : deepPds) {
                                String relMappedBy;
                                Method relRm = relPd.getReadMethod();
                                ManyToMany manyToMany = relRm.getAnnotation(ManyToMany.class);
                                if (manyToMany == null || (relMappedBy = manyToMany.mappedBy()) == null || !relMappedBy.equals(propertyName)) continue;
                                relatedPropertyPd = relPd;
                                break;
                            }
                            if (relatedPropertyPd == null) {
                                throw new MapConverterException("Related many to many property for " + bean.getClass().getName() + "." + propertyName + " in class " + deepClassInfo.getBeanDescriptor().getBeanClass().getName() + " not found !");
                            }
                            Method relReadMethod = relatedPropertyPd.getReadMethod();
                            Collection coll2 = (Collection)readMethod.invoke(bean, new Object[0]);
                            for (Object object : relatedObjects) {
                                if (coll2 instanceof List) {
                                    if (!coll2.contains(object)) {
                                        coll2.add(object);
                                    }
                                } else {
                                    coll2.add(object);
                                }
                                if (!persist) continue;
                                Collection relColl2 = (Collection)relReadMethod.invoke(object, new Object[0]);
                                securityManager.checkMergePermission(req, object, relatedPropertyPd);
                                relColl2.add(bean);
                                em.merge(object);
                            }
                            continue;
                        }
                        coll = (Collection)readMethod.invoke(bean, new Object[0]);
                        for (Object ro : relatedObjects) {
                            coll.add(ro);
                            if (!persist) continue;
                            PropertyDescriptor relatedPropertyPd = null;
                            PropertyDescriptor[] propertyDescriptorArray = deepPds;
                            int relColl2 = propertyDescriptorArray.length;
                            for (n = 0; n < relColl2; ++n) {
                                deepPd = propertyDescriptorArray[n];
                                if (!deepPd.getName().equals(mappedBy)) continue;
                                relatedPropertyPd = deepPd;
                                break;
                            }
                            if (relatedPropertyPd == null) {
                                throw new MapConverterException("Cannot find mappedby property " + mappedBy);
                            }
                            Collection collection = (Collection)relatedPropertyPd.getReadMethod().invoke(ro, new Object[0]);
                            securityManager.checkMergePermission(req, ro, relatedPropertyPd);
                            collection.add(bean);
                            em.merge(ro);
                        }
                        continue;
                    }
                    if (omA != null) {
                        mappedBy = omA.mappedBy();
                        if (mappedBy == null || mappedBy.equals("")) {
                            throw new MapConverterException("Missing mappedby annotation for property " + pd.getName());
                        }
                        coll = (Collection)readMethod.invoke(bean, new Object[0]);
                        for (Object ro : relatedObjects) {
                            coll.add(ro);
                            if (!persist) continue;
                            PropertyDescriptor relatedPropertyPd = null;
                            PropertyDescriptor[] propertyDescriptorArray = deepPds;
                            int relColl2 = propertyDescriptorArray.length;
                            for (n = 0; n < relColl2; ++n) {
                                deepPd = propertyDescriptorArray[n];
                                if (!deepPd.getName().equals(mappedBy)) continue;
                                relatedPropertyPd = deepPd;
                                break;
                            }
                            if (relatedPropertyPd == null) {
                                throw new MapConverterException("Cannot find mappedby property " + mappedBy);
                            }
                            relatedPropertyPd.getWriteMethod().invoke(ro, bean);
                            securityManager.checkMergePermission(req, ro);
                            em.merge(ro);
                        }
                        continue;
                    }
                    throw new MapConverterException("Expected OneToMany or ManyTOMany annotation for property " + pd.getName());
                }
                Object res = null;
                String[] values = value;
                if (values.length > 1) {
                    throw new MapConverterException("More than one query parameter for many to one relationship.");
                }
                String didStr = values[0];
                if (!didStr.equals("")) {
                    PropertyDescriptor[] relPPds;
                    String propertyTypeName = propertyType.getName();
                    propertyTypeName = propertyTypeName.substring(propertyTypeName.lastIndexOf(".") + 1);
                    ExtBeanInfo deepClassInfo = PersistenceIntrospector.getPersistenceBeanInfo(propertyType, true);
                    PropertyDescriptor relatedIdPd = deepClassInfo.getIdPropertyDescriptor();
                    if (!relatedIdPd.getName().equals(deepProperty)) {
                        throw new MapConverterException("Property " + deepProperty + " is not the ID property.");
                    }
                    ManyToOne manyToOneAnno = readMethod.getAnnotation(ManyToOne.class);
                    OneToOne oneToOneAnno = readMethod.getAnnotation(OneToOne.class);
                    Object idObj = null;
                    Class<?> idClass = relatedIdPd.getPropertyType();
                    Class idwClass = NativeTypeWrapper.getWrapperClass(idClass);
                    Constructor idCstr = idwClass.getConstructor(String.class);
                    idObj = idCstr.newInstance(didStr);
                    res = em.find(propertyType, idObj);
                    if (persist && manyToOneAnno != null) {
                        for (PropertyDescriptor relPpd : relPPds = deepClassInfo.getPersistencePropertyDescriptors()) {
                            ParameterizedType prelRt;
                            Type[] relAtas;
                            Method method = relPpd.getReadMethod();
                            OneToMany oneToManyAnno = method.getAnnotation(OneToMany.class);
                            if (oneToManyAnno == null) continue;
                            String mappedby = oneToManyAnno.mappedBy();
                            Type relRt = method.getGenericReturnType();
                            if (!(relRt instanceof ParameterizedType) || (relAtas = (prelRt = (ParameterizedType)relRt).getActualTypeArguments()) == null || relAtas.length != 1) continue;
                            Type relAta = relAtas[0];
                            Class relAClass = null;
                            if (relAta instanceof Class) {
                                relAClass = (Class)relAta;
                            }
                            if (mappedby == null || !mappedby.equals(propertyName) || relAClass == null || !relAClass.isAssignableFrom(beanClass)) continue;
                            securityManager.checkMergePermission(req, res, relPpd);
                            Collection relColl = (Collection)method.invoke(res, new Object[0]);
                            relColl.add(bean);
                            break;
                        }
                    } else if (persist && oneToOneAnno != null) {
                        relPPds = deepClassInfo.getPersistencePropertyDescriptors();
                        String mappedBy = oneToOneAnno.mappedBy();
                        if (mappedBy != null && !mappedBy.equals("")) {
                            for (PropertyDescriptor propertyDescriptor : relPPds) {
                                if (!propertyDescriptor.getName().equals(mappedBy)) continue;
                                Method relWm = propertyDescriptor.getWriteMethod();
                                relWm.invoke(res, bean);
                                break;
                            }
                        } else {
                            for (PropertyDescriptor propertyDescriptor : relPPds) {
                                String mappedby;
                                Method relRm = propertyDescriptor.getReadMethod();
                                OneToOne relOneToOneAnno = relRm.getAnnotation(OneToOne.class);
                                if (relOneToOneAnno == null || (mappedby = relOneToOneAnno.mappedBy()) == null || !mappedby.equals(propertyName)) continue;
                                Method relWm = propertyDescriptor.getWriteMethod();
                                relWm.invoke(res, bean);
                                break;
                            }
                        }
                    }
                }
                return res;
            }
        }
        catch (NoSuchMethodException extBeanInfo) {
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new MapConverterException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new MapConverterException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new MapConverterException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new MapConverterException((Throwable)e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new MapConverterException((Throwable)e);
        }
        return o;
    }

    public boolean createPrepersistBeanModel(Object bean, Map<String, String[]> properties, BeanModel<T> beanModel) throws MapConverterException {
        ExtBeanInfo beanInfo;
        boolean prePersistRequired = false;
        try {
            beanInfo = PersistenceIntrospector.getPersistenceBeanInfo(bean.getClass(), true);
        }
        catch (IntrospectionException e1) {
            throw new MapConverterException((Throwable)e1);
        }
        PropertyDescriptor[] beanProperties = beanInfo.getPersistencePropertyDescriptors();
        for (int i = 0; i < beanProperties.length; ++i) {
            PropertyDescriptor propertyDescriptor = beanProperties[i];
            Method readMethod = propertyDescriptor.getReadMethod();
            Column columnAnno = readMethod.getAnnotation(Column.class);
            boolean updatable = true;
            if (columnAnno != null) {
                updatable = columnAnno.updatable();
            }
            boolean nullable = true;
            if (columnAnno != null) {
                nullable = columnAnno.nullable();
            }
            if (updatable && nullable) continue;
            Method writeMethod = propertyDescriptor.getWriteMethod();
            try {
                PropertyApplyResult par = this.applyProperty(propertyDescriptor, properties, bean);
                PropertyValidationResult pvr = par.getValidationResult();
                if (pvr == null || pvr.isValid()) {
                    Object val = par.getPropertyValue();
                    if (val != null) {
                        if (val.equals(NULL_VALUE) || val.equals(NULL_VALUE_AS_DEF)) {
                            writeMethod.invoke(bean, new Object[]{null});
                        } else {
                            writeMethod.invoke(bean, val);
                        }
                    }
                } else {
                    ValidationResult vr = beanModel.getValidationResult();
                    if (vr == null) {
                        vr = new ValidationResult(ValidationResult.Type.ERRORS);
                        beanModel.setValidationResult(vr);
                    }
                    vr.putPropertyValidationResult(propertyDescriptor.getName(), pvr);
                }
            }
            catch (IllegalArgumentException e) {
                throw new MapConverterException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MapConverterException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new MapConverterException((Throwable)e);
            }
            prePersistRequired = true;
        }
        if (this.DEBUG) {
            System.out.println("Applied not updatable properties.");
        }
        return prePersistRequired;
    }

    public BeanModel<Object> createBeanModel(Object bean, Map<String, String[]> properties, EntityManager em, boolean persist, HttpServletRequest req, SecurityManager securityManager) throws MapConverterException {
        BeanModel beanModel = new BeanModel(bean);
        this.applyToBeanModel(beanModel, properties, em, persist, req, securityManager);
        return beanModel;
    }

    public void applyToBeanModel(BeanModel<?> beanModel, Map<String, String[]> properties, EntityManager em, boolean persist, HttpServletRequest req, SecurityManager securityManager) throws MapConverterException {
        ExtBeanInfo beanInfo;
        Object bean = beanModel.getBean();
        try {
            beanInfo = PersistenceIntrospector.getPersistenceBeanInfo(bean.getClass(), true);
        }
        catch (IntrospectionException e1) {
            throw new MapConverterException((Throwable)e1);
        }
        PropertyDescriptor[] beanProperties = beanInfo.getPersistencePropertyDescriptors();
        for (int i = 0; i < beanProperties.length; ++i) {
            PropertyDescriptor propertyDescriptor = beanProperties[i];
            Method writeMethod = propertyDescriptor.getWriteMethod();
            try {
                PropertyApplyResult par = this.applyProperty(propertyDescriptor, properties, bean, em, persist, req, securityManager);
                PropertyValidationResult pvr = par.getValidationResult();
                if (pvr == null || pvr.isValid()) {
                    Object val = par.getPropertyValue();
                    if (val == null) continue;
                    if (val.equals(NULL_VALUE) || val.equals(NULL_VALUE_AS_DEF)) {
                        writeMethod.invoke(bean, new Object[]{null});
                        continue;
                    }
                    writeMethod.invoke(bean, val);
                    continue;
                }
                ValidationResult vr = beanModel.getValidationResult();
                if (vr == null) {
                    vr = new ValidationResult(ValidationResult.Type.ERRORS);
                    beanModel.setValidationResult(vr);
                } else {
                    vr.setType(ValidationResult.Type.ERRORS);
                }
                vr.putPropertyValidationResult(propertyDescriptor.getName(), pvr);
                continue;
            }
            catch (PermissionDeniedException e) {
                throw new MapConverterException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new MapConverterException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MapConverterException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new MapConverterException((Throwable)e);
            }
        }
        if (this.DEBUG) {
            System.out.println("Converting finished");
        }
    }

    public Object setBeanProperties(Object bean, Map<String, String[]> properties, EntityManager em, boolean persist, HttpServletRequest req, SecurityManager securityManager) throws MapConverterException {
        ExtBeanInfo beanInfo;
        try {
            beanInfo = PersistenceIntrospector.getPersistenceBeanInfo(bean.getClass(), true);
        }
        catch (IntrospectionException e1) {
            throw new MapConverterException((Throwable)e1);
        }
        PropertyDescriptor[] beanProperties = beanInfo.getPersistencePropertyDescriptors();
        for (int i = 0; i < beanProperties.length; ++i) {
            PropertyDescriptor propertyDescriptor = beanProperties[i];
            Method writeMethod = propertyDescriptor.getWriteMethod();
            try {
                Object val = this.getValue(propertyDescriptor, properties, bean, em, persist, req, securityManager);
                if (val == null) continue;
                if (val.equals(NULL_VALUE) || val.equals(NULL_VALUE_AS_DEF)) {
                    writeMethod.invoke(bean, new Object[]{null});
                    continue;
                }
                writeMethod.invoke(bean, val);
                continue;
            }
            catch (PermissionDeniedException e) {
                throw new MapConverterException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new MapConverterException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MapConverterException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new MapConverterException((Throwable)e);
            }
        }
        if (this.DEBUG) {
            System.out.println("Converting finished");
        }
        return bean;
    }

    private class PropertyApplyResult {
        private PropertyValidationResult validationResult;
        private Object propertyValue;

        public PropertyApplyResult(Object value, PropertyValidationResult pvr) {
            this.propertyValue = value;
            this.validationResult = pvr;
        }

        public Object getPropertyValue() {
            return this.propertyValue;
        }

        public void setPropertyValue(Object propertyValue) {
            this.propertyValue = propertyValue;
        }

        public PropertyValidationResult getValidationResult() {
            return this.validationResult;
        }

        public void setValidationResult(PropertyValidationResult validationResult) {
            this.validationResult = validationResult;
        }
    }
}

